package com.ejie.y41b.utils.tree;

import java.util.Iterator;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Y41bArbolOrganismos;
import com.ejie.y41b.model.Y41bGrupoOrganismoTree;
import com.ejie.y41b.model.Y41bOrganismoTree;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * 
 *  
 * 
 */
public class Y41bOrganismosTree {

	/**
     * 
     */
	private String _activeNode = "";

	/**
	 * Nodo Activo
	 * 
	 * @param key
	 *            String
	 */
	public void setActiveNode(String key) {
		this._activeNode = key;
	}

	/**
	 * Nodo Activo
	 * 
	 * @return String
	 */
	public String getActiveNode() {
		return this._activeNode;
	}

	/**
	 * Preseleccionar un nodo
	 * 
	 * @param key
	 *            String
	 * @return String
	 */
	private String printNodeKey(String key) {
		if (this._activeNode.equals(key)) {
			return "\"activate\": true, \"focus\": true, \"expand\": true, \"select\": false, \"key\": \""
					+ key + "\"";

			// activate: false, // Initial active status.
			// focus: false, // Initial focused status.
			// expand: false, // Initial expanded status.
			// select: false,

		} else {
			if (this._activeNode.startsWith(key)) {
				// return "\"activate\": false, \"key\": \"" + key + "\"";
				return "\"activate\": false, \"focus\": false, \"expand\": true, \"select\": false, \"key\": \""
						+ key + "\"";
			} else {
				return "\"activate\": false, \"focus\": false, \"expand\": false, \"select\": false, \"key\": \""
						+ key + "\"";
			}

		}

	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param _tree
	 *            Y42bTree
	 * @return String
	 */
	public static String obtieneJsonArbol(Y41bArbolOrganismos _tree) {
		Y41bOrganismosTree t = new Y41bOrganismosTree();
		t._activeNode = (_tree.getNodeActive() != null ? _tree.getNodeActive()
				: "");

		return t.getTreeStructureStr(_tree);
	}

	/**
	 * Obtiene estructura Json
	 * 
	 * @param tree
	 *            Y41bArbolOrganismos
	 * @return json tree
	 */
	private String getTreeStructureStr(Y41bArbolOrganismos tree) {

		// Pintar arbolito
		StringBuffer aux = new StringBuffer();

		try {
			aux.append("["); // [

			Iterator<Y41bGrupoOrganismoTree> itGr = tree.getLstGrupos()
					.iterator();
			Y41bGrupoOrganismoTree grupo = null;
			while (itGr.hasNext()) {
				grupo = itGr.next();
				aux.append(this.bloqueGrupos(grupo));
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");
		} catch (Exception e1) {
			e1.printStackTrace();
		}

		return aux.toString();
	}

	/**
	 * BloqueGrupos
	 * 
	 * @param grupo
	 *            Y41bGrupoOrganismoTree
	 * @return String
	 */
	private String bloqueGrupos(Y41bGrupoOrganismoTree grupo) {
		StringBuffer aux = new StringBuffer(Y41bConstantes.BUFFER_300);

		String key = grupo.getGrupoId();
		// aux.append("{\"title\": \""
		// + Y41bUtils.printTreeLabel(grupo.getNombreEs(),
		// grupo.getNombreEu()) + "\", ");

		aux.append("{\"title\": \""
		// + "<span class='arbol_grupo'>"
				+ Y41bUtils.printTreeLabel(grupo.getNombreEs(),
						grupo.getNombreEu())
				// + "</span>"
				+ "\", ");

		aux.append("\"isFolder\": false, ");
		aux.append("\"addClass\": \"arbol_grupo\", ");

		aux.append(this.printNodeKey(key));

		if (grupo.getLstChildren().size() > 0) {
			aux.append(",");
			aux.append("\"children\": [");

			Iterator<?> itGr = grupo.getLstChildren().iterator();
			Object child = null;
			while (itGr.hasNext()) {
				child = itGr.next();
				if (child instanceof Y41bGrupoOrganismoTree) {
					aux.append(this
							.bloqueGrupos((Y41bGrupoOrganismoTree) child));
				} else {
					aux.append(this.addChild(child));
				}
				if (itGr.hasNext()) {
					aux.append(",");
				}
			}
			aux.append("]");

		}
		aux.append("}");

		return aux.toString();
	}

	/**
	 * Añadir hijos
	 * 
	 * @param child
	 *            Object
	 * @return String
	 */
	private String addChild(Object child) {
		Y41bOrganismoTree Y41bOrganismoTree = null;
		StringBuffer aux = new StringBuffer();

		if (child instanceof Y41bGrupoOrganismoTree) {
			aux.append("{\"title\": \""
			// + "<span class='arbol_grupo'>"
					+ Y41bUtils.printTreeLabel(
							((Y41bGrupoOrganismoTree) child).getNombreEs(),
							((Y41bGrupoOrganismoTree) child).getNombreEu())
					// + "</span>"
					+ "\",");
			aux.append("\"isFolder\": false, ");
			String key = ((Y41bGrupoOrganismoTree) child).getGrupoId();
			aux.append("\"addClass\": \"arbol_grupo\", ");
			aux.append(this.printNodeKey(key));
			aux.append("}");

		} else if (child instanceof Y41bOrganismoTree) {

			Y41bOrganismoTree = (Y41bOrganismoTree) child;

			aux.append("{\"title\": \""
			// + "<span class='arbol_entidad'>"
					+ Y41bUtils.printTreeLabel(Y41bOrganismoTree.getNombreEs(),
							Y41bOrganismoTree.getNombreEu())
					// + "</span>"
					+ "\",");

			StringBuffer key = new StringBuffer(Y41bConstantes.NUM_128);
			key.append(Y41bOrganismoTree.getGrupoId());
			key.append("#");
			key.append("E_");
			key.append(Y41bOrganismoTree.getCodOrg());

			aux.append("\"addClass\": \"arbol_entidad\", ");
			aux.append(this.printNodeKey(key.toString()));

			aux.append("}");

		}

		return aux.toString();
	}

}
