package com.ejie.y41b.utils.tree;

import java.util.List;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Descriptor;

/**
 * 
 *  
 * 
 */
public class Y41bDescriptoresTree {

	/**
         * 
         */
	private Y41bDescriptoresTree() {

	}

	/**
	 * Obtiene estructura Json para el arbol
	 * 
	 * @param lstDescriptores
	 *            List<Descriptor>
	 * @param selectedIdList
	 *            List<String>
	 * @return sb
	 */
	public static String obtieneJsonArbol(List<Descriptor> lstDescriptores,
			List<String> selectedIdList) {
		StringBuffer sb = new StringBuffer(Y41bConstantes.BUFFER_300);

		String key = "";

		sb.append("[");

		for (Descriptor descriptor : lstDescriptores) {
			key = descriptor.getIdDescriptor();

			sb.append("{\"title\": \"" + descriptor.getNombre() + "\",");
			if (selectedIdList != null && selectedIdList.contains(key)) {
				sb.append("\"select\": true, ");
			}
			sb.append("\"key\": \"" + key + "\"");
			sb.append("}");

			if (!descriptor
					.equals(lstDescriptores.get(lstDescriptores.size() - 1))) {
				sb.append(",");
			}
		}
		sb.append("]");

		return sb.toString();
	}

}
