package com.ejie.y41b.utils.sipca;

import java.text.DecimalFormat;

import javax.annotation.Resource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

import com.ejie.y41b.constantes.Y41bConstantes;

/**
 * The Class Y41bFuncionesAuxiliaresSipca.
 * 
 *  
 */
public class Y41bFuncionesSipca {
	private static Y41bFuncionesSipca INSTANCE = null;

	private static final Logger logger = LoggerFactory
			.getLogger(Y41bFuncionesSipca.class);

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Resource
	ReloadableResourceBundleMessageSource appMessageSource;

	// Private constructor suppresses
	/**
	 * Instantiates a new y41b funciones auxiliares platea.
	 */
	private Y41bFuncionesSipca() {

	}

	// creador sincronizado para protegerse de posibles problemas multi-hilo
	// otra prueba para evitar instanciación múltiple
	/**
	 * Creates the instance.
	 */
	private synchronized static void createInstance() {
		if (INSTANCE == null) {
			INSTANCE = new Y41bFuncionesSipca();
		}
	}

	/**
	 * Gets the single instance of Y41bFuncionesAuxiliaresPlatea.
	 * 
	 * @return single instance of Y41bFuncionesAuxiliaresPlatea
	 */
	public static Y41bFuncionesSipca getInstance() {
		if (INSTANCE == null)
			createInstance();
		return INSTANCE;
	}

	/**
	 * @param referencia
	 *            String
	 * @param entEmisora
	 *            String
	 * @param suf
	 *            String
	 * @param importeProc
	 *            String
	 * @param fechaFin
	 *            String
	 * @return refDigitoControl
	 */

	public static String referenciaDigitoControl(String referencia,
			String entEmisora, String suf, String importeProc, String fechaFin) {
		logger.info("-----------ENTRA referenciaDigitoControl-----------");
		logger.info("referencia---> " + referencia);// ejemplo:
													// 0000001234
		logger.info("entEmisora---> " + entEmisora);// ejemplo: 4833001
		logger.info("suf----------> " + suf);// ejemplo: 511
		logger.info("importeProc--> " + importeProc);// ejemplo: 5230
														// (en centimos
														// 52,30€)
		logger.info("fechaFin-----> " + fechaFin);// ejemplo: 060414
													// (ddMMyy)

		double ref = Double.parseDouble(referencia);
		double emisora = Double.parseDouble(entEmisora);
		double sufijo = Double.parseDouble(suf);
		double importe = Double.parseDouble(importeProc);
		double identificacion = Double.parseDouble(fechaFin);
		double suma;
		String resultado = null;
		String refDigitoControl = null;
		StringBuffer cadena = new StringBuffer();
		int DigitosControl = 0;

		suma = emisora + sufijo + ref + identificacion + importe;

		DecimalFormat formatoDecimal = new DecimalFormat("0000.0000");
		double division = suma / Y41bConstantes.NUM_97;
		resultado = formatoDecimal.format(division);
		logger.info("division---------> " + resultado);
		resultado = resultado.replaceAll(",", ".");
		logger.info("resultado---------> " + resultado);

		cadena.append(resultado);
		cadena.append("00");

		resultado = cadena.toString();

		logger.info("cadena------------> " + cadena);

		if (resultado.indexOf(".") == -1) {
			// Si no hay ningún decimal los dígitos de control son "00"
			resultado = "00";
			logger.info("primeros 2 digitos decimales----------> " + resultado);
		} else {
			// Nos quedamos con los 2 primeros dígitos decimales
			resultado = resultado.substring(resultado.indexOf(".") + 1)
					.substring(0, 2);
			logger.info("primeros 2 digitos decimales----------> " + resultado);
			if ("00".equals(resultado)) {
				DigitosControl = 0;
			} else {
				// Calculamos 100 - los 2 primeros dígitos decimales
				DigitosControl = Y41bConstantes.NUM_100
						- Integer.parseInt(resultado);
			}
			logger.info("DigitosControl----------> " + DigitosControl);

			refDigitoControl = (referencia + String.valueOf(DigitosControl));

			// si nos devuelve un digito de control, añadimos un cero a la
			// izquierda
			logger.info("String.valueOf(DigitosControl).length()------->"
					+ String.valueOf(DigitosControl).length());
			if (String.valueOf(DigitosControl).length() == 1) {
				refDigitoControl = (referencia + "0" + String
						.valueOf(DigitosControl));
			}

		}

		logger.info("referencia + DigitoControl------------>"
				+ refDigitoControl);

		logger.info("-----------SALE DE referenciaDigitoControl-----------");

		return refDigitoControl;
	}

}
