package com.ejie.y41b.utils.platea;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.platea.Proceedings;

/**
 * The Class Y41bFuncionesAuxiliaresPlatea.
 */
public class Y41bFuncionesAuxiliaresPlatea {
	private static Y41bFuncionesAuxiliaresPlatea INSTANCE = null;

	private static final Logger logger = LoggerFactory.getLogger(Y41bFuncionesAuxiliaresPlatea.class);

	// Private constructor suppresses
	/**
	 * Instantiates a new y41b funciones auxiliares platea.
	 */
	private Y41bFuncionesAuxiliaresPlatea() {

	}

	// creador sincronizado para protegerse de posibles problemas multi-hilo
	// otra prueba para evitar instanciación múltiple
	/**
	 * Creates the instance.
	 */
	private synchronized static void createInstance() {
		if (INSTANCE == null) {
			INSTANCE = new Y41bFuncionesAuxiliaresPlatea();
		}
	}

	/**
	 * Gets the single instance of Y41bFuncionesAuxiliaresPlatea.
	 * 
	 * @return single instance of Y41bFuncionesAuxiliaresPlatea
	 */
	public static Y41bFuncionesAuxiliaresPlatea getInstance() {
		if (INSTANCE == null)
			createInstance();
		return INSTANCE;
	}

	/**
	 * Devuelve codigo procedimiento platea.
	 * 
	 * @param tipoProcedimiento
	 *            the tipo procedimiento
	 * @return the string
	 */
	public static String devuelveCodigoProcedimientoPlatea(String tipoProcedimiento) {
		if (Y41bConstantes.TIPO_PROC_SANCIONES.equals(tipoProcedimiento)) {
			return Y41bConstantes.ID_PROCEDIMIENTO_SANCIONES;
		} else if (Y41bConstantes.TIPO_PROC_ARBITRAJE.equals(tipoProcedimiento)) {
			return Y41bConstantes.ID_PROCEDIMIENTO_ARBITRAJE;
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_ALTA.equals(tipoProcedimiento)) {
			return Y41bConstantes.ID_PROCEDIMIENTO_ADHALTA;
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_MOD.equals(tipoProcedimiento)) {
			return Y41bConstantes.ID_PROCEDIMIENTO_ADHMODIF;
		} else if (Y41bConstantes.TIPO_PROC_ADHESIONES_BAJA.equals(tipoProcedimiento)) {
			return Y41bConstantes.ID_PROCEDIMIENTO_ADHBAJA;
		} else {
			logger.error("NO ENCUENTRO EL TIPO DE PROCEDIMIENTO.devuelveCodigoProcedimientoPlatea");
			return "";
		}
	}

	/**
	 * Elimina los proceedings duplicados
	 * 
	 * @param listProceedings
	 *            lista de proceedings
	 * @return lista de proceedings sin duplicados
	 */
	public static List<Proceedings> eliminarDuplicadosProceedings(List<Proceedings> listProceedings) {
		if (listProceedings != null) {
			Map<String, Proceedings> mapProceedings = new HashMap<String, Proceedings>(listProceedings.size());

			for (Proceedings p : listProceedings) {
				mapProceedings.put(p.getProceedingsID(), p);
			}

			List<Proceedings> listaProceedingsSinDuplicados = new ArrayList<Proceedings>();
			// Agrego cada elemento del map a una nueva lista y muestro cada
			// elemento.
			for (Entry<String, Proceedings> p : mapProceedings.entrySet()) {
				listaProceedingsSinDuplicados.add(p.getValue());
			}
			return listaProceedingsSinDuplicados;
		} else {
			return null;
		}
	}

}
