/**
 * 
 */
package com.ejie.y41b.utils.modulos;

import org.springframework.stereotype.Component;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.contextprovider.AppContext;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.utils.Y41bUtils;

/**
 *  
 * 
 */
@Component(value = "Y41bModuloUtils")
public class Y41bModuloUtils extends SpringBeanAutowiringSupport {
	private static Y41bModuloUtils INSTANCE = null;

	private static ParametrosDao parametrosDao;

	/**
	 * Instantiates a new y41b utils.
	 */
	private Y41bModuloUtils() {

	}

	// creador sincronizado para protegerse de posibles problemas multi-hilo
	// otra prueba para evitar instanciacin mltiple
	/**
	 * Creates the instance.
	 */
	private synchronized static void createInstance() {
		if (Y41bModuloUtils.INSTANCE == null) {
			Y41bModuloUtils.INSTANCE = new Y41bModuloUtils();
			Y41bModuloUtils.parametrosDao = (ParametrosDao) AppContext.getContext().getBean("ParametrosDao");
		}
	}

	/**
	 * Gets the single instance of Y41bUtils.
	 * 
	 * @return single instance of Y41bUtils
	 */
	public static Y41bModuloUtils getInstance() {
		if (Y41bModuloUtils.INSTANCE == null) {
			Y41bModuloUtils.createInstance();
		}
		return Y41bModuloUtils.INSTANCE;
	}

	/**
	 * mostrarArbitraje
	 * 
	 * @return true, if successful
	 */
	public boolean mostrarArbitraje() {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.ACTIVAR_ARBITRAJE);
		parametros = Y41bModuloUtils.parametrosDao.find(parametros);
		return (parametros != null && !Y41bUtils.esNullOCadenaVacia(parametros.getValor())
				&& Y41bConstantes.VALOR_SI.equals(parametros.getValor()));
	}

	/**
	 * mostrarArbitraje
	 * 
	 * @return true, if successful
	 */
	public boolean mostrarPagoPericialColegio() {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.ACTIVAR_PAGO_PERICIAL_COLEGIO);
		parametros = Y41bModuloUtils.parametrosDao.find(parametros);
		return (parametros != null && !Y41bUtils.esNullOCadenaVacia(parametros.getValor())
				&& Y41bConstantes.VALOR_SI.equals(parametros.getValor()));
	}

	/**
	 * mostrarAdhesiones
	 * 
	 * @return true, if successful
	 */
	public boolean mostrarAdhesiones() {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.ACTIVAR_ADHESIONES);
		parametros = Y41bModuloUtils.parametrosDao.find(parametros);
		return (parametros != null && !Y41bUtils.esNullOCadenaVacia(parametros.getValor())
				&& Y41bConstantes.VALOR_SI.equals(parametros.getValor()));
	}

	/**
	 * mostrarControlMercado
	 * 
	 * @return true, if successful
	 */
	public boolean mostrarControlMercado() {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.ACTIVAR_CONTROLMERCADO);
		parametros = this.parametrosDao.find(parametros);
		if (parametros != null && !Y41bUtils.esNullOCadenaVacia(parametros.getValor())
				&& Y41bConstantes.VALOR_SI.equals(parametros.getValor())) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * mostrarADOEIKA
	 * 
	 * @return true, if successful
	 */
	public boolean mostrarADOEIKA() {
		return this.parametrosDao.superadaFechaEIKA();
	}

	/**
	 * anyoFechaADOEIKA
	 * 
	 * @return int
	 */
	public int anyoFechaADOEIKA() {
		return this.parametrosDao.anyoFechaEIKA();
	}

	/**
	 * obtenerCodOrganismoAECOSAN
	 * 
	 * @return String
	 */
	public String obtenerCodOrganismoAECOSAN() {
		Parametros parametros = new Parametros();
		parametros.setParametro(Y41bConstantes.INSPECCION_PARAMETRO_COD_ORGANISMO_AECOSAN);
		parametros = this.parametrosDao.find(parametros);
		if (parametros != null) {
			return parametros.getValor();
		} else {
			return "";
		}
	}
}
