package com.ejie.y41b.utils.mail;

import java.util.ArrayList;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.AttachFile;
import com.ejie.y41b.utils.Y41bUtils;
import com.ejie.y41b.utils.config.Y41bConfig;

/**
 * V74nbMailSender
 * 
 *  
 */
public class Y41bMailSender {

	/**
	 * Metodo
	 * 
	 */
	public Y41bMailSender() {
		super();
	}

	/**
	 * Metodo send
	 * 
	 * @param objMsg
	 *            (V34bbMailMessage)
	 * @throws Exception
	 *             Excepci�n
	 */
	public void send(Y41bMailMessage objMsg) throws Exception {

		Session session = this.getSession(objMsg);
		MimeMessage message = new MimeMessage(session);
		this.setRecipes(message, objMsg);
		this.setSubject(message, objMsg);
		this.setFrom(message, objMsg);
		Multipart multipart = new MimeMultipart();
		this.setBodyContent(multipart, objMsg);
		this.setAttachments(multipart, objMsg);
		try {
			message.setContent(multipart);
			Transport.send(message);
		} catch (SendFailedException e) {
			e.printStackTrace();
			// Si hay direcciones invalidas --> se eliminan estas del mensaje y
			// depu�s se reintenta el env�o.
			Address recipes[] = e.getInvalidAddresses();
			this.removeRecipesFromMessage(message, recipes);
			try {
				Transport.send(message);
			} catch (MessagingException e1) {
				e.printStackTrace();
				throw new Exception("Fallo el envio de email. Error escribiendo los contenidos o enviando", e1);
			}
		} catch (MessagingException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Error escribiendo los contenidos o enviando", e);
		} catch (Exception e2) {
			e2.printStackTrace();
			throw new Exception("Fallo el envio de email. Error escribiendo los contenidos o enviando", e2);
		}
	}

	/**
	 * Metodo setBodyContent
	 * 
	 * @param multipart
	 *            Multipart
	 * @param objMsg
	 *            V34bbMailMessage
	 * @throws Exception
	 *             Excepci�n
	 */
	private void setBodyContent(Multipart multipart, Y41bMailMessage objMsg) throws Exception {
		try {
			BodyPart messageBodyPart = new MimeBodyPart();
			messageBodyPart.setContent(objMsg.getMsgBodyText(), "text/html; charset=iso-8859-1");
			multipart.addBodyPart(messageBodyPart);
		} catch (MessagingException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Error escribiendo el contenido del body", e);
		}
	}

	/**
	 * Metodo setAttachments
	 * 
	 * @param multipart
	 *            Multipart
	 * @param objMsg
	 *            V34bbMailMessage
	 * @throws Exception
	 *             Excepci�n
	 */
	private void setAttachments(Multipart multipart, Y41bMailMessage objMsg) throws Exception {
		try {
			// Se controla la existencia de attachments para permitir el envio
			// de mails sin ellos
			if (objMsg != null && objMsg.getAttachments() != null) {
				for (int i = 0; i < objMsg.getAttachments().size(); i++) {
					this.getAttachment(i, multipart, objMsg);
				}
			}
		} catch (MessagingException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Error escribiendo el adjunto del correo del body", e);
		}
	}

	/**
	 * Metodo getAddress
	 * 
	 * @param i
	 *            int
	 * @param multipart
	 *            Multipart
	 * @param objMsg
	 *            V34bbMailMessage
	 * @throws Exception
	 *             Excepci�n
	 */
	private void getAttachment(int i, Multipart multipart, Y41bMailMessage objMsg) throws Exception {

		try {
			AttachFile fileattach = (AttachFile) objMsg.getAttachments().get(i);
			byte[] raw = fileattach.getAdjunto().getBytes(1, (int) fileattach.getAdjunto().length());

			ByteArrayDataSource ds = new ByteArrayDataSource(raw, fileattach.getContentType());
			DataHandler dh = new DataHandler(ds);

			BodyPart attach = new MimeBodyPart();
			attach.setDataHandler(dh);
			attach.setFileName(fileattach.getNombre());
			if (!Y41bUtils.esNullOCadenaVacia(fileattach.getContentId())) {
				attach.setHeader("Content-ID", "<" + fileattach.getContentId() + ">");
			}
			multipart.addBodyPart(attach);

		} catch (AddressException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n es erronea", e);

		} catch (MessagingException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n es erronea", e);
		}

	}

	/**
	 * Metodo setFrom
	 * 
	 * @param message
	 *            MimeMessage
	 * @param objMsg
	 *            V34bbMailMessage
	 * @throws Exception
	 *             Excepci�n
	 */
	private void setFrom(MimeMessage message, Y41bMailMessage objMsg) throws Exception {
		try {
			if (objMsg.getFrom() != null) {
				message.setFrom(new InternetAddress(objMsg.getFrom()));
			}
		} catch (AddressException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n del From es erronea", e);

		} catch (MessagingException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n del From es erronea", e);
		}
	}

	/**
	 * Metodo setFrom
	 * 
	 * @param message
	 *            MimeMessage
	 * @param objMsg
	 *            V34bbMailMessage
	 * @throws Exception
	 *             Excepci�n
	 */
	private void setSubject(MimeMessage message, Y41bMailMessage objMsg) throws Exception {
		try {
			if (objMsg.getSubject() != null) {
				message.setSubject(objMsg.getSubject());
			} else {
				message.setSubject("");
			}
		} catch (MessagingException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Subject incorrectp", e);
		}

	}

	/**
	 * Metodo setRecipes
	 * 
	 * @param message
	 *            MimeMessage
	 * @param objMsg
	 *            V34bbMailMessage
	 * @throws Exception
	 *             Excepci�n
	 */
	private void setRecipes(MimeMessage message, Y41bMailMessage objMsg) throws Exception {

		try {

			for (int i = 0; i < objMsg.getTo().size(); i++) {

				this.getAddress(i, message, objMsg);
				// address = new InternetAddress((String)objMsg.getTo().get(i));
				// message.addRecipient(Message.RecipientType.TO, address);
			}

			for (int i = 0; i < objMsg.getCC().size(); i++) {

				this.getAddress1(i, message, objMsg);
				// Address address1 = new
				// InternetAddress((String)objMsg.getCC().get(i));
				// message.addRecipient(Message.RecipientType.CC, address1);
			}

			for (int i = 0; i < objMsg.getBCC().size(); i++) {
				this.getAddress2(i, message, objMsg);
				// Address address2 = new
				// InternetAddress((String)objMsg.getBCC().get(i));
				// message.addRecipient(Message.RecipientType.BCC, address2);
			}
		} catch (AddressException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n es erronea", e);

		} catch (MessagingException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n es erronea", e);
		}
	}

	/**
	 * Metodo getAddress
	 * 
	 * @param i
	 *            int
	 * @param message
	 *            MimeMessage
	 * @param objMsg
	 *            V34bbMailMessage
	 * @throws Exception
	 *             Excepci�n
	 */
	private void getAddress(int i, MimeMessage message, Y41bMailMessage objMsg) throws Exception {

		try {
			Address address = new InternetAddress((String) objMsg.getTo().get(i));
			message.addRecipient(Message.RecipientType.TO, address);
		} catch (AddressException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n es erronea", e);

		} catch (MessagingException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n es erronea", e);
		}

	}

	/**
	 * Metodo getAddress1
	 * 
	 * @param i
	 *            int
	 * @param message
	 *            MimeMessage
	 * @param objMsg
	 *            V34bbMailMessage
	 * @throws Exception
	 *             Excepci�n
	 */
	private void getAddress1(int i, MimeMessage message, Y41bMailMessage objMsg) throws Exception {

		try {
			Address address = new InternetAddress((String) objMsg.getCC().get(i));
			message.addRecipient(Message.RecipientType.CC, address);
		} catch (AddressException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n es erronea", e);

		} catch (MessagingException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n es erronea", e);
		}

	}

	/**
	 * Metodo getAddress2
	 * 
	 * @param i
	 *            int
	 * @param message
	 *            MimeMessage
	 * @param objMsg
	 *            V34bbMailMessage
	 * @throws Exception
	 *             Excepci�n
	 */
	private void getAddress2(int i, MimeMessage message, Y41bMailMessage objMsg) throws Exception {

		try {
			Address address = new InternetAddress((String) objMsg.getBCC().get(i));
			message.addRecipient(Message.RecipientType.BCC, address);
		} catch (AddressException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n es erronea", e);

		} catch (MessagingException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n es erronea", e);
		}

	}

	/**
	 * Metodo getSession
	 * 
	 * @param objMsg
	 *            V34bbMailMessage
	 * @return session Session
	 */
	private Session getSession(Y41bMailMessage objMsg) {

		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);

		String local = (String) prop.getProperty("y41bVistaWar.entorno.local");

		if (local.equals("true")) {
			Properties props = new Properties();
			final String username = prop.getProperty("y41bVistaWar.mail.local.username");
			final String password = prop.getProperty("y41bVistaWar.mail.local.password");
			props.put("mail.smtp.host", (String) prop.getProperty("y41bVistaWar.mail.local.smtp"));
			props.put("mail.smtp.auth", "true");
			props.put("mail.smtp.starttls.enable", "true");
			props.put("mail.smtp.port", (String) prop.getProperty("y41bVistaWar.mail.local.port"));

			Session session = Session.getDefaultInstance(props, new javax.mail.Authenticator() {
				protected PasswordAuthentication getPasswordAuthentication() {
					return new PasswordAuthentication(username, password);
				}
			});

			return session;
		} else {
			Properties props = new Properties();
			props.put("mail.transport.protocol", "smtp");
			props.put("mail.smtp.host", objMsg.getEmailServer());
			Session session = Session.getInstance(props);

			return session;
		}
	}

	/**
	 * Metodo removeRecipesFromMessage
	 * 
	 * @param message
	 *            MimeMessage
	 * @param recipients
	 *            Address []
	 * @throws Exception
	 *             Excepci�n
	 */
	private void removeRecipesFromMessage(MimeMessage message, Address[] recipients) throws Exception {

		try {

			ArrayList to = new ArrayList();
			Address[] arto = message.getRecipients(Message.RecipientType.TO);
			if (arto != null) {
				for (int i = 0; i < arto.length; i++) {
					to.add(arto[i]);
				}
			}

			ArrayList cc = new ArrayList();
			Address[] arcc = message.getRecipients(Message.RecipientType.CC);
			if (arcc != null) {
				for (int i = 0; i < arcc.length; i++) {
					cc.add(arcc[i]);
				}
			}

			ArrayList bcc = new ArrayList();
			Address[] arbcc = message.getRecipients(Message.RecipientType.BCC);
			if (arbcc != null) {
				for (int i = 0; i < arbcc.length; i++) {
					bcc.add(arbcc[i]);
				}
			}

			for (int i = 0; i < recipients.length; i++) {
				Address recipient = recipients[i];

				if (to.contains(recipient)) {
					to.remove(recipient);
					continue;
				}
				if (cc.contains(recipient)) {
					cc.remove(recipient);
					continue;
				}
				if (bcc.contains(recipient)) {
					bcc.remove(recipient);
					continue;
				}
			}

			arbcc = null;
			arto = null;
			arcc = null;

			if (to.size() > 0) {
				arto = new Address[to.size()];
				for (int i = 0; i < to.size(); i++) {
					arto[i] = (Address) to.get(i);
				}
			}
			if (cc.size() > 0) {
				arcc = new Address[cc.size()];
				for (int i = 0; i < cc.size(); i++) {
					arcc[i] = (Address) cc.get(i);
				}
			}
			if (bcc.size() > 0) {
				arbcc = new Address[bcc.size()];
				for (int i = 0; i < bcc.size(); i++) {
					arbcc[i] = (Address) bcc.get(i);
				}
			}

			message.setRecipients(Message.RecipientType.TO, arto);
			message.setRecipients(Message.RecipientType.CC, arcc);
			message.setRecipients(Message.RecipientType.BCC, arbcc);

		} catch (MessagingException e) {
			e.printStackTrace();
			throw new Exception("Fallo el envio de email. Direcci�n es erronea", e);
		}

	}

}
