package com.ejie.y41b.utils.jdbc;

import java.sql.Blob;
import java.sql.SQLException;

public class Y41bJdbcUtils {
	private static Y41bJdbcUtils INSTANCE = null;

	// Private constructor suppresses
	private Y41bJdbcUtils() {

	}

	// creador sincronizado para protegerse de posibles problemas multi-hilo
	// otra prueba para evitar instanciación múltiple
	private synchronized static void createInstance() {
		if (INSTANCE == null) {
			INSTANCE = new Y41bJdbcUtils();
		}
	}

	public static Y41bJdbcUtils getInstance() {
		if (INSTANCE == null)
			createInstance();
		return INSTANCE;
	}

	/**
	 * Convierto un Blob a un byte[]
	 * 
	 * @param blob
	 * @return byte[]
	 */
	public static byte[] ConvertBlobToByte(Blob blob) {
		byte[] raw = null;

		try {
			if (blob != null) {
				raw = blob.getBytes(1, (int) blob.length());
			}
		} catch (SQLException e) {
			return null;
		} catch (Throwable e) {
			return null;
		}

		return raw;
	}

}
