package com.ejie.y41b.utils.fecha;

import java.text.DateFormatSymbols;
import java.text.spi.DateFormatSymbolsProvider;
import java.util.Locale;

public class DateFormatSymbolsProvider_eu extends DateFormatSymbolsProvider {
	private Locale basque;

	public DateFormatSymbolsProvider_eu() {
		this.basque = new Locale("eu");
	}

	public DateFormatSymbols getInstance(Locale locale) {
		if (locale.getLanguage().equals(this.basque.getLanguage())) {
			DateFormatSymbols df = new DateFormatSymbols();
			String[] newMonths = { "urtarrila", "otsaila", "martxoa",
					"apirila", "maiatza", "ekaina", "uztaila", "abuztua",
					"iraila", "urria", "azaroa", "abendua" };
			String[] newShortMonths = { "urt", "ots", "mar", "api", "mai",
					"eka", "uzt", "abu", "ira", "urr", "aza", "abe" };
			String[] newShortWeekdays = { "", "iga", "leh", "art", "azk",
					"oeg", "oir", "lar" };
			String[] newWeekdays = { "", "igandea", "astelehena", "asteartea",
					"asteazkena", "osteguna", "ostirala", "larunbata" };
			df.setMonths(newMonths);

			df.setShortMonths(newShortMonths);
			df.setShortWeekdays(newShortWeekdays);
			df.setWeekdays(newWeekdays);
			return df;
		}
		return null;
	}

	public Locale[] getAvailableLocales() {
		return new Locale[] { this.basque };
	}
}
