/**
 * 
 */
package com.ejie.y41b.utils.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import com.ejie.y41b.constantes.Y41bConstantes;

/**
 * 
 * Excepcion generica para los proyectos de llamada al WS AA66.
 * 
 *  
 * 
 */
public class Y41bAA66Exception extends Exception implements Serializable {

	private static final long serialVersionUID = 1L;

	private String codigoError;
	private String descripcionCastellano;
	private String descripcionEuskera;
	private String idErroneo;
	private String nivelGravedadError;
	private List<Y41bAA66Exception> listY41bAA66Exception = new ArrayList<Y41bAA66Exception>();

	public Y41bAA66Exception() {
		codigoError = "";
		descripcionCastellano = "";
		descripcionEuskera = "";
		idErroneo = "";
		nivelGravedadError = "";
	}

	public Y41bAA66Exception(String codigoError, String descripcionCastellano,
			String descripcionEuskera, String idErroneo,
			String nivelGravedadError) {
		this.codigoError = codigoError;
		this.descripcionCastellano = descripcionCastellano;
		this.descripcionEuskera = descripcionEuskera;
		this.idErroneo = idErroneo;
		this.nivelGravedadError = nivelGravedadError;
	}

	public Y41bAA66Exception(List<Y41bAA66Exception> listY41bAA66Exception,
			String nivelGravedadError) {
		this.listY41bAA66Exception = listY41bAA66Exception;
		this.nivelGravedadError = nivelGravedadError;
	}

	/**
	 * @return the codigoError
	 */
	public String getCodigoError() {
		return codigoError;
	}

	/**
	 * @param codigoError
	 *            the codigoError to set
	 */
	public void setCodigoError(String codigoError) {
		this.codigoError = codigoError;
	}

	/**
	 * @return the descripcionCastellano
	 */
	public String getDescripcionCastellano() {
		return descripcionCastellano;
	}

	/**
	 * @param descripcionCastellano
	 *            the descripcionCastellano to set
	 */
	public void setDescripcionCastellano(String descripcionCastellano) {
		this.descripcionCastellano = descripcionCastellano;
	}

	/**
	 * @return the descripcionEuskera
	 */
	public String getDescripcionEuskera() {
		return descripcionEuskera;
	}

	/**
	 * @param descripcionEuskera
	 *            the descripcionEuskera to set
	 */
	public void setDescripcionEuskera(String descripcionEuskera) {
		this.descripcionEuskera = descripcionEuskera;
	}

	/**
	 * @return the idErroneo
	 */
	public String getIdErroneo() {
		return idErroneo;
	}

	/**
	 * @param idErroneo
	 *            the idErroneo to set
	 */
	public void setIdErroneo(String idErroneo) {
		this.idErroneo = idErroneo;
	}

	/**
	 * @return the nivelGravedadError
	 */
	public String getNivelGravedadError() {
		return nivelGravedadError;
	}

	/**
	 * @param nivelGravedadError
	 *            the nivelGravedadError to set
	 */
	public void setNivelGravedadError(String nivelGravedadError) {
		this.nivelGravedadError = nivelGravedadError;
	}

	/**
	 * @return the listY41bAA66Exception
	 */
	public List<Y41bAA66Exception> getListY41bAA66Exception() {
		return listY41bAA66Exception;
	}

	/**
	 * @param listY41bAA66Exception
	 *            the listY41bAA66Exception to set
	 */
	public void setListY41bAA66Exception(
			List<Y41bAA66Exception> listY41bAA66Exception) {
		this.listY41bAA66Exception = listY41bAA66Exception;
	}

	public String getMessage() {
		return getDescripcionCastellano();
	}

	public String getDescripcion(Locale locale) {
		if (Y41bConstantes.EUSKERA.equals(locale.toString())) {
			return getDescripcionEuskera();
		}
		return getDescripcionCastellano();
	}
}
