package com.ejie.y41b.utils.dokusi;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Y41bUtilsDokusi {
	private static Y41bUtilsDokusi INSTANCE = null;

	// Private constructor suppresses
	private Y41bUtilsDokusi() {

	}

	// creador sincronizado para protegerse de posibles problemas multi-hilo
	// otra prueba para evitar instanciación múltiple
	private synchronized static void createInstance() {
		if (INSTANCE == null) {
			INSTANCE = new Y41bUtilsDokusi();
		}
	}

	public static Y41bUtilsDokusi getInstance() {
		if (INSTANCE == null)
			createInstance();
		return INSTANCE;
	}

	/**
	 * Decodifica una cadena de caracteres que se encuentra codificada en
	 * formato Base64
	 * 
	 * @param encData
	 *            Datos a decodificar
	 * @return Bytes con los datos decodificados
	 * @throws Exception
	 *             e
	 */
	public static byte[] decode(String encData) throws Exception {
		byte[] decData = null;
		BASE64Decoder decoder;
		decoder = new BASE64Decoder();

		decData = decoder.decodeBuffer(encData);

		return decData;
	}

	/**
	 * Codifica en Base64 un array de bytes
	 * 
	 * @param decData
	 *            Datos a codificar
	 * @return String con los datos codificados en Base64
	 * @throws
	 */
	public static String encode(byte[] decData) {
		String encData;
		BASE64Encoder encoder;
		encoder = new BASE64Encoder();
		encData = encoder.encode(decData);
		return encData;
	}

}
