package com.ejie.y41b.utils.documentos;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import sun.misc.BASE64Encoder;

/**
 *  
 */
public class Y41bDocumento {
	/**
	 * @param pathDocumento
	 *            String
	 * @return byte
	 * @throws Exception
	 *             e
	 */
	public static byte[] leerArchivoOrigen(String pathDocumento)
			throws Exception {
		byte[] fileBytes = null;
		File elFicheroRTF = new File(pathDocumento);
		FileInputStream fis = new FileInputStream(elFicheroRTF);
		long length = elFicheroRTF.length();

		fileBytes = new byte[(int) length];
		int offset = 0;
		int numRead = 0;
		while (offset < fileBytes.length
				&& (numRead = fis.read(fileBytes, offset, fileBytes.length
						- offset)) >= 0) {
			offset += numRead;
		}
		fis.close();
		return fileBytes;
	}

	/**
	 * Crea un objeto de la clase Document a partir del String XML que recibe
	 * como parametro
	 * 
	 * @param xml
	 *            String xml
	 * @throws Exception
	 *             e
	 * @return Document objeto de la clase Document.
	 */

	public static Document fncCrearDoc(String xml) throws Exception {
		// final String metodo ="crearDoc";
		Document doc = null;
		DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory
				.newInstance();
		DocumentBuilder documentBuilder = documentBuilderFactory
				.newDocumentBuilder();
		try {
			doc = documentBuilder.parse((InputStream) new ByteArrayInputStream(
					xml.getBytes("UTF-8")));
		} catch (SAXException sax) {

			throw sax;
		}
		return doc;
	}

	/**
	 * Recupera el valor de una etiqueta(nodo) de un documento
	 * 
	 * @param document
	 *            - el documento del que se recupera el valor de la etiqueta
	 * @param rutaElemento
	 *            - la ruta del nodo dentro del documento, separado por '.'
	 * @throws Exception
	 *             e
	 * @return String - valor de la etiqueta (nodo)
	 */

	public static String fncRecuperarValorElemento(Document document,
			String rutaElemento) throws Exception {
		String resultado = null;
		StringTokenizer tokCadena = null;
		String bloque = null;
		NodeList listaNodos = null;
		Element elemento = null;
		int contador = 0;
		tokCadena = new StringTokenizer(rutaElemento, ".");
		while (tokCadena.hasMoreTokens()) {
			bloque = tokCadena.nextToken();
			if (contador == 0) {
				listaNodos = document.getElementsByTagName(bloque);
			} else {
				listaNodos = elemento.getElementsByTagName(bloque);
			}
			elemento = (Element) listaNodos.item(0);
			contador++;
		}
		if (listaNodos.item(0).getChildNodes().item(0) != null) {
			resultado = (listaNodos.item(0).getChildNodes().item(0))
					.getNodeValue();
		}
		return resultado;
	}

	/**
	 * Recupera la lista de nodos de una etiqueta
	 * 
	 * @param document
	 *            - el documento del que se recupera la lista de nodos
	 * @param rutaElemento
	 *            - la ruta de la etiqueta dentro del documento, separado por
	 *            '.'
	 * @throws Exception
	 *             e
	 * @return NodeList - lista de nodos
	 */

	public static NodeList fncRecuperarListaElementos(Document document,
			String rutaElemento) throws Exception {
		NodeList listaResultado = null;
		StringTokenizer tokCadena = null;
		String bloque = null;
		NodeList listaNodos = null;
		Element elemento = null;
		int contador = 0;
		tokCadena = new StringTokenizer(rutaElemento, ".");
		while (tokCadena.hasMoreTokens()) {
			bloque = tokCadena.nextToken();
			if (contador == 0) {
				listaNodos = document.getElementsByTagName(bloque);
			} else {
				listaNodos = elemento.getElementsByTagName(bloque);
			}
			elemento = (Element) listaNodos.item(0);
			contador++;
		}
		if (listaNodos != null) {
			listaResultado = listaNodos;
		}
		return listaResultado;
	}

	/**
	 * Devuelve un nodo de una lista de nodos
	 * 
	 * @param listaNodos
	 *            NodeList: Lista de nodos
	 * @param elemento
	 *            int:El elemento de la lista de nodos
	 * @param nodo
	 *            int: El nodo dentro del elemento
	 * @throws Exception
	 *             e
	 * @return Node
	 */
	public static Node fncRecuperarNodo(NodeList listaNodos, int elemento,
			int nodo) throws Exception {
		return listaNodos.item(elemento).getChildNodes().item(nodo);
	}

	/**
	 * Devuelve el valor de un atributo
	 * 
	 * @param nodo
	 *            Node:Nodo que contiene el atributo
	 * @param strPfAtributo
	 *            String:Nombre del atributo
	 * @return String:Valor del atributo
	 * @throws Exception
	 *             e
	 */
	public static String fncValorAtributo(Node nodo, String strPfAtributo)
			throws Exception {
		if (nodo.hasAttributes()) {
			try {
				return nodo.getAttributes().getNamedItem(strPfAtributo)
						.getNodeValue();
			} catch (Exception e) {
				return "";
			}
		} else {
			return "";
		}
	}

	/**
	 * Codifica en Base64 un array de bytes
	 * 
	 * @param decData
	 *            Datos a codificar
	 * @return String con los datos codificados en Base64
	 * @throws
	 */
	public static String encode(byte[] decData) {
		String encData;
		BASE64Encoder encoder;
		encoder = new BASE64Encoder();
		encData = encoder.encode(decData);
		return encData;
	}// Fin encode

	/**
	 * Este m�todo elimina el caracter especial que se encuentre en una cadena
	 * deteminada.
	 * 
	 * @param s
	 *            String
	 * @param caracterEsp
	 *            char
	 * @return String
	 */
	public static String quitaEsp(String s, char caracterEsp) {
		if (s.indexOf(caracterEsp) == -1) {
			return (s);
		}
		StringBuffer resultado = new StringBuffer();
		int longitud = s.length();
		int i = 0;

		for (; i < longitud; i++) {
			char c = s.charAt(i);
			if (c == caracterEsp) {
				resultado.append("");
			} else {
				resultado.append(c);
			}
		}
		return (resultado.toString());
	}

	/**
	 * @param integrationToken
	 *            String
	 * @param paramXml
	 *            String
	 * @common operation
	 * @return :String
	 * @throws Exception
	 *             e
	 */
	public String generateDocument(String paramXml) throws Exception {
		StringBuffer parametrosXML = new StringBuffer(paramXml);
		parametrosXML = new StringBuffer(Y41bDocumento.quitaEsp(
				parametrosXML.toString(), '\r'));
		parametrosXML = new StringBuffer(Y41bDocumento.quitaEsp(
				parametrosXML.toString(), '\n'));
		parametrosXML = new StringBuffer(Y41bDocumento.quitaEsp(
				parametrosXML.toString(), '\t'));
		parametrosXML = new StringBuffer(Y41bDocumento.quitaEsp(
				parametrosXML.toString(), '\b'));
		parametrosXML = new StringBuffer(parametrosXML.toString().replaceAll(
				"  ", ""));
		parametrosXML = new StringBuffer(parametrosXML.toString().replaceAll(
				"> <", "><"));
		String documentoOrigen = null;

		try {
			Document documento = Y41bDocumento.fncCrearDoc(parametrosXML
					.toString());
			String rutaPathXml = "TemplateDocument.Path";
			String rutaPathDocumentFields = "TemplateDocument.DocumentFields";

			String pathDocumento = Y41bDocumento.fncRecuperarValorElemento(
					documento, rutaPathXml);

			NodeList datosDocumento = Y41bDocumento.fncRecuperarListaElementos(
					documento, rutaPathDocumentFields);
			int numeroValores = datosDocumento.item(0).getChildNodes()
					.getLength();
			documentoOrigen = new String(
					Y41bDocumento.leerArchivoOrigen(pathDocumento));

			for (int i = 0; i < numeroValores; i++) {
				Node nodoValor = Y41bDocumento.fncRecuperarNodo(datosDocumento,
						0, i);
				String valorAtributo = Y41bDocumento.fncValorAtributo(
						nodoValor, "Name");

				String valorDato = "";
				if (nodoValor.getFirstChild() != null) {
					valorDato = nodoValor.getFirstChild().getNodeValue();
				}

				documentoOrigen = documentoOrigen.replaceAll(valorAtributo,
						valorDato);
			}

			byte[] data = documentoOrigen.getBytes();

			documentoOrigen = Y41bDocumento.encode(data);
		} catch (Exception e) {
			throw e;
		}

		return documentoOrigen;
	}

	/**
	 * @param integrationToken
	 *            String
	 * @param paramXml
	 *            String
	 * @param plantilla
	 *            String
	 * @common operation
	 * @return :String
	 * @throws Exception
	 *             e
	 */
	public String generateDocument(String paramXml, String plantilla)
			throws Exception {
		StringBuffer parametrosXML = new StringBuffer(paramXml);
		parametrosXML = new StringBuffer(Y41bDocumento.quitaEsp(
				parametrosXML.toString(), '\r'));
		parametrosXML = new StringBuffer(Y41bDocumento.quitaEsp(
				parametrosXML.toString(), '\n'));
		parametrosXML = new StringBuffer(Y41bDocumento.quitaEsp(
				parametrosXML.toString(), '\t'));
		parametrosXML = new StringBuffer(Y41bDocumento.quitaEsp(
				parametrosXML.toString(), '\b'));
		// parametrosXML = new
		// StringBuffer(parametrosXML.toString().replaceAll("  ", ""));
		parametrosXML = new StringBuffer(parametrosXML.toString().replaceAll(
				"> <", "><"));

		String documentoOrigen = plantilla;

		try {
			Document documento = Y41bDocumento.fncCrearDoc(parametrosXML
					.toString());

			String rutaPathDocumentFields = "TemplateDocument.DocumentFields";

			NodeList datosDocumento = Y41bDocumento.fncRecuperarListaElementos(
					documento, rutaPathDocumentFields);

			int numeroValores = datosDocumento.item(0).getChildNodes()
					.getLength();

			for (int i = 0; i < numeroValores; i++) {
				Node nodoValor = Y41bDocumento.fncRecuperarNodo(datosDocumento,
						0, i);
				String valorAtributo = Y41bDocumento.fncValorAtributo(
						nodoValor, "Name");

				String valorDato = "";
				if (nodoValor.getFirstChild() != null) {
					valorDato = nodoValor.getFirstChild().getNodeValue();
				}

				documentoOrigen = documentoOrigen.replaceAll(valorAtributo,
						valorDato);
			}
		} catch (Exception e) {
			throw e;
		}
		// Vuelve a poner los dolares en las cadenas
		return unEscaparCadena(documentoOrigen);
	}

	/***
	 * 
	 * @param cadena
	 *            cadena
	 * @return devuelve la cadena con los dolares
	 * 
	 */
	private static String unEscaparCadena(String cadena) {
		// Reemplazar la cadena siempre que no sea en el caracter 0 o en el
		// último.
		if (cadena.length() > 0) {
			return cadena.replaceAll("\\'24", "\\$");
		}
		return cadena;
	}

	/**
	 * 
	 * @param inputStream
	 * @return
	 * @throws IOException
	 */
	public static byte[] readDocumentContent(InputStream inputStream)
			throws IOException {
		byte[] result = null;

		try {
			ByteArrayOutputStream buffer = new ByteArrayOutputStream();
			int nRead;
			byte[] data = new byte[16384];

			while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
				buffer.write(data, 0, nRead);
			}
			buffer.flush();
			result = buffer.toByteArray();
		} catch (IOException e) {
			throw e;
		}

		return result;
	}
}
