package com.ejie.y41b.utils.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import com.ejie.y41b.constantes.Y41bConstantes;

public class Y41bConfig {

	private Y41bConfig() {
	}

	/**
	 * Static method to obtain properties
	 * 
	 * @param nombreFichero
	 * @return properties
	 */
	public static Properties loadProperties(String nombreFichero) {
		return getProperties(nombreFichero);

	}

	/**
	 * Método que carga el fichero de propiedades
	 * 
	 * @param nombreFichero
	 *            String
	 * @return Properties
	 */
	public static Properties getProperties(String nombreFichero) {

		String propertiesLog = nombreFichero;
		InputStream configLog = Y41bConfig.class
				.getResourceAsStream(propertiesLog);
		Properties pLog = new Properties();

		try {
			pLog.load(configLog);
		} catch (IOException e) {
			e.printStackTrace();
		}

		return pLog;
	}

	/**
	 * Devuelve el properties pasado por parametro del fichero de configuracion
	 * de la aplicacion (Y41bConstantes.CONFIG_PATH)
	 * 
	 * @param strPfClave
	 *            the strPfClave
	 * @return configAplication
	 */
	public static String getConfigAplicacion(final String strPfClave) {
		String resultado = null;
		if (strPfClave != null) {
			final Properties dokusiProp = loadProperties(Y41bConstantes.CONFIG_PATH);
			if (dokusiProp.containsKey(strPfClave)) {
				resultado = dokusiProp.getProperty(strPfClave);
			}
		}
		return resultado;
	}
}
