package com.ejie.y41b.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.UnknownFormatConversionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.xml.sax.InputSource;

import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.dokusi.Documento;
import com.ejie.y41b.utils.config.Y41bConfig;
import com.ejie.y41b.utils.fecha.DateFormatSymbolsProvider_eu;
import com.ejie.y41b.utils.fichero.Y41bFicheroUtils;
import com.ejie.y41b.utils.mail.Y41bMailMessage;
import com.ejie.y41b.utils.mail.Y41bMailSender;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;

/**
 * The Class Y41bUtils.
 */
public class Y41bUtils {
	private static Y41bUtils INSTANCE = null;

	private static final int MAXCADENABYTE = 1024;

	private static final DateFormat ANNIO_FORMAT = new SimpleDateFormat("yyyy");

	private static final DateFormat FECHA_LARGA_FORMAT_ALT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

	private static final Logger logger = LoggerFactory.getLogger(Y41bUtils.class);

	// Private constructor suppresses
	/**
	 * Instantiates a new y41b utils.
	 */
	private Y41bUtils() {

	}

	// creador sincronizado para protegerse de posibles problemas multi-hilo
	// otra prueba para evitar instanciacin mltiple
	/**
	 * Creates the instance.
	 */
	private synchronized static void createInstance() {
		if (INSTANCE == null) {
			INSTANCE = new Y41bUtils();
		}
	}

	/**
	 * Gets the single instance of Y41bUtils.
	 * 
	 * @return single instance of Y41bUtils
	 */
	public static Y41bUtils getInstance() {
		if (INSTANCE == null)
			createInstance();
		return INSTANCE;
	}

	/**
	 * Convert to ut f8.
	 * 
	 * @param label
	 *            the label
	 * @return the string
	 */
	public static String ConvertToUTF8(String label) {
		String temp = "";

		try {
			temp = new String(label.getBytes("ISO-8859-1"), "UTF8");
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}

		return temp;
	}

	/**
	 * Devuelve la fecha de hoy en el formato correspondiente con el idioma
	 * 
	 * @return Date fecha hoy
	 */
	public static Date obtenerFechaHoy() {
		return Calendar.getInstance().getTime();
	}

	/**
	 * Devuelve la fecha de hoy en el formato correspondiente con el idioma sin
	 * hora
	 * 
	 * @return Date fecha hoy sin hora
	 */
	public static Date obtenerFechaHoySinHora() {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);

		return calendar.getTime();
	}

	/**
	 * Parsea un string de fecha con el formato correspondiente al idioma del
	 * locale y devuelve la fecha.
	 * 
	 * @param dateString
	 *            the date string
	 * @param locale
	 *            the locale
	 * @return the date
	 * @throws Exception
	 *             the exception
	 */
	public static Date parseDate(String dateString, Locale locale) throws Exception {
		if (dateString != null && !dateString.equals("")) {
			DateFormat dateFormat = null;
			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				dateFormat = new SimpleDateFormat("dd/MM/yyyy");
			} else if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				dateFormat = new SimpleDateFormat("yyyy/MM/dd");
			} else {
				throw new Exception("Language date parse support not implemented for this language.");
			}
			return dateFormat.parse(dateString);
		}
		return null;
	}

	/**
	 * Parsea un string de fecha con el formato correspondiente al idioma del
	 * locale y devuelve la fecha.
	 * 
	 * @param dateString
	 *            the date string
	 * @param locale
	 *            the locale
	 * @return the date
	 * @throws Exception
	 *             the exception
	 */
	public static Date parseDateTime(String dateTimeString, Locale locale) throws Exception {
		if (dateTimeString != null && !dateTimeString.equals("")) {
			DateFormat dateFormat = null;
			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
			} else if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
			} else {
				throw new Exception("Language date parse support not implemented for this language.");
			}
			return dateFormat.parse(dateTimeString);
		}
		return null;
	}

	/**
	 * Parsea un string de fecha con el formato correspondiente al idioma del
	 * locale y devuelve la fecha. Recibe un tipo date
	 * 
	 * @param date
	 *            (Date)
	 * @param locale
	 *            the locale
	 * @return the date
	 * @throws Exception
	 *             the exception
	 */
	public static Date parseDate(Date date, Locale locale) throws Exception {
		if (date != null) {
			SimpleDateFormat formatter = null;
			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				formatter = new SimpleDateFormat("dd/MM/yyyy");
			} else if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				formatter = new SimpleDateFormat("yyyy/MM/dd");
			} else {
				throw new Exception("Language date parse support not implemented for this language.");
			}
			return formatter.parse(formatter.format(date));

		}
		return null;
	}

	/**
	 * Parses the date.
	 * 
	 * @param strFecha
	 *            the str fecha
	 * @return the date
	 */
	public static Date parseDate(String strFecha) {
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat("yyyy-MM-dd");
		formatoDelTexto.setLenient(false);
		// String strFecha = "2007-12-25";
		Date fecha = null;
		try {
			if (strFecha != null) {
				if (strFecha.length() == 10) {
					fecha = formatoDelTexto.parse(strFecha);
				}
			}

		} catch (ParseException ex) {
			logger.error("Fecha incorrecta: " + strFecha);

			ex.printStackTrace();
		}
		return fecha;
	}

	/**
	 * Parses the date to string.
	 * 
	 * @param fecha
	 *            the fecha
	 * @param lang
	 *            the lang
	 * @return the string
	 */
	public static String parseDateToString(Date fecha, String lang) {
		String fechaFormateada = "";
		DecimalFormat df = new DecimalFormat("00");

		if (fecha != null) {
			Calendar calendar = Calendar.getInstance();
			calendar.setTime(fecha);

			int dia = calendar.get(Calendar.DAY_OF_MONTH); // dia del mes
			int mes = calendar.get(Calendar.MONTH) + 1; // mes, de 0 a 11
			int anio = calendar.get(Calendar.YEAR); // ao

			if (Y41bConstantes.EUSKERA.equals(lang)) {
				fechaFormateada = anio + "/" + df.format(mes) + "/" + df.format(dia);
			} else {
				fechaFormateada = df.format(dia) + "/" + df.format(mes) + "/" + anio;
			}
		}
		return fechaFormateada;
	}

	/**
	 * Parsea un string de fecha del servicio registro de entrada/salida.
	 * 
	 * @param dateString
	 *            the date string
	 * @return the date
	 * @throws Exception
	 *             the exception
	 */
	public static Date parseRegistrytimestamp(String dateString) throws Exception {
		if (dateString != null && !dateString.equals("")) {
			DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			return dateFormat.parse(dateString);
		}
		return null;
	}

	/**
	 * Parsea un string de fecha del servicio registro de salida para una
	 * notificacion.
	 * 
	 * @param dateString
	 *            the date string
	 * @return the date
	 * @throws Exception
	 *             the exception
	 */
	public static Date parseNotificationRegistrytimestamp(String dateString) throws Exception {
		if (dateString != null && !dateString.equals("")) {
			DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
			return dateFormat.parse(dateString);
		}
		return null;
	}

	/**
	 * Este metodo sirve para devolver la fecha actual larga del sistema
	 * (dd/MM/yyyy HH:mm:ss)
	 * 
	 * @return La fecha larga de sistema
	 */
	public static String fncFechaActualLargaAlternativa() {
		return Y41bUtils.FECHA_LARGA_FORMAT_ALT.format(new Date());
	}

	/**
	 * Este metodo sirve para devolver la fecha actual larga del sistema
	 * (dd/MM/yyyy HH:mm:ss)
	 * 
	 * @param time
	 *            Timestamp
	 * @return La fecha larga de sistema
	 */
	public static String fncParsearFechaLargaAlternativa(Timestamp time) {
		return Y41bUtils.FECHA_LARGA_FORMAT_ALT.format(time);
	}

	/**
	 * Convierte un OutputStream a String
	 * 
	 * @param rd
	 * @return
	 * @throws IOException
	 */
	public static String convertOutputStreamToString(OutputStream os) throws IOException {

		return "";
	}

	/**
	 * Convierte un InputStream a String
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static String convertInputStreamToString(InputStream is) throws IOException {
		/*
		 * To convert the InputStream to String we use the Reader.read(char[]
		 * buffer) method. We iterate until the Reader return -1 which means
		 * there's no more data to read. We use the StringWriter class to
		 * produce the string.
		 */
		if (is != null) {
			Writer writer = new StringWriter();

			char[] buffer = new char[1024];
			try {
				Reader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
				int n;
				while ((n = reader.read(buffer)) != -1) {
					writer.write(buffer, 0, n);
				}
			} finally {
				is.close();
			}
			return writer.toString();
		} else {
			return "";
		}
	}

	/**
	 * Obtiene longitud de cualquier inputStream
	 * 
	 * @param is
	 * @return
	 * @throws IOException
	 */
	public static int getLongitudInputStream(InputStream is) {
		int n = 0;
		if (is != null) {
			try {
				while ((n = is.read()) != -1) {
					n++;
				}
			} catch (IOException e) {
				e.printStackTrace();
			} finally {
				try {
					is.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
		}
		return n;
	}

	/**
	 * Muestra la etiqueta parseada para una estructura json - arbol
	 * 
	 * @param lblEs
	 * @param lblEu
	 * @return
	 */
	public static String printTreeLabel(String lblEs, String lblEu) {
		return isLanguage(lblEs, lblEu);
	}

	/**
	 * Muestra la etiqueta en el idioma correspondiente
	 * 
	 * @param lblEs
	 * @param lblEu
	 * @return
	 */
	private static String isLanguage(String lblEs, String lblEu) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();

		if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
			return filtroDB(lblEu);
		} else {
			return filtroDB(lblEs);
		}

	}

	public static String filtroDB(String input) {

		logger.info(input);
		if (input == null) {
			return "";
		} else {
			input = input.replaceAll("\"", "");
		}

		return input;
	}

	/**
	 * Filtra caracteres antes de ingreso en DB
	 * 
	 * @param label
	 * @return
	 */
	public static String _filtroDB(String input) {

		logger.debug("**********************************");
		logger.debug(input);
		logger.debug("**********************************");
		// Comprueba que no contenga caracteres prohibidos
		/*
		 * El caracter '+' representa una o ms veces El caracter '^' dentro de
		 * los corchetes es un NOT, permite encontrar cualquier carcter que NO
		 * se encuentre dentro del grupo indicado
		 */
		// Pattern p = Pattern.compile("[^A-Za-z0-9\\.\\@_\\-~#]+");
		Pattern p = Pattern.compile("[^A-Za-z0-9@ _()-]");
		Matcher m = p.matcher(input);
		StringBuffer sb = new StringBuffer();
		boolean resultado = m.find();
		boolean caracteresIlegales = false;
		while (resultado) {
			caracteresIlegales = true;
			m.appendReplacement(sb, "");
			resultado = m.find();
		}

		// Aade el ultimo segmento de la entrada a la cadena
		m.appendTail(sb);

		if (caracteresIlegales) {
			logger.info("La cadena contena caracteres ilegales que han sido suprimidos");
		}

		return sb.toString();
	}

	/**
	 * A partir de un String (XML) que contiene etiqueta
	 * <xml-fragment></xml-fragment> devuelve el mismo String sin esa etiqueta
	 * 
	 * @param xmlFragment
	 *            String a quitar la cadena xmlFragment
	 * @return String xmlSinFragment
	 */
	public static String deleteXmlFragment(String xmlFragment) {
		String xmlSinFragment = xmlFragment;
		xmlSinFragment = xmlSinFragment.replaceAll("<xml-fragment>", "");
		xmlSinFragment = xmlSinFragment.replaceAll("</xml-fragment>", "");
		return xmlSinFragment;
	}

	/**
	 * Devuelve true si el string vienen informado y false si el string es nulo
	 * o vacio
	 * 
	 * @param stringIn
	 *            Dato a evaluar
	 * @return boolean true o false
	 */
	public static boolean isFilled(String stringIn) {
		if (stringIn == null || stringIn.equals("")) {
			return false;
		}
		return true;
	}

	/**
	 * Transforma un campo Clob a String
	 * 
	 * @param clob
	 *            Clob la cual se desea transformar
	 * @return String Devuelve la cadena resultante de las transformaciones.
	 */
	public static String clobToString(Clob clob) {

		try {
			if (clob != null) {
				Reader reader = clob.getCharacterStream();
				CharArrayWriter writer = new CharArrayWriter();

				int i = 1;

				while ((i = reader.read()) != -1) {
					writer.write(i);
				}

				return new String(writer.toCharArray());
			} else {
				return null;
			}
		} catch (SQLException sqle) {
			return null;
		} catch (IOException ioe) {
			return null;
		}
	}

	/**
	 * Transforma un campo Clob a String
	 * 
	 * @param string
	 * @return String Devuelve la cadena resultante de las transformaciones.
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public static Clob stringToClob(String string) throws SQLException, IOException {

		if (string != null && !string.equals("")) {
			Clob clob = new SerialClob(string.toCharArray());
			clob.setString(1, string);

			return clob;
		} else {
			return null;
		}
	}

	/**
	 * Transforma un campo Blob a String
	 * 
	 * @param blob
	 *            Blob la cual se desea transformar
	 * @return String Devuelve la cadena resultante de las transformaciones.
	 * @throws SQLException
	 *             SQLException
	 * @throws IOException
	 *             IOException
	 */
	public static String blobToString(Blob blob) throws SQLException, IOException {

		if (blob != null) {
			InputStream inStream = blob.getBinaryStream();

			int count;
			java.io.ByteArrayOutputStream bo = new java.io.ByteArrayOutputStream();
			byte[] b = new byte[Y41bUtils.MAXCADENABYTE];
			try {
				while ((count = inStream.read(b, 0, Y41bUtils.MAXCADENABYTE)) > 0) {
					bo.write(b, 0, count);
				}
			} finally {
				bo.close();
			}

			return new String(bo.toString());
		} else {
			return null;
		}
	}

	public static void copyStream(InputStream input, OutputStream output) throws IOException {
		byte[] buffer = new byte[Y41bUtils.MAXCADENABYTE];
		int length;
		while ((length = input.read(buffer)) != -1) {
			output.write(buffer, 0, length);
		}
	}

	/**
	 * Recoge una hora HH:mm:ss y la deja como HH:mm
	 * 
	 * @param String
	 *            hora
	 * @return String hora
	 */
	public static String horaToHora(String hora) {
		String hora5char = "";
		if (hora.length() > 5) {
			hora5char = hora.substring(0, 5);
		}
		return hora5char;
	}

	/**
	 * Se envia un mail
	 * 
	 * @param smtp
	 *            Servidor smtp
	 * @param asunto
	 *            Asunto del mensaje
	 * @param body
	 *            Cuerpo del mensaje
	 * @param from
	 *            Email quien envia el mensaje
	 * @param to
	 *            Email a quien va dirigido el mensaje
	 * @param cco
	 *            Email copia oculta
	 * @param attachments
	 *            Ficheros adjuntos en el mensaje
	 * @return boolean True si el mensaje se envio correctamente y False en caso
	 *         contrario
	 */
	public static boolean sendMail(String smtp, String asunto, String body, String from, String to, String cco,
			Collection attachments) {

		try {

			Y41bMailMessage eMailMessage = new Y41bMailMessage();
			Y41bMailSender sendMessage = new Y41bMailSender();
			eMailMessage.setFrom(from);
			eMailMessage.setEmailServer(smtp);
			eMailMessage.setSubject(asunto);
			eMailMessage.setNotDeliveryAddress("");
			eMailMessage.setMsgBodyText(body);

			// para introducir los destinatarios
			String[] destinatarios = to.toString().split(";");
			for (int i = 0; i < destinatarios.length; i++) {
				if (!"".equals(destinatarios[i])) {
					eMailMessage.addTo(destinatarios[i]);
				}
			}

			// Cambiado para que vayan con copia oculta
			String[] copiaoculta = cco.toString().split(";");
			for (int i = 0; i < copiaoculta.length; i++) {
				if (!"".equals(copiaoculta[i])) {
					eMailMessage.addBCC(copiaoculta[i]);
				}
			}

			eMailMessage.setAttachments((ArrayList) attachments);

			sendMessage.send(eMailMessage);
		} catch (Exception e) {
			logger.error("EMAIL NO MANDADO." + e.getMessage(), e);
			return false;
		}
		return true;
	}

	/**
	 * Transforma una fecha String a java.sql.Date.
	 * 
	 * @param fecha
	 *            String con la fecha a convertir
	 * @param formato
	 *            String con el formato de la fecha
	 * @return java.sql.Date fecha convertida
	 * @exception ParseException
	 *                Se produce la excepcin cuando la fecha est mal
	 *                formateada.
	 */
	public static java.sql.Date formatearStringToDateFormato(String fecha, String formato) throws ParseException {
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(formato);
		java.sql.Date dFecha = null;

		dFecha = new java.sql.Date(formatoDelTexto.parse(fecha).getTime());

		return dFecha;
	}

	/**
	 * Transforma una fecha String a java.sql.Date.
	 * 
	 * @param fecha
	 *            String con la fecha a convertir
	 * @return java.sql.Date fecha convertida
	 * @exception ParseException
	 *                Se produce la excepcin cuando la fecha est mal
	 *                formateada.
	 */
	public static java.sql.Date formatearStringToDateFormato(String fecha) {

		if (fecha == null || "".equals(fecha)) {
			return null;
		}

		String formato = "";
		Locale locale = LocaleContextHolder.getLocale();
		if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
			formato = Y41bConstantes.FORMATO_FECHA_EU;
		} else {
			formato = Y41bConstantes.FORMATO_FECHA_ES;
		}
		SimpleDateFormat formatoDelTexto = new SimpleDateFormat(formato);
		java.sql.Date dFecha = null;
		try {
			dFecha = new java.sql.Date(formatoDelTexto.parse(fecha).getTime());
		} catch (ParseException e) {
			dFecha = null;
		}

		return dFecha;
	}

	/**
	 * Transforma un java.sql.Date a la mascara de formato de fecha recibida
	 * como parmetro.
	 * 
	 * @param fecha
	 *            String
	 * @param formato
	 *            String con el formato a parsear
	 * @return String fecha formateada
	 * @exception ParseException
	 *                Se produce la excepcin cuando la fecha est mal
	 *                formateada.
	 */
	public static String formatearDateToString(java.util.Date fecha, String formato) throws ParseException {
		DateFormat sdf = null;

		if (fecha == null) {
			return null;
		} else {
			sdf = new SimpleDateFormat(formato);
		}

		return sdf.format(fecha);
	}

	/**
	 * Transforma un java.sql.Date a la mascara de formato de fecha recibida
	 * como parmetro.
	 * 
	 * @param fecha
	 *            String
	 * @param formato
	 *            String con el formato a parsear
	 * @param idioma
	 *            String con el idioma
	 * @return String fecha formateada
	 * @exception ParseException
	 *                Se produce la excepcin cuando la fecha est mal
	 *                formateada.
	 */
	public static String formatearDateToString(java.util.Date fecha, String formato, String idioma)
			throws ParseException {

		SimpleDateFormat sdf = null;

		if (fecha == null) {
			return null;
		} else {
			sdf = new SimpleDateFormat(formato, new Locale(idioma));
		}

		return sdf.format(fecha);
	}

	/**
	 * Suma dias a una fecha dada
	 * 
	 * @param fecha
	 *            Date
	 * @param days
	 *            int
	 * @return Date fecha
	 */
	public static Date addDays(Date fecha, int days) {
		Calendar date = Calendar.getInstance();
		date.setTime(fecha);
		date.add(Calendar.DAY_OF_YEAR, days);
		Date resultado = date.getTime();
		return resultado;
	}

	/**
	 * Suma dias a una fecha dada
	 * 
	 * @param fecha
	 *            Date
	 * @param days
	 *            long
	 * @return Date fecha
	 */
	public static Date addDays(Date fecha, long days) {
		Calendar date = Calendar.getInstance();
		date.setTime(fecha);
		date.add(Calendar.DAY_OF_YEAR, (int) days);
		Date resultado = date.getTime();
		return resultado;
	}

	/**
	 * Suma dias a una fecha dada
	 * 
	 * @param fecha
	 *            Date
	 * @param days
	 *            long
	 * @return Date fecha
	 */
	public static Date addMonth(Date fecha, int months) {
		Calendar date = Calendar.getInstance();
		date.setTime(fecha);
		date.add(Calendar.MONTH, months);
		Date resultado = date.getTime();
		return resultado;
	}

	/**
	 * Suma dias a una fecha dada
	 * 
	 * @param fecha
	 *            Date
	 * @param days
	 *            long
	 * @return Date fecha
	 */
	public static Date addYear(Date fecha, int years) {
		Calendar date = Calendar.getInstance();
		date.setTime(fecha);
		date.add(Calendar.YEAR, years);
		Date resultado = date.getTime();
		return resultado;
	}

	/*
	 * Convenience method to add a specified number of minutes to a Date object
	 * From:
	 * http://stackoverflow.com/questions/9043981/how-to-add-minutes-to-my-date
	 * 
	 * @param minutes The number of minutes to add
	 * 
	 * @param beforeTime The time that will have minutes added to it
	 * 
	 * @return A date object with the specified number of minutes added to it
	 */
	public static Date addMinutesToDate(int minutes, Date beforeTime) {
		long ONE_MINUTE_IN_MILLIS = 60000;// millisecs

		long curTimeInMs = beforeTime.getTime();
		Date afterAddingMins = new Date(curTimeInMs + (minutes * ONE_MINUTE_IN_MILLIS));
		return afterAddingMins;
	}

	/**
	 * Transforma un java.sql.Date a la mascara de formato de fecha recibida
	 * como parmetro.
	 * 
	 * @param fecha
	 *            String
	 * @param formato
	 *            String con el formato a parsear
	 * @param idioma
	 *            String con el idioma
	 * @return String fecha formateada
	 * @exception ParseException
	 *                Se produce la excepcin cuando la fecha est mal
	 *                formateada.
	 */
	public static String formatearDateToStringEuskera(java.util.Date fecha, String formato, String idioma)
			throws ParseException {

		SimpleDateFormat sdf = null;
		DateFormatSymbolsProvider_eu dateFormatSymbolsProvider_eu = new DateFormatSymbolsProvider_eu();

		if (fecha == null) {
			return null;
		} else {
			sdf = new SimpleDateFormat(formato, dateFormatSymbolsProvider_eu.getInstance(new Locale(idioma)));
		}

		return sdf.format(fecha);
	}

	/**
	 * Normaliza datos de entrada de formularios a 0 - Para combos normalmente
	 * 
	 * @param input
	 *            input
	 * @return "" vacio
	 */
	public static String normalizarCero(String input) {

		String rt = "";
		if (input == null) {
			rt = Y41bConstantes.CERO;
		} else if ("".equals(input)) {
			rt = Y41bConstantes.CERO;
		} else {
			rt = input;
		}

		return rt;
	}

	/**
	 * Normaliza datos de entrada de formularios a "" - excepto combos
	 * 
	 * @param input
	 *            String
	 * @return String
	 */
	public static String normalizarVacio(String input) {

		String rt = Y41bConstantes.VACIO;
		if (input != null) {
			if (!"null".equals(input)) {
				rt = input;
			}
		}

		return rt;
	}

	/**
	 * Convierte un Long en String
	 * 
	 * @param input
	 *            Long
	 * @return String
	 */
	public static String convertLong2String(Long input) {

		if (input != null) {
			return input.toString();
		} else {
			return Y41bConstantes.VACIO;
		}
	}

	/**
	 * Convierte un Long en String
	 * 
	 * @param input
	 *            Long
	 * @return String
	 */
	public static String convertFloat2StringFormateado(float input) {
		try {
			if (input != 0) {
				if (input % 1 == 0) {
					return Integer.toString((int) input);
				} else {
					// return String.format("%.,2f", input);
					input = Math.round(input * 100f) / 100f;
					return Float.toString(input).replace('.', ',');
				}
			} else {
				return "0";
			}
		} catch (UnknownFormatConversionException e) {
			return "0";
		}
	}

	/**
	 * Convierte un BigDecimal en String
	 * 
	 * @param input
	 *            BigDecimal
	 * @return String
	 */
	public static String convertBigDecimal2String(BigDecimal input) {

		if (input != null) {
			return input.toString();
		} else {
			return Y41bConstantes.VACIO;
		}
	}

	/**
	 * Normaliza datos de entrada de formularios a null en caso de cadenas
	 * vacias
	 * 
	 * @param input
	 *            String
	 * @return String
	 */
	public static String normalizarNulo(String input) {

		if (input != null) {
			if ("".equals(input)) {
				return null;
			} else {
				return input;
			}
		} else {
			return null;
		}
	}

	/**
	 * Normaliza datos de entrada de formularios a null en caso de cadenas
	 * vacias
	 * 
	 * @param input
	 *            String
	 * @return BigDecimal
	 */

	public static BigDecimal normalizarBigDecimal(String input) {

		if (input != null) {
			if ("".equals(input)) {
				return null;
			} else {
				return new BigDecimal(input);
			}
		} else {
			return null;
		}
	}

	/**
	 * Mtodo que dada 1 cadena de texto html elimina todas las etiquetas HTML
	 * de que consta
	 * 
	 * @param cadena
	 *            String la cadena de texto html
	 * @return String la cadena sin etiquetas html
	 */
	public static String eliminarTags(String cadena) {
		while (true) {
			int izdaTag = cadena.indexOf("<");
			if (izdaTag < 0)
				return cadena;
			int derTag = cadena.indexOf(">", izdaTag);
			if (derTag < 0)
				return cadena;
			cadena = cadena.substring(0, izdaTag) + " " + cadena.substring(derTag + 1);
		}
	}

	/**
	 * Mtodo que dada 1 cadena de texto html elimina todas los &xxxxx; de que
	 * consta
	 * 
	 * @param cadena
	 *            String la cadena de texto html
	 * @return String la cadena sin etiquetas html
	 */
	public static String eliminarAmpersand(String cadena) {
		while (true) {
			int izdaTag = cadena.indexOf("&");
			if (izdaTag < 0)
				return cadena;
			int derTag = cadena.indexOf(";", izdaTag);
			if (derTag < 0)
				return cadena;
			cadena = cadena.substring(0, izdaTag) + " " + cadena.substring(derTag + 1);
		}
	}

	/**
	 * Mtodo que dada 1 cadena de texto html sustituye los <li xxxxxxxx>de que
	 * consta
	 * 
	 * @param cadena
	 *            String la cadena de texto html
	 * @return String la cadena sin etiquetas
	 *         <li>
	 */
	public static String sustituirTagsLi(String cadena) {
		while (true) {
			int izdaTag = cadena.indexOf("<li");
			if (izdaTag < 0)
				return cadena;
			int derTag = cadena.indexOf(">", izdaTag);
			if (derTag < 0)
				return cadena;
			cadena = cadena.substring(0, izdaTag) + "&bullet;" + cadena.substring(derTag + 1);
		}
	}

	/**
	 * Mtodo que dada 1 cadena de texto html sustituye los <span de subrayado
	 * 
	 * @param cadena
	 *            String la cadena de texto html
	 * @return String la cadena sin etiquetas <span >
	 */
	public static String sustituirTagsSpanUnderline(String cadena) {
		while (true) {
			int izdaTag = cadena.indexOf("<span style=\"text-decoration: underline;\">");
			if (izdaTag < 0)
				return cadena;
			int derTag = cadena.indexOf(">", izdaTag);
			if (derTag < 0)
				return cadena;
			cadena = cadena.substring(0, izdaTag) + "&subrayadoini;" + cadena.substring(derTag + 1);

			izdaTag = cadena.indexOf("</span>", izdaTag);
			if (izdaTag < 0)
				return cadena;
			derTag = cadena.indexOf(">", izdaTag);
			if (derTag < 0)
				return cadena;
			cadena = cadena.substring(0, izdaTag) + "&subrayadofin;" + cadena.substring(derTag + 1);

		}
	}

	/**
	 * Mtodo que dada 1 cadena de texto html sustituye los <span de tachado
	 * 
	 * @param cadena
	 *            String la cadena de texto html
	 * @return String la cadena sin etiquetas <span >
	 */
	public static String sustituirTagsSpanStrike(String cadena) {
		while (true) {
			int izdaTag = cadena.indexOf("<span style=\"text-decoration: line-through;\">");
			if (izdaTag < 0)
				return cadena;
			int derTag = cadena.indexOf(">", izdaTag);
			if (derTag < 0)
				return cadena;
			cadena = cadena.substring(0, izdaTag) + "&tachadoini;" + cadena.substring(derTag + 1);

			izdaTag = cadena.indexOf("</span>", izdaTag);
			if (izdaTag < 0)
				return cadena;
			derTag = cadena.indexOf(">", izdaTag);
			if (derTag < 0)
				return cadena;
			cadena = cadena.substring(0, izdaTag) + "&tachadofin;" + cadena.substring(derTag + 1);

		}
	}

	/**
	 * Devuelve un string con el ao del sistema en formato corto.
	 * 
	 * @return String: string con el ao en formato AAAA.
	 * @throws Exception
	 *             e
	 */
	public static String fncObtenerAnnoSistema() throws Exception {
		return Y41bUtils.ANNIO_FORMAT.format(new Date());
	}// Fin fncObtenerAnnoSistema

	/**
	 * Devuelve un string con el ao del sistema en formato corto.
	 * 
	 * @param fecha
	 *            Date
	 * @return String: string con el ao en formato AAAA.
	 * @throws Exception
	 *             e
	 */
	public static String fncObtenerAnnoFecha(java.util.Date fecha) throws Exception {
		return Y41bUtils.ANNIO_FORMAT.format(fecha);
	}// Fin fncObtenerAnnoFecha

	/**
	 * La fecha del sistema en formato largo DD/MM/AAAATHH:MM:SS si el idioma
	 * que le pasamos es el castellano, o AAAA/MM/DDTHH:MM:SS si se trata de
	 * euskera
	 * 
	 * @param bolPfSeparador
	 *            Si devuelve True, separa la hora con una T y si devuelve
	 *            False, separa con espacio
	 * @return String
	 * @throws Exception
	 */
	public static String fncPresentarFechaSistemaTimeStamp(boolean bolPfSeparador) {
		Date date = new Date();
		Timestamp timestamp = new Timestamp(date.getTime());
		String fecha = timestamp.toString();

		if (bolPfSeparador) {
			fecha = timestamp.toString().replaceAll(" ", "T");
		}
		return fecha;
	}

	/**
	 * Extrae el texto firmado del ejgvdocument de una solicitud
	 * 
	 * @param strEjgvDocument
	 *            String con el ejgvdocument
	 * @return String String con el texto firmado
	 * @throws Exception
	 */
	public static String fncExtaerTextoFirmado(String strEjgvDocument) {
		/*
		 * String textoFirmado = strEjgvDocument.substring(
		 * strEjgvDocument.indexOf("<!-- ejgvSignedInfo") +
		 * Y41bConstantes.NUM_19,
		 * strEjgvDocument.indexOf("ejgvSignedInfo -->"));
		 */
		return "texto firmado";
	}

	/**
	 * Mtodo que indica si una cadena es nula o cadena vacia
	 * 
	 * @param valor
	 *            a comprobar
	 * @return booleano indicando el resultado
	 */
	public static boolean esNullOCadenaVacia(String valor) {
		return (valor == null || "".equals(valor));
	}

	/**
	 * Mtodo que obtiene la extension de un fichero
	 * 
	 * @param filename
	 *            String
	 * @return String extension del fichero
	 */
	public static String getExtensionFile(String filename) {
		int index = filename.lastIndexOf('.');
		if (index == -1) {
			return "";
		} else {
			return filename.substring(index + 1);
		}
	}

	/**
	 * Mtodo que obtiene el nombre de un fichero sin extension
	 * 
	 * @param filename
	 *            String
	 * @return String nombre del fichero sin extension
	 */
	public static String getNameFile(String filename) {
		int index = filename.lastIndexOf('.');
		if (index == -1) {
			return "";
		} else {
			return filename.substring(0, index);
		}
	}

	/**
	 * Mtodo que obtiene el nombre de un fichero desde un path
	 * 
	 * @param pathFile
	 *            String
	 * @return String nombre del fichero
	 */
	public static String getNameFileFromPath(String pathFile) {
		int index = pathFile.lastIndexOf('/');
		if (index == -1) {
			return "";
		} else {
			return pathFile.substring(index + 1);
		}
	}

	/**
	 * Mtodo que obtiene el nombre de un fichero sin extension
	 * 
	 * @param filename
	 *            String
	 * @return String nombre del fichero sin extension
	 */
	public static String getNameFileDokusi(String filename) {
		StringBuffer nombreNuevoFichero = new StringBuffer();

		String nombre = filename;
		int index = filename.lastIndexOf('.');
		if (index != -1) {
			nombre = filename.substring(0, index);
		}
		String extension = Y41bUtils.getExtensionFile(filename);

		nombreNuevoFichero.append(nombre).append(".").append(extension);

		return nombreNuevoFichero.toString();
	}

	/**
	 * Mtodo que recorre los campos de un objeto para reemplazar "" por null
	 * 
	 * @param objeto
	 *            Object
	 * @return String nombre del fichero sin extension
	 */
	public static Object limpiarObjeto(Object objeto) {

		if (null == objeto) {
			return null;
		}
		try {

			Class<? extends Object> objetoClass = objeto.getClass();

			for (Field campos : objetoClass.getDeclaredFields()) {

				char first = Character.toUpperCase(campos.getName().charAt(0));
				String capitalized = first + campos.getName().substring(1);

				try {
					Method getField = objetoClass.getDeclaredMethod("get" + capitalized, new Class[] {});
					Class<?> fieldClass = getField.getReturnType();

					Method setField = objetoClass.getDeclaredMethod("set" + capitalized, new Class[] { fieldClass });

					setField.setAccessible(true);
					getField.setAccessible(true);

					Object get = Y41bUtils.invoke(objetoClass, getField.getName(), null);

					Y41bUtils.invoke(objetoClass, setField.getName(), new Object[] { null });

					get = Y41bUtils.invoke(objetoClass, getField.getName(), null);
					get.toString();
					Object value = getField.invoke(objetoClass, new Object[] {});

					if (fieldClass.isInstance("java.lang.String")) {
						if (value != null) {

						}
					}
					Y41bUtils.logger.info("Field Class: " + fieldClass.getName() + " instanceOf: "
							+ fieldClass.isInstance("java.lang.String") + " Value Class: "
							+ fieldClass.getClass().getName());
				} catch (Exception e) {
				}

			}

		} catch (Exception e) {
			return null;
		}

		return objeto;

	}

	public static Object invoke(Object obj, String method, Object[] args) throws Exception {
		if (Y41bUtils.logger.isInfoEnabled()) {
			Y41bUtils.logger.info("MODCONReflection:invoke:ENTRA");
		}
		Class c;
		Object result = null;

		try {

			c = obj.getClass();

			Method[] methods = c.getMethods();
			String name = null;

			for (int i = 0; i < methods.length; i++) {
				name = methods[i].getName();
				if (name.equals(method)) {
					result = methods[i].invoke(obj, args);
					break;
				}
			}

		} catch (Exception e) {
			Y41bUtils.logger.error("***** ERROR: \n" + e.getStackTrace().toString());
			throw new Exception();
		}
		if (Y41bUtils.logger.isInfoEnabled()) {
			Y41bUtils.logger.info("MODCONReflection:invoke:Sale");
		}
		return result;
	}

	/**
	 * Format double2decimales ycoma.
	 * 
	 * @param valor
	 *            the valor
	 * @return the string
	 */
	public static String formatDouble2decimalesYcoma(double valor) {
		DecimalFormat decim = new DecimalFormat("#.00");
		String s = decim.format(valor);
		s = s.replace('\u002e', '\u002c');
		return s;
	}

	/**
	 * Format double2decimales ycoma.
	 * 
	 * @param valor
	 *            the valor
	 * @return the string
	 */
	public static String formatDouble2decimalesYcomaYpuntoMiles(double valor) {

		DecimalFormatSymbols simbolo = new DecimalFormatSymbols();
		simbolo.setDecimalSeparator(',');
		simbolo.setGroupingSeparator('.');
		DecimalFormat formateador = new DecimalFormat("###,###.##", simbolo);
		String s = formateador.format(valor);
		return s;
	}

	/**
	 * Dame sql.
	 * 
	 * @param sql
	 *            the sql
	 * @param args
	 *            the args
	 * @return the string
	 * @throws Exception
	 *             the exception
	 */
	public static String dameSQL(String sql, Object[] args) throws Exception {
		String aux = sql;
		int posicion = 0;
		for (int i = 0; i < args.length; i++) {
			Object object = args[i];

			posicion = sql.indexOf('?');

			if (posicion > 0) {
				if (object == null) {
					sql = sql.substring(0, posicion) + " null " + sql.substring(posicion + 1, sql.length());
				} else if (object instanceof String) {
					sql = sql.substring(0, posicion) + "'" + object.toString() + "'"
							+ sql.substring(posicion + 1, sql.length());
				} else if (object instanceof Date) {
					sql = sql.substring(0, posicion) + "'" + object.toString() + "'"
							+ sql.substring(posicion + 1, sql.length());
				} else {
					sql = sql.substring(0, posicion) + object.toString() + sql.substring(posicion + 1, sql.length());
				}
			} else {
				throw new Exception("dameSQL. No cuadra numero de argumentos. Parametros con ? : "
						+ countChars(aux, '?') + ". Parametros:" + args.length);
			}
		}
		return sql;
	}

	/**
	 * Count matches.
	 * 
	 * @param str
	 *            the str
	 * @param sub
	 *            the sub
	 * @return the int
	 */
	public static int countChars(String input, char find) {
		if (input.indexOf(find) != -1) {
			return countChars(input.substring(0, input.indexOf(find)), find)
					+ countChars(input.substring(input.indexOf(find) + 1), find) + 1;
		} else {
			return 0;
		}

	}

	/**
	 * Redondea un double a dos decimales
	 * 
	 * @param number
	 *            double
	 * @return double redondeado a 2 decimales
	 */
	public static double round2DecimalDouble(double number) {
		return Math.round(number * Math.pow(Y41bConstantes.NUM_10, 2)) / Math.pow(Y41bConstantes.NUM_10, 2);
	}

	/**
	 * Metodo que aade 0 a un entero hasta que alcance la longitud deseada
	 * 
	 * @param param
	 *            String al que se aaden 0
	 * @param width
	 *            longitud deseada
	 * @return String cadena modificada
	 */
	public static String zeroPad(String param, int width) {
		StringBuffer result = new StringBuffer("");
		for (int i = 0; i < width - param.length(); i++) {
			result.append("0");
		}
		result.append(param);
		return result.toString();
	}

	/**
	 * Compone la direccin.
	 * 
	 * @param calle
	 *            the calle
	 * @param bloque
	 *            the bloque
	 * @param portal
	 *            the portal
	 * @param numero
	 *            the numero
	 * @param bis
	 *            the bis
	 * @param piso
	 *            the piso
	 * @param aproxPostal
	 *            the aprox postal
	 * @return the string
	 */
	public static String componerDireccion(String calle, String bloque, String portal, int numero, String bis,
			String piso, String aproxPostal) {
		logger.info("Y41bUtils. componerDireccion" + calle + "." + bloque + "." + portal + "." + numero + "." + bis
				+ "." + piso + "." + aproxPostal);
		StringBuilder txtDireccion = new StringBuilder("");

		if (calle != null && !calle.equals("")) {
			txtDireccion.append(calle);
		}
		if (bloque != null && !bloque.equals("")) {
			if (!Y41bUtils.esNullOCadenaVacia(txtDireccion.toString())) {
				txtDireccion.append(" ");
			}
			txtDireccion.append(bloque);
		}
		if ((portal != null) && !portal.equals("") && !portal.equals("0")) {
			if (!Y41bUtils.esNullOCadenaVacia(txtDireccion.toString())) {
				txtDireccion.append(" ");
			}
			txtDireccion.append(portal);
		}
		if (numero != 0) {
			if (!Y41bUtils.esNullOCadenaVacia(txtDireccion.toString())) {
				txtDireccion.append(" ");
			}
			txtDireccion.append(numero);
		}
		if (bis != null && !bis.equals("")) {
			if (!Y41bUtils.esNullOCadenaVacia(txtDireccion.toString())) {
				txtDireccion.append(" ");
			}
			txtDireccion.append(bis);
		}
		if ((piso != null) && !piso.equals("") && !portal.equals("0")) {
			if (!Y41bUtils.esNullOCadenaVacia(txtDireccion.toString())) {
				txtDireccion.append(", ");
			}
			txtDireccion.append(piso);
		}

		if (txtDireccion.length() == 0) {
			if (aproxPostal != null && !aproxPostal.equals("")) {
				if (!Y41bUtils.esNullOCadenaVacia(txtDireccion.toString())) {
					txtDireccion.append(" ");
				}
				txtDireccion.append(aproxPostal);

			}
		}
		logger.info("Y41bUtils. Fin componerDireccion" + txtDireccion.toString() + ".");
		return txtDireccion.toString();

	}

	/**
	 * Trata null.
	 * 
	 * @param objeto
	 *            the objeto
	 * @return the string
	 */
	public static String trataNull(Object objeto) {
		return (objeto == null) ? "" : objeto.toString();
	}

	/**
	 * Checks if is numeric.
	 * 
	 * @param cadena
	 *            the cadena
	 * @return true, if is numeric
	 */
	public static boolean isNumeric(String cadena) {
		try {
			Integer.parseInt(cadena);
			return true;
		} catch (NumberFormatException nfe) {
			return false;
		}
	}

	/**
	 * Checks if is numeric short.
	 * 
	 * @param cadena
	 *            the cadena
	 * @return true, if is numeric short
	 */
	public static boolean isNumericShort(String cadena) {
		try {
			Short.parseShort(cadena);
			return true;
		} catch (NumberFormatException nfe) {
			return false;
		}
	}

	/**
	 * Hay tramitacion platea.
	 * 
	 * @return true, if successful
	 */
	public static boolean interactuarConDokusi() {
		Properties prop = Y41bConfig.loadProperties(Y41bConstantes.CONFIG_PATH);
		String local = (String) prop.getProperty("y41bVistaWar.entorno.local");
		return (!(local.equals("true")));
	}

	/**
	 * Rellena por la izquierda el valor introducido por par?metro con un
	 * car?cter hasta el tama?o indicado. Suele usarse para rellenar campos
	 * num?ricos.
	 * 
	 * @param valor
	 *            Cadena de caracteres
	 * @param caracter
	 *            Car?cter con el que rellenar el valor
	 * @param tamano
	 *            Tama?o final
	 * @return String
	 */
	public static String rellenaIzda(String valor, String caracter, int tamano) {
		if (!Y41bUtils.isFilled(valor)) {
			StringBuffer retorno = new StringBuffer();

			for (int i = 0; i < tamano; i++) {
				retorno.append(caracter);
			}

			return retorno.toString();
		}

		if (valor.length() > tamano) {
			valor = valor.substring(0, tamano);
		}

		StringBuffer valorRetorno = new StringBuffer(valor);

		while (valorRetorno.length() < tamano) {
			valorRetorno.insert(0, caracter);
		}

		return valorRetorno.toString();
	}

	/**
	 * Rellena por la derecha el valor introducido por par?metro con un car?cter
	 * hasta el tama?o indicado. Suele usarse para rellenar campos num?ricos.
	 * 
	 * @param valor
	 *            Cadena de caracteres
	 * @param caracter
	 *            Car?cter con el que rellenar el valor
	 * @param tamano
	 *            Tama?o final
	 * @return String
	 */
	public static String rellenaDcha(String valor, String caracter, int tamano) {
		if (!Y41bUtils.isFilled(valor)) {
			StringBuffer retorno = new StringBuffer();

			for (int i = 0; i < tamano; i++) {
				retorno.append(caracter);
			}

			return retorno.toString();
		}

		if (valor.length() > tamano) {
			valor = valor.substring(0, tamano);
		}

		StringBuffer valorRetorno = new StringBuffer(valor);

		while (valorRetorno.length() < tamano) {
			valorRetorno.insert(valorRetorno.length(), caracter);
		}

		return valorRetorno.toString();
	}

	/**
	 * Trunca una cadena a partir de un numero de caracteres Si la cadena es mas
	 * corta que el numero de caracteres deseado devuelve la misma cadena de
	 * caracteres
	 * 
	 * @param valor
	 *            Cadena de caracteres
	 * @param tamanyo
	 *            Tamanyo final
	 * @return String
	 */
	public static String upToNCharacters(String valor, int tamanyo) {
		String resultado = null;
		if (valor != null) {
			resultado = valor.substring(0, Math.min(valor.length(), tamanyo));
		}
		return resultado;
	}

	/**
	 * Transforma un importe de Euros a Cntimos
	 * 
	 * @param importeEuros
	 *            BigDecimal con importe con un . en bbbdd por ejemplo 105.03
	 * @return String
	 */
	public static String transformarEurosACents(BigDecimal importeEuros) {
		importeEuros = importeEuros.multiply(new BigDecimal(100));
		String importeCent = String.valueOf(importeEuros.intValue());
		return importeCent;
	}

	/**
	 * Transforma un importe de Euros a C?ntimos
	 * 
	 * @param importeEuros
	 *            BigDecimal con importe con un . en bbbdd por ejemplo 105.03
	 * @return String
	 */
	public static String formatearAEuros(BigDecimal importeEuros) {
		if (importeEuros != null) {
			DecimalFormatSymbols simbolo = new DecimalFormatSymbols();
			simbolo.setDecimalSeparator(',');
			simbolo.setGroupingSeparator('.');
			DecimalFormat formateador = new DecimalFormat("###,###.##", simbolo);
			String s = formateador.format(importeEuros);
			return s;
		} else {
			return "";
		}
	}

	public static String getDurationProceso(long millis) {
		if (millis < 0) {
			throw new IllegalArgumentException("La duracin debe ser mayor que cero!");
		}

		long days = TimeUnit.MILLISECONDS.toDays(millis);
		millis -= TimeUnit.DAYS.toMillis(days);
		long hours = TimeUnit.MILLISECONDS.toHours(millis);
		millis -= TimeUnit.HOURS.toMillis(hours);
		long minutes = TimeUnit.MILLISECONDS.toMinutes(millis);
		millis -= TimeUnit.MINUTES.toMillis(minutes);
		long seconds = TimeUnit.MILLISECONDS.toSeconds(millis);

		StringBuilder sb = new StringBuilder(64);
		sb.append(days);
		sb.append("Dias");
		sb.append(hours);
		sb.append(" Horas");
		sb.append(minutes);
		sb.append(" Minutos ");
		sb.append(seconds);
		sb.append(" Segundos");

		return (sb.toString());
	}

	/**
	 * convertPdftoBlob
	 * 
	 * @return Blob
	 */
	public static Blob convertPdftoBlob(String pdfFilename) {

		Blob pdfBlob = null;
		try {
			PdfReader reader = new PdfReader(pdfFilename);
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			PdfStamper stamper = new PdfStamper(reader, baos);
			stamper.close();
			pdfBlob = new SerialBlob(baos.toByteArray());
			reader.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SerialException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return pdfBlob;
	}

	/**
	 * convertPdftoBlob
	 * 
	 * @return Blob
	 */
	public static Blob convertTxtFiletoBlob(String filename) {

		Blob pdfBlob = null;
		try {

			String fichero = Y41bFicheroUtils.leerFichero(new File(filename));

			pdfBlob = new SerialBlob(fichero.getBytes());

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SerialException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return pdfBlob;
	}

	/**
	 * isDocumentoLocalizableByContentType
	 * 
	 * @param adjuntardocs
	 *            Adjuntardocs
	 * @return boolean
	 */
	public static boolean isDocumentoLocalizable(Adjuntardocs adjuntardocs) {
		String contentType = null;
		if (adjuntardocs != null && adjuntardocs.getThnofile() != null) {
			StringBuffer extension = new StringBuffer();
			extension.append(".").append(Y41bUtils.getExtensionFile(adjuntardocs.getThnofile()));
			if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_DOC)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSWORD;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_DOCX)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSWORDX;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_XLS)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSEXCEL;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_XLSX)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSEXCELX;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_RTF)) {
				contentType = Y41bConstantes.CONTENT_TYPE_RTF;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_BMP)) {
				contentType = Y41bConstantes.CONTENT_TYPE_BMP;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_TXT)) {
				contentType = Y41bConstantes.CONTENT_TYPE_TXT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_HTML)) {
				contentType = Y41bConstantes.CONTENT_TYPE_HTML;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_JPG)) {
				contentType = Y41bConstantes.CONTENT_TYPE_JPEG;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_MPP)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSPROJECT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODG)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODGRAPHICS;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODP)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODPRESENTATION;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODS)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODSPREADSHEET;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODT)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODTEXT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_PNG)) {
				contentType = Y41bConstantes.CONTENT_TYPE_PNG;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_PPTX)) {
				contentType = Y41bConstantes.CONTENT_TYPE_CONTENT_TYPE_OFFICEDPRESENTATION;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_PPT)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSPOWERPOINT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_TIF)) {
				contentType = Y41bConstantes.CONTENT_TYPE_TIFF;
			}
		}
		return isDocumentoLocalizable(adjuntardocs.getThorigen(), contentType);
	}

	/**
	 * isDocumentoLocalizableByExtension
	 * 
	 * @param documento
	 *            Documento
	 * @return boolean
	 */
	public static boolean isDocumentoLocalizable(Documento documento) {
		String contentType = null;
		if (documento != null && documento.getExtension() != null) {
			StringBuffer extension = new StringBuffer();
			extension.append(".").append(documento.getExtension());
			if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_DOC)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSWORD;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_DOCX)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSWORDX;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_XLS)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSEXCEL;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_XLSX)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSEXCELX;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_RTF)) {
				contentType = Y41bConstantes.CONTENT_TYPE_RTF;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_BMP)) {
				contentType = Y41bConstantes.CONTENT_TYPE_BMP;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_TXT)) {
				contentType = Y41bConstantes.CONTENT_TYPE_TXT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_HTML)) {
				contentType = Y41bConstantes.CONTENT_TYPE_HTML;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_JPG)) {
				contentType = Y41bConstantes.CONTENT_TYPE_JPEG;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_MPP)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSPROJECT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODG)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODGRAPHICS;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODP)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODPRESENTATION;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODS)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODSPREADSHEET;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODT)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODTEXT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_PNG)) {
				contentType = Y41bConstantes.CONTENT_TYPE_PNG;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_PPTX)) {
				contentType = Y41bConstantes.CONTENT_TYPE_CONTENT_TYPE_OFFICEDPRESENTATION;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_PPT)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSPOWERPOINT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_TIF)) {
				contentType = Y41bConstantes.CONTENT_TYPE_TIFF;
			}
		}

		String origen = null;
		if (documento != null && documento.getOrigenDocumento() != null) {
			if (documento.getOrigenDocumento().equals(Y41bConstantes.ORIGEN_ADMINISTRACION)) {
				origen = Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION;
			}
		}
		return isDocumentoLocalizable(origen, contentType);
	}

	/**
	 * isDocumentoLocalizable
	 * 
	 * @param origen
	 *            String
	 * @param contentType
	 *            String
	 * @return boolean
	 */
	private static boolean isDocumentoLocalizable(String origen, String contentType) {
		// Validacion localizador para documentos origen
		if (origen != null && origen.equals(Y41bConstantes.ORIGEN_SOL_APORTADO_ADMINISTRACION)) {
			// Validacion Tipo Documento
			final Set<String> validContentTypes = new HashSet<String>(Arrays.asList(new String[] {
					Y41bConstantes.CONTENT_TYPE_MSWORD, Y41bConstantes.CONTENT_TYPE_MSWORDX,
					Y41bConstantes.CONTENT_TYPE_RTF, Y41bConstantes.CONTENT_TYPE_MSEXCEL,
					Y41bConstantes.CONTENT_TYPE_MSEXCELX, Y41bConstantes.CONTENT_TYPE_BMP,
					Y41bConstantes.CONTENT_TYPE_TXT, Y41bConstantes.CONTENT_TYPE_HTML, Y41bConstantes.CONTENT_TYPE_JPEG,
					Y41bConstantes.CONTENT_TYPE_MSPROJECT, Y41bConstantes.CONTENT_TYPE_ODGRAPHICS,
					Y41bConstantes.CONTENT_TYPE_ODPRESENTATION, Y41bConstantes.CONTENT_TYPE_ODSPREADSHEET,
					Y41bConstantes.CONTENT_TYPE_ODTEXT, Y41bConstantes.CONTENT_TYPE_PNG,
					Y41bConstantes.CONTENT_TYPE_CONTENT_TYPE_OFFICEDPRESENTATION,
					Y41bConstantes.CONTENT_TYPE_MSPOWERPOINT, Y41bConstantes.CONTENT_TYPE_TIFF }));
			if (contentType != null && validContentTypes.contains(contentType)) {
				return true;
			}
		}
		return false;
	}

	/**
	 * isDocumentoTransformableByExtension
	 * 
	 * @param documento
	 *            Documento
	 * @return boolean
	 */
	public static boolean isDocumentoTransformable(Documento documento) {
		String contentType = null;
		if (documento != null && documento.getExtension() != null) {
			StringBuffer extension = new StringBuffer();
			extension.append(".").append(documento.getExtension());
			if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_DOC)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSWORD;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_DOCX)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSWORDX;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_XLS)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSEXCEL;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_XLSX)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSEXCELX;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_RTF)) {
				contentType = Y41bConstantes.CONTENT_TYPE_RTF;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_BMP)) {
				contentType = Y41bConstantes.CONTENT_TYPE_BMP;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_TXT)) {
				contentType = Y41bConstantes.CONTENT_TYPE_TXT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_HTML)) {
				contentType = Y41bConstantes.CONTENT_TYPE_HTML;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_JPG)) {
				contentType = Y41bConstantes.CONTENT_TYPE_JPEG;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_MPP)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSPROJECT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODG)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODGRAPHICS;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODP)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODPRESENTATION;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODS)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODSPREADSHEET;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_ODT)) {
				contentType = Y41bConstantes.CONTENT_TYPE_ODTEXT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_PNG)) {
				contentType = Y41bConstantes.CONTENT_TYPE_PNG;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_PPTX)) {
				contentType = Y41bConstantes.CONTENT_TYPE_CONTENT_TYPE_OFFICEDPRESENTATION;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_PPT)) {
				contentType = Y41bConstantes.CONTENT_TYPE_MSPOWERPOINT;
			} else if (extension.toString().equalsIgnoreCase(Y41bConstantes.EXTENSION_TIF)) {
				contentType = Y41bConstantes.CONTENT_TYPE_TIFF;
			}

		}

		/*
		 * if (documento.getOrigenDocumento() != null &&
		 * documento.getOrigenDocumento().equals(
		 * Y41bConstantes.ORIGEN_CIUDADANIA)) { return false; }
		 */

		return isDocumentoTransformable(contentType);
	}

	/**
	 * isDocumentoTransformable
	 * 
	 * @param contentType
	 *            String
	 * @return boolean
	 */
	private static boolean isDocumentoTransformable(String contentType) {
		// Validacion Tipo Documento
		final Set<String> validContentTypes = new HashSet<String>(
				Arrays.asList(new String[] { Y41bConstantes.CONTENT_TYPE_MSWORD, Y41bConstantes.CONTENT_TYPE_MSWORDX,
						Y41bConstantes.CONTENT_TYPE_RTF, Y41bConstantes.CONTENT_TYPE_MSEXCEL,
						Y41bConstantes.CONTENT_TYPE_MSEXCELX, Y41bConstantes.CONTENT_TYPE_BMP,
						Y41bConstantes.CONTENT_TYPE_TXT, Y41bConstantes.CONTENT_TYPE_HTML,
						Y41bConstantes.CONTENT_TYPE_JPEG, Y41bConstantes.CONTENT_TYPE_MSPROJECT,
						Y41bConstantes.CONTENT_TYPE_ODGRAPHICS, Y41bConstantes.CONTENT_TYPE_ODPRESENTATION,
						Y41bConstantes.CONTENT_TYPE_ODSPREADSHEET, Y41bConstantes.CONTENT_TYPE_ODTEXT,
						Y41bConstantes.CONTENT_TYPE_PNG, Y41bConstantes.CONTENT_TYPE_CONTENT_TYPE_OFFICEDPRESENTATION,
						Y41bConstantes.CONTENT_TYPE_MSPOWERPOINT, Y41bConstantes.CONTENT_TYPE_TIFF }));
		if (contentType != null && validContentTypes.contains(contentType)) {
			return true;
		}

		return false;
	}

	public static boolean isValidNIF(String value) {
		Pattern mask = Pattern.compile("[0-9]{8,8}[A-Z]");
		if (value == null || value.length() == 0) {
			return false;
		} else {
			Matcher matcher = mask.matcher(value.toUpperCase());

			if (matcher.matches()) {
				char letra = Y41bUtils.calcularLetraNIF(value);

				if (letra == value.toUpperCase().charAt(value.length() - 1)) {
					return true;
				}
				return false;
			} else {
				return false;
			}
		}
	}

	/**
	 * Calcula la letra correspondiente a un DNI
	 * 
	 * @param nif
	 *            NIF a partir del cual se calcular su correspondiente letra
	 * @return Letra calculada para el DNI del NIF
	 */
	public static char calcularLetraNIF(String nif) {
		String cadena = "TRWAGMYFPDXBNJZSQVHLCKE";
		int dni = 0;
		int pos = 0;

		try {
			if (nif.length() == 9) {
				dni = Integer.parseInt(nif.substring(0, nif.length() - 1));
			} else {
				dni = Integer.parseInt(nif);
			}
			pos = dni % 23;
			return cadena.charAt(pos);
		} catch (NumberFormatException nfe) {
			return '!';
		}
	}

	public static boolean isValidCIF(String value) {
		// Pattern mask =
		// Pattern.compile("[[A-H][J-N][P-S]UVW][0-9]{7}[0-9A-J]");
		// int longitudCero = 0;

		if (value == null || value.length() == 0) {
			return false;
		} else {
			boolean resultado = Y41bUtils.validarCifPuro(value.toUpperCase());

			return resultado;
		}
	}

	/**
	 * validarCifPuro
	 * 
	 * @param cif
	 *            String
	 * @return boolean
	 */

	public static boolean validarCifPuro(String cif) {
		try {
			Pattern mask = Pattern.compile("[[A-H][J-N][P-S]UVW][0-9]{7}[0-9A-J]");
			String CONTROL_SOLO_NUMEROS = "ABEH"; // Slo admiten
													// nmeros como
													// caracter de
													// control
			String CONTROL_SOLO_LETRAS = "KPQS"; // Slo admiten
													// letras como
													// caracter de
													// control
			String CONTROL_NUMERO_A_LETRA = "JABCDEFGHI"; // Conversin
															// de
															// dígito
															// a
															// letra
															// de
															// control.
			Matcher matcher = mask.matcher(cif);

			if (!matcher.matches()) {
				// No cumple el patrn
				return false;
			}

			int parA = 0;
			for (int i = 2; i < 8; i += 2) {
				final int digito = Character.digit(cif.charAt(i), 10);
				if (digito < 0) {
					return false;
				}
				parA += digito;
			}

			int nonB = 0;
			for (int i = 1; i < 9; i += 2) {
				final int digito = Character.digit(cif.charAt(i), 10);
				if (digito < 0) {
					return false;
				}
				int nn = 2 * digito;
				if (nn > 9) {
					nn = 1 + (nn - 10);
				}
				nonB += nn;
			}

			final int parcialC = parA + nonB;
			final int digitoE = parcialC % 10;
			final int digitoD = (digitoE > 0) ? (10 - digitoE) : 0;
			final char letraIni = cif.toUpperCase().charAt(0);
			final char caracterFin = cif.toUpperCase().charAt(8);

			final boolean esControlValido =
					// el caracter de control es vlido como letra?
					(CONTROL_SOLO_NUMEROS.indexOf(letraIni) < 0
							&& CONTROL_NUMERO_A_LETRA.charAt(digitoD) == caracterFin) ||
					// el caracter de control es vlido como dgito?
							(CONTROL_SOLO_LETRAS.indexOf(letraIni) < 0 && digitoD == Character.digit(caracterFin, 10));
			return esControlValido;

		} catch (Exception e) {
			return false;
		}

	}

	public static boolean isValidNIE(String value) {
		Pattern mask = Pattern.compile("[X-Z]\\d{7}[A-Z]");
		if (value == null || value.length() == 0) {
			return true;
		} else {

			Matcher matcher = mask.matcher(value.toUpperCase());

			if (matcher.matches()) {
				if ('X' == value.toUpperCase().charAt(0)) {
					value = value.toUpperCase().replaceFirst("X", "0");
				} else if ('Y' == value.toUpperCase().charAt(0)) {
					value = value.toUpperCase().replaceFirst("Y", "1");
				} else if ('Z' == value.toUpperCase().charAt(0)) {
					value = value.toUpperCase().replaceFirst("Z", "2");
				}
				char letra = Y41bUtils.calcularLetraNIF(value);

				if (letra == value.toUpperCase().charAt(value.length() - 1)) {
					return true;
				}
				return false;
			} else {
				return false;
			}
		}
	}

	public static java.util.Date convertFromSQLDateToJAVADate(java.sql.Date sqlDate) {
		java.util.Date javaDate = null;
		if (sqlDate != null) {
			javaDate = new Date(sqlDate.getTime());
		}
		return javaDate;
	}

	/**
	 * 
	 * @return 'Hoy'
	 */
	public static Date hoy() {
		return new Date();
	}

	/**
	 * Funcin que elimina acentos y caracteres especiales de una cadena de
	 * texto.
	 * 
	 * @param input
	 * @return cadena de texto limpia de acentos y caracteres especiales.
	 */
	public static String removeAcentosCaracteresEspeciales(String input) {
		// Cadena de caracteres original a sustituir.
		String original = "u";
		// Cadena de caracteres ASCII que reemplazarn los originales.
		String ascii = "aaaeeeiiiooouuunAAAEEEIIIOOOUUUNcC";
		String output = input;
		for (int i = 0; i < original.length(); i++) {
			// Reemplazamos los caracteres especiales.
			output = output.replace(original.charAt(i), ascii.charAt(i));
		} // for i
		return output;
	}// remove1

	/**
	 * Metodo que devuelve un list con todos los campos seleccionados de una
	 * consulta
	 * 
	 * @param rsSelect
	 *            ResultSet
	 * @return List<String>
	 */
	public static List<String> cargarDatosBDVO(ResultSet rsSelect) {
		List<String> listRetorno = null;
		try {
			ResultSetMetaData rMetaData = rsSelect.getMetaData();
			int columnasRegistro = rMetaData.getColumnCount();
			String datosColumna = "";
			for (int intColumna = 1; intColumna <= columnasRegistro; intColumna++) {
				if (listRetorno == null) {
					listRetorno = new ArrayList<String>();
				}
				datosColumna = rMetaData.getColumnName(intColumna);
				listRetorno.add(datosColumna);
			}

		} catch (Exception e) {
		}
		return listRetorno;
	}

	/**
	 * Valida si el string es una direccin de correo vlida.
	 * 
	 * @param email
	 *            String
	 * @return boolean
	 */
	public static boolean validaEmailFormato(String email) {
		boolean result = true;
		try {
			InternetAddress emailAddr = new InternetAddress(email);
			emailAddr.validate();
		} catch (AddressException ex) {
			result = false;
		}
		return result;
	}

	public static String idiomaOneChar(String idiomaTwoChar) {

		if (idiomaTwoChar != null && !"".equals(idiomaTwoChar)) {

			if (Y41bConstantes.CASTELLANO.equalsIgnoreCase(idiomaTwoChar)) {
				return Y41bConstantes.CASTELLANO_CENSO;
			}
			return Y41bConstantes.EUSKERA_CENSO;
		}

		return idiomaTwoChar == null ? null : idiomaTwoChar.substring(0, 1);
	}

	public static String idiomaTwoChar(String idiomaOneChar) {

		if (idiomaOneChar != null && !"".equals(idiomaOneChar)) {

			if (Y41bConstantes.CASTELLANO_CENSO.equalsIgnoreCase(idiomaOneChar)) {
				return Y41bConstantes.CASTELLANO;
			}
			return Y41bConstantes.EUSKERA;
		}

		return idiomaOneChar == null ? null : idiomaOneChar.substring(0, 1);
	}

	/**
	 * reemplazarAmpersandPasarela.
	 * 
	 * @param cadena
	 *            String
	 * @return String resultado
	 */
	public static String reemplazarAmpersandPasarela(String cadena) {
		if (cadena != null) {
			return cadena.replace("&", "and");
		} else {
			return cadena;
		}
	}

	private static final String CADENA_INICIO_EJGV_DOCUMENTO = "<!-- ejgvDocument";
	private static final String CADENA_FIN_EJGV_DOCUMENTO = "ejgvDocument -->";

	/**
	 * extraerEjgvDocument
	 * 
	 * @param documento
	 *            String
	 * @return String
	 */
	public static String extraerEjgvDocument(String documento) {
		return documento.substring(
				documento.indexOf(Y41bUtils.CADENA_INICIO_EJGV_DOCUMENTO)
						+ Y41bUtils.CADENA_INICIO_EJGV_DOCUMENTO.length(),
				documento.indexOf(Y41bUtils.CADENA_FIN_EJGV_DOCUMENTO));
	}

	private static final String XPATH_LANGUAGE = "/ejgvDocument/body/ApplicantInfo/language";
	private static final String XPATH_MAIL = "/ejgvDocument/body/ApplicantInfo/notices/notice/channel/channelInfo/emailAddress";
	private static final String XPATH_PHONE = "/ejgvDocument/body/ApplicantInfo/notices/notice/channel/channelInfo/smsNumber";

	/**
	 * localizarIdiomaEnXML
	 * 
	 * @param documento
	 *            String
	 * @return String
	 */
	public static String localizarIdiomaEnXML(String documento) {
		return Y41bUtils.localizarValorEnXML(documento, Y41bUtils.XPATH_LANGUAGE);
	}

	/**
	 * localizarMailEnXML
	 * 
	 * @param documento
	 *            String
	 * @return String
	 */
	public static String localizarMailEnXML(String documento) {
		return Y41bUtils.localizarValorEnXML(documento, Y41bUtils.XPATH_MAIL);
	}

	/**
	 * localizarTelefonoEnXML
	 * 
	 * @param documento
	 *            String
	 * @return String
	 */
	public static String localizarTelefonoEnXML(String documento) {
		return Y41bUtils.localizarValorEnXML(documento, Y41bUtils.XPATH_PHONE);
	}

	/**
	 * localizarValorEnXML
	 * 
	 * @param documento
	 *            String
	 * @param expression
	 *            String
	 * @return String
	 */
	private static String localizarValorEnXML(String documento, String expression) {
		String resultado = null;
		try {
			XPathFactory xPathfactory = XPathFactory.newInstance();
			XPath xpath = xPathfactory.newXPath();
			XPathExpression expr = xpath.compile(expression);
			resultado = expr.evaluate(new InputSource(new StringReader(documento)));
		} catch (XPathExpressionException e) {
			e.printStackTrace();
		}
		return resultado;
	}

	/**
	 * Convierte el tamao en Bytes a MBs
	 * 
	 * @param tamano
	 *            long
	 * @return long
	 */
	public static long convertBytesToMB(long tamano) {
		long MEGABYTE = Y41bConstantes.NUM_1024 * Y41bConstantes.NUM_1024;
		return tamano / MEGABYTE;
	}

	/**
	 * Convierte cadena a mayusculas
	 * 
	 * @param cadena
	 *            String
	 * @return String
	 */
	public static String upperCase(String cadena) {
		return (cadena != null ? cadena.toUpperCase() : cadena);
	}

	/**
	 * Elimina los prefijos en un xml
	 * 
	 * @param xmlString
	 *            String
	 * @return String
	 */
	public static String removePrefixes(String xmlString) {
		return xmlString.replaceAll("(<\\?[^<]*\\?>)?", "")
				. /* remove preamble */
				replaceAll("xmlns.*?(\"|\').*?(\"|\')",
						"") /* remove xmlns declaration */
				.replaceAll("(<)(\\w+:)(.*?>)",
						"$1$3") /* remove opening tag prefix */
				.replaceAll("(</)(\\w+:)(.*?>)",
						"$1$3"); /* remove closing tags prefix */
	}

	/**
	 * Filtra caracteres antes de ingreso en DB
	 * 
	 * @param label
	 * @return
	 */
	public static String dejarLetrasNumerosComaEspacio(String input) {
		Pattern p = Pattern.compile("[^A-Za-z0-9, ]");
		Matcher m = p.matcher(input);
		StringBuffer sb = new StringBuffer();
		boolean resultado = m.find();
		boolean caracteresIlegales = false;
		while (resultado) {
			caracteresIlegales = true;
			m.appendReplacement(sb, "");
			resultado = m.find();
		}

		// Aade el ultimo segmento de la entrada a la cadena
		m.appendTail(sb);

		if (caracteresIlegales) {
			logger.info("La cadena contena caracteres ilegales que han sido suprimidos");
		}

		return sb.toString();
	}
}
