package com.ejie.y41b.utils;

import java.util.Random;

public class Y41bUIDGenerator {

	private static final Object monitor = new Object();
	private static final char[] symbols = new char[36];
	private static Y41bUIDGenerator instance;

	static {
		for (int idx = 0; idx < 10; ++idx)
			symbols[idx] = (char) ('0' + idx);
		for (int idx = 10; idx < 36; ++idx)
			symbols[idx] = (char) ('a' + idx - 10);
	}

	private final Random random = new Random();

	private char[] buf;

	public static Y41bUIDGenerator getInstance() {
		synchronized (monitor) {
			if (instance == null) {
				instance = new Y41bUIDGenerator();
			}
			return instance;
		}
	}

	public String generateId(int length) {
		if (length < 1)
			throw new IllegalArgumentException("length < 1: " + length);
		buf = new char[length];

		for (int idx = 0; idx < buf.length; ++idx)
			buf[idx] = symbols[random.nextInt(symbols.length)];
		return new String(buf).toUpperCase();
	}

}
