package com.ejie.y41b.utils;

public class Y41bStringUtils {

	// Private constructor suppresses
	private Y41bStringUtils() {

	}

	private static final String PLAIN_ASCII = "AaEeIiOoUu" // grave
			+ "AaEeIiOoUuYy" // acute
			+ "AaEeIiOoUuYy" // circumflex
			+ "AaOoNn" // tilde
			+ "AaEeIiOoUuYy" // umlaut
			+ "Aa" // ring
			+ "Cc" // cedilla
			+ "OoUu" // double acute
	;

	private static final String UNICODE = "\u00C0\u00E0\u00C8\u00E8\u00CC\u00EC\u00D2\u00F2\u00D9\u00F9"
			+ "\u00C1\u00E1\u00C9\u00E9\u00CD\u00ED\u00D3\u00F3\u00DA\u00FA\u00DD\u00FD"
			+ "\u00C2\u00E2\u00CA\u00EA\u00CE\u00EE\u00D4\u00F4\u00DB\u00FB\u0176\u0177"
			+ "\u00C3\u00E3\u00D5\u00F5\u00D1\u00F1"
			+ "\u00C4\u00E4\u00CB\u00EB\u00CF\u00EF\u00D6\u00F6\u00DC\u00FC\u0178\u00FF"
			+ "\u00C5\u00E5" + "\u00C7\u00E7" + "\u0150\u0151\u0170\u0171";

	public static String convertNonAscii(String s) {
		if (s == null)
			return null;
		StringBuilder sb = new StringBuilder();
		int n = s.length();
		for (int i = 0; i < n; i++) {
			char c = s.charAt(i);
			int pos = UNICODE.indexOf(c);
			if (pos > -1) {
				sb.append(PLAIN_ASCII.charAt(pos));
			} else {
				sb.append(c);
			}
		}
		return sb.toString();
	}

	public static final String unescapeHTML(String s, int f) {
		String[][] escape = { { "&lt;", "<" }, { "&gt;", ">" },
				{ "&amp;", "&" }, { "&quot;", "\"" }, { "&aacute;", "á" },
				{ "&acute;", "´" }, { "&Aacute;", "Á" }, { "&eacute;", "é" },
				{ "&Eacute;", "É" }, { "&iacute;", "í" }, { "&Iacute;", "Í" },
				{ "&oacute;", "ó" }, { "&Oacute;", "Ó" }, { "&uacute;", "ú" },
				{ "&Uacute;", "Ú" }, { "&ntilde;", "ñ" }, { "&Ntilde;", "Ñ" },
				{ "&apos;", "'" }, { "&deg;", "º" }, { "&agrave;", "à" },
				{ "&Agrave;", "À" }, { "&acirc;", "â" }, { "&auml;", "ä" },
				{ "&Auml;", "Ä" }, { "&Acirc;", "Â" }, { "&aring;", "å" },
				{ "&Aring;", "Å" }, { "&aelig;", "æ" }, { "&AElig;", "Æ" },
				{ "&ccedil;", "ç" }, { "&Ccedil;", "Ç" }, { "&eacute;", "é" },
				{ "&Eacute;", "É" }, { "&egrave;", "è" }, { "&Egrave;", "È" },
				{ "&ecirc;", "ê" }, { "&Ecirc;", "Ê" }, { "&euml;", "ë" },
				{ "&Euml;", "Ë" }, { "&iuml;", "ï" }, { "&Iuml;", "Ï" },
				{ "&ocirc;", "ô" }, { "&Ocirc;", "Ô" }, { "&ouml;", "ö" },
				{ "&Ouml;", "Ö" }, { "&oslash;", "ø" }, { "&Oslash;", "Ø" },
				{ "&szlig;", "ß" }, { "&ugrave;", "ù" }, { "&Ugrave;", "Ù" },
				{ "&ucirc;", "û" }, { "&Ucirc;", "Û" }, { "&uuml;", "ü" },
				{ "&Uuml;", "Ü" }, { "&nbsp;", " " }, { "&reg;", "\u00a9" },
				{ "&copy;", "\u00ae" }, { "&euro;", "\\\\'80" }, { "&ellipsis;", "\\\\'85" },
				{ "&Ccedil;", "Ç" }, { "&ccedil;", "ç" }, { "&uml;", "¨" },
				{ "&iquest;", "¿" }, { "&middot;", "·" },
				{ "&lineSeparator;", "{\\\\par \\\\pard}" },
				{ "&separator;", "{\\\\sb \\\\sb}" },
				{ "&negritaini;", "\\\\b " },
				{ "&negritafin;", "\\\\b0 \\\\'20" },
				{ "&italicini;", "\\\\i " },
				{ "&italicfin;", "\\\\i0 \\\\'20" }, { "&ene;", "\\\\'f1" },
				{ "&ENE;", "\\\\'d1" }, { "&subrayadoini;", "\\\\ul " },
				{ "&subrayadofin;", "\\\\ul0 \\\\'20" },
				{ "&bullet;", "\\\\'95" }, { "&tachadoini;", "\\\\strike" },
				{ "&tachadofin;", "\\\\strike0" },

		};
		int i, j, k;

		if (s != null) {
			i = s.indexOf("&", f);
			if (i > -1) {
				j = s.indexOf(";", i);
				// --------
				// we don't start from the beginning
				// the next time, to handle the case of
				// the &
				// thanks to Pieter Hertogh for the bug fix!
				f = i + 1;
				// --------
				if (j > i) {
					// ok this is not most optimized way to
					// do it, a StringBuffer would be better,
					// this is left as an exercise to the reader!
					String temp = s.substring(i, j + 1);
					// search in escape[][] if temp is there
					k = 0;
					while (k < escape.length) {
						if (escape[k][0].equals(temp))
							break;
						else
							k++;
					}
					if (k < escape.length) {
						s = s.substring(0, i) + escape[k][1]
								+ s.substring(j + 1);
						return unescapeHTML(s, f); // recursive call
					}
				}
			}
		}
		return s;
	}
}