package com.ejie.y41b.utils;

import java.util.Calendar;
import java.util.Date;

import com.ejie.y41b.constantes.Y41bConstantes;

/**
 * Y41bLiquidacionUtils
 * 
 *  
 *
 */
public class Y41bLiquidacionUtils {

	/**
	 * Instantiates a new y41b utils.
	 */
	private Y41bLiquidacionUtils() {

	}

	/**
	 * fechaLimitePago
	 * 
	 * Se calcula la fecha limite de pago de esta forma
	 * 
	 * Notificaciones entre el 1 el 15 de cada mes: se pone fecha limite para el
	 * pago el dia 20 del mes siguiente.
	 * 
	 * Notificaciones entre el 16 y el ultimo dia de cada mes: se pone fecha
	 * limite para el pago el dia 5 del mes siguiente al siguiente.
	 * 
	 * @param fecha
	 *            Date
	 * @param idioma
	 *            String
	 * @return String
	 */
	public static String fechaLimitePago(Date fecha, String idioma) {
		StringBuilder fechaLimitePasarela = new StringBuilder("");
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(fecha);
		int dia = calendar.get(Calendar.DAY_OF_MONTH); // dia del mes
		int mes = calendar.get(Calendar.MONTH) + 1; // mes, de 0 a 11
		int anio = calendar.get(Calendar.YEAR); // anyo
		if (dia >= Y41bConstantes.NUM_16) {
			dia = Y41bConstantes.NUM_20;
			if (mes == Y41bConstantes.NUM_12) {
				anio++;
				mes = Y41bConstantes.NUM_2;
			} else if (mes == Y41bConstantes.NUM_11) {
				anio++;
				mes = Y41bConstantes.NUM_1;
			} else {
				mes = mes + Y41bConstantes.NUM_2;
			}
		} else {
			dia = Y41bConstantes.NUM_5;
			if (mes == Y41bConstantes.NUM_12) {
				anio++;
				mes = Y41bConstantes.NUM_2;
			} else if (mes == Y41bConstantes.NUM_11) {
				anio++;
				mes = Y41bConstantes.NUM_1;
			} else {
				mes = mes + Y41bConstantes.NUM_2;
			}
		}
		if (Y41bConstantes.EUSKERA.equals(idioma)) {
			fechaLimitePasarela.append(anio).append(Y41bConstantes.FORMATO_FECHA_SEPARADOR)
					.append(Y41bUtils.zeroPad(String.valueOf(mes), 2)).append(Y41bConstantes.FORMATO_FECHA_SEPARADOR)
					.append(Y41bUtils.zeroPad(String.valueOf(dia), 2));
		} else {
			fechaLimitePasarela.append(Y41bUtils.zeroPad(String.valueOf(dia), 2))
					.append(Y41bConstantes.FORMATO_FECHA_SEPARADOR).append(Y41bUtils.zeroPad(String.valueOf(mes), 2))
					.append(Y41bConstantes.FORMATO_FECHA_SEPARADOR).append(anio);
		}
		return fechaLimitePasarela.toString();
	}

	/**
	 * fechaLimitePago
	 * 
	 * Se calcula la fecha limite de pago de esta forma
	 * 
	 * Notificaciones entre el 1 el 15 de cada mes: se pone fecha limite para el
	 * pago el dia 20 del mes siguiente.
	 * 
	 * Notificaciones entre el 16 y el ultimo dia de cada mes: se pone fecha
	 * limite para el pago el dia 5 del mes siguiente al siguiente.
	 * 
	 * @param idioma
	 *            String
	 * @return String
	 */
	public static String fechaLimitePago(String idioma) {
		return Y41bLiquidacionUtils.fechaLimitePago(Y41bUtils.obtenerFechaHoy(), idioma);
	}

}
