package com.ejie.y41b.utils;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * The Class Y41bEjgvUtils
 * 
 *  
 */
public class Y41bEjgvUtils {

	private static final Logger logger = LoggerFactory
			.getLogger(Y41bEjgvUtils.class);

	// Private constructor suppresses
	/**
	 * Instantiates a new a61t utils.
	 */
	private Y41bEjgvUtils() {

	}

	/**
	 * Recupera desde Dokusi el XML del tramite solicitado.
	 * 
	 * @param ejgvXML
	 *            String
	 * @return String
	 * @throws Exception
	 *             Excepcion
	 */
	public static String getDetailInfo(String ejgvXML) throws Exception {
		String detailInfoXML = "";
		// String ejgvXML =
		// ejgvHtml.substring(ejgvHtml.indexOf("<!-- ejgvDocument")+
		// "<!-- ejgvDocument".length(),ejgvHtml.indexOf("ejgvDocument -->"));
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder;
		Document doc = null;
		try {
			builder = factory.newDocumentBuilder();
			doc = builder.parse(new InputSource(new StringReader(ejgvXML)));
		} catch (Exception ex_getDetailInfo) {
			Y41bEjgvUtils.logger.error("Y41bEjgvUtils.getDetailInfo",
					ex_getDetailInfo);
			throw new Y41bUDAException("error.platea.invocation", true,
					ex_getDetailInfo);
		}
		if (doc != null) {
			NodeList nodes = doc.getElementsByTagName("detailInfo");
			detailInfoXML = Y41bEjgvUtils.nodeToString(nodes.item(0));
		}
		return detailInfoXML;
	}

	/**
	 * Transforma un nodo a un String
	 * 
	 * @param node
	 *            Nodo a transformar
	 * @return String Valor del nodo
	 */
	private static String nodeToString(Node node) {
		StringWriter sw = new StringWriter();
		try {
			if (node != null) {
				Transformer t = TransformerFactory.newInstance()
						.newTransformer();
				t.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
				t.setOutputProperty(OutputKeys.INDENT, "yes");
				t.transform(new DOMSource(node), new StreamResult(sw));
			}
		} catch (TransformerException te_nodeToString) {
			Y41bEjgvUtils.logger.error("Y41bEjgvUtils.nodeToString",
					te_nodeToString);
			throw new Y41bUDAException("error.platea.invocation", true,
					te_nodeToString);
		}
		return sw.toString();
	}
}
