package com.ejie.y41b.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * * Y41bValidacionesToolkitServiceImpl
 * 
 *  
 */

@Service(value = "validacionesToolkitService")
public class Y41bValidacionesToolkitServiceImpl implements Y41bValidacionesToolkitService {

	private static final Logger logger = LoggerFactory.getLogger(Y41bValidacionesToolkitServiceImpl.class);

	/**
	 * Metodo para validar el nif de la solicitud
	 *
	 * @param nif
	 *            String
	 * 
	 * @return boolean
	 * @throws Exception
	 * 
	 * 
	 */
	public boolean validarNifSolicitudes(String nif) throws Exception {
		logger.debug("validarNifSolicitudes nif " + nif);
		// Si el NIF NO contiene la letra H,G o R devuelva false, en caso
		// contrario que devuelva true.
		if (nif != null && (nif.toUpperCase().contains("H") || nif.toUpperCase().contains("G")
				|| nif.toUpperCase().contains("R"))) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Metodo para obtener el tipo de solicitud
	 * 
	 * @param nif
	 *            String
	 * 
	 * @return String
	 * @throws Exception
	 * 
	 * 
	 */
	public String obtenerTipoSolicitud(String nif) throws Exception {
		logger.debug("obtenerTipoSolicitud nif " + nif);
		// Si el NIF contiene la letra H, devolver "1" (Reclamacin
		// consumidor), en caso contrario devolver ""
		if (nif != null && nif.toUpperCase().contains("H")) {
			return "1";
		} else {
			return "2";
		}
	}

}
