// CHECKSTYLE:OFF
package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.AaccEuskadi;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbpropbandeja;
import com.ejie.y41b.model.BandejaAlerta;
import com.ejie.y41b.model.BandejaCampanha;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaFirmaBusqueda;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.BandejaInspeccionesFiltro;
import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.BandejaSolicitudesBusqueda;
import com.ejie.y41b.model.BusquedaInspeccion;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CargaTrabajo;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.model.Consulta;
import com.ejie.y41b.model.ConsultaBusqueda;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.EstablecimientoDetalle;
import com.ejie.y41b.model.ExcelAdheridas;
import com.ejie.y41b.model.FiltroArbitraje;
import com.ejie.y41b.model.FiltroSanciones;
import com.ejie.y41b.model.InspeccionesPropBandeja;
import com.ejie.y41b.model.Jjaa;
import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.model.Pagos;
import com.ejie.y41b.model.PagosBusqueda;
import com.ejie.y41b.model.Remesa;
import com.ejie.y41b.model.RemesaBusqueda;
import com.ejie.y41b.model.Sanbandeja;
import com.ejie.y41b.model.Sanpropbandeja;
import com.ejie.y41b.model.Secretar;
import com.ejie.y41b.model.SolicitudBusqueda;
import com.ejie.y41b.model.Tclugaud;
import com.ejie.y41b.utils.Y41bUtils;

/**
 *  
 */
// CHECKSTYLE:OFF NCSS
@Service(value = "excelGeneratorService")
public class Y41bExcelGeneratorServiceImpl implements Y41bExcelGeneratorService {

	@Autowired
	private ConsultaService consultaService;

	@Autowired
	private CampanhaService campanhaService;

	@Autowired
	private AlertaService alertaService;

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private ConsumidorService consumidorService;

	@Autowired
	private EstablecimientoService establecimientoService;

	@Autowired
	private ExpedienService expedienService;

	@Autowired
	private BandejaSolicitudesService bandejaSolicitudesService;

	@Autowired
	private BandejaFirmaService bandejaFirmaService;

	@Autowired
	private SanpropbandejaService sanpropbandejaService;

	@Autowired
	private SolarbService solarbService;

	@Autowired
	private ArbpropbandejaService arbpropbandejaService;

	@Autowired
	private PagosService pagosService;

	@Autowired
	private SanbandejaService sanbandejaService;

	@Autowired
	private BandejaCampanhaService bandejaCampanhasService;

	@Autowired
	private BandejaAlertaService bandejaAlertasService;

	@Autowired
	private ArbbandejaService arbbandejaService;

	@Autowired
	private OoeeService ooeeService;

	@Autowired
	private AaccService aaccService;

	@Autowired
	private AaccEuskadiService aaccEuskadiService;

	@Autowired
	private ArbitroService arbitroService;

	@Resource
	private ReloadableResourceBundleMessageSource appMessageSource;
	@Autowired
	private EmpperService empperService;
	@Autowired
	private JjaaService jjaaService;

	@Autowired
	private ArbadhsolService arbadhsolService;

	@Autowired
	private TclugaudService tclugaudService;

	@Autowired
	private ExcelAdheridasService excelAdheridasService;

	@Autowired
	private SecretarService secretarService;

	@Autowired
	private RemesaService remesaService;

	@Autowired
	private ComunicacionSoivreService comunicacionSoivreService;

	@Autowired
	private ActaService actaService;

	@Autowired
	private BandejaInspeccionesService bandejaInspeccionesService;

	@Autowired
	private InspeccionesPropBandejaService inspeccionesPropBandejaService;

	@Autowired
	private CargaTrabajoService cargaTrabajoService;

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en consultas
	 * 
	 * @param consulta
	 *            Consulta
	 * @return String
	 */
	public String getConsultasExcel(Consulta consulta) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getConsultasListTable(consulta));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en campanhas
	 * 
	 * @param campanha
	 *            Campanha
	 * @return String
	 */
	public String getCampanhasExcel(Campanha campanha) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getCampanhasListTable(campanha));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en alertas
	 * 
	 * @param alerta
	 *            Alerta
	 * @return String
	 */
	public String getAlertasExcel(Alerta alerta) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getAlertasListTable(alerta));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en comunicaciones soivre
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return String
	 */
	public String getComunicacionesSoivreExcel(ComunicacionSoivre comunicacionSoivre) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getComunicacionesSoivreListTable(comunicacionSoivre));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param solicitudBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	public String getSolicitudesExcel(SolicitudBusqueda solicitudBusqueda) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getSolicitudesListTable(solicitudBusqueda));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en inspecciones
	 * 
	 * @param acta
	 *            Acta acta
	 * @return String
	 */
	public String getInspeccionesExcel(Acta acta) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getInspeccionesListTable(acta));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en sanciones
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return String
	 */
	public String getSancionesExcel(FiltroSanciones filtroSanciones) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getSancionesListTable(filtroSanciones));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en sanciones
	 * 
	 * @param filtroArbitrajes
	 *            FiltroArbitraje
	 * @return String
	 */
	public String getArbitrajesExcel(FiltroArbitraje filtroArbitraje) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getArbitrajesListTable(filtroArbitraje));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en consumidores
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return String
	 */
	public String getConsumidoresExcel(Consumidor consumidor) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getConsumidoresListTable(consumidor));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en establecimientos
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return String
	 */
	public String getEstablecimientosExcel(Establecimiento establecimiento, EstablecimSector establecimSector) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getEstablecimientosListTable(establecimiento, establecimSector));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en establecimientos
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return String
	 */
	public String getEstablecimientosExcelExtendido(Establecimiento establecimiento,
			EstablecimSector establecimSector) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getEstablecimientosListTableExtendido(establecimiento, establecimSector));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en carga de trabajo
	 * 
	 * @param cargaTrabajo
	 *            CargaTrabajo
	 * @return String
	 */
	public String getCargaTrabajoExcel(CargaTrabajo cargaTrabajo) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getCargaTrabajoListTable(cargaTrabajo));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return String
	 */
	private String getConsultasListTable(Consulta consulta) {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getConsultasHeaderRow());

		Date cofechaDesde = null;
		Date cofechaHasta = null;
		try {
			cofechaDesde = Y41bUtils.parseDate(consulta.getCofechadesde(), locale);
			cofechaHasta = Y41bUtils.parseDate(consulta.getCofechahasta(), locale);
		} catch (Exception e) {
		}

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("numeroConsulta");
		List<ConsultaBusqueda> consultasBusqueda = this.consultaService.findAllLikeConsulta(consulta, pagination, false,
				cofechaDesde, cofechaHasta);

		for (ConsultaBusqueda consultaBusquedaAux : consultasBusqueda) {
			xslString.append(getConsultasRow(consultaBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return String
	 */
	private String getCampanhasListTable(Campanha campanha) {

		// Obtener el mensaje dependiendo del idioma
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getCampanhasHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("cmFechaInicio");

		List<Campanha> campanhas = this.campanhaService.findAllLikeCampanha(campanha, pagination, false);

		for (Campanha campanhaAux : campanhas) {
			xslString.append(getCampanhasRow(campanhaAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return String
	 */
	private String getComunicacionesSoivreListTable(ComunicacionSoivre comunicacionSoivre) {

		// Obtener el mensaje dependiendo del idioma
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getComunicacionesSoivreHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("desc");
		pagination.setSort("v6fechaentrada");

		List<ComunicacionSoivre> comunicacionesSoivre = this.comunicacionSoivreService.findAllLike(comunicacionSoivre,
				pagination, false);

		for (ComunicacionSoivre comunicacionSoivreAux : comunicacionesSoivre) {
			xslString.append(getComunicacionesSoivreRow(comunicacionSoivreAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return String
	 */
	private String getAlertasListTable(Alerta alerta) {

		// Obtener el mensaje dependiendo del idioma
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getAlertasHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("desc");
		pagination.setSort("alfeen");

		List<Alerta> alertas = this.alertaService.findAllLike(alerta, pagination, false);

		for (Alerta alertaAux : alertas) {
			xslString.append(getAlertasRow(alertaAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param solicitudBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	private String getSolicitudesListTable(SolicitudBusqueda solicitudBusqueda) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getSolicitudesHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("numExpediente");
		List<SolicitudBusqueda> solicitudesBusqueda = this.denunciaService.findAllLikeSolicitudes(solicitudBusqueda,
				pagination, false);

		for (SolicitudBusqueda solicitudBusquedaAux : solicitudesBusqueda) {
			xslString.append(getSolicitudesRow(solicitudBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param acta
	 *            Acta
	 * @return String
	 */
	private String getInspeccionesListTable(Acta acta) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getInspeccionesHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setSord("desc");
		pagination.setSidx("acfere");

		List<BusquedaInspeccion> inspeccionesBusqueda = this.actaService.findAllActaLike(acta, pagination);

		for (BusquedaInspeccion inspeccionBusquedaAux : inspeccionesBusqueda) {

			xslString.append(getInspeccionesRow(inspeccionBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param cargaTrabajo
	 *            CargaTrabajo
	 * @return String
	 */
	private String getCargaTrabajoListTable(CargaTrabajo cargaTrabajo) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getCargaTrabajoHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setSord("asc");
		pagination.setSidx("monombre");

		List<CargaTrabajo> listCargaTrabajo = this.cargaTrabajoService.findAll(cargaTrabajo, pagination);

		for (CargaTrabajo cargaTrabajoAux : listCargaTrabajo) {

			xslString.append(getCargaTrabajoRow(cargaTrabajoAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param pagosAux
	 *            pagosAux
	 * @return String
	 */
	private String getSancionesListTable(FiltroSanciones pagosAux) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getSancionesHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("desc");
		pagination.setSort("codCompleto");
		List<FiltroSanciones> sancionesBusqueda = this.expedienService.findAllLikeSanciones(pagosAux, pagination,
				false);

		for (FiltroSanciones sancionesBusquedaAux : sancionesBusqueda) {
			xslString.append(this.getSancionesRow(sancionesBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param pagosAux
	 *            pagosAux
	 * @return String
	 */
	private String getArbitrajesListTable(FiltroArbitraje pagosAux) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getArbitrajesHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("codCompleto");
		List<FiltroArbitraje> arbitrajeBusqueda = this.solarbService.findAllLikeArbitrajes(pagosAux, pagination, false);

		for (FiltroArbitraje arbitrajeBusquedaAux : arbitrajeBusqueda) {
			xslString.append(this.getArbitrajesRow(arbitrajeBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return String
	 */
	private String getConsumidoresListTable(Consumidor consumidor) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getConsumidoresHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("DTNIF");
		List<Consumidor> consumidors = this.consumidorService.findAllLikeConsumidor(consumidor, pagination, false);

		for (Consumidor consumidorAux : consumidors) {
			xslString.append(getConsumidoresRow(consumidorAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return String
	 */
	private String getEstablecimientosListTable(Establecimiento establecimiento, EstablecimSector establecimSector) {

		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getEstablecimientosHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("ESNIF");

		List<Establecimiento> establecimientos = this.establecimientoService.findAllLikeEstablecimiento(establecimiento,
				establecimSector, pagination, false);

		for (Establecimiento establecimientoAux : establecimientos) {
			xslString.append(getEstablecimientosRow(establecimientoAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return String
	 */
	private String getEstablecimientosListTableExtendido(Establecimiento establecimiento,
			EstablecimSector establecimSector) {

		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getEstablecimientosHeaderRowExtendido());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("ESNIF");

		List<EstablecimientoDetalle> establecimientos = this.establecimientoService
				.findAllLikeEstablecimientoExtendido(establecimiento, establecimSector, pagination, false);

		for (EstablecimientoDetalle establecimientoAux : establecimientos) {
			xslString.append(getEstablecimientosRowExtendido(establecimientoAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getConsultasHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getHeaderField(appMessageSource.getMessage("excel.numeroConsulta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cofecha", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.monombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nombreMunicipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tfpnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.coinl37", null, locale)));
		/*
		 * header.append(getHeaderField(appMessageSource.getMessage(
		 * "excel.psnombre", null, locale)));
		 */
		header.append(getHeaderField(appMessageSource.getMessage("excel.cosituacion", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getCampanhasHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getHeaderField(appMessageSource.getMessage("excel.campanhas.codigo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.campanhas.nombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.campanhas.origen", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.campanhas.tipo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.campanhas.online", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.campanhas.fechainicio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.campanhas.fechacierre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.campanhas.fase", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.campanhas.activa", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getAlertasHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getHeaderField(appMessageSource.getMessage("excel.alertas.origen", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.alertas.numalerta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.alertas.anyo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.alertas.paisCCAAAecosan", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.alertas.producto", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.alertas.codigobarras", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.alertas.fechaentrada", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.alertas.fechamaximaplazo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.alertas.activa", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getComunicacionesSoivreHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getHeaderField(appMessageSource.getMessage("excel.comunicacionessoivre.codigo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.comunicacionessoivre.tipo", null, locale)));
		header.append(
				getHeaderField(appMessageSource.getMessage("excel.comunicacionessoivre.importador", null, locale)));
		header.append(
				getHeaderField(appMessageSource.getMessage("excel.comunicacionessoivre.organismo", null, locale)));
		header.append(
				getHeaderField(appMessageSource.getMessage("excel.comunicacionessoivre.fechaentrada", null, locale)));
		header.append(getHeaderField(
				appMessageSource.getMessage("excel.comunicacionessoivre.fechasolinspeccion", null, locale)));
		header.append(
				getHeaderField(appMessageSource.getMessage("excel.comunicacionessoivre.fecharespuesta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.comunicacionessoivre.nombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.comunicacionessoivre.marca", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.comunicacionessoivre.modelo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.comunicacionessoivre.unidades", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSolicitudesHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.numeroSolicitud", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.defede", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.orgNombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.dtnomreclamante", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.esnomreclamado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.trnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.decision", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.monombreExpediente", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getInspeccionesHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.inspecciones.tipoorigen", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.inspecciones.origen", null, locale)));

		header.append(getHeaderField(appMessageSource.getMessage("excel.inspecciones.numExpediente", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.inspecciones.tipoInspeccion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.inspecciones.fechaInicio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.inspecciones.establecimiento", null, locale)));
		header.append(getHeaderField(
				appMessageSource.getMessage("excel.inspecciones.establecimientomunicipio", null, locale)));

		header.append(getHeaderField(appMessageSource.getMessage("excel.inspecciones.productoservicio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.inspecciones.tramite", null, locale)));

		header.append(
				getHeaderField(appMessageSource.getMessage("excel.inspecciones.productosencontrados", null, locale)));

		// header.append(getHeaderField(appMessageSource.getMessage(
		// "excel.inspecciones.fase", null, locale)));

		header.append(getHeaderField(appMessageSource.getMessage("excel.inspecciones.decision", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.inspecciones.responsableexp", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSancionesHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaInicio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaFin", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.denunciado", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nombreMunicipio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tramite", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tipoResolucion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.instructor", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getArbitrajesHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaInicio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaFin", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.reclamante", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.reclamado", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tramite", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.instructor", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getConsumidoresHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.nifCifNie", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.ape1", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.ape2", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.direccion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nombreMunicipio", null, locale)));
		// header.append(getHeaderField(appMessageSource.getMessage("excel.telefono",
		// null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getEstablecimientosHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.cierre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cif", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nombrecomercial", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.razonsocial", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nombreMunicipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.direccion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.adherido", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.sede", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getEstablecimientosHeaderRowExtendido() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.cierre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cif", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nombrecomercial", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.razonsocial", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nombreMunicipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.direccion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.adherido", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.sede", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechaAdh", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nAdh", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tipoArb", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.mediacion", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.adhIndef", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechaFinAdh", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechaBajaEfectiva", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechaPetiAct", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cp", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.provincia", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getCargaTrabajoHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(
				getHeaderField(appMessageSource.getMessage("excel.cargatrabajo.responsableexpediente", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cargatrabajo.inspecciones", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cargatrabajo.denuncias", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cargatrabajo.solicitudes", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cargatrabajo.arbitraje", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cargatrabajo.sancionador", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cargatrabajo.total", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param cargaTrabajo
	 *            CargaTrabajo
	 * @return String
	 */
	private String getCargaTrabajoRow(CargaTrabajo cargaTrabajo) {

		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// monombre
		row.append(getField(Y41bUtils.normalizarVacio(cargaTrabajo.getMonombre())));

		// expedientesInspecciones
		row.append(getField(cargaTrabajo.getExpedientesInspecciones().toString()));

		// expedientesDenuncias
		row.append(getField(cargaTrabajo.getExpedientesDenuncias().toString()));

		// expedientesSolicitudes
		row.append(getField(cargaTrabajo.getExpedientesSolicitudes().toString()));

		// expedientesArbitraje
		row.append(getField(cargaTrabajo.getExpedientesArbitraje().toString()));

		// expedientesSancionador
		row.append(getField(cargaTrabajo.getExpedientesSancionador().toString()));

		// expedientesTotal
		row.append(getField(cargaTrabajo.getExpedientesTotal().toString()));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar cabeceras.
	 * 
	 * @param fieldName
	 *            String
	 * @return String
	 */
	private static String getHeaderField(String fieldName) {
		StringBuffer field = new StringBuffer();
		field.append("<th>");
		field.append(Y41bUtils.normalizarVacio(fieldName));
		field.append("</th>");
		return field.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param consultaBusqueda
	 *            ConsultaBusqueda
	 * @return String
	 */
	private String getConsultasRow(ConsultaBusqueda consultaBusqueda) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numeroConsulta
		row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda.getNumeroConsulta())));

		// cofecha
		row.append(getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(consultaBusqueda.getCofecha(), locale.getLanguage()))));

		// monombre
		row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda.getMonombre())));

		// nombreMunicipio
		row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda.getNombreMunicipio())));

		// tfpnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda.getTfpnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda.getTfpnombree())));
		}

		// coinl37
		if (consultaBusqueda.getCoinl37() != null && consultaBusqueda.getCoinl37().equals(Y41bConstantes.VALOR_SI)) {
			row.append(getField(appMessageSource.getMessage("excel.web", null, locale)));
		} else {
			row.append(getField(appMessageSource.getMessage("excel.oficina", null, locale)));
		}

		// psnombre
		/*
		 * if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
		 * row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda
		 * .getPsnombre()))); } else {
		 * row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda
		 * .getPsnombree()))); }
		 */

		// cosituacion
		if ((consultaBusqueda.getCosituacion() != null
				&& consultaBusqueda.getCosituacion().equals(Y41bConstantes.SITUACION_PENDIENTES))
				|| consultaBusqueda.getCosituacion() == null || consultaBusqueda.getCosituacion().equals("")) {
			row.append(getField(Y41bConstantes.VALOR_SI));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		}

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return String
	 */
	private String getCampanhasRow(Campanha campanha) {

		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// codigo
		row.append(getFieldTexto(Y41bUtils.normalizarVacio(campanha.getCmcodigo())));
		// nombre
		row.append(getField(Y41bUtils.normalizarVacio(campanha.getCmnombre())));
		// origen
		String origen = null;
		if (Y41bConstantes.CAMPANA_ORIGEN_ESTATAL.equals(campanha.getCmorigen())) {
			origen = getHeaderField(appMessageSource.getMessage("excel.campanhas.estatal", null, locale));
		} else if (Y41bConstantes.CAMPANA_ORIGEN_KONTSUMOBIDE.equals(campanha.getCmorigen())) {
			origen = getHeaderField(appMessageSource.getMessage("excel.campanhas.kontsumobide", null, locale));
		} else if (Y41bConstantes.CAMPANA_ORIGEN_UE.equals(campanha.getCmorigen())) {
			origen = getHeaderField(appMessageSource.getMessage("excel.campanhas.unioneuropea", null, locale));
		} else {
			origen = getField(campanha.getCmorigen());
		}
		row.append(Y41bUtils.normalizarVacio(origen));
		// tipo
		String tipo = null;
		if (Y41bConstantes.CAMPANA_TIPO_CONTROLPRODUCTO.equals(campanha.getCmtipo())) {
			tipo = getHeaderField(appMessageSource.getMessage("excel.campanhas.controlproductos", null, locale));
		} else if (Y41bConstantes.CAMPANA_TIPO_MIXTAS.equals(campanha.getCmtipo())) {
			tipo = getHeaderField(appMessageSource.getMessage("excel.campanhas.mixtas", null, locale));
		} else if (Y41bConstantes.CAMPANA_TIPO_MUESTRAS.equals(campanha.getCmtipo())) {
			tipo = getHeaderField(appMessageSource.getMessage("excel.campanhas.muestras", null, locale));
		} else {
			tipo = getField(campanha.getCmtipo());
		}
		row.append(Y41bUtils.normalizarVacio(tipo));
		// online
		String online = null;
		if (Y41bConstantes.VALOR_SI.equals(campanha.getCmonline())) {
			online = getHeaderField(appMessageSource.getMessage("excel.campanhas.si", null, locale));
		} else {
			online = getField(Y41bUtils.normalizarVacio(campanha.getCmonline()));
		}
		row.append(online);
		// fechainicio
		row.append(getField(Y41bUtils
				.normalizarVacio((campanha.getCmfechainicio() != null) ? campanha.getCmfechainicio().toString() : "")));
		// fechacierre
		row.append(getField(Y41bUtils
				.normalizarVacio((campanha.getCmfechacierre() != null) ? campanha.getCmfechacierre().toString() : "")));
		// fase
		String fase = null;
		if (Y41bConstantes.FASE_CAMPANHA_ANALISIS.equals(campanha.getCmfase())) {
			fase = getHeaderField(appMessageSource.getMessage("excel.campanhas.analisis", null, locale));
		} else if (Y41bConstantes.FASE_CAMPANHA_BORRADOR.equals(campanha.getCmfase())) {
			fase = getHeaderField(appMessageSource.getMessage("excel.campanhas.borrador", null, locale));
		} else if (Y41bConstantes.FASE_CAMPANHA_CIERRE.equals(campanha.getCmfase())) {
			fase = getHeaderField(appMessageSource.getMessage("excel.campanhas.cierre", null, locale));
		} else if (Y41bConstantes.FASE_CAMPANHA_EJECUCION.equals(campanha.getCmfase())) {
			fase = getHeaderField(appMessageSource.getMessage("excel.campanhas.ejecucion", null, locale));
		} else if (Y41bConstantes.FASE_CAMPANHA_INACTIVA.equals(campanha.getCmfase())) {
			fase = getHeaderField(appMessageSource.getMessage("excel.campanhas.inactiva", null, locale));
		} else if (Y41bConstantes.FASE_CAMPANHA_VALIDACION.equals(campanha.getCmfase())) {
			fase = getHeaderField(appMessageSource.getMessage("excel.campanhas.validacion", null, locale));
		} else {
			fase = getField(Y41bUtils.normalizarVacio(campanha.getCmfase()));
		}
		row.append(fase);
		// activa
		String activa = null;
		if (Y41bConstantes.VALOR_SI.equals(campanha.getCmactiva())) {
			activa = getHeaderField(appMessageSource.getMessage("excel.campanhas.si", null, locale));
		} else if (Y41bConstantes.VALOR_NO.equals(campanha.getCmactiva())) {
			activa = getHeaderField(appMessageSource.getMessage("excel.campanhas.no", null, locale));
		} else {
			activa = getField(Y41bUtils.normalizarVacio(campanha.getCmactiva()));
		}
		row.append(activa);

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param alerta
	 *            Alerta
	 * @return String
	 */
	private String getAlertasRow(Alerta alerta) {

		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// origen
		row.append(getField(Y41bUtils.normalizarVacio(alerta.getAlcoor())));
		// numalerta
		row.append(getField(Y41bUtils.normalizarVacio(alerta.getAlnror())));
		// anyo
		row.append(getField(Y41bUtils.convertLong2String(alerta.getAlnran())));
		// paisCCAAAecosan
		row.append(getField(Y41bUtils.normalizarVacio(alerta.getAlorigen())));
		// producto
		row.append(getField(Y41bUtils.normalizarVacio(alerta.getAlproducto())));
		// codigobarras
		row.append(getField("&nbsp;" + Y41bUtils.normalizarVacio(alerta.getAlcodigobarras())));

		// fechaentrada
		row.append(
				getField(Y41bUtils.normalizarVacio((alerta.getAlfeen() != null) ? alerta.getAlfeen().toString() : "")));
		// fechamaximaplazo
		row.append(getField(Y41bUtils
				.normalizarVacio((alerta.getAlmaxfechaplazo() != null) ? alerta.getAlmaxfechaplazo().toString() : "")));
		// activa
		String activa = null;
		if (Y41bConstantes.VALOR_SI.equals(alerta.getAlactiva())) {
			activa = getHeaderField(appMessageSource.getMessage("excel.campanhas.si", null, locale));
		} else if (Y41bConstantes.VALOR_NO.equals(alerta.getAlactiva())) {
			activa = getHeaderField(appMessageSource.getMessage("excel.campanhas.no", null, locale));
		} else {
			activa = getField(Y41bUtils.normalizarVacio(alerta.getAlactiva()));
		}
		row.append(activa);

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return String
	 */
	private String getComunicacionesSoivreRow(ComunicacionSoivre comunicacionSoivre) {

		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// codigo
		row.append(getField(Y41bUtils.normalizarVacio(comunicacionSoivre.getV6codigo())));
		// tipo
		// activa
		String tipo = null;
		if ("S".equals(comunicacionSoivre.getV6tipo())) {
			tipo = getHeaderField(
					appMessageSource.getMessage("excel.comunicacionessoivre.tipo.subsanables", null, locale));
		} else if ("D".equals(comunicacionSoivre.getV6tipo())) {
			tipo = getHeaderField(
					appMessageSource.getMessage("excel.comunicacionessoivre.tipo.rechazoImportacion", null, locale));
		} else if ("A".equals(comunicacionSoivre.getV6tipo())) {
			tipo = getHeaderField(appMessageSource.getMessage("excel.comunicacionessoivre.tipo.alerta", null, locale));
		} else if ("I".equals(comunicacionSoivre.getV6tipo())) {
			tipo = getHeaderField(
					appMessageSource.getMessage("excel.comunicacionessoivre.tipo.informativa", null, locale));
		}
		row.append(tipo);

		// importador
		row.append(getField(Y41bUtils.normalizarVacio(comunicacionSoivre.getV6importadoresnombre())));
		// organismo
		row.append(getField(Y41bUtils.normalizarVacio(comunicacionSoivre.getV6coor())));
		// fechaentrada
		row.append(getField(Y41bUtils.normalizarVacio((comunicacionSoivre.getV6fechaentrada() != null)
				? comunicacionSoivre.getV6fechaentrada().toString() : "")));
		// fechasolinspeccion
		row.append(getField(Y41bUtils.normalizarVacio((comunicacionSoivre.getV6fechasolinspeccion() != null)
				? comunicacionSoivre.getV6fechasolinspeccion().toString() : "")));
		// fecharespuesta
		row.append(getField(Y41bUtils.normalizarVacio((comunicacionSoivre.getV6fecharespuesta() != null)
				? comunicacionSoivre.getV6fecharespuesta().toString() : "")));
		// nombre
		row.append(getField(Y41bUtils.normalizarVacio(comunicacionSoivre.getV6nomps())));
		// marca
		row.append(getField(Y41bUtils.normalizarVacio(comunicacionSoivre.getV6marcaps())));
		// modelo
		row.append(getField(Y41bUtils.normalizarVacio(comunicacionSoivre.getV6modelops())));
		// unidades
		row.append(getField(comunicacionSoivre.getV6numunidades().toString()));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param solicitudBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	private String getSolicitudesRow(SolicitudBusqueda solicitudBusqueda) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda.getNumExpediente())));

		// defede
		row.append(getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(solicitudBusqueda.getDefede(), locale.getLanguage()))));

		// orgNombre
		// if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
		// row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda
		// .getOrgNombre())));
		//
		// } else {
		// row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda
		// .getOrgNombree())));
		// }

		// monombreExpediente
		row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda.getMonombreExpediente())));

		// dtnombre
		row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda.getDtnombre())));

		// esnombre
		row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda.getEsnombre())));

		// trnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda.getTrnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda.getTrnombree())));
		}

		// fnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda.getFnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda.getFnombree())));
		}

		// dnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda.getDenombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda.getDenombree())));
		}

		// // monombreExpediente
		// row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda
		// .getMonombreExpediente())));
		// monombreTramitador
		row.append(getField(Y41bUtils.normalizarVacio(solicitudBusqueda.getMonombreTramitador())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param solicitudBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	private String getInspeccionesRow(BusquedaInspeccion busquedaInspeccion) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// tipoorigen
		String tipoOrigen = "";

		if (busquedaInspeccion.getAtcocm() != null) {
			tipoOrigen = appMessageSource.getMessage("excel.inspecciones.campanha", null, locale);
		} else if (busquedaInspeccion.getAtcohd() != null && busquedaInspeccion.getAtcohddenuncia() == null) {
			tipoOrigen = appMessageSource.getMessage("excel.inspecciones.solicitud", null, locale);
		} else if (busquedaInspeccion.getAtcohd() != null && busquedaInspeccion.getAtcohddenuncia() != null) {
			tipoOrigen = appMessageSource.getMessage("excel.inspecciones.denuncia", null, locale);
		} else if (busquedaInspeccion.getAtcoal() != null) {
			tipoOrigen = appMessageSource.getMessage("excel.inspecciones.alerta", null, locale);
		} else if (busquedaInspeccion.getAtidcomunicacionsoivre() != null) {
			tipoOrigen = appMessageSource.getMessage("excel.inspecciones.soivre", null, locale);
		} else if (busquedaInspeccion.getActiororigen() != null && busquedaInspeccion.getActiororigen().equals("C")) {
			tipoOrigen = appMessageSource.getMessage("excel.inspecciones.comunicacionesExternas", null, locale);
		} else if (busquedaInspeccion.getActiororigen() != null && busquedaInspeccion.getActiororigen().equals("N")) {
			tipoOrigen = appMessageSource.getMessage("excel.inspecciones.notificacionProductores", null, locale);
		} else {
			tipoOrigen = appMessageSource.getMessage("excel.inspecciones.oficio", null, locale);
		}

		row.append(getField(Y41bUtils.normalizarVacio(tipoOrigen)));

		// codigoorigen
		String codigoOrigen = null;
		// Si es hecho denunciado...
		if (busquedaInspeccion.getAtcohd() != null) {
			if (busquedaInspeccion.getHdnror() != null) {
				codigoOrigen = busquedaInspeccion.getHdnror();
			} else {
				codigoOrigen = busquedaInspeccion.getDecoor() + "-" + busquedaInspeccion.getDenror() + "-"
						+ busquedaInspeccion.getDenran();
			}

			// Si es campanha...
		} else if (busquedaInspeccion.getAtcocm() != null) {
			codigoOrigen = busquedaInspeccion.getAtcocm();

			// Si es alerta...
		} else if (busquedaInspeccion.getAtcoal() != null) {
			codigoOrigen = busquedaInspeccion.getAlnror() + "-" + busquedaInspeccion.getAlnran();

			// Si es comunicacion Soivre...
		} else if (busquedaInspeccion.getAtidcomunicacionsoivre() != null) {
			codigoOrigen = busquedaInspeccion.getV6codigo();

		} else {
			codigoOrigen = "";
		}
		row.append(getFieldTexto(Y41bUtils.normalizarVacio(codigoOrigen)));

		// numExp
		StringBuilder numExp = new StringBuilder("");
		if (busquedaInspeccion.getAccoor() != null && !"".equals(busquedaInspeccion.getAccoor())) {
			numExp.append(busquedaInspeccion.getAccoor() + "-");
		}
		if (busquedaInspeccion.getAcnror() != null && !"".equals(busquedaInspeccion.getAcnror())) {
			numExp.append(busquedaInspeccion.getAcnror());
		}
		if (busquedaInspeccion.getAcnror() != null && !"".equals(busquedaInspeccion.getAcnror())
				&& busquedaInspeccion.getAcnran() != null && !"".equals(busquedaInspeccion.getAcnran())) {
			numExp.append("-");
		}
		if (busquedaInspeccion.getAcnran() != null && !"".equals(busquedaInspeccion.getAcnran())) {
			numExp.append(busquedaInspeccion.getAcnran());
		}
		row.append(getField(Y41bUtils.normalizarVacio(numExp.toString())));

		// tipoinspeccion
		String tipoinspeccion = "";
		if (busquedaInspeccion.getAttipo() != null
				&& busquedaInspeccion.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS)) {
			tipoinspeccion = appMessageSource.getMessage("excel.inspecciones.tomamuestras", null, locale);
		} else if (busquedaInspeccion.getAttipo() != null
				&& busquedaInspeccion.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR)) {
			tipoinspeccion = appMessageSource.getMessage("excel.inspecciones.controlestandar", null, locale);
		} else if (busquedaInspeccion.getAttipo() != null
				&& busquedaInspeccion.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS)) {
			tipoinspeccion = appMessageSource.getMessage("excel.inspecciones.controlotros", null, locale);
		}

		row.append(getField(Y41bUtils.normalizarVacio(tipoinspeccion)));

		// acfere
		row.append(getField(Y41bUtils.normalizarVacio(busquedaInspeccion.getAcfere())));

		// esnombre
		row.append(getField(Y41bUtils.normalizarVacio(busquedaInspeccion.getEsnombre())));

		// municipio

		row.append(getField(Y41bUtils.normalizarVacio(busquedaInspeccion.getEsmunicipio())));

		// busquedaInspeccionprse
		List<String> prodServ = new ArrayList<String>();

		if (busquedaInspeccion.getAtnoprse() != null) {
			prodServ.add(busquedaInspeccion.getAtnoprse());
		}
		if (busquedaInspeccion.getAtnomaps() != null) {
			prodServ.add(busquedaInspeccion.getAtnomaps());
		}
		if (busquedaInspeccion.getAtnomops() != null) {
			prodServ.add(busquedaInspeccion.getAtnomops());
		}
		if (busquedaInspeccion.getAtnrlops() != null) {
			prodServ.add(busquedaInspeccion.getAtnrlops());
		}

		String prodServJoined = StringUtils.join(prodServ.toArray(new String[prodServ.size()]), " - ");
		row.append(getField(Y41bUtils.normalizarVacio(prodServJoined)));

		// trnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(busquedaInspeccion.getTrnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(busquedaInspeccion.getTrnombree())));
		}

		// fnombre
		// if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
		// row.append(getField(Y41bUtils.normalizarVacio(busquedaInspeccion
		// .getFnombre())));
		// } else {
		// row.append(getField(Y41bUtils.normalizarVacio(busquedaInspeccion
		// .getFnombree())));
		// }
		if (busquedaInspeccion.getAtuinmovilizadas() != null) {
			row.append(getField(Y41bUtils.normalizarVacio(busquedaInspeccion.getAtuinmovilizadas().toString())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		}

		// denombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(busquedaInspeccion.getDenombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(busquedaInspeccion.getDenombree())));
		}

		// monombre
		row.append(getField(Y41bUtils.normalizarVacio(busquedaInspeccion.getMonombre())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param pagosAux
	 *            pagosAux
	 * @return String
	 */
	private String getSancionesRow(FiltroSanciones pagosAux) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getcodCompleto())));

		// fecha inicio
		row.append(getFieldFecha(
				Y41bUtils.normalizarVacio(Y41bUtils.parseDateToString(pagosAux.getExfere(), locale.getLanguage()))));

		// fecha fin
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(pagosAux.getSanexp().getExfecfin(), locale.getLanguage()))));

		// sancionado
		row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getEstablecimiento().getEsnombre())));

		// municipio
		row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getEstablecimiento().getEsnombreMunicipio())));

		// fase
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getFase().getFnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getFase().getFnombree())));
		}

		// tramite
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getSantramexp().getTrnomtramCompletoes())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getSantramexp().getTrnomtramCompletoeu())));
		}

		// tipo resolucion
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getTctipres().getTtrnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getTctipres().getTtrnombreeu())));
		}

		// responsable expediente
		row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getCensoMonitor().getMonombre())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param pagosAux
	 *            pagosAux
	 * @return String
	 */
	private String getArbitrajesRow(FiltroArbitraje pagosAux) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getCodCompleto())));

		// fecha inicio
		row.append(getFieldFecha(
				Y41bUtils.normalizarVacio(Y41bUtils.parseDateToString(pagosAux.getSafesoli(), locale.getLanguage()))));

		// fecha fin
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(pagosAux.getArbexp().getExfecfin(), locale.getLanguage()))));

		// reclamante
		row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getArbintervReclamante().getUanombre())));

		// reclamado
		row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getArbintervReclamado().getUanombre())));

		// fase
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getFase().getFnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getFase().getFnombree())));
		}

		// tramite
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getArbtramexp().getTrnomtramCompletoes())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getArbtramexp().getTrnomtramCompletoeu())));
		}

		// responsable expediente
		row.append(getField(Y41bUtils.normalizarVacio(pagosAux.getCensoMonitor().getMonombre())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return String
	 */
	private String getConsumidoresRow(Consumidor consumidor) {
		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// dtnif
		row.append(getField(Y41bUtils.normalizarVacio(consumidor.getDtnif())));

		// dtnombre
		row.append(getField(Y41bUtils.normalizarVacio(consumidor.getDtnombre())));

		// dtapellido1
		row.append(getField(Y41bUtils.normalizarVacio(consumidor.getDtapellido1())));

		// dtapellido2
		row.append(getField(Y41bUtils.normalizarVacio(consumidor.getDtapellido2())));

		// dtdireccionCompleta
		row.append(getField(Y41bUtils.normalizarVacio(consumidor.getDtdireccionCompleta())));

		// dtnombreMunicipio
		row.append(getField(Y41bUtils.normalizarVacio(consumidor.getDtnombreMunicipio())));

		// dtnrtel
		// row.append(getField(Y41bUtils.normalizarVacio(consumidor.getDtnrtel())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return String
	 */
	private String getEstablecimientosRow(Establecimiento establecimiento) {
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// esfeba
		if (establecimiento.getEsfeba() != null) {
			row.append(getField(Y41bUtils.normalizarVacio(Y41bConstantes.VALOR_SI)));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		}

		// esnif
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsnif())));

		// esnoco
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsnoco())));

		// esnombre
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsnombre())));

		// esnombreMunicipio
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsnombreMunicipio())));

		// esdireccionCompleta
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsdireccionCompleta())));

		// esinadar
		if (establecimiento.getEsinadar() != null && establecimiento.getEsinadar().equals(Y41bConstantes.VALOR_NO)) {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		} else {
			if ("A".equals(establecimiento.getEsinadar())) {
				row.append(getField(appMessageSource.getMessage("excel.adherido", null, locale)));
			} else if ("L".equals(establecimiento.getEsinadar())) {
				row.append(getField(appMessageSource.getMessage("excel.adheridoL", null, locale)));
			} else if ("B".equals(establecimiento.getEsinadar())) {
				row.append(getField(appMessageSource.getMessage("excel.adheridoB", null, locale)));
			} else {
				row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsinadar())));
			}
		}

		// essede
		if (establecimiento.getEssede() != null && establecimiento.getEssede().equals(Y41bConstantes.VALOR_SI)) {
			row.append(getField(Y41bUtils.normalizarVacio(Y41bConstantes.VALOR_SI)));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		}

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return String
	 */
	private String getEstablecimientosRowExtendido(EstablecimientoDetalle establecimiento) {
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// esfeba
		if (establecimiento.getEsfeba() != null) {
			row.append(getField(Y41bUtils.normalizarVacio(Y41bConstantes.VALOR_SI)));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		}

		// esnif
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsnif())));

		// esnoco
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsnoco())));

		// esnombre
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsnombre())));

		// esnombreMunicipio
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsnombreMunicipio())));

		// esdireccionCompleta
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsdireccionCompleta())));

		// esinadar
		if (establecimiento.getEsinadar() != null && establecimiento.getEsinadar().equals(Y41bConstantes.VALOR_NO)) {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		} else {
			if ("A".equals(establecimiento.getEsinadar())) {
				row.append(getField(appMessageSource.getMessage("excel.adherido", null, locale)));
			} else if ("L".equals(establecimiento.getEsinadar())) {
				row.append(getField(appMessageSource.getMessage("excel.adheridoL", null, locale)));
			} else if ("B".equals(establecimiento.getEsinadar())) {
				row.append(getField(appMessageSource.getMessage("excel.adheridoB", null, locale)));
			} else {
				row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsinadar())));
			}
		}

		// essede
		if (establecimiento.getEssede() != null && establecimiento.getEssede().equals(Y41bConstantes.VALOR_SI)) {
			row.append(getField(Y41bUtils.normalizarVacio(Y41bConstantes.VALOR_SI)));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		}

		// esfeadar
		row.append(getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(establecimiento.getEsfeadar(), locale.getLanguage()))));

		// numero adhesion
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getAhnrdi())));

		// tipo arbitraje
		if (Y41bConstantes.ARBITRAJE_SAINTISO_DERECHO.equalsIgnoreCase(establecimiento.getEsintiar())) {
			row.append(getField(Y41bUtils
					.normalizarVacio(appMessageSource.getMessage("plantilla.arbitraje.derecho", null, locale))));
		} else if (Y41bConstantes.ARBITRAJE_SAINTISO_EQUIDAD.equalsIgnoreCase(establecimiento.getEsintiar())) {
			row.append(getField(Y41bUtils
					.normalizarVacio(appMessageSource.getMessage("plantilla.arbitraje.equidad", null, locale))));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		}

		// mediacion
		if (establecimiento.getAhmedia() != null && establecimiento.getAhmedia().equals(Y41bConstantes.VALOR_SI)) {
			row.append(getField(Y41bUtils.normalizarVacio(Y41bConstantes.VALOR_SI)));
		} else if (establecimiento.getAhmedia() != null
				&& establecimiento.getAhmedia().equals(Y41bConstantes.VALOR_NO)) {
			row.append(getField(Y41bUtils.normalizarVacio(Y41bConstantes.VALOR_NO)));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		}

		// adhesion indefinida
		if (establecimiento.getAhindef() != null && establecimiento.getAhindef().equals(Y41bConstantes.VALOR_SI)
				|| (establecimiento.getEsinadar() != null
						&& !establecimiento.getEsinadar().equals(Y41bConstantes.VALOR_NO)
						&& establecimiento.getAhfeba() == null)) {
			row.append(getField(Y41bUtils.normalizarVacio(Y41bConstantes.VALOR_SI)));
		} else if ((establecimiento.getAhindef() != null
				&& establecimiento.getAhindef().equals(Y41bConstantes.VALOR_NO))
				|| (establecimiento.getEsinadar() != null
						&& !establecimiento.getEsinadar().equals(Y41bConstantes.VALOR_NO))) {
			row.append(getField(Y41bUtils.normalizarVacio(Y41bConstantes.VALOR_NO)));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		}

		// fecha fin adhesion
		row.append(getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(establecimiento.getAhfere(), locale.getLanguage()))));

		// fecha baja efectiva
		row.append(getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(establecimiento.getAhfeba(), locale.getLanguage()))));

		// fecha peticion actualizacion
		row.append(getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(establecimiento.getEsfeerd(), locale.getLanguage()))));

		// codigo postal
		row.append(getFieldTexto(Y41bUtils.normalizarVacio(establecimiento.getEsnombreCp())));

		// esnombreProvincia
		row.append(getField(Y41bUtils.normalizarVacio(establecimiento.getEsnombreProvincia())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getField(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>");
		field.append(Y41bUtils.normalizarVacio(fieldValue));
		field.append("</td>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getFieldTexto(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>=ESPACIOS(\"");
		field.append(Y41bUtils.normalizarVacio(fieldValue));
		field.append("\")</td>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getFieldMoneda(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td>=MONEDA(");
		field.append(Y41bUtils.normalizarVacio(fieldValue));
		field.append(";2)</td>");
		return field.toString();
	}

	/**
	 * Generar.
	 * 
	 * @param fieldValue
	 *            String
	 * @return String
	 */
	private static String getFieldFecha(final String fieldValue) {
		StringBuffer field = new StringBuffer();
		field.append("<td align='center' width='75'>");
		field.append("=T(\"");
		field.append(Y41bUtils.normalizarVacio(fieldValue));
		field.append("\")");
		field.append("</td>");
		return field.toString();
	}

	/* ---------------------------------------------------- */
	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en consultas
	 * 
	 * @param consulta
	 *            Consulta
	 * @return String
	 */
	public String getConsultasExcelBandeja(Consulta consulta) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getConsultasListTableBandeja(consulta));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return String
	 */
	private String getConsultasListTableBandeja(Consulta consulta) {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getConsultasHeaderRowBandeja());

		Date cofechaDesde = null;
		Date cofechaHasta = null;
		try {
			cofechaDesde = Y41bUtils.parseDate(consulta.getCofechadesde(), locale);
			cofechaHasta = Y41bUtils.parseDate(consulta.getCofechahasta(), locale);
		} catch (Exception e) {
		}

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("cofecha");
		List<ConsultaBusqueda> consultasBusqueda = this.consultaService.findAllLikeConsulta(consulta, pagination, false,
				cofechaDesde, cofechaHasta);

		for (ConsultaBusqueda consultaBusquedaAux : consultasBusqueda) {
			xslString.append(getConsultasRowBandeja(consultaBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getConsultasHeaderRowBandeja() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");
		header.append(getHeaderField(appMessageSource.getMessage("excel.numeroConsulta", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.cofecha", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.monombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nombreMunicipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.prodserv", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.coinl37", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.documentos", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param consultaBusqueda
	 *            ConsultaBusqueda
	 * @return String
	 */
	private String getConsultasRowBandeja(ConsultaBusqueda consultaBusqueda) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numeroConsulta
		row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda.getNumeroConsulta())));

		// cofecha
		row.append(getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(consultaBusqueda.getCofecha(), locale.getLanguage()))));

		// monombre
		row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda.getMonombre())));

		// nombreMunicipio
		row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda.getNombreMunicipio())));

		// prod/serv
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda.getPsnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(consultaBusqueda.getPsnombree())));
		}

		// coinl37
		if (consultaBusqueda.getCoinl37() != null && consultaBusqueda.getCoinl37().equals(Y41bConstantes.VALOR_SI)) {
			row.append(getField(appMessageSource.getMessage("excel.web", null, locale)));
		} else {
			row.append(getField(appMessageSource.getMessage("excel.oficina", null, locale)));
		}

		// documentos
		if (consultaBusqueda.getDocumentos() != null
				&& consultaBusqueda.getDocumentos().equals(Y41bConstantes.VALOR_SI)) {
			row.append(getField(Y41bConstantes.VALOR_SI));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio("")));
		}

		row.append("</tr>");
		return row.toString();
	}

	/*--- solicitudes bandeja */

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 */
	public String getSolicitudesExcelBandeja(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getSolicitudesListTableBandeja(bandejaSolicitudes, censoMonitor));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 */
	private String getSolicitudesListTableBandeja(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getSolicitudesHeaderRowBandeja());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("EHFECHA");
		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
				.findAllBandejaSolicitudes(bandejaSolicitudes, censoMonitor, pagination);

		for (BandejaSolicitudesBusqueda bandejaSolicitudesBusquedaAux : listBandejaSolicitudesBusqueda) {
			xslString.append(getSolicitudesRowBandeja(bandejaSolicitudesBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSolicitudesHeaderRowBandeja() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tfpnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tiposol", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.trnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.orgNombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.oridest", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nbdoc", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fecha", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.estado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechalimite", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param bandejaSolicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	private String getSolicitudesRowBandeja(BandejaSolicitudesBusqueda bandejaSolicitudesBusqueda) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getNumExpediente())));

		// tfpnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTfpnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTfpnombree())));
		}

		// tipoSolicitud
		String tipoSolicitudNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getHdcosc());
		String tipoSolicitudTexto = "";

		if ("D".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.denuncia", null, locale);
		} else if ("Q".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.queja", null, locale);
		} else if ("R".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.reclamacion", null, locale);
		}

		row.append(getField(tipoSolicitudTexto));

		// fnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombree())));
		}

		// trnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombree())));
		}

		// monombreTramitador
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getMonombre())));

		// origen
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getQ5origen())));

		// indvariosdocs
		String nbfichero = "";

		if ("S".equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = appMessageSource.getMessage("excel.documentos", null, locale);

		} else if ("N"
				.equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getQ5tedesfile());

		}

		row.append(getField(nbfichero));

		// fechatram
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechatramite(), locale.getLanguage()))));

		// estado

		String estadoNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getEstadotramite());
		String estadoNB = "";

		if ("P".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientefirma", null, locale);
		} else if ("F".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmado", null, locale);
		} else if ("I".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientelocalizacion", null, locale);
		} else if ("L".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.localizado", null, locale);
		} else if ("R".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.errorlocalizacion", null, locale);
		} else if ("D".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmadenegada", null, locale);
		} else if ("E".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = "";
		} else if ("T".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.tramitado", null, locale);
		}

		row.append(getField(estadoNB));

		// fechalimite
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechalimite(), locale.getLanguage()))));

		row.append("</tr>");
		return row.toString();
	}

	/*--- firmas bandeja */
	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 * @throws Exception
	 */
	public String getFirmasExcelBandeja(BandejaFirma bandejaFirma, CensoMonitor censoMonitor) throws Exception {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getFirmasListTableBandeja(bandejaFirma, censoMonitor));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 * @throws Exception
	 */
	private String getFirmasListTableBandeja(BandejaFirma bandejaFirma, CensoMonitor censoMonitor) throws Exception {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getFirmasHeaderRowBandeja());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("FECHALIMFIRMA");
		List<BandejaFirmaBusqueda> listBandejaFirmaBusqueda = this.bandejaFirmaService.findAllBandejaFirma(bandejaFirma,
				censoMonitor, pagination);

		for (BandejaFirmaBusqueda bandejaFirmaBusquedaAux : listBandejaFirmaBusqueda) {
			xslString.append(getFirmasRowBandeja(bandejaFirmaBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getFirmasHeaderRowBandeja() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.tipoexpediente", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.codexpediente", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.responsable", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.destinatario", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fase", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tramite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nbdoc", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechalimite", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param bandejaFirmaBusqueda
	 *            BandejaFirmaBusqueda
	 * @return String
	 */
	private String getFirmasRowBandeja(BandejaFirmaBusqueda bandejaFirmaBusqueda) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// pnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaFirmaBusqueda.getPnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaFirmaBusqueda.getPnombree())));
		}

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(bandejaFirmaBusqueda.getExpediente())));

		// responsable
		row.append(getField(Y41bUtils.normalizarVacio(bandejaFirmaBusqueda.getMonombre())));

		// destinatario
		row.append(getField(Y41bUtils.normalizarVacio(bandejaFirmaBusqueda.getDestinatario())));

		// fnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaFirmaBusqueda.getFnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaFirmaBusqueda.getFnombree())));
		}

		// trnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaFirmaBusqueda.getTrnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaFirmaBusqueda.getTrnombree())));
		}

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(bandejaFirmaBusqueda.getDesfile())));

		// Fechalimfirma
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaFirmaBusqueda.getFechalimfirma(), locale.getLanguage()))));

		row.append("</tr>");
		return row.toString();
	}

	/*--- sanprop bandeja */

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param filterSanpropbandeja
	 *            Sanpropbandeja
	 * @return String
	 */
	public String getSanPropExcelBandeja(Sanpropbandeja filterSanpropbandeja) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getSanPropListTableBandeja(filterSanpropbandeja));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param filterArbpropbandeja
	 *            Arbpropbandeja
	 * @return String
	 */
	public String getArbPropExcelBandeja(Arbpropbandeja filterArbpropbandeja) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getArbPropListTableBandeja(filterArbpropbandeja));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filterSanpropbandeja
	 *            Sanpropbandeja
	 * @return String
	 */
	private String getSanPropListTableBandeja(Sanpropbandeja filterSanpropbandeja) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getSanpropHeaderRowBandeja());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("BAPRSANFEC");
		List<Sanpropbandeja> listSanpropbandejas = this.sanpropbandejaService.findAll(filterSanpropbandeja, pagination);

		for (Sanpropbandeja sanpropbandejaAux : listSanpropbandejas) {
			xslString.append(getSanpropRowBandeja(sanpropbandejaAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filterSanpropbandeja
	 *            Sanpropbandeja
	 * @return String
	 */
	private String getArbPropListTableBandeja(Arbpropbandeja filterArbpropbandeja) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getArbpropHeaderRowBandeja());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("BAPRARBFEC");
		List<Arbpropbandeja> listArbpropbandejas = this.arbpropbandejaService.findAll(filterArbpropbandeja, pagination);

		for (Arbpropbandeja arbpropbandejaAux : listArbpropbandejas) {
			xslString.append(getArbpropRowBandeja(arbpropbandejaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSanpropHeaderRowBandeja() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.codexpediente", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.procedimiento", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechahecho", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.sancionado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.provincia", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.municipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.responsable", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getArbpropHeaderRowBandeja() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.codexpediente", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.procedimiento", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechahecho", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.establecimiento", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.provincia", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.municipio", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.responsable", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.observaciones", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param sanpropbandeja
	 *            Sanpropbandeja
	 * @return String
	 */
	private String getSanpropRowBandeja(Sanpropbandeja sanpropbandeja) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// getBaprsanexcodigocompleto
		row.append(getField(Y41bUtils.normalizarVacio(sanpropbandeja.getBaprsanexcodigocompleto())));

		// pnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(sanpropbandeja.getTipoProcedimiento().getPnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(sanpropbandeja.getTipoProcedimiento().getPnombree())));
		}

		// Baprsanfec
		row.append(getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(sanpropbandeja.getBaprsanfec(), locale.getLanguage()))));

		// esnoco
		row.append(getField(Y41bUtils.normalizarVacio(sanpropbandeja.getEstablecimiento().getEsnoco())));

		// baprsanprov
		row.append(getField(Y41bUtils.normalizarVacio(sanpropbandeja.getBaprsanprov())));

		// baprsanprov
		row.append(getField(Y41bUtils.normalizarVacio(sanpropbandeja.getBaprsanmunic())));

		// monombre
		row.append(getField(Y41bUtils.normalizarVacio(sanpropbandeja.getCensoMonitor().getMonombre())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param arbpropbandeja
	 *            Arbpropbandeja
	 * @return String
	 */
	private String getArbpropRowBandeja(Arbpropbandeja arbpropbandeja) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// getBaprarbexcodigocompleto
		row.append(getField(Y41bUtils.normalizarVacio(arbpropbandeja.getBaprarbexcodigocompleto())));

		// pnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(arbpropbandeja.getTipoProcedimiento().getPnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(arbpropbandeja.getTipoProcedimiento().getPnombree())));
		}

		// Baprarbfec
		row.append(getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(arbpropbandeja.getBaprarbfec(), locale.getLanguage()))));

		// esnoco
		row.append(getField(Y41bUtils.normalizarVacio(arbpropbandeja.getEstablecimiento().getEsnoco())));

		// baprarbprov
		row.append(getField(Y41bUtils.normalizarVacio(arbpropbandeja.getBaprarbprov())));

		// baprarbprov
		row.append(getField(Y41bUtils.normalizarVacio(arbpropbandeja.getBaprarbmunic())));

		// monombre
		row.append(getField(Y41bUtils.normalizarVacio(arbpropbandeja.getCensoMonitor().getMonombre())));

		// tieneObserv
		row.append(getField(Y41bUtils.normalizarVacio(arbpropbandeja.getTieneObserv())));

		row.append("</tr>");
		return row.toString();
	}

	/* ---------------------------------------------------- */
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.Y41bExcelGeneratorService#getPagosExcel(com.ejie
	 * .y41b.model.PagosBusqueda)
	 */
	@Override
	public String getPagosExcel(PagosBusqueda filtroPagos) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getPagosListTable(filtroPagos));

		xslString.append("</table>");

		return xslString.toString();
	}

	@Override
	public String getOtrosIngresosExcel(PagosBusqueda filtroPagos) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getOtrosIngresosListTable(filtroPagos));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filtroPagos
	 *            PagosBusqueda
	 * @return String
	 */
	private String getPagosListTable(PagosBusqueda filtroPagos) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getPagosHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("EXCOOR asc, CORRELATIVOPAD asc, EXNRAN ");
		List<Pagos> pagos = this.pagosService.findAllPagos(filtroPagos, pagination);
		for (Pagos pagosAux : pagos) {
			xslString.append(this.getPagosRow(pagosAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filtroPagos
	 *            PagosBusqueda
	 * @return String
	 */
	private String getOtrosIngresosListTable(PagosBusqueda filtroPagos) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getOtrosIngresosHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		// pagination.setAscDsc("asc");
		// pagination.setSort("EXCOOR asc ");
		List<Pagos> pagos = this.pagosService.findAllOtrosPagos(filtroPagos, pagination);
		for (Pagos pagosAux : pagos) {
			xslString.append(this.getOtrosIngresosRow(pagosAux));
		}

		return xslString.toString();
	}

	/**
	 * @param pagosAux
	 *            Pagos
	 * @return String
	 */
	private String getPagosRow(Pagos pagosAux) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(Y41bExcelGeneratorServiceImpl.getField(pagosAux.getSgexpediente()));

		// referencia
		String referencia = pagosAux.getSgreferencia();
		row.append(Y41bExcelGeneratorServiceImpl.getFieldTexto(Y41bUtils.normalizarVacio(referencia)));

		// referencia origen
		String referenciafracc = pagosAux.getSgreferenciafracc();
		row.append(Y41bExcelGeneratorServiceImpl.getFieldTexto(Y41bUtils.normalizarVacio(referenciafracc)));

		// establecimiento
		row.append(Y41bExcelGeneratorServiceImpl.getField(pagosAux.getSgestablecimiento().getEsnombre()));

		// concepto
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(pagosAux.getConceptopago().getSddesces()));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(pagosAux.getConceptopago().getSddesdeu())));
		}

		// fecha emision
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(pagosAux.getSgfechaemision(), locale.getLanguage()))));

		// Importe euros
		row.append(Y41bExcelGeneratorServiceImpl.getFieldMoneda(
				Y41bUtils.normalizarVacio(pagosAux.getSgimporte().toString().replace('\u002e', '\u002c').trim())));

		// estado
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(pagosAux.getEstadopago().getSadesces())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(pagosAux.getEstadopago().getSadesces())));
		}
		// Via apremio
		if (Y41bConstantes.VALOR_SI.equals(pagosAux.getSgviaapremio())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(pagosAux.getSgviaapremio()));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(pagosAux.getSgviaapremio())));
		}
		// Via apremio
		if (Y41bConstantes.VALOR_SI.equals(pagosAux.getSgprontopago())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(pagosAux.getSgprontopago()));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(pagosAux.getSgprontopago())));
		}
		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getPagosHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.liquidacion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.liquidacionOrigen", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.razonsocial", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.concepto", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaEmision", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.importe", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.estado", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.viaapremio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.prontopago", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getOtrosIngresosHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.ejercicio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.titular", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.cifnif", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.liquidacion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.estado", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * @param pagosAux
	 *            Pagos
	 * @return String
	 */
	private String getOtrosIngresosRow(Pagos pagosAux) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// ejercicio
		row.append(Y41bExcelGeneratorServiceImpl.getField(pagosAux.getConceptopago().getSdejercicio().toString()));

		// numExpediente
		row.append(Y41bExcelGeneratorServiceImpl.getField(pagosAux.getSgexpediente()));

		// establecimiento
		row.append(Y41bExcelGeneratorServiceImpl.getField(pagosAux.getSgestablecimiento().getEsnombre()));

		// cif/dni
		row.append(Y41bExcelGeneratorServiceImpl.getField(pagosAux.getSgestablecimiento().getEsnif()));

		// liquidacion
		String liquidacion = pagosAux.getSgreferencia();
		row.append(Y41bExcelGeneratorServiceImpl.getFieldTexto(Y41bUtils.normalizarVacio(liquidacion)));

		// estado
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(pagosAux.getEstadopago().getSadesces())));
		}
		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getViaApremioHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.razonsocial", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nifcif", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.importePendiente", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaEnvioReso", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaNotiReso", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaPresentacionRA", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.resolucionRA", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaNotiRA", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.sinLiqFirme", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * com.ejie.y41b.service.Y41bExcelGeneratorService#getViaApremioExcel(com
	 * .ejie.y41b.model.FiltroSanciones)
	 */
	@Override
	public String getViaApremioExcel(FiltroSanciones filtroSanciones) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getViaApremioListTable(filtroSanciones));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return Object
	 */
	private Object getViaApremioListTable(FiltroSanciones filtroSanciones) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getViaApremioHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setSort("EXCOOR ASC,  CORRELATIVOPAD ASC, EXNRAN  ");
		pagination.setAscDsc("ASC");

		List<FiltroSanciones> sancionesBusqueda = this.expedienService.findAllSancionesViaApremio(filtroSanciones,
				pagination);

		for (FiltroSanciones sancionesBusquedaAux : sancionesBusqueda) {
			xslString.append(this.getViaApremioRow(sancionesBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param pagosAux
	 *            pagosAux
	 * @return String
	 */
	private String getViaApremioRow(FiltroSanciones pagosAux) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(pagosAux.getcodCompleto())));

		// sancionado
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(pagosAux.getEstablecimiento().getEsnombre())));

		// nifcif
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(pagosAux.getEstablecimiento().getEsnif())));

		// importe pendiente, viene formateado 9.999,99 y es necesario
		// eliminarel punto de miles
		row.append(Y41bExcelGeneratorServiceImpl.getFieldMoneda(Y41bUtils
				.normalizarVacio(pagosAux.getImportePendiente().replace("\u20AC", "").trim().replaceAll("\\.", ""))));
		// fecha envio reso
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(pagosAux.getFechaEnvioReso(), locale.getLanguage()))));
		// fecha noti reso
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(pagosAux.getFechaNotiReso(), locale.getLanguage()))));

		// fecha presentacion RA
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(pagosAux.getFechaPresentacionRA(), locale.getLanguage()))));

		// resolucion RA
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl
					.getFieldFecha(Y41bUtils.normalizarVacio(pagosAux.getResolucionRAes())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl
					.getFieldFecha(Y41bUtils.normalizarVacio(pagosAux.getResolucionRAeu())));
		}

		// fecha noti RA
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(pagosAux.getFechaNotiRA(), locale.getLanguage()))));

		// sin liquidacion firme
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio((pagosAux.getSinLiquidacionesFirmes() ? "V" : ""))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * @param filterSanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	public String getSanbandejaExcel(Sanbandeja filterSanbandeja, CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getSanbandejaListTable(filterSanbandeja, censoMonitor, perfil));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	public String getBandejaCampanhasExcel(CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getBandejaCampanhasListTable(censoMonitor, perfil));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	public String getBandejaCampanhasSSCCExcel(CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getBandejaCampanhasSSCCListTable(censoMonitor, perfil));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	public String getBandejaAlertasExcel(CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getBandejaAlertasListTable(censoMonitor, perfil));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	public String getBandejaComunicacionesSoivreExcel(CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getBandejaComunicacionesSoivreListTable(censoMonitor, perfil));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return String
	 */
	public String getBandejaPropuestasInspeccionesExcel(InspeccionesPropBandeja inspeccionesPropBandeja) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getBandejaPropuestasInspeccionesListTable(inspeccionesPropBandeja));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param bandejaInspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @return String
	 */
	public String getBandejaInspeccionesExcel(BandejaInspecciones bandejaInspecciones, CensoMonitor censoMonitor,
			BandejaInspeccionesFiltro bandejaInspeccionesFiltro) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(
				this.getBandejaInspeccionesListTable(bandejaInspecciones, censoMonitor, bandejaInspeccionesFiltro));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * @param filterArbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	public String getArbbandejaExcel(Arbbandeja filterArbbandeja, CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getArbbandejaListTable(filterArbbandeja, censoMonitor, perfil));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * 
	 * @param filterSanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	private String getSanbandejaListTable(Sanbandeja filterSanbandeja, CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getSanbandejaHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("BAFECALTA");
		List<Sanbandeja> sanbandejas = this.sanbandejaService.dameBandeja(filterSanbandeja, pagination, censoMonitor,
				perfil);

		for (Sanbandeja sanbandejaAux : sanbandejas) {
			xslString.append(this.getSanbandejaRow(sanbandejaAux));
		}

		return xslString.toString();
	}

	/**
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	private String getBandejaCampanhasListTable(CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getBandejaCampanhasHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		// pagination.setAscDsc("asc");
		// pagination.setSort("tzfehast");

		BandejaCampanha bandejaCampanha = new BandejaCampanha();

		String coor = "";
		if (censoMonitor.getOrganismo() != null) {
			coor = censoMonitor.getOrganismo().getCodOrg();
		}
		bandejaCampanha.setTzcoor(coor);

		List<BandejaCampanha> bandejaCampanhas = this.bandejaCampanhasService.findAll(bandejaCampanha, censoMonitor,
				pagination);

		for (BandejaCampanha bandejaCampanhaAux : bandejaCampanhas) {
			xslString.append(this.getBandejaCampanhasRow(bandejaCampanhaAux));
		}

		return xslString.toString();
	}

	/**
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	private String getBandejaCampanhasSSCCListTable(CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getBandejaCampanhasHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		// pagination.setAscDsc("asc");
		// pagination.setSort("tzfehast");

		BandejaCampanha bandejaCampanha = new BandejaCampanha();

		String coor = "";
		if (censoMonitor.getOrganismo() != null) {
			coor = censoMonitor.getOrganismo().getCodOrg();
		}
		bandejaCampanha.setTzcoor(coor);

		List<BandejaCampanha> bandejaCampanhas = this.bandejaCampanhasService.findAllSSCC(bandejaCampanha, censoMonitor,
				pagination);

		for (BandejaCampanha bandejaCampanhaAux : bandejaCampanhas) {
			xslString.append(this.getBandejaCampanhasRow(bandejaCampanhaAux));
		}

		return xslString.toString();
	}

	/**
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	private String getBandejaAlertasListTable(CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getBandejaAlertasHeaderRow(censoMonitor));

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("crfechacomunicacion");

		BandejaAlerta bandejaAlerta = new BandejaAlerta();

		String coor = "";
		if (censoMonitor.getOrganismo() != null) {
			coor = censoMonitor.getOrganismo().getCodOrg();
		}
		bandejaAlerta.setCrcoor(coor);

		List<BandejaAlerta> bandejaAlertas = this.bandejaAlertasService.findAll(bandejaAlerta, censoMonitor,
				pagination);

		for (BandejaAlerta bandejaAlertaAux : bandejaAlertas) {
			xslString.append(this.getBandejaAlertasRow(bandejaAlertaAux, censoMonitor));
		}

		return xslString.toString();
	}

	/**
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	private String getBandejaComunicacionesSoivreListTable(CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getBandejaComunicacionesSoivreHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		// pagination.setAscDsc("asc");
		// pagination.setSort("IDCOMUNICACIONSOIVRE");

		ComunicacionSoivre bandejaComunicacionSoivre = new ComunicacionSoivre();
		List<ComunicacionSoivre> bandejaComunicacionesSoivre = this.comunicacionSoivreService
				.findAllBandejaComunicacionSoivre(bandejaComunicacionSoivre, censoMonitor, pagination);

		for (ComunicacionSoivre bandejaComunicacionSoivreAux : bandejaComunicacionesSoivre) {
			xslString.append(this.getBandejaComunicacionesSoivreRow(bandejaComunicacionSoivreAux));
		}

		return xslString.toString();
	}

	/**
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 */
	private String getBandejaPropuestasInspeccionesListTable(InspeccionesPropBandeja inspeccionesPropBandeja) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getBandejaPropuestasInspeccionesHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("desc");
		pagination.setSort("BAPRINSFEC");

		List<InspeccionesPropBandeja> listPropInspecciones = this.inspeccionesPropBandejaService
				.findAll(inspeccionesPropBandeja, pagination);

		for (InspeccionesPropBandeja propInspeccionesAux : listPropInspecciones) {
			xslString.append(this.getBandejaPropuestasInspeccionesRow(propInspeccionesAux));
		}

		return xslString.toString();
	}

	/**
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param bandejaInspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @return String
	 */
	private String getBandejaInspeccionesListTable(BandejaInspecciones bandejaInspecciones, CensoMonitor censoMonitor,
			BandejaInspeccionesFiltro bandejaInspeccionesFiltro) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getBandejaInspeccionesHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("fechatramite");

		List<BandejaInspecciones> listInspecciones = this.bandejaInspeccionesService.findAll(bandejaInspecciones,
				pagination, censoMonitor, bandejaInspeccionesFiltro);

		for (BandejaInspecciones inspeccionesAux : listInspecciones) {
			xslString.append(this.getBandejaInspeccionesRow(inspeccionesAux));
		}

		return xslString.toString();
	}

	/**
	 * 
	 * @param filterArbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	private String getArbbandejaListTable(Arbbandeja filterArbbandeja, CensoMonitor censoMonitor, String perfil) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getArbbandejaHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("desc");
		pagination.setSort("ABFEC");
		List<Arbbandeja> arbbandejas = this.arbbandejaService.dameBandeja(filterArbbandeja, pagination, censoMonitor,
				perfil);

		for (Arbbandeja arbbandejaAux : arbbandejas) {
			xslString.append(this.getArbbandejaRow(arbbandejaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param sanbandejaAux
	 *            Sanbandeja
	 * @return String
	 */
	private String getSanbandejaRow(Sanbandeja sanbandejaAux) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(sanbandejaAux.getExpedien().getcodCompleto())));

		// fase
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(sanbandejaAux.getFase().getFnombre())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(sanbandejaAux.getFase().getFnombree())));
		}

		// tramite
		String estado = "";
		if (Y41bConstantes.TRAMITE_SANCIONES_PROPUESTARESOLUCION.equals(sanbandejaAux.getSantramexp().getTrcodigo())
				|| Y41bConstantes.TRAMITE_SANCIONES_RESOLUCION.equals(sanbandejaAux.getSantramexp().getTrcodigo())
				|| Y41bConstantes.TRAMITE_SANCIONES_RECEPCIONORDENCONSEJERO
						.equals(sanbandejaAux.getSantramexp().getTrcodigo())) {
			if (sanbandejaAux.getSantramexp().getTrresotipo() != null) {
				if ("SA1".equals(sanbandejaAux.getSantramexp().getTrresotipo())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.decision.sa1", null, locale))
							.concat(")");
				} else if ("SA2".equals(sanbandejaAux.getSantramexp().getTrresotipo())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.decision.sa2", null, locale))
							.concat(")");
				} else if ("SA3".equals(sanbandejaAux.getSantramexp().getTrresotipo())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.decision.sa3", null, locale))
							.concat(")");
				} else if ("SA4".equals(sanbandejaAux.getSantramexp().getTrresotipo())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.decision.sa4", null, locale))
							.concat(")");
				}
			}
		} else if (Y41bConstantes.TRAMITE_SANCIONES_ACUSERECIBO.equals(sanbandejaAux.getSantramexp().getTrcodigo())) {
			if (sanbandejaAux.getSantramexp().getTrestadoacuse() != null) {
				if ("A".equals(sanbandejaAux.getSantramexp().getTrestadoacuse())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.estadoAcuse.aceptado", null, locale))
							.concat(")");
				} else if ("R".equals(sanbandejaAux.getSantramexp().getTrestadoacuse())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.estadoAcuse.rechazado", null, locale))
							.concat(")");
				} else if ("N".equals(sanbandejaAux.getSantramexp().getTrestadoacuse())) {
					estado = " ("
							.concat(this.appMessageSource.getMessage("excel.estadoAcuse.noentregado", null, locale))
							.concat(")");
				}
			}
		} else {

			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (sanbandejaAux.getSantramexp().getEnvcdessitcorreoses() != null) {
					estado = " (".concat(sanbandejaAux.getSantramexp().getEnvcdessitcorreoses()).concat(")");
				}
			} else {
				if (sanbandejaAux.getSantramexp().getEnvcdessitcorreoseu() != null) {
					estado = " (".concat(sanbandejaAux.getSantramexp().getEnvcdessitcorreoseu()).concat(")");
				}
			}
		}
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(
					sanbandejaAux.getSantramexp().getTrnomtramCompletoes().concat(" ").concat(estado))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(
					sanbandejaAux.getSantramexp().getTrnomtramCompletoeu().concat(" ").concat(estado))));
		}

		// Tramites pendientes
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(sanbandejaAux.getTramitesPendientes())));
		// Avisos
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(sanbandejaAux.getAvisos())));
		// responsable expediente
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(sanbandejaAux.getMonitor().getMonombre())));
		// establecimiento
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(sanbandejaAux.getSaninterv().getUanombre())));
		// documento
		if (Y41bConstantes.VALOR_SI.equals(sanbandejaAux.getSantramexp().getIndVariosDocumentos())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(
					Y41bUtils.normalizarVacio(appMessageSource.getMessage("excel.documentos", null, locale))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(sanbandejaAux.getSantramexp().getU5tedesfile())));
		}
		// Fecha fin
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(sanbandejaAux.getSantramexp().getTrfecfin(), locale.getLanguage()))));

		// estado
		String cadena = "";
		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(sanbandejaAux.getBaestado())) {
			cadena = "excel.estado.tramitado";
		} else if (Y41bConstantes.ESTADO_TRAMITE_FIRMADO.equals(sanbandejaAux.getBaestado())) {
			cadena = "excel.estado.firmado";
		} else if (Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA.equals(sanbandejaAux.getBaestado())) {
			cadena = "excel.estado.pendientefirma";
		} else if (Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION.equals(sanbandejaAux.getBaestado())) {
			cadena = "excel.estado.pendientelocalizacion";
		} else if (Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO.equals(sanbandejaAux.getBaestado())) {
			cadena = "excel.estado.localizado";
		} else if (Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA.equals(sanbandejaAux.getBaestado())) {
			cadena = "excel.estado.firmadenegada";
		} else if (Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION.equals(sanbandejaAux.getBaestado())) {
			cadena = "excel.estado.errorlocalizacion";
		} else {
			cadena = "";
		}
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(appMessageSource.getMessage(cadena, null, locale))));
		// Estado firma
		if (Y41bConstantes.VALOR_SI.equals(sanbandejaAux.getEstadoFirma())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(
					Y41bUtils.normalizarVacio(appMessageSource.getMessage("excel.pendientefirma", null, locale))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio("")));
		}
		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param bandejaCampanhaAux
	 *            BandejaCampanha
	 * @return String
	 */
	private String getBandejaCampanhasRow(BandejaCampanha bandejaCampanhaAux) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// campanha.cmcodigo
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(bandejaCampanhaAux.getCampanha().getCmcodigo())));

		// campanha.cmnombre
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(bandejaCampanhaAux.getCampanha().getCmnombre())));

		// tzfedesd
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(bandejaCampanhaAux.getTzfedesd(), locale.getLanguage()))));

		// tzfehast
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(bandejaCampanhaAux.getTzfehast(), locale.getLanguage()))));

		// tznumTomasMuestrasSol
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaCampanhaAux.getTznumTomasMuestrasSol()))));

		// tznumTomasMuestrasRealizadas
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(String.valueOf(bandejaCampanhaAux.getTznumTomasMuestrasRealizadas()))));

		// tznumControlesEstandarSol
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(String.valueOf(bandejaCampanhaAux.getTznumControlesEstandarSol()))));

		// tznumControlesEstandarRealizados
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(String.valueOf(bandejaCampanhaAux.getTznumControlesEstandarRealizados()))));

		// tznumControlesOtrosSol
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaCampanhaAux.getTznumControlesOtrosSol()))));

		// tznumControlesOtrosRealizados
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(String.valueOf(bandejaCampanhaAux.getTznumControlesOtrosRealizados()))));

		// tznumInspecAdicionalesSol
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(String.valueOf(bandejaCampanhaAux.getTznumInspecAdicionalesSol()))));

		// tznumInspecAdicionalesRealizadas
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(String.valueOf(bandejaCampanhaAux.getTznumInspecAdicionalesRealizadas()))));

		// tztotalInspeccionesSol
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaCampanhaAux.getTztotalInspeccionesSol()))));

		// tztotalInspeccionesRealizadas
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(String.valueOf(bandejaCampanhaAux.getTztotalInspeccionesRealizadas()))));

		// tznumInspeccionesAsociadas
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(String.valueOf(bandejaCampanhaAux.getTznumInspeccionesAsociadas()))));
		// tzfase
		String cadena = "";
		if (Y41bConstantes.FASE_CAMPANHA_INACTIVA.equals(bandejaCampanhaAux.getTzfase())) {
			cadena = "excel.fase.inactiva";
		} else if (Y41bConstantes.FASE_CAMPANHA_BORRADOR.equals(bandejaCampanhaAux.getTzfase())) {
			cadena = "excel.fase.borrador";
		} else if (Y41bConstantes.FASE_CAMPANHA_VALIDACION.equals(bandejaCampanhaAux.getTzfase())) {
			cadena = "excel.fase.validacion";
		} else if (Y41bConstantes.FASE_CAMPANHA_EJECUCION.equals(bandejaCampanhaAux.getTzfase())) {
			cadena = "excel.fase.ejecucion";
		} else if (Y41bConstantes.FASE_CAMPANHA_ANALISIS.equals(bandejaCampanhaAux.getTzfase())) {
			cadena = "excel.fase.analisis";
		} else if (Y41bConstantes.FASE_CAMPANHA_CIERRE.equals(bandejaCampanhaAux.getTzfase())) {
			cadena = "excel.fase.cierre";
		} else {
			cadena = "";
		}

		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(appMessageSource.getMessage(cadena, null, locale))
						+ (("excel.fase.ejecucion".equals(cadena)) ? " (" + bandejaCampanhaAux.getNumFinalizados() + "/"
								+ bandejaCampanhaAux.getNumProgramaciones() + ")" : "")));

		// comentarios
		cadena = "";
		if (Y41bConstantes.VALOR_SI.equals(bandejaCampanhaAux.getComentarios())) {
			cadena = "excel.campanhas.si";
		} else {
			cadena = "";
		}

		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(appMessageSource.getMessage(cadena, null, locale))));

		// informefinal
		cadena = "";
		if (Y41bConstantes.CAMPANHA_INFORME_VACIO.equals(bandejaCampanhaAux.getInformefinal())) {
			cadena = "excel.informefinal.vacio";
		} else if (Y41bConstantes.CAMPANHA_INFORME_SEMICOMPLETO.equals(bandejaCampanhaAux.getInformefinal())) {
			cadena = "excel.informefinal.semicompleto";
		} else if (Y41bConstantes.CAMPANHA_INFORME_COMPLETO.equals(bandejaCampanhaAux.getInformefinal())) {
			cadena = "excel.informefinal.completo";
		} else {
			cadena = "";
		}

		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils
				.normalizarVacio(appMessageSource.getMessage(cadena, null, locale))
				+ (("excel.informefinal.semicompleto".equals(cadena)) ? " (" + bandejaCampanhaAux.getNumFinalizados()
						+ "/" + bandejaCampanhaAux.getNumProgramaciones() + ")" : "")));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param bandejaAlertaAux
	 *            BandejaAlerta
	 * @return String
	 */
	private String getBandejaAlertasRow(BandejaAlerta bandejaAlertaAux, CensoMonitor censoMonitor) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// alerta.alcoor
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(bandejaAlertaAux.getAlerta().getAlcoor())));

		// alerta.alnror
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(bandejaAlertaAux.getAlerta().getAlnror())));

		// alerta.alnran
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getAlerta().getAlnran()))));

		// intervinientes.nombre
		if (!Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO
				.equals(censoMonitor.getPerfilOrganizacion().getIdPerfil())) {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(bandejaAlertaAux.getIntervinientes().getNombre())));
		}

		// alproducto
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(bandejaAlertaAux.getAlproducto())));

		// crfechacomunicacion
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaAlertaAux.getCrfechacomunicacion(), locale.getLanguage()))));

		// crcnactu
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getCrcnactu()))));

		// numInspeccionesRealizadas
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getNumInspeccionesRealizadas()))));

		// numInspeccionesEnCurso
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getNumInspeccionesEnCurso()))));

		// numProductosInmovilizados
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getNumProductosInmovilizados()))));

		// numProductosRecuperados
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getNumProductosRecuperados()))));

		// numProductosDestruidos
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getNumProductosDestruidos()))));

		// numProductosDevueltosOrigen
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getNumProductosDevueltosOrigen()))));

		// numProductosLibreComercializacion
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getNumProductosLibreComercializacion()))));

		// numProductosTomaMuestras
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getNumProductosTomaMuestras()))));

		// numProductosOtros
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getNumProductosOtros()))));

		// numProductosPendientes
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(bandejaAlertaAux.getNumProductosPendientes()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param bandejaComunicacionesSoivreAux
	 *            BandejaComunicacionesSoivre
	 * @return String
	 */
	private String getBandejaComunicacionesSoivreRow(ComunicacionSoivre bandejaComunicacionesSoivreAux) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// v6codigo
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(bandejaComunicacionesSoivreAux.getV6codigo())));

		// v6tipo
		String cadena = "";
		if (Y41bConstantes.SOIVRE_TIPO_SUBSANABLES.equals(bandejaComunicacionesSoivreAux.getV6tipo())) {
			cadena = "excel.tipo.subsanables";
		} else if (Y41bConstantes.SOIVRE_TIPO_RECHAZOS.equals(bandejaComunicacionesSoivreAux.getV6tipo())) {
			cadena = "excel.tipo.rechazos";
		} else if (Y41bConstantes.SOIVRE_TIPO_ALERTA.equals(bandejaComunicacionesSoivreAux.getV6tipo())) {
			cadena = "excel.tipo.alerta";
		} else if (Y41bConstantes.SOIVRE_TIPO_INFORMATIVA.equals(bandejaComunicacionesSoivreAux.getV6tipo())) {
			cadena = "excel.tipo.informativa";
		}

		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(appMessageSource.getMessage(cadena, null, locale))));

		// v6numsolicitud
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(bandejaComunicacionesSoivreAux.getV6numsolicitud())));

		// v6fechasolinspeccion
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils.normalizarVacio(Y41bUtils
				.parseDateToString(bandejaComunicacionesSoivreAux.getV6fechasolinspeccion(), locale.getLanguage()))));

		// v6establecimientovisitaesnombre
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(bandejaComunicacionesSoivreAux.getV6establecimientovisitaesnombre())));

		// v6establecimientovisitaesnombreMunicipio
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils
				.normalizarVacio(bandejaComunicacionesSoivreAux.getV6establecimientovisitaesnombreMunicipio())));

		// getV6codexpediente
		if (bandejaComunicacionesSoivreAux.getV6coactua() != null
				&& bandejaComunicacionesSoivreAux.getV6coactua() != "") {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(bandejaComunicacionesSoivreAux.getV6codexpediente())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(""));
		}

		// v6inspeccionsolicitada
		row.append(Y41bExcelGeneratorServiceImpl.getField(
				Y41bUtils.normalizarVacio(String.valueOf(bandejaComunicacionesSoivreAux.getV6inspeccionsolicitada()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param inspeccionAux
	 *            BusquedaInspeccion
	 * @return String
	 */
	private String getBandejaPropuestasInspeccionesRow(InspeccionesPropBandeja inspeccionesPropBandeja) {
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// pnombre
		String pnombre = "";
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			pnombre = inspeccionesPropBandeja.getBaprinstipoprocedimiento().getPnombre();
		} else {
			pnombre = inspeccionesPropBandeja.getBaprinstipoprocedimiento().getPnombree();
		}

		if (inspeccionesPropBandeja != null && inspeccionesPropBandeja.getBaprinstipoprocedimiento() != null
				&& inspeccionesPropBandeja.getBaprinstipoprocedimiento().getPcodigo() != null
				&& inspeccionesPropBandeja.getBaprinstipoprocedimiento().getPcodigo()
						.equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)
				&& inspeccionesPropBandeja.getBaprinsexesdenuncia() != null) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils
					.normalizarVacio(appMessageSource.getMessage("excel.inspecciones.origen.denuncia", null, locale))));
		} else if (inspeccionesPropBandeja != null && inspeccionesPropBandeja.getBaprinstipoprocedimiento() != null
				&& inspeccionesPropBandeja.getBaprinstipoprocedimiento().getPcodigo() != null && inspeccionesPropBandeja
						.getBaprinstipoprocedimiento().getPcodigo().equals(Y41bConstantes.TIPO_PROC_SOLICITUDES)) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(
					appMessageSource.getMessage("excel.inspecciones.origen.solicitud", null, locale))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(pnombre)));
		}

		// baprinsexcodcompleto
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(inspeccionesPropBandeja.getBaprinsexcodcompleto())));

		// baprinsfec
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(inspeccionesPropBandeja.getBaprinsfec(), locale.getLanguage()))));

		// baprinsestablecimiento.esnoco
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(inspeccionesPropBandeja.getBaprinsestablecimiento().getEsnoco())));

		// baprinsprovnombre
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(inspeccionesPropBandeja.getBaprinsprovnombre())));

		// baprinsmunicnombre
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(inspeccionesPropBandeja.getBaprinsmunicnombre())));

		// baprinsresponsable.monombre
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(inspeccionesPropBandeja.getBaprinsresponsable().getMonombre())));

		// baprinsinstrucinspecc
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(inspeccionesPropBandeja.getBaprinsinstrucinspecc())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param inspeccionAux
	 *            BusquedaInspeccion
	 * @return String
	 */
	private String getBandejaInspeccionesRow(BandejaInspecciones inspeccionAux) {
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// Cod. expediente
		String expediente = inspeccionAux.getAccoor() + "-" + inspeccionAux.getAcnror() + "-"
				+ inspeccionAux.getAcnran() + "-" + inspeccionAux.getAtnror();
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(expediente)));

		// tipoinspeccion
		String tipoinspeccion = "";
		if (inspeccionAux.getAttipo() != null
				&& inspeccionAux.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_TOMA_MUESTRAS)) {
			tipoinspeccion = appMessageSource.getMessage("excel.inspecciones.tomamuestras", null, locale);
		} else if (inspeccionAux.getAttipo() != null
				&& inspeccionAux.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR)) {
			tipoinspeccion = appMessageSource.getMessage("excel.inspecciones.controlestandar", null, locale);
		} else if (inspeccionAux.getAttipo() != null
				&& inspeccionAux.getAttipo().equals(Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS)) {
			tipoinspeccion = appMessageSource.getMessage("excel.inspecciones.controlotros", null, locale);
		}

		row.append(getField(Y41bUtils.normalizarVacio(tipoinspeccion)));

		// Origen
		String origen = "";
		if (Y41bConstantes.INSPECCIONES_ORIGEN_CAMPANHA.equals(inspeccionAux.getOrigen())) {
			origen = appMessageSource.getMessage("excel.inspecciones.origen.campanha", null, locale);
		} else if (Y41bConstantes.INSPECCIONES_ORIGEN_ALERTA.equals(inspeccionAux.getOrigen())) {
			origen = appMessageSource.getMessage("excel.inspecciones.origen.alerta", null, locale);
		} else if (Y41bConstantes.INSPECCIONES_ORIGEN_SOIVRE.equals(inspeccionAux.getOrigen())) {
			origen = appMessageSource.getMessage("excel.inspecciones.origen.soivre", null, locale);
		} else if (Y41bConstantes.INSPECCIONES_ORIGEN_DENUNCIA.equals(inspeccionAux.getOrigen())) {
			origen = appMessageSource.getMessage("excel.inspecciones.origen.denuncia", null, locale);
		} else if (Y41bConstantes.INSPECCIONES_ORIGEN_SOLICITUD.equals(inspeccionAux.getOrigen())) {
			origen = appMessageSource.getMessage("excel.inspecciones.origen.solicitud", null, locale);
		} else if (Y41bConstantes.INSPECCIONES_ORIGEN_OFICIO.equals(inspeccionAux.getOrigen())) {
			origen = appMessageSource.getMessage("excel.inspecciones.origen.oficio", null, locale);
		} else if (Y41bConstantes.INSPECCIONES_ORIGEN_NOTIFICACION_PRODUCTORES.equals(inspeccionAux.getOrigen())) {
			origen = appMessageSource.getMessage("excel.inspecciones.origen.notificacionProductores", null, locale);
		} else if (Y41bConstantes.INSPECCIONES_ORIGEN_COMUNICACION_EXTERNA.equals(inspeccionAux.getOrigen())) {
			origen = appMessageSource.getMessage("excel.inspecciones.origen.comunicacionExterna", null, locale);
		}
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(origen)));

		// Expediente origen
		row.append(
				Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(inspeccionAux.getExpedienteorigen())));

		// Tramite
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(inspeccionAux.getTrnombre())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(inspeccionAux.getTrnombree())));
		}

		// Fecha tramite
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(inspeccionAux.getFechatramite(), locale.getLanguage()))));

		// Tramites pendientes
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(String.valueOf(inspeccionAux.getTramitespendientes()))));

		// Establecimiento visitado
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(inspeccionAux.getEsnoco())));

		// municipio
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(inspeccionAux.getEsmunicipio())));

		// Documento
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(inspeccionAux.getQ5nofile())));

		// Inspector
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(inspeccionAux.getMonombre())));

		// Estado tramite
		String estadoNormalizado = Y41bUtils.normalizarVacio(inspeccionAux.getEstadotramite());
		String estadoNB = "";
		if ("P".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientefirma", null, locale);
		} else if ("F".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmado", null, locale);
		} else if ("I".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientelocalizacion", null, locale);
		} else if ("L".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.localizado", null, locale);
		} else if ("R".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.errorlocalizacion", null, locale);
		} else if ("D".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmadenegada", null, locale);
		} else if ("E".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = "";
		} else if ("T".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.tramitado", null, locale);
		}
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(estadoNB)));

		// Fecha limite
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(inspeccionAux.getFechalimite(), locale.getLanguage()))));

		// Estado firma
		if (inspeccionAux.getEstadoFirma() != null && inspeccionAux.getEstadoFirma().equals(Y41bConstantes.VALOR_SI)) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(
					Y41bUtils.normalizarVacio(appMessageSource.getMessage("excel.pendientefirma", null, locale))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio("")));
		}

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param arbbandejaAux
	 *            Arbbandeja
	 * @return String
	 */
	private String getArbbandejaRow(Arbbandeja arbbandejaAux) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(arbbandejaAux.getSolarb().getcodCompleto())));

		// fase
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(arbbandejaAux.getFase().getFnombre())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(arbbandejaAux.getFase().getFnombree())));
		}

		// tramite
		String estado = "";
		if (Y41bConstantes.TRAMITE_ARBITRAJE_RESOLUCION.equals(arbbandejaAux.getArbtramexp().getTrcodigo())) {
			if (arbbandejaAux.getArbtramexp().getTrresotipo() != null) {
				if ("AR1".equals(arbbandejaAux.getArbtramexp().getTrresotipo())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.resolucion.inadmision", null, locale))
							.concat(")");
				} else if ("AR2".equals(arbbandejaAux.getArbtramexp().getTrresotipo())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.resolucion.traslado", null, locale))
							.concat(")");
				} else if ("AR3".equals(arbbandejaAux.getArbtramexp().getTrresotipo())) {
					estado = " ("
							.concat(this.appMessageSource.getMessage("excel.resolucion.desistimiento", null, locale))
							.concat(")");
				} else if ("AR4".equals(arbbandejaAux.getArbtramexp().getTrresotipo())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.resolucion.acuerdo", null, locale))
							.concat(")");
				} else if ("AR5".equals(arbbandejaAux.getArbtramexp().getTrresotipo())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.resolucion.acumulacion", null, locale))
							.concat(")");
				} else if ("AR6".equals(arbbandejaAux.getArbtramexp().getTrresotipo())) {
					estado = " ("
							.concat(this.appMessageSource.getMessage("excel.resolucion.noLocalizado", null, locale))
							.concat(")");
				} else if ("AR7".equals(arbbandejaAux.getArbtramexp().getTrresotipo())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.resolucion.laudo", null, locale))
							.concat(")");
				} else if ("AR8".equals(arbbandejaAux.getArbtramexp().getTrresotipo())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.resolucion.caducidad", null, locale))
							.concat(")");
				} else if ("AR9".equals(arbbandejaAux.getArbtramexp().getTrresotipo())) {
					estado = " ("
							.concat(this.appMessageSource.getMessage("excel.resolucion.noAceptacion", null, locale))
							.concat(")");
				} else if ("AR10".equals(arbbandejaAux.getArbtramexp().getTrresotipo())) {
					estado = " ("
							.concat(this.appMessageSource.getMessage("excel.resolucion.noSubsanacion", null, locale))
							.concat(")");
				} else if ("AR11".equals(arbbandejaAux.getArbtramexp().getTrresotipo())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.resolucion.error", null, locale))
							.concat(")");
				}
			}
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_LAUDO.equals(arbbandejaAux.getArbtramexp().getTrcodigo())) {
			if (arbbandejaAux.getArbtramexp().getTrestadoacuse() != null) {
				if ("D".equals(arbbandejaAux.getArbtramexp().getTrresultado())) {
					estado = " ("
							.concat(this.appMessageSource.getMessage("excel.estadoLaudo.desestimado", null, locale))
							.concat(")");
				} else if ("E".equals(arbbandejaAux.getArbtramexp().getTrresultado())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.estadoLaudo.estimado", null, locale))
							.concat(")");
				} else if ("P".equals(arbbandejaAux.getArbtramexp().getTrresultado())) {
					estado = " ("
							.concat(this.appMessageSource.getMessage("excel.estadoLaudo.estimadoParcial", null, locale))
							.concat(")");
				} else if ("H".equals(arbbandejaAux.getArbtramexp().getTrresultado())) {
					estado = " ("
							.concat(this.appMessageSource.getMessage("excel.estadoLaudo.inhibitorio", null, locale))
							.concat(")");
				}
			}
		} else if (Y41bConstantes.TRAMITE_ARBITRAJE_ACUSERECIBO.equals(arbbandejaAux.getArbtramexp().getTrcodigo())) {
			if (arbbandejaAux.getArbtramexp().getTrestadoacuse() != null) {
				if ("A".equals(arbbandejaAux.getArbtramexp().getTrestadoacuse())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.estadoAcuse.aceptado", null, locale))
							.concat(")");
				} else if ("R".equals(arbbandejaAux.getArbtramexp().getTrestadoacuse())) {
					estado = " (".concat(this.appMessageSource.getMessage("excel.estadoAcuse.rechazado", null, locale))
							.concat(")");
				} else if ("N".equals(arbbandejaAux.getArbtramexp().getTrestadoacuse())) {
					estado = " ("
							.concat(this.appMessageSource.getMessage("excel.estadoAcuse.noentregado", null, locale))
							.concat(")");
				}
			}
		} else {

			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				if (arbbandejaAux.getArbtramexp().getEnvcdessitcorreoses() != null) {
					estado = " (".concat(arbbandejaAux.getArbtramexp().getEnvcdessitcorreoses()).concat(")");
				}
			} else {
				if (arbbandejaAux.getArbtramexp().getEnvcdessitcorreoseu() != null) {
					estado = " (".concat(arbbandejaAux.getArbtramexp().getEnvcdessitcorreoseu()).concat(")");
				}
			}
		}
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(
					arbbandejaAux.getArbtramexp().getTrnomtramCompletoes().concat(" ").concat(estado))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(
					arbbandejaAux.getArbtramexp().getTrnomtramCompletoeu().concat(" ").concat(estado))));
		}

		// Tramites pendientes
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(arbbandejaAux.getTramitesPendientes())));
		// Avisos
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(arbbandejaAux.getAvisos())));
		// responsable expediente
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(arbbandejaAux.getMonitor().getMonombre())));
		// reclamante
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(arbbandejaAux.getSolarb().getDtnombre())));
		// establecimiento
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(arbbandejaAux.getArbinterv().getUanombre())));
		// documento
		if (Y41bConstantes.VALOR_SI.equals(arbbandejaAux.getArbtramexp().getIndVariosDocumentos())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(
					Y41bUtils.normalizarVacio(appMessageSource.getMessage("excel.documentos", null, locale))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(arbbandejaAux.getArbtramexp().getX5tedesfile())));
		}
		// Fecha fin
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(arbbandejaAux.getArbtramexp().getTrfecfin(), locale.getLanguage()))));

		// estado
		String cadena = "";
		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(arbbandejaAux.getAbestado())) {
			cadena = "excel.estado.tramitado";
		} else if (Y41bConstantes.ESTADO_TRAMITE_FIRMADO.equals(arbbandejaAux.getAbestado())) {
			cadena = "excel.estado.firmado";
		} else if (Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA.equals(arbbandejaAux.getAbestado())) {
			cadena = "excel.estado.pendientefirma";
		} else if (Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION.equals(arbbandejaAux.getAbestado())) {
			cadena = "excel.estado.pendientelocalizacion";
		} else if (Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO.equals(arbbandejaAux.getAbestado())) {
			cadena = "excel.estado.localizado";
		} else if (Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA.equals(arbbandejaAux.getAbestado())) {
			cadena = "excel.estado.firmadenegada";
		} else if (Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION.equals(arbbandejaAux.getAbestado())) {
			cadena = "excel.estado.errorlocalizacion";
		} else {
			cadena = "";
		}
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(appMessageSource.getMessage(cadena, null, locale))));
		// Estado firma
		if (Y41bConstantes.VALOR_SI.equals(arbbandejaAux.getEstadoFirma())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(
					Y41bUtils.normalizarVacio(appMessageSource.getMessage("excel.pendientefirma", null, locale))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio("")));
		}
		// Estado firma arbitros
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(arbbandejaAux.getEstadoFirmaArbitros())));
		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSanbandejaHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tramite", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tp", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.avisos", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.instructor", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.esnombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.documento", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fecha", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.estado", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.comun.estadoFirma", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getBandejaCampanhasHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.codorg", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.descripcion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaInicio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaFin", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tomasMuestrasSolicitadas", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tomasMuestrasRealizadas", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.controlesEstandarSolicitados", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.controlesEstandarRealizados", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.controlesOtrosSolicitados", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.controlesOtrosRealizados", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecAdicionalesSolicitadas", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecAdicionalesRealizadas", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.totalInspecSolicitadas", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.totalInspecRealizadas", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecAsociadas", null, locale)));

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fase", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.comentarios", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.informeFinal", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getBandejaAlertasHeaderRow(CensoMonitor censoMonitor) {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.origen", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.numero", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.anio", null, locale)));
		if (!Y41bConstantes.PERFIL_ADMINISTRADOR_MANTENIMIENTO
				.equals(censoMonitor.getPerfilOrganizacion().getIdPerfil())) {
			header.append(Y41bExcelGeneratorServiceImpl
					.getHeaderField(this.appMessageSource.getMessage("excel.distribuidor", null, locale)));
		}
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.producto", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechacomunicacionsstt", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecSolicitadas", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecRealizadas", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecCurso", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.productosInmovilizados", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.productosRecuperados", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.productosDestruidos", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.productosDevueltos", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl.getHeaderField(
				this.appMessageSource.getMessage("excel.productosLibreComercializacion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.productosTomaMuestras", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.productosOtros", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.productosPendientes", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getBandejaComunicacionesSoivreHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.cod", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tipo", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.numSolicitud", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechaSolicitud", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.establecimiento", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nombreMunicipio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspeccion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.instrucciones", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getBandejaPropuestasInspeccionesHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.propuestasInspecciones.origen", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl.getHeaderField(
				this.appMessageSource.getMessage("excel.propuestasInspecciones.codExpediente", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl.getHeaderField(
				this.appMessageSource.getMessage("excel.propuestasInspecciones.fechaSolicitud", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl.getHeaderField(
				this.appMessageSource.getMessage("excel.propuestasInspecciones.establecimientoInsp", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.provincia", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.municipio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.responsable", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.motivo", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getBandejaInspeccionesHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.cod", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.inspecciones.tipoInspeccion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecciones.origen", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecciones.codorigen", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecciones.tramite", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecciones.fechaTramite", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecciones.tramitePendiente", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl.getHeaderField(
				this.appMessageSource.getMessage("excel.inspecciones.establecimientoVisitado", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl.getHeaderField(
				appMessageSource.getMessage("excel.inspecciones.establecimientomunicipio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecciones.nombreDocumento", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecciones.inspector", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecciones.estado", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.inspecciones.fechaLimite", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.comun.estadoFirma", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getArbbandejaHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tramite", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tp", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.avisos", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.instructor", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.reclamante", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.esnombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.documento", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fecha", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.estado", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.comun.estadoFirma", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.comun.estadoFirmaArbitros", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaAdministrativo(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getSolicitudesListTableBandejaAdministrativo(bandejaSolicitudes, censoMonitor,
				trFechaDesde, trFechaHasta, excluirAcuses));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	private String getSolicitudesListTableBandejaAdministrativo(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getSolicitudesHeaderRowBandejaAdministrativo());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
				.findAllBandejaSolicitudesAdministrativo(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						excluirAcuses, pagination);

		for (BandejaSolicitudesBusqueda bandejaSolicitudesBusquedaAux : listBandejaSolicitudesBusqueda) {
			xslString.append(getSolicitudesRowBandejaAdministrativo(bandejaSolicitudesBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSolicitudesHeaderRowBandejaAdministrativo() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tfpnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tiposol", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.trnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.numtp", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.orgNombre", null, locale)));
		// header.append(getHeaderField(appMessageSource.getMessage(
		// "excel.oridest", null, locale)));
		// header.append(getHeaderField(appMessageSource.getMessage("excel.nbdoc",
		// null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fecha", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.estado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechalimite", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param bandejaSolicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	private String getSolicitudesRowBandejaAdministrativo(BandejaSolicitudesBusqueda bandejaSolicitudesBusqueda) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getNumExpediente())));

		// tfpnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTfpnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTfpnombree())));
		}

		// tipoSolicitud
		String tipoSolicitudNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getHdcosc());
		String tipoSolicitudTexto = "";

		if ("D".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.denuncia", null, locale);
		} else if ("Q".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.queja", null, locale);
		} else if ("R".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.reclamacion", null, locale);
		}

		row.append(getField(tipoSolicitudTexto));

		// fnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombree())));
		}

		// trnombre --- + situacion

		/* ****************************************************************** */

		String postFijo = doGetDescripcionEstado(bandejaSolicitudesBusqueda, locale);

		/* ****************************************************************** */

		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombre()) + postFijo));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombree()) + postFijo));
		}

		// num tramites pendientes
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getNumTramitesPendientes())));

		// monombreTramitador
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getMonombre())));

		// // origen
		// row.append(getField(Y41bUtils
		// .normalizarVacio(bandejaSolicitudesBusqueda.getQ5origen())));
		//
		// // indvariosdocs
		// String nbfichero = "";
		//
		// if ("S".equalsIgnoreCase(Y41bUtils
		// .normalizarVacio(bandejaSolicitudesBusqueda
		// .getIndVariosDocumentos()))) {
		//
		// nbfichero = appMessageSource.getMessage("excel.documentos", null,
		// locale);
		//
		// } else if ("N".equalsIgnoreCase(Y41bUtils
		// .normalizarVacio(bandejaSolicitudesBusqueda
		// .getIndVariosDocumentos()))) {
		//
		// nbfichero = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda
		// .getQ5tedesfile());
		//
		// }
		//
		// row.append(getField(nbfichero));

		// fechatram
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechatramite(), locale.getLanguage()))));

		// estado

		String estadoNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getEstadotramite());
		String estadoNB = "";

		if ("P".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientefirma", null, locale);
		} else if ("F".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmado", null, locale);
		} else if ("I".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientelocalizacion", null, locale);
		} else if ("L".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.localizado", null, locale);
		} else if ("R".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.errorlocalizacion", null, locale);
		} else if ("D".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmadenegada", null, locale);
		} else if ("E".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = "";
		} else if ("T".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.tramitado", null, locale);
		}

		row.append(getField(estadoNB));

		// fechalimite
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechalimite(), locale.getLanguage()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param conStandBy
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaENYPD(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, Boolean conStandBy, String excluirAcuses) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getSolicitudesListTableBandejaENYPD(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, conAsignacionResp, conStandBy, excluirAcuses));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param conStandBy
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	private String getSolicitudesListTableBandejaENYPD(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, Boolean conStandBy, String excluirAcuses) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getSolicitudesHeaderRowBandejaENYPD());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
				.findAllBandejaSolicitudesENYPD(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						conAsignacionResp, conStandBy, excluirAcuses, pagination);

		for (BandejaSolicitudesBusqueda bandejaSolicitudesBusquedaAux : listBandejaSolicitudesBusqueda) {
			xslString.append(getSolicitudesRowBandejaENYPD(bandejaSolicitudesBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSolicitudesHeaderRowBandejaENYPD() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tiposol", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.trnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.reclamanteDenunciante", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.reclamadoDenunciado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nbdoc", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fecha", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param bandejaSolicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	private String getSolicitudesRowBandejaENYPD(BandejaSolicitudesBusqueda bandejaSolicitudesBusqueda) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getNumExpediente())));

		// tipoSolicitud
		String tipoSolicitudNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getHdcosc());
		String tipoSolicitudTexto = "";

		if ("D".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.denuncia", null, locale);
		} else if ("Q".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.queja", null, locale);
		} else if ("R".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.reclamacion", null, locale);
		}

		row.append(getField(tipoSolicitudTexto));

		// fnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombree())));
		}

		// trnombre

		/* ****************************************************************** */

		String postFijo = doGetDescripcionEstado(bandejaSolicitudesBusqueda, locale);

		/* ****************************************************************** */

		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombre()) + postFijo));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombree()) + postFijo));
		}

		// reclamante
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getReclamante())));

		// reclamado
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getReclamado())));
		// indvariosdocs
		String nbfichero = "";

		if ("S".equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = appMessageSource.getMessage("excel.documentos", null, locale);

		} else if ("N"
				.equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getQ5tedesfile());

		}

		row.append(getField(nbfichero));

		// fechatram
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechatramite(), locale.getLanguage()))));

		// // fechalimite
		// row.append(getFieldFecha(Y41bUtils.normalizarVacio(Y41bUtils
		// .parseDateToString(bandejaSolicitudesBusqueda.getFechalimite(),
		// locale.getLanguage()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaECTP(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(
				this.getSolicitudesListTableBandejaECTP(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * 
	 * @return String
	 */
	private String getSolicitudesListTableBandejaECTP(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getSolicitudesHeaderRowBandejaECTP());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
				.findAllBandejaSolicitudesECTP(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						pagination);

		for (BandejaSolicitudesBusqueda bandejaSolicitudesBusquedaAux : listBandejaSolicitudesBusqueda) {
			xslString.append(getSolicitudesRowBandejaECTP(bandejaSolicitudesBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSolicitudesHeaderRowBandejaECTP() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tiposol", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tfpnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.trnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.numtp", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.reclamanteDenunciante", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.reclamadoDenunciado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nbdoc", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fecha", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.estado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechalimite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.comun.estadoFirma", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param bandejaSolicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	private String getSolicitudesRowBandejaECTP(BandejaSolicitudesBusqueda bandejaSolicitudesBusqueda) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getNumExpediente())));

		// tipoSolicitud
		String tipoSolicitudNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getHdcosc());
		String tipoSolicitudTexto = "";

		if ("D".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.denuncia", null, locale);
		} else if ("Q".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.queja", null, locale);
		} else if ("R".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.reclamacion", null, locale);
		}

		row.append(getField(tipoSolicitudTexto));

		// tfpnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTfpnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTfpnombree())));
		}

		// fnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombree())));
		}

		// trnombre

		/* ****************************************************************** */

		String postFijo = doGetDescripcionEstado(bandejaSolicitudesBusqueda, locale);

		/* ****************************************************************** */

		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombre()) + postFijo));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombree()) + postFijo));
		}

		// num tramites pendientes
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getNumTramitesPendientes())));

		// reclamante
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getReclamante())));

		// reclamado
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getReclamado())));
		// indvariosdocs
		String nbfichero = "";

		if ("S".equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = appMessageSource.getMessage("excel.documentos", null, locale);

		} else if ("N"
				.equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getQ5tedesfile());

		}

		row.append(getField(nbfichero));

		// fechatram
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechatramite(), locale.getLanguage()))));

		// estado

		String estadoNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getEstadotramite());
		String estadoNB = "";

		if ("P".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientefirma", null, locale);
		} else if ("F".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmado", null, locale);
		} else if ("I".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientelocalizacion", null, locale);
		} else if ("L".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.localizado", null, locale);
		} else if ("R".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.errorlocalizacion", null, locale);
		} else if ("D".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmadenegada", null, locale);
		} else if ("E".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = "";
		} else if ("T".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.tramitado", null, locale);
		}

		row.append(getField(estadoNB));

		// fechalimite
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechalimite(), locale.getLanguage()))));

		// Estado firma
		if (bandejaSolicitudesBusqueda.getEstadoFirma() != null
				&& bandejaSolicitudesBusqueda.getEstadoFirma().equals(Y41bConstantes.VALOR_SI)) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(
					Y41bUtils.normalizarVacio(appMessageSource.getMessage("excel.pendientefirma", null, locale))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio("")));
		}

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaECTPO(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getSolicitudesListTableBandejaECTPO(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, excluirAcuses));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	private String getSolicitudesListTableBandejaECTPO(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getSolicitudesHeaderRowBandejaECTPO());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
				.findAllBandejaSolicitudesECTPO(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						excluirAcuses, pagination);

		for (BandejaSolicitudesBusqueda bandejaSolicitudesBusquedaAux : listBandejaSolicitudesBusqueda) {
			xslString.append(getSolicitudesRowBandejaECTPO(bandejaSolicitudesBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSolicitudesHeaderRowBandejaECTPO() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tiposol", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tfpnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.trnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.numtp", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.reclamanteDenunciante", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.reclamadoDenunciado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nbdoc", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fecha", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.estado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechalimite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.comun.estadoFirma", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param bandejaSolicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	private String getSolicitudesRowBandejaECTPO(BandejaSolicitudesBusqueda bandejaSolicitudesBusqueda) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getNumExpediente())));

		// tipoSolicitud
		String tipoSolicitudNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getHdcosc());
		String tipoSolicitudTexto = "";

		if ("D".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.denuncia", null, locale);
		} else if ("Q".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.queja", null, locale);
		} else if ("R".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.reclamacion", null, locale);
		}

		row.append(getField(tipoSolicitudTexto));

		// tfpnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTfpnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTfpnombree())));
		}

		// fnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombree())));
		}

		// trnombre

		/* ****************************************************************** */

		String postFijo = doGetDescripcionEstado(bandejaSolicitudesBusqueda, locale);

		/* ****************************************************************** */

		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombre()) + postFijo));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombree()) + postFijo));
		}

		// num tramites pendientes
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getNumTramitesPendientes())));

		// reclamante
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getReclamante())));

		// reclamado
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getReclamado())));
		// indvariosdocs
		String nbfichero = "";

		if ("S".equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = appMessageSource.getMessage("excel.documentos", null, locale);

		} else if ("N"
				.equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getQ5tedesfile());

		}

		row.append(getField(nbfichero));

		// fechatram
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechatramite(), locale.getLanguage()))));

		// estado

		String estadoNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getEstadotramite());
		String estadoNB = "";

		if ("P".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientefirma", null, locale);
		} else if ("F".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmado", null, locale);
		} else if ("I".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientelocalizacion", null, locale);
		} else if ("L".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.localizado", null, locale);
		} else if ("R".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.errorlocalizacion", null, locale);
		} else if ("D".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmadenegada", null, locale);
		} else if ("E".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = "";
		} else if ("T".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.tramitado", null, locale);
		}

		row.append(getField(estadoNB));

		// fechalimite
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechalimite(), locale.getLanguage()))));

		// Estado firma
		if (bandejaSolicitudesBusqueda.getEstadoFirma() != null
				&& bandejaSolicitudesBusqueda.getEstadoFirma().equals(Y41bConstantes.VALOR_SI)) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(
					Y41bUtils.normalizarVacio(appMessageSource.getMessage("excel.pendientefirma", null, locale))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio("")));
		}

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaEONYPD(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, String excluirAcuses) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getSolicitudesListTableBandejaEONYPD(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, conAsignacionResp, excluirAcuses));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * @return String
	 */
	private String getSolicitudesListTableBandejaEONYPD(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp,
			String excluirAcuses) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getSolicitudesHeaderRowBandejaEONYPD());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
				.findAllBandejaSolicitudesEONYPD(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						conAsignacionResp, excluirAcuses, pagination);

		for (BandejaSolicitudesBusqueda bandejaSolicitudesBusquedaAux : listBandejaSolicitudesBusqueda) {
			xslString.append(getSolicitudesRowBandejaEONYPD(bandejaSolicitudesBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSolicitudesHeaderRowBandejaEONYPD() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tiposol", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.trnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.responsable", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.reclamanteDenunciante", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.reclamadoDenunciado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nbdoc", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fecha", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param bandejaSolicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	private String getSolicitudesRowBandejaEONYPD(BandejaSolicitudesBusqueda bandejaSolicitudesBusqueda) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getNumExpediente())));

		// tipoSolicitud
		String tipoSolicitudNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getHdcosc());
		String tipoSolicitudTexto = "";

		if ("D".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.denuncia", null, locale);
		} else if ("Q".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.queja", null, locale);
		} else if ("R".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.reclamacion", null, locale);
		}

		row.append(getField(tipoSolicitudTexto));

		// fnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombree())));
		}

		// trnombre

		/* ****************************************************************** */

		String postFijo = doGetDescripcionEstado(bandejaSolicitudesBusqueda, locale);

		/* ****************************************************************** */

		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombre()) + postFijo));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombree()) + postFijo));
		}

		// responsable exp
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getMonombre())));

		// reclamante
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getReclamante())));

		// reclamado
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getReclamado())));

		// indvariosdocs
		String nbfichero = "";

		if ("S".equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = appMessageSource.getMessage("excel.documentos", null, locale);

		} else if ("N"
				.equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getQ5tedesfile());

		}

		row.append(getField(nbfichero));

		// fechatram
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechatramite(), locale.getLanguage()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaEOCTP(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getSolicitudesListTableBandejaEOCTP(bandejaSolicitudes, censoMonitor, trFechaDesde,
				trFechaHasta, excluirAcuses));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	private String getSolicitudesListTableBandejaEOCTP(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getSolicitudesHeaderRowBandejaEOCTP());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setSort("FECHATRAMITE");
		pagination.setAscDsc(Y41bConstantes.ORDENACION_DESC);
		List<BandejaSolicitudesBusqueda> listBandejaSolicitudesBusqueda = this.bandejaSolicitudesService
				.findAllBandejaSolicitudesEOCTP(bandejaSolicitudes, censoMonitor, trFechaDesde, trFechaHasta,
						excluirAcuses, pagination);

		for (BandejaSolicitudesBusqueda bandejaSolicitudesBusquedaAux : listBandejaSolicitudesBusqueda) {
			xslString.append(getSolicitudesRowBandejaEOCTP(bandejaSolicitudesBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSolicitudesHeaderRowBandejaEOCTP() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(getHeaderField(appMessageSource.getMessage("excel.codigo", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.tiposol", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.trnombre", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.numtp", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.responsable", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.reclamanteDenunciante", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.reclamadoDenunciado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.nbdoc", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fecha", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.estado", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.fechalimite", null, locale)));
		header.append(getHeaderField(appMessageSource.getMessage("excel.comun.estadoFirma", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param bandejaSolicitudesBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	private String getSolicitudesRowBandejaEOCTP(BandejaSolicitudesBusqueda bandejaSolicitudesBusqueda) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// numExpediente
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getNumExpediente())));

		// tipoSolicitud
		String tipoSolicitudNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getHdcosc());
		String tipoSolicitudTexto = "";

		if ("D".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.denuncia", null, locale);
		} else if ("Q".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.queja", null, locale);
		} else if ("R".equalsIgnoreCase(tipoSolicitudNormalizado)) {
			tipoSolicitudTexto = appMessageSource.getMessage("excel.reclamacion", null, locale);
		}

		row.append(getField(tipoSolicitudTexto));

		// fnombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombre())));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getFnombree())));
		}

		// trnombre

		/* ****************************************************************** */

		String postFijo = doGetDescripcionEstado(bandejaSolicitudesBusqueda, locale);

		/* ****************************************************************** */

		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombre()) + postFijo));
		} else {
			row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getTrnombree()) + postFijo));
		}

		// num tramites pendientes
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getNumTramitesPendientes())));

		// responsable exp
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getMonombre())));

		// reclamante
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getReclamante())));

		// reclamado
		row.append(getField(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getReclamado())));

		// indvariosdocs
		String nbfichero = "";

		if ("S".equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = appMessageSource.getMessage("excel.documentos", null, locale);

		} else if ("N"
				.equalsIgnoreCase(Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getIndVariosDocumentos()))) {

			nbfichero = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getQ5tedesfile());

		}

		row.append(getField(nbfichero));

		// fechatram
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechatramite(), locale.getLanguage()))));

		// estado

		String estadoNormalizado = Y41bUtils.normalizarVacio(bandejaSolicitudesBusqueda.getEstadotramite());
		String estadoNB = "";

		if ("P".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientefirma", null, locale);
		} else if ("F".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmado", null, locale);
		} else if ("I".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientelocalizacion", null, locale);
		} else if ("L".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.localizado", null, locale);
		} else if ("R".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.errorlocalizacion", null, locale);
		} else if ("D".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.firmadenegada", null, locale);
		} else if ("E".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = "";
		} else if ("T".equalsIgnoreCase(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.tramitado", null, locale);
		}

		row.append(getField(estadoNB));

		// fechalimite
		row.append(getFieldFecha(Y41bUtils.normalizarVacio(
				Y41bUtils.parseDateToString(bandejaSolicitudesBusqueda.getFechalimite(), locale.getLanguage()))));

		// Estado firma
		if (bandejaSolicitudesBusqueda.getEstadoFirma() != null
				&& bandejaSolicitudesBusqueda.getEstadoFirma().equals(Y41bConstantes.VALOR_SI)) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(
					Y41bUtils.normalizarVacio(appMessageSource.getMessage("excel.pendientefirma", null, locale))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio("")));
		}

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en ooee
	 * 
	 * @param filtroOoee
	 *            Ooee
	 * @return String
	 */
	public String getOoeeExcel(Ooee filtroOoee) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getOoeeListTable(filtroOoee));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filtroOoee
	 *            Ooee
	 * @return String
	 */
	private String getOoeeListTable(Ooee filtroOoee) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getOoeeHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("oecodigo");
		List<Ooee> ooeeBusqueda = this.ooeeService.findAllBusqueda(filtroOoee, pagination);

		for (Ooee ooeeBusquedaAux : ooeeBusqueda) {
			xslString.append(this.getOoeeRow(ooeeBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getOoeeHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.codorg", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.siglas", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nombreMunicipio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.adherido", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechabaja", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param ooee
	 *            Ooee
	 * @return String
	 */
	private String getOoeeRow(Ooee ooee) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// oecodigo
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(ooee.getOecodigo())));
		// Nombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(ooee.getOrganismo().getNombreEs())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(ooee.getOrganismo().getNombreEu())));
		}
		// Siglas
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(ooee.getOetesi())));
		// municipio
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(ooee.getOrganismo().getNombreMunicipio())));
		// Adherido
		if (ooee.getOeadherido() != null && ooee.getOeadherido().equals(Y41bConstantes.CENSO_ARB_ADHERIDO)) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(Y41bConstantes.VALOR_SI)));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio("")));
		}
		// fecha baja
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(
				Y41bUtils.normalizarVacio(Y41bUtils.parseDateToString(ooee.getOefeadfin(), locale.getLanguage()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en aacc
	 * 
	 * @param filtroAaccEuskadi
	 *            AaccEuskadi
	 * @return String
	 */
	public String getAaccEuskadiExcel(AaccEuskadi filtroAaccEuskadi) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getAaccEuskadiListTable(filtroAaccEuskadi));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filtroAaccEuskadi
	 *            AaccEuskadi
	 * @return String
	 */
	private String getAaccEuskadiListTable(AaccEuskadi filtroAaccEuskadi) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getAaccEuskadiHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("aeNumRegistro");
		List<AaccEuskadi> aaccEuskadiBusqueda = this.aaccEuskadiService.findAllBusqueda(filtroAaccEuskadi, pagination);

		for (AaccEuskadi aaccEuskadiBusquedaAux : aaccEuskadiBusqueda) {
			xslString.append(this.getAaccEuskadiRow(aaccEuskadiBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getAaccEuskadiHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.cod", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.aaccEuskadi.activa", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.aaccEuskadi.numregistro", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nif", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tipo", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.territorio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.municipio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.direccion", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param aaccEuskadi
	 *            AaccEuskadi
	 * @return String
	 */
	private String getAaccEuskadiRow(AaccEuskadi aaccEuskadi) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// codigo
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(aaccEuskadi.getAeCodigo())));

		// de baja
		if (aaccEuskadi.getAeFechaBaja() != null && !(aaccEuskadi.getAeFechaBaja().equals(""))) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(Y41bConstantes.NO_COMPLETO)));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(Y41bConstantes.SI_COMPLETO)));
		}

		// numRegistro
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(aaccEuskadi.getAeNumRegistro())));

		// NIF
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(aaccEuskadi.getAeNif())));

		// Nombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(aaccEuskadi.getAeNombreEs())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(aaccEuskadi.getAeNombreEu())));
		}
		// tipo
		String tipo = "";
		if (aaccEuskadi.getAeTipoOrg() != null && !(aaccEuskadi.getAeTipoOrg().equalsIgnoreCase(""))) {

			if (aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("A")) {
				tipo = this.appMessageSource.getMessage("excel.aaccEuskadi.asociacion", null, locale);
			} else if (aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("C")) {
				tipo = this.appMessageSource.getMessage("excel.aaccEuskadi.cooperativa", null, locale);
			} else if (aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("F")) {
				tipo = this.appMessageSource.getMessage("excel.aaccEuskadi.federacion", null, locale);
			} else if (aaccEuskadi.getAeTipoOrg().equalsIgnoreCase("D")) {
				tipo = this.appMessageSource.getMessage("excel.aaccEuskadi.confederacion", null, locale);
			}

		}
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(tipo)));

		// Territorio
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(aaccEuskadi.getAeTerritorio())));

		// Municipio
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(aaccEuskadi.getAeMunicipio())));

		// Direccion
		String direccion = "";

		direccion = Y41bUtils.normalizarVacio(aaccEuskadi.getAeDireccion());

		if (aaccEuskadi.getAePortal() != null && !(aaccEuskadi.getAePortal().equalsIgnoreCase(""))) {
			direccion = direccion + ", " + aaccEuskadi.getAePortal();
		}

		if (aaccEuskadi.getAeCompledirec() != null && !(aaccEuskadi.getAeCompledirec().equalsIgnoreCase(""))
				&& aaccEuskadi.getAeCompledirec().indexOf("#") == -1) {
			direccion = direccion + " " + aaccEuskadi.getAeCompledirec();
		}

		row.append(Y41bExcelGeneratorServiceImpl.getField(direccion));

		row.append("</tr>");
		return row.toString();
	}
	/////////////////////////////////////////////////

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en aacc
	 * 
	 * @param filtroAacc
	 *            Aacc
	 * @return String
	 */
	public String getAaccExcel(Aacc filtroAacc) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getAaccListTable(filtroAacc));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filtroAacc
	 *            Aacc
	 * @return String
	 */
	private String getAaccListTable(Aacc filtroAacc) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getAaccHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("cccodigo");
		List<Aacc> aaccBusqueda = this.aaccService.findAllBusqueda(filtroAacc, pagination);

		for (Aacc aaccBusquedaAux : aaccBusqueda) {
			xslString.append(this.getAaccRow(aaccBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getAaccHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.codorg", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.siglas", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nombreMunicipio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.adherido", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechabaja", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param aacc
	 *            Aacc
	 * @return String
	 */
	private String getAaccRow(Aacc aacc) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// oecodigo
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(aacc.getCccodigo())));
		// Nombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(aacc.getOrganismo().getNombreEs())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(aacc.getOrganismo().getNombreEu())));
		}
		// Siglas
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(aacc.getCctesi())));
		// municipio
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(aacc.getOrganismo().getNombreMunicipio())));
		// Adherido
		if (aacc.getCcadherido() != null && aacc.getCcadherido().equals(Y41bConstantes.CENSO_ARB_ADHERIDO)) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(Y41bConstantes.VALOR_SI)));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio("")));
		}
		// fecha baja
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(
				Y41bUtils.normalizarVacio(Y41bUtils.parseDateToString(aacc.getCcfeadfin(), locale.getLanguage()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en aacc
	 * 
	 * @param filtroArbitro
	 *            Arbitro
	 * @return String
	 */
	public String getArbitroExcel(Arbitro filtroArbitro) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getArbitroListTable(filtroArbitro));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en aacc
	 * 
	 * @param filtroSecretar
	 *            Secretar
	 * @return String
	 */
	public String getSecretarExcel(Secretar filtroSecretar) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getSecretarListTable(filtroSecretar));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filtroArbitro
	 *            Arbitro
	 * @return String
	 */
	private String getArbitroListTable(Arbitro filtroArbitro) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getArbitroHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("arnombre");
		List<Arbitro> arbitroBusqueda = this.arbitroService.findAll(filtroArbitro, pagination);

		for (Arbitro arbitroBusquedaAux : arbitroBusqueda) {
			xslString.append(this.getArbitroRow(arbitroBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filtroSecretar
	 *            Secretar
	 * @return String
	 */
	private String getSecretarListTable(Secretar filtroSecretar) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getSecretarioHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("srnombre");
		List<Secretar> secretarBusqueda = this.secretarService.findAll(filtroSecretar, pagination);

		for (Secretar secretarBusquedaAux : secretarBusqueda) {
			xslString.append(this.getSecretarRow(secretarBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getArbitroHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nif", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.arbitro.tipo", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.arbitro.ooeeAacc", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param arbitro
	 *            Arbitro
	 * @return String
	 */
	private String getArbitroRow(Arbitro arbitro) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// arnif
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(arbitro.getArnif())));
		// arnombre
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(arbitro.getArnombre())));
		// artipo
		if (Y41bConstantes.CENSO_ARB_TIPOARBITROC.equals(arbitro.getArincoes())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils
					.normalizarVacio(this.appMessageSource.getMessage("excel.arbitro.consumidor", null, locale))));
		} else if (Y41bConstantes.CENSO_ARB_TIPOARBITROE.equals(arbitro.getArincoes())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils
					.normalizarVacio(this.appMessageSource.getMessage("excel.arbitro.empresarial", null, locale))));
		} else if (Y41bConstantes.CENSO_ARB_TIPOARBITROP.equals(arbitro.getArincoes())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils
					.normalizarVacio(this.appMessageSource.getMessage("excel.arbitro.presidente", null, locale))));
		}
		// Asociacion/Organizacion
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(arbitro.getArnoentidadEs())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(arbitro.getArnoentidadEu())));
		}
		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param secretar
	 *            Secretar
	 * @return String
	 */
	private String getSecretarRow(Secretar secretar) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// arnif
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(secretar.getSrnif())));
		// arnombre
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(secretar.getSrnombre())));

		// Th
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(secretar.getSrThActs())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(secretar.getSrThActs())));
		}
		row.append("</tr>");
		return row.toString();
	}

	private String doGetDescripcionEstado(BandejaSolicitudesBusqueda bandejaSolicitudesBusqueda, Locale locale) {
		String estadoAcuse = "";
		String postFijo = "";

		if (bandejaSolicitudesBusqueda.getSituacionacuse() != null) {
			if (Y41bConstantes.SITUACION_ACUSERECIBO_ACEPTADO.equals(bandejaSolicitudesBusqueda.getSituacionacuse())) {
				estadoAcuse = appMessageSource.getMessage("situacionacuse.aceptado", null, locale);
			} else if (Y41bConstantes.SITUACION_ACUSERECIBO_RECHAZADO
					.equals(bandejaSolicitudesBusqueda.getSituacionacuse())) {
				estadoAcuse = appMessageSource.getMessage("situacionacuse.rechazado", null, locale);
			} else if (Y41bConstantes.SITUACION_ACUSERECIBO_NOENTREGADO
					.equals(bandejaSolicitudesBusqueda.getSituacionacuse())) {
				estadoAcuse = appMessageSource.getMessage("situacionacuse.noentregado", null, locale);
			}
			postFijo = " (" + estadoAcuse + ")";
		} else {
			if (Y41bConstantes.EUSKERA.equals(locale.getLanguage())) {
				if (bandejaSolicitudesBusqueda.getEnvcdessitcorreoseu() != null) {
					postFijo = " (" + bandejaSolicitudesBusqueda.getEnvcdessitcorreoseu() + ")";
				}
			} else {
				if (bandejaSolicitudesBusqueda.getEnvcdessitcorreoses() != null) {
					postFijo = " (" + bandejaSolicitudesBusqueda.getEnvcdessitcorreoses() + ")";
				}
			}
		}
		return postFijo;
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en perito
	 * 
	 * @param filtroPerito
	 *            Empper
	 * @return String
	 */
	public String getPeritoExcel(Empper filtroPerito) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getPeritoListTable(filtroPerito));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filtroPerito
	 *            Empper
	 * @return String
	 */
	private String getPeritoListTable(Empper filtroPerito) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getPeritoHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("penombre");
		List<Empper> empperBusqueda = this.empperService.findAll(filtroPerito, pagination);

		for (Empper empperBusquedaAux : empperBusqueda) {
			xslString.append(this.getPeritoRow(empperBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getPeritoHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(
				Y41bExcelGeneratorServiceImpl.getHeaderField(appMessageSource.getMessage("excel.nif", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(appMessageSource.getMessage("excel.nombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(appMessageSource.getMessage("excel.empresa", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(appMessageSource.getMessage("excel.thactuacion", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getSecretarioHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(
				Y41bExcelGeneratorServiceImpl.getHeaderField(appMessageSource.getMessage("excel.nif", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(appMessageSource.getMessage("excel.nombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(appMessageSource.getMessage("excel.thactuacion", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param empper
	 *            Empper
	 * @return String
	 */
	private String getPeritoRow(Empper empper) {

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// nif
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(empper.getPecif())));
		// nombre
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(empper.getPenombre())));
		// empresa
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(empper.getEstablecimiento().getEsnombre())));
		// Territorios actuacion
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(empper.getPeThActs())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en ooee
	 * 
	 * @param filtroJjaa
	 *            Jjaa
	 * @return String
	 */
	public String getJjaaExcel(Jjaa filtroJjaa) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getJjaaListTable(filtroJjaa));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filtroJjaa
	 *            Jjaa
	 * @return String
	 */
	private String getJjaaListTable(Jjaa filtroJjaa) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getJjaaHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("jacodigo");
		List<Jjaa> jjaaBusqueda = this.jjaaService.findAll(filtroJjaa, pagination);

		for (Jjaa jjaaBusquedaAux : jjaaBusqueda) {
			xslString.append(this.getJjaaRow(jjaaBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getJjaaHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(appMessageSource.getMessage("excel.codorg", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(appMessageSource.getMessage("excel.nombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(appMessageSource.getMessage("excel.nombreMunicipio", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param jjaa
	 *            Jjaa
	 * @return String
	 */
	private String getJjaaRow(Jjaa jjaa) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// oecodigo
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(jjaa.getJacodigo())));
		// Nombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(jjaa.getOrganismo().getNombreEs())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl
					.getField(Y41bUtils.normalizarVacio(jjaa.getOrganismo().getNombreEu())));
		}
		// municipio
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(jjaa.getOrganismo().getNombreMunicipio())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * @param filterAdhbandeja
	 *            Arbadhsol
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 */
	public String getAdhbandejaExcel(Arbadhsol filterAdhbandeja, CensoMonitor censoMonitor) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getAdhbandejaListTable(filterAdhbandeja, censoMonitor));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * 
	 * @param filterAdhbandeja
	 *            Arbadhsol
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 */
	private String getAdhbandejaListTable(Arbadhsol filterAdhbandeja, CensoMonitor censoMonitor) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getAdhbandejaHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("ADHFECALTA");

		List<Arbadhsol> adhbandejas = this.arbadhsolService.findBandeja(filterAdhbandeja, censoMonitor, pagination);

		for (Arbadhsol adhbandejaAux : adhbandejas) {
			xslString.append(this.getAdhbandejaRow(adhbandejaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param arbadhsol
	 *            Arbadhsol
	 * @return String
	 */
	private String getAdhbandejaRow(Arbadhsol arbadhsol) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// nmero Expediente
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(arbadhsol.getNumExpediente())));

		// tipo de solicitud
		row.append(Y41bExcelGeneratorServiceImpl.getField(this.appMessageSource
				.getMessage("excel.adhtipo.".concat(arbadhsol.getAdhtipo().toLowerCase()), null, locale)));

		// razn social
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(arbadhsol.getAdhesnom())));

		// nombre comercial
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(arbadhsol.getAdhesnoco())));

		// fecha alta
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(Y41bUtils
				.normalizarVacio(Y41bUtils.parseDateToString(arbadhsol.getAdhfecalta(), locale.getLanguage()))));
		// estado
		String estadoNormalizado = Y41bUtils.normalizarVacio(arbadhsol.getAdhestado());
		String estadoNB = "";
		if ("I".equals(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.pendientelocalizacion", null, locale);
		} else if ("L".equals(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.localizado", null, locale);
		} else if ("R".equals(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.errorlocalizacion", null, locale);
		} else if ("A".equals(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.estado.aceptada", null, locale);
		} else if ("X".equals(estadoNormalizado)) {
			estadoNB = appMessageSource.getMessage("excel.estado.rechazada", null, locale);
		} else {
			estadoNB = "";
		}
		row.append(getField(estadoNB));
		// Estado firma
		if (Y41bConstantes.VALOR_SI.equals(arbadhsol.getEstadoFirma())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(
					Y41bUtils.normalizarVacio(appMessageSource.getMessage("excel.pendientefirma", null, locale))));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio("")));
		}

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getAdhbandejaHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.numeroExpediente", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.tiposol", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.razonsocial", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nombrecomercial", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechasolicitud", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(appMessageSource.getMessage("excel.estado", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.comun.estadoFirma", null, locale)));
		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en Tclugaud
	 * 
	 * @param filtroTclugaud
	 *            Tclugaud
	 * @return String
	 */
	public String getTclugaudExcel(Tclugaud filtroTclugaud) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getTclugaudListTable(filtroTclugaud));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filtroTclugaud
	 *            Tclugaud
	 * @return String
	 */
	private String getTclugaudListTable(Tclugaud filtroTclugaud) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getTclugaudHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		pagination.setAscDsc("asc");
		pagination.setSort("t4codigo");
		List<Tclugaud> tclugaudBusqueda = this.tclugaudService.findAllBusqueda(filtroTclugaud, pagination);

		for (Tclugaud tclugaudBusquedaAux : tclugaudBusqueda) {
			xslString.append(this.getTclugaudRow(tclugaudBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getTclugaudHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.codorg", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nombre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.nombreMunicipio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.direccion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.fechabaja", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param tclugaud
	 *            Tclugaud
	 * @return String
	 */
	private String getTclugaudRow(Tclugaud tclugaud) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// oecodigo
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(tclugaud.getT4codigo())));
		// Nombre
		if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(tclugaud.getT4nombre())));
		} else {
			row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(tclugaud.getT4nombreeu())));
		}

		// // municipio
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(tclugaud.getT4municipio())));
		// // direccionCompleta
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(tclugaud.getDireccionCompleta())));
		// // fecha baja
		row.append(Y41bExcelGeneratorServiceImpl.getFieldFecha(
				Y41bUtils.normalizarVacio(Y41bUtils.parseDateToString(tclugaud.getT4fecbaja(), locale.getLanguage()))));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en aacc
	 * 
	 * @param filtroAacc
	 *            Aacc
	 * @return String
	 */
	public String getEmpresasAdheridasExcel(Integer tipoFiltro, Integer numAdhDesde, Integer numAdhHasta,
			List<String> listaCIF) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getEmpresasAdheridasListTable(tipoFiltro, numAdhDesde, numAdhHasta, listaCIF));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filtroAacc
	 *            Aacc
	 * @return String
	 */
	private String getEmpresasAdheridasListTable(Integer tipoFiltro, Integer numAdhDesde, Integer numAdhHasta,
			List<String> listaCIF) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(this.getEmpresasAdheridasHeaderRow());

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_500));
		pagination.setAscDsc("asc");
		pagination.setSort("AHNRDI");
		List<ExcelAdheridas> listaExcelAdheridas = this.excelAdheridasService.findAll(tipoFiltro, numAdhDesde,
				numAdhHasta, listaCIF, pagination);

		for (ExcelAdheridas excelAdheridaAux : listaExcelAdheridas) {
			xslString.append(this.gettEmpresasAdheridasRow(excelAdheridaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @return String
	 */
	private String getEmpresasAdheridasHeaderRow() {
		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.razonSocial", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.nombreComercial", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.cif", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.idioma", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.web", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.comentarios", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.descriptores", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.sede", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.fechaAdhesion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.numeroAdhesion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.tipoArbitraje", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.mediacion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.adhesionIndefinida", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.juntaArbitralId", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.juntaArbitral", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.fechaFinAdhesion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.fechaBajaEfectiva", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl.getHeaderField(
				this.appMessageSource.getMessage("excel.empAdh.fechaPeticionActualizacion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.codigoSector", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.nombreSectorEs", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.nombreSectorEu", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.codigoOrgEmpresarial", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.orgEmpresarial", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.contacto", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.fechaCierre", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.email", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.emailMultipleEs", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.emailMultipleEu", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.telefono1", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.telefono2", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.residenciaEn", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.pais", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.provincia", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.municipio", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.localidad", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.calle", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.portal", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.complementoDireccion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.direccionNoCapv", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.codigoPostal", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.direccionAntigua", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl.getHeaderField(
				this.appMessageSource.getMessage("excel.empAdh.fechaUltimaModificacion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl.getHeaderField(
				this.appMessageSource.getMessage("excel.empAdh.usuarioUltimaModificacion", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.representanteLegal", null, locale)));
		header.append(Y41bExcelGeneratorServiceImpl
				.getHeaderField(this.appMessageSource.getMessage("excel.empAdh.nifRepresentante", null, locale)));

		header.append("</tr>");
		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param excelAdheridas
	 *            ExcelAdheridas
	 * @return String
	 */
	private String gettEmpresasAdheridasRow(ExcelAdheridas excelAdheridas) {
		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getRazonSocial())));
		row.append(
				Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getNombreComercial())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getCif())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getIdioma())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getWeb())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getComentarios())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getDescriptores())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getSede())));
		row.append(
				Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getFechaAdhesion())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(
				(excelAdheridas.getNumeroAdhesion() == null ? "" : excelAdheridas.getNumeroAdhesion().toString()))));
		row.append(
				Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getTipoArbitraje())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getMediacion())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getAdhesionIndefinida())));
		row.append(
				Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getJuntaArbitralId())));
		row.append(
				Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getJuntaArbitral())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getFechaFinAdhesion())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getFechaBajaEfectiva())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getFechaPeticionActualizacion())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getCodigoSector())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getNombreSectorCastellano())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getNombreSectorEuskera())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getCodigoOrgEmpresarial())));
		row.append(
				Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getOrgEmpresarial())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getContacto())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getFechaCierre())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getEmail())));
		row.append(
				Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getEmailMultipleC())));
		row.append(
				Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getEmailMultipleE())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getTelefono1())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getTelefono2())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getResidenciaEn())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getPais())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getProvincia())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getMunicipio())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getLocalidad())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getCalle())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getPortal())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getComplementoDireccion())));
		row.append(
				Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getDireccionNocapv())));
		row.append(Y41bExcelGeneratorServiceImpl.getField(Y41bUtils.normalizarVacio(excelAdheridas.getCodigoPostal())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getDireccionAntigua())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getFechaUltimaModificacion())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getUsuarioUltimaModificacion())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getRepresentanteLegal())));
		row.append(Y41bExcelGeneratorServiceImpl
				.getField(Y41bUtils.normalizarVacio(excelAdheridas.getNiCifNieRepresentante())));

		row.append("</tr>");
		return row.toString();
	}

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param filterRemesa
	 *            RemesaBusqueda
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * @return String
	 */
	public String getRemesasExcel(RemesaBusqueda filterRemesa, CensoMonitor censoMonitor) {
		StringBuffer xslString = new StringBuffer();

		xslString.append("<table border='1'>");

		xslString.append(this.getRemesasListTable(filterRemesa, censoMonitor));

		xslString.append("</table>");

		return xslString.toString();
	}

	/**
	 * Obtiene datos.
	 * 
	 * @param filterRemesa
	 *            RemesaBusqueda
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * @return String
	 */
	private String getRemesasListTable(RemesaBusqueda filterRemesa, CensoMonitor censoMonitor) {
		StringBuffer xslString = new StringBuffer();

		// add header
		xslString.append(getRemesasHeaderRow(filterRemesa));

		Pagination pagination = new Pagination();
		pagination.setRows(Long.valueOf(Y41bConstantes.NUM_2000));
		List<Remesa> listRemesasBusqueda = this.remesaService.findAllRemesasLikeExcel(filterRemesa, pagination, false);

		for (Remesa remesaBusquedaAux : listRemesasBusqueda) {
			xslString.append(getRemesasRow(remesaBusquedaAux));
		}

		return xslString.toString();
	}

	/**
	 * Generar cabecera.
	 * 
	 * @param filterRemesa
	 *            RemesaBusqueda
	 * @return String
	 */
	private String getRemesasHeaderRow(RemesaBusqueda filterRemesa) {

		// Obtener el mensaje dependiendo del idioma
		Locale locale = LocaleContextHolder.getLocale();
		StringBuffer header = new StringBuffer();
		header.append("<tr style='BACKGROUND-COLOR: #808080;FONT-WEIGHT: bold;color: #FFFFFF'>");

		if (filterRemesa.getRmtipo().equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {

			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.tipoExpediente", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.codigo", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.tramitador", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.fechaGeneracion", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.fechaEmision", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.estado", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.fechaActualizacion", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.idColeccionAA66", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.codColeccionAA66", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.idRemesaAA66", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.codRemesaAA66", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.descError", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.expediente", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.tramitadorEnvio", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.acto", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.destinatario", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.CP", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.provincia", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.municipio", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.fecha", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.estadoEnvio", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.situacionEnvio", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.situacionAcuse", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.tramitacionAcuse", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.situacionCorreos", null, locale)));
			header.append(
					getHeaderField(appMessageSource.getMessage("excel.remesa.idEnvioDevueltoAA66", null, locale)));
			header.append(
					getHeaderField(appMessageSource.getMessage("excel.remesa.codEnvioDevueltoAA66", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.codBarras", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.descErrorEnvio", null, locale)));
			header.append("</tr>");

		} else if (filterRemesa.getRmtipo().equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION)) {

			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.tipoExpediente", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.codigo", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.tramitador", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.fechaGeneracion", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.fechaEmision", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.estado", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.expediente", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.tramitadorEnvio", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.acto", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.destinatario", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.CP", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.provincia", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.municipio", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.fecha", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.situacionAcuse", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.tramitacionAcuse", null, locale)));

		} else if (filterRemesa.getRmtipo().equalsIgnoreCase(Y41bConstantes.TRAMITE_COMUNICACION)) {

			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.tipoExpediente", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.codigo", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.tramitador", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.fechaGeneracion", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.fechaEmision", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.estado", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.expediente", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.tramitadorEnvio", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.destinatario", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.CP", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.provincia", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.municipio", null, locale)));
			header.append(getHeaderField(appMessageSource.getMessage("excel.remesa.fecha", null, locale)));
		}

		return header.toString();
	}

	/**
	 * Generar fila de datos.
	 * 
	 * @param remesaBusquedaAux
	 *            Remesa
	 * @return String
	 */
	private String getRemesasRow(Remesa remesaBusquedaAux) {

		Locale locale = LocaleContextHolder.getLocale();

		StringBuffer row = new StringBuffer();
		row.append("<tr>");

		// //////////////////////////////////////////////////////////////////////////////////////////////////
		// //////////////////////////////////////////////////////////////////////////////////////////////////

		if (remesaBusquedaAux.getRmtipo().equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION_ELECTRONICA)) {

			// tipoExpediente

			// row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux
			// .getRmtipoproc())));

			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtpnombres())));
			} else {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtpnombreu())));
			}

			// codigo
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmcodigo())));

			// tramitador

			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtramitador())));

			// fechaGeneracion
			row.append(getFieldFecha(Y41bUtils.normalizarVacio(
					Y41bUtils.parseDateToString(remesaBusquedaAux.getRmfechageneracion(), locale.getLanguage()))));
			// fechaEmision
			row.append(getFieldFecha(Y41bUtils.normalizarVacio(
					Y41bUtils.parseDateToString(remesaBusquedaAux.getRmfechaemision(), locale.getLanguage()))));

			// estado

			String strEstado = Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmestado());

			StringBuffer strEstadoDesc = new StringBuffer(Y41bConstantes.NUM_3000);

			if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_PENDIENTE)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.pendiente", null, locale));
			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_GENERADA)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.generada", null, locale));
			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_EMITIDA)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.emitida", null, locale));
			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ERRONEA)
					|| strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ELIMINACION_ERRONEA)
					|| strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS)) {

				if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ERRONEA)) {
					strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.erronea", null, locale));
				}
				if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ELIMINACION_ERRONEA)) {
					strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.erroneaElim", null, locale));
				}
				if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS)) {
					strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.erroneaResp", null, locale));
				}

				// Para sacar el error a continuacion como en la tabla del
				// aplicativo, descomentar
				// if (remesaBusquedaAux.getRmdesErroreu() != null
				// && remesaBusquedaAux.getRmdesErroreu() != "") {
				// strEstadoDesc.append(" (");
				// if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				// strEstadoDesc.append(remesaBusquedaAux.getRmdesErrores());
				// } else {
				// strEstadoDesc.append(remesaBusquedaAux.getRmdesErroreu());
				// }
				// strEstadoDesc.append(")");
				// }

			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_CERRADA)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.cerrada", null, locale));
			}

			row.append(getField(strEstadoDesc.toString()));

			// ////////////
			// fechaActualizacion
			row.append(getFieldFecha(Y41bUtils.normalizarVacio(
					Y41bUtils.parseDateToString(remesaBusquedaAux.getRmFechaActualizacion(), locale.getLanguage()))));

			// idColeccionAA66
			String strIdColeccionAA66 = "";
			strIdColeccionAA66 = (remesaBusquedaAux.getRmidColeccionAA66() == 0) ? ""
					: remesaBusquedaAux.getRmidColeccionAA66().toString();

			row.append(getField(Y41bUtils.normalizarVacio(strIdColeccionAA66)));

			// codColeccionAA66
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmcodColeccionAA66())));

			// idRemesaAA66
			String strIdRemesaAA66 = "";
			strIdRemesaAA66 = (remesaBusquedaAux.getRmidRemesaAA66() == 0) ? ""
					: remesaBusquedaAux.getRmidRemesaAA66().toString();

			row.append(getField(Y41bUtils.normalizarVacio(strIdRemesaAA66)));

			// codRemesaAA66
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmcodRemesaAA66())));

			// descError
			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmdesErrores())));
			} else {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmdesErroreu())));
			}

			// num expediente
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmnumexpediente())));

			// tramitadorEnvio
			// row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux
			// .getRmtramitadorenviocod())));

			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtramitadorenvionb())));

			// acto
			String strActo = "";
			if (remesaBusquedaAux.getRmacto() != null) {
				if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_SUBSANACION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.subsanacion", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_ALEGACION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.alegacion", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_REQUERIMIENTO)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.requerimiento", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_RESOLUCION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.resolucion", null, locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_RESOLUCION_RECURSO)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.resolucionrecurso", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_RECURSO)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.recurso", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_DESISTIMIENTO)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.desistimiento", null, locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_ACEPTACION_RENUNCIA)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.aceptacionrenuncia", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_COMUNICACION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.comunicacion", null, locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_PROPUESTA_RESOLUCION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.propuestaresolucion", null,
							locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_RESOL_COMPLEMENTARIA)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.resolucioncomplementaria", null,
							locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_SOL_INCOACION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.solincoacion", null, locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_RESOLUCIONRECURSOACEPTDEN)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.resolucionrecursoaceptden", null,
							locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_DESC_COMUNICACION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.subsanacion", null, locale);
				} // EVOLUTIVO 0135083 2.4
				else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_SAN_REQUERIMIENTOINFO)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.requerimientoInfo", null, locale);
				} // 0150948: Evolutivo Arbitraje Marzo-2020
					// 2.5
				else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_COPIA_COMPULSADA)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.copiaCompulsada", null, locale);
				}
			}
			row.append(getField(Y41bUtils.normalizarVacio(strActo)));

			// destinatario
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmdestinatario())));

			// CP
			row.append(getFieldTexto(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmCP())));

			// provincia
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmProvincia())));

			// municipio
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmMunicipio())));

			// fecha
			row.append(getFieldFecha(Y41bUtils.normalizarVacio(
					Y41bUtils.parseDateToString(remesaBusquedaAux.getRmFecha(), locale.getLanguage()))));

			// estadoEnvio
			String strEstadoenvio = "";
			if (remesaBusquedaAux.getRmEstadoEnvio() != null) {
				if (remesaBusquedaAux.getRmEstadoEnvio()
						.equalsIgnoreCase(Y41bConstantes.AA66_ENVIO_SITUACION_RESPONDIDO_POR_CORREOS)) {
					strEstadoenvio = appMessageSource.getMessage("excel.remesa.estadoenvio.respondido", null, locale);
				} else if (remesaBusquedaAux.getRmEstadoEnvio()
						.equalsIgnoreCase(Y41bConstantes.AA66_ENVIO_SITUACION_ERROR)) {
					strEstadoenvio = appMessageSource.getMessage("excel.remesa.estadoenvio.erroneo", null, locale);
				}
			}
			row.append(getField(Y41bUtils.normalizarVacio(strEstadoenvio)));

			// situacionEnvio
			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmSituacionEnvioes())));
			} else {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmSituacionEnvioeu())));
			}

			// situacionAcuse
			String strSituacionAcuse = "";
			if (remesaBusquedaAux.getRmSituacionAcuse() != null) {
				if (remesaBusquedaAux.getRmSituacionAcuse().equalsIgnoreCase(Y41bConstantes.ESTADO_ACUSE_ACEPTADO)) {
					strSituacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.aceptado", null, locale);
				} else if (remesaBusquedaAux.getRmSituacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_ACUSE_NO_ENTREGADO)) {
					strSituacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.noentregado", null, locale);
				} else if (remesaBusquedaAux.getRmSituacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_ACUSE_RECHAZADO)) {
					strSituacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.rechazado", null, locale);
				}
			}
			row.append(getField(Y41bUtils.normalizarVacio(strSituacionAcuse)));

			// tramitacionAcuse
			String strTramitacionAcuse = "";

			if (remesaBusquedaAux.getRmTramitacionAcuse() != null) {
				if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.pendientefirma", null,
							locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.pendientelocalizacion", null,
							locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.localizado", null, locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.errorlocalizacion", null,
							locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.entramitacion", null, locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.firmado", null, locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.tramitado", null, locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.firmadenegada", null, locale);
				}
			}
			row.append(getField(Y41bUtils.normalizarVacio(strTramitacionAcuse)));

			// situacionCorreos

			StringBuffer strSituacionCorreos = new StringBuffer(Y41bConstantes.NUM_3000);

			strSituacionCorreos.append(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmSituacionCorreoscod()));

			if (remesaBusquedaAux.getRmSituacionCorreoses() != null
					|| remesaBusquedaAux.getRmSituacionCorreoseu() != null) {
				strSituacionCorreos.append(" (");
				if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
					strSituacionCorreos.append(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmSituacionCorreoses()));
				} else {
					strSituacionCorreos.append(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmSituacionCorreoseu()));
				}
				strSituacionCorreos.append(")");
			}

			row.append(getField(Y41bUtils.normalizarVacio(strSituacionCorreos.toString())));

			// idEnvioDevueltoAA66
			String strIdEnvioDevueltoAA66 = "";
			strIdEnvioDevueltoAA66 = (remesaBusquedaAux.getRmIdEnvioDevueltoAA66() == 0) ? ""
					: remesaBusquedaAux.getRmIdEnvioDevueltoAA66().toString();

			row.append(getField(Y41bUtils.normalizarVacio(strIdEnvioDevueltoAA66)));

			// codEnvioDevueltoAA66
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmCodEnvioDevueltoAA66())));

			// codBarras
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmCodigoBarras())));

			// descErrorEnvio
			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmDescEnvioes())));
			} else {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmDescEnvioeu())));
			}
		} else if (remesaBusquedaAux.getRmtipo().equalsIgnoreCase(Y41bConstantes.TRAMITE_NOTIFICACION)) {

			//
			// tipoExpediente

			// row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux
			// .getRmtipoproc())));

			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtpnombres())));
			} else {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtpnombreu())));
			}

			// codigo
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmcodigo())));

			// tramitador

			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtramitador())));

			// fechaGeneracion
			row.append(getFieldFecha(Y41bUtils.normalizarVacio(
					Y41bUtils.parseDateToString(remesaBusquedaAux.getRmfechageneracion(), locale.getLanguage()))));
			// fechaEmision
			row.append(getFieldFecha(Y41bUtils.normalizarVacio(
					Y41bUtils.parseDateToString(remesaBusquedaAux.getRmfechaemision(), locale.getLanguage()))));

			// estado

			String strEstado = Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmestado());

			StringBuffer strEstadoDesc = new StringBuffer(Y41bConstantes.NUM_3000);

			if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_PENDIENTE)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.pendiente", null, locale));
			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_GENERADA)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.generada", null, locale));
			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_EMITIDA)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.emitida", null, locale));
			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ERRONEA)
					|| strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ELIMINACION_ERRONEA)
					|| strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS)) {

				if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ERRONEA)) {
					strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.erronea", null, locale));
				}
				if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ELIMINACION_ERRONEA)) {
					strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.erroneaElim", null, locale));
				}
				if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS)) {
					strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.erroneaResp", null, locale));
				}

				// Para sacar el error a continuacion como en la tabla del
				// aplicativo, descomentar
				// if (remesaBusquedaAux.getRmdesErroreu() != null
				// && remesaBusquedaAux.getRmdesErroreu() != "") {
				// strEstadoDesc.append(" (");
				// if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				// strEstadoDesc.append(remesaBusquedaAux.getRmdesErrores());
				// } else {
				// strEstadoDesc.append(remesaBusquedaAux.getRmdesErroreu());
				// }
				// strEstadoDesc.append(")");
				// }

			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_CERRADA)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.cerrada", null, locale));
			}

			row.append(getField(strEstadoDesc.toString()));

			// num expediente
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmnumexpediente())));

			// tramitadorEnvio
			// row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux
			// .getRmtramitadorenviocod())));

			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtramitadorenvionb())));

			// acto
			String strActo = "";
			if (remesaBusquedaAux.getRmacto() != null) {
				if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_SUBSANACION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.subsanacion", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_ALEGACION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.alegacion", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_REQUERIMIENTO)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.requerimiento", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_RESOLUCION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.resolucion", null, locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_RESOLUCION_RECURSO)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.resolucionrecurso", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_RECURSO)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.recurso", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_DESISTIMIENTO)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.desistimiento", null, locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_ACEPTACION_RENUNCIA)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.aceptacionrenuncia", null, locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_COMUNICACION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.comunicacion", null, locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_PROPUESTA_RESOLUCION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.propuestaresolucion", null,
							locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_RESOL_COMPLEMENTARIA)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.resolucioncomplementaria", null,
							locale);
				} else if (remesaBusquedaAux.getRmacto().equalsIgnoreCase(Y41bConstantes.NOTIFICACION_SOL_INCOACION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.solincoacion", null, locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_RESOLUCIONRECURSOACEPTDEN)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.resolucionrecursoaceptden", null,
							locale);
				} else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_DESC_COMUNICACION)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.subsanacion", null, locale);
				} // EVOLUTIVO 0135083 2.4
				else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.NOTIFICACION_SAN_REQUERIMIENTOINFO)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.requerimientoInfo", null, locale);
				} // 0150948: Evolutivo Arbitraje Marzo-2020
					// 2.5
				else if (remesaBusquedaAux.getRmacto()
						.equalsIgnoreCase(Y41bConstantes.TIPO_NOTIFICACION_ARBITRAJE_COPIA_COMPULSADA)) {
					strActo = appMessageSource.getMessage("excel.remesa.notificacion.copiaCompulsada", null, locale);
				}
			}
			row.append(getField(Y41bUtils.normalizarVacio(strActo)));

			// destinatario
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmdestinatario())));

			// CP
			row.append(getFieldTexto(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmCP())));

			// provincia
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmProvincia())));

			// municipio
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmMunicipio())));

			// fecha
			row.append(getFieldFecha(Y41bUtils.normalizarVacio(
					Y41bUtils.parseDateToString(remesaBusquedaAux.getRmFecha(), locale.getLanguage()))));

			// situacionAcuse
			String strSituacionAcuse = "";
			if (remesaBusquedaAux.getRmSituacionAcuse() != null) {
				if (remesaBusquedaAux.getRmSituacionAcuse().equalsIgnoreCase(Y41bConstantes.ESTADO_ACUSE_ACEPTADO)) {
					strSituacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.aceptado", null, locale);
				} else if (remesaBusquedaAux.getRmSituacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_ACUSE_NO_ENTREGADO)) {
					strSituacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.noentregado", null, locale);
				} else if (remesaBusquedaAux.getRmSituacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_ACUSE_RECHAZADO)) {
					strSituacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.rechazado", null, locale);
				}
			}
			row.append(getField(Y41bUtils.normalizarVacio(strSituacionAcuse)));

			// tramitacionAcuse
			String strTramitacionAcuse = "";

			if (remesaBusquedaAux.getRmTramitacionAcuse() != null) {
				if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.pendientefirma", null,
							locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_PENDIENTELOCALIZACION)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.pendientelocalizacion", null,
							locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_LOCALIZADO)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.localizado", null, locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_ERRORLOCALIZACION)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.errorlocalizacion", null,
							locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.entramitacion", null, locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_FIRMADO)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.firmado", null, locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.tramitado", null, locale);
				} else if (remesaBusquedaAux.getRmTramitacionAcuse()
						.equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA)) {
					strTramitacionAcuse = appMessageSource.getMessage("excel.remesa.acuse.firmadenegada", null, locale);
				}
			}
			row.append(getField(Y41bUtils.normalizarVacio(strTramitacionAcuse)));

			//

		} else if (remesaBusquedaAux.getRmtipo().equalsIgnoreCase(Y41bConstantes.TRAMITE_COMUNICACION)) {
			// tipoExpediente

			// row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux
			// .getRmtipoproc())));

			if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtpnombres())));
			} else {
				row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtpnombreu())));
			}

			// codigo
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmcodigo())));

			// tramitador

			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtramitador())));

			// fechaGeneracion
			row.append(getFieldFecha(Y41bUtils.normalizarVacio(
					Y41bUtils.parseDateToString(remesaBusquedaAux.getRmfechageneracion(), locale.getLanguage()))));
			// fechaEmision
			row.append(getFieldFecha(Y41bUtils.normalizarVacio(
					Y41bUtils.parseDateToString(remesaBusquedaAux.getRmfechaemision(), locale.getLanguage()))));

			// estado

			String strEstado = Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmestado());

			StringBuffer strEstadoDesc = new StringBuffer(Y41bConstantes.NUM_3000);

			if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_PENDIENTE)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.pendiente", null, locale));
			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_GENERADA)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.generada", null, locale));
			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_EMITIDA)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.emitida", null, locale));
			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ERRONEA)
					|| strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ELIMINACION_ERRONEA)
					|| strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS)) {

				if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ERRONEA)) {
					strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.erronea", null, locale));
				}
				if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_ELIMINACION_ERRONEA)) {
					strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.erroneaElim", null, locale));
				}
				if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_EMITIDA_RESPUESTAS_ERRONEAS)) {
					strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.erroneaResp", null, locale));
				}

				// Para sacar el error a continuacion como en la tabla del
				// aplicativo, descomentar
				// if (remesaBusquedaAux.getRmdesErroreu() != null
				// && remesaBusquedaAux.getRmdesErroreu() != "") {
				// strEstadoDesc.append(" (");
				// if (Y41bConstantes.CASTELLANO.equals(locale.getLanguage())) {
				// strEstadoDesc.append(remesaBusquedaAux.getRmdesErrores());
				// } else {
				// strEstadoDesc.append(remesaBusquedaAux.getRmdesErroreu());
				// }
				// strEstadoDesc.append(")");
				// }

			} else if (strEstado.equalsIgnoreCase(Y41bConstantes.ESTADO_REMESA_CERRADA)) {
				strEstadoDesc.append(appMessageSource.getMessage("excel.remesa.estado.cerrada", null, locale));
			}

			row.append(getField(strEstadoDesc.toString()));

			// num expediente
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmnumexpediente())));

			// tramitadorEnvio
			// row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux
			// .getRmtramitadorenviocod())));

			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmtramitadorenvionb())));

			// destinatario
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmdestinatario())));

			// CP
			row.append(getFieldTexto(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmCP())));

			// provincia
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmProvincia())));

			// municipio
			row.append(getField(Y41bUtils.normalizarVacio(remesaBusquedaAux.getRmMunicipio())));

			// fecha
			row.append(getFieldFecha(Y41bUtils.normalizarVacio(
					Y41bUtils.parseDateToString(remesaBusquedaAux.getRmFecha(), locale.getLanguage()))));

		}
		// //////////////////////////////////////////////////////////////////////////////////////////////////
		// //////////////////////////////////////////////////////////////////////////////////////////////////

		row.append("</tr>");
		return row.toString();
	}

}
