package com.ejie.y41b.service;

import java.util.Date;
import java.util.List;

import com.ejie.y41b.model.Aacc;
import com.ejie.y41b.model.AaccEuskadi;
import com.ejie.y41b.model.Acta;
import com.ejie.y41b.model.Alerta;
import com.ejie.y41b.model.Arbadhsol;
import com.ejie.y41b.model.Arbbandeja;
import com.ejie.y41b.model.Arbitro;
import com.ejie.y41b.model.Arbpropbandeja;
import com.ejie.y41b.model.BandejaFirma;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.BandejaInspeccionesFiltro;
import com.ejie.y41b.model.BandejaSolicitudes;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CargaTrabajo;
import com.ejie.y41b.model.CensoMonitor;
import com.ejie.y41b.model.ComunicacionSoivre;
import com.ejie.y41b.model.Consulta;
import com.ejie.y41b.model.Consumidor;
import com.ejie.y41b.model.Empper;
import com.ejie.y41b.model.EstablecimSector;
import com.ejie.y41b.model.Establecimiento;
import com.ejie.y41b.model.FiltroArbitraje;
import com.ejie.y41b.model.FiltroSanciones;
import com.ejie.y41b.model.InspeccionesPropBandeja;
import com.ejie.y41b.model.Jjaa;
import com.ejie.y41b.model.Ooee;
import com.ejie.y41b.model.PagosBusqueda;
import com.ejie.y41b.model.RemesaBusqueda;
import com.ejie.y41b.model.Sanbandeja;
import com.ejie.y41b.model.Sanpropbandeja;
import com.ejie.y41b.model.Secretar;
import com.ejie.y41b.model.SolicitudBusqueda;
import com.ejie.y41b.model.Tclugaud;

/**
 *  
 */
public interface Y41bExcelGeneratorService {

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en consultas
	 * 
	 * @param consulta
	 *            Consulta
	 * @return String
	 */
	String getConsultasExcel(Consulta consulta);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en campanhas
	 * 
	 * @param campanha
	 *            Campanha
	 * @return String
	 */
	public String getCampanhasExcel(Campanha campanha);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en alertas
	 * 
	 * @param alerta
	 *            Alerta
	 * @return String
	 */
	public String getAlertasExcel(Alerta alerta);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en comunicaciones soivre
	 * 
	 * @param comunicacionSoivre
	 *            ComunicacionSoivre
	 * @return String
	 */
	public String getComunicacionesSoivreExcel(ComunicacionSoivre comunicacionSoivre);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param solicitudBusqueda
	 *            SolicitudBusqueda
	 * @return String
	 */
	public String getSolicitudesExcel(SolicitudBusqueda solicitudBusqueda);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en inspecciones
	 * 
	 * @param acta
	 *            Acta
	 * @return String
	 */
	public String getInspeccionesExcel(Acta acta);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en consumidores
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return String
	 */
	public String getConsumidoresExcel(Consumidor consumidor);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en establecimientos
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return String
	 */
	public String getEstablecimientosExcel(Establecimiento establecimiento, EstablecimSector establecimSector);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en establecimientos
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param establecimSector
	 *            EstablecimSector
	 * @return String
	 */
	public String getEstablecimientosExcelExtendido(Establecimiento establecimiento, EstablecimSector establecimSector);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en sanciones
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return String
	 */
	public String getSancionesExcel(FiltroSanciones filtroSanciones);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en sanciones
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return String
	 */
	public String getArbitrajesExcel(FiltroArbitraje filtroArbitraje);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en consultas
	 * 
	 * @param consulta
	 *            Consulta
	 * @return String
	 */
	String getConsultasExcelBandeja(Consulta consulta);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandeja(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaFirma
	 *            BandejaFirma
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 * @throws Exception
	 */
	public String getFirmasExcelBandeja(BandejaFirma bandejaFirma, CensoMonitor censoMonitor) throws Exception;

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param filterSanpropbandeja
	 *            Sanpropbandeja
	 * 
	 * 
	 * @return String
	 */
	public String getSanPropExcelBandeja(Sanpropbandeja filterSanpropbandeja);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param filterSanpropbandeja
	 *            Sanpropbandeja
	 * 
	 * 
	 * @return String
	 */
	public String getArbPropExcelBandeja(Arbpropbandeja filterArbpropbandeja);

	/**
	 * @param filtroPagos
	 *            PagosBusqueda
	 * @return String
	 */
	public String getPagosExcel(PagosBusqueda filtroPagos);

	/**
	 * @param filtroPagos
	 *            PagosBusqueda
	 * @return String
	 */
	public String getOtrosIngresosExcel(PagosBusqueda filtroPagos);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en via apremio
	 * 
	 * @param filtroSanciones
	 *            FiltroSanciones
	 * @return String
	 */
	public String getViaApremioExcel(FiltroSanciones filtroSanciones);

	/**
	 * @param filterSanbandeja
	 *            Sanbandeja
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	String getSanbandejaExcel(Sanbandeja filterSanbandeja, CensoMonitor censoMonitor, String perfil);

	/**
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	String getBandejaCampanhasExcel(CensoMonitor censoMonitor, String perfil);

	/**
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	public String getBandejaCampanhasSSCCExcel(CensoMonitor censoMonitor, String perfil);

	/**
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	String getBandejaAlertasExcel(CensoMonitor censoMonitor, String perfil);

	/**
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	String getBandejaComunicacionesSoivreExcel(CensoMonitor censoMonitor, String perfil);

	/**
	 * @param inspeccionesPropBandeja
	 *            InspeccionesPropBandeja
	 * @return String
	 */
	String getBandejaPropuestasInspeccionesExcel(InspeccionesPropBandeja inspeccionesPropBandeja);

	/**
	 * 
	 * @param bandejaInspecciones
	 *            BandejaInspecciones
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param bandejaInspeccionesFiltro
	 *            BandejaInspeccionesFiltro
	 * @return String
	 */
	public String getBandejaInspeccionesExcel(BandejaInspecciones bandejaInspecciones, CensoMonitor censoMonitor,
			BandejaInspeccionesFiltro bandejaInspeccionesFiltro);

	/**
	 * @param filterArbbandeja
	 *            Arbbandeja
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param perfil
	 *            String
	 * @return String
	 */
	String getArbbandejaExcel(Arbbandeja filterArbbandeja, CensoMonitor censoMonitor, String perfil);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaAdministrativo(BandejaSolicitudes bandejaSolicitudes,
			CensoMonitor censoMonitor, Date trFechaDesde, Date trFechaHasta, String excluirAcuses);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param conStandBy
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaENYPD(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, Boolean conStandBy, String excluirAcuses);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * 
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaECTP(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaECTPO(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param conAsignacionResp
	 *            Boolean
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaEONYPD(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, Boolean conAsignacionResp, String excluirAcuses);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param bandejaSolicitudes
	 *            BandejaSolicitudes
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param trFechaDesde
	 *            Date
	 * @param trFechaHasta
	 *            Date
	 * @param excluirAcuses
	 *            String
	 * 
	 * @return String
	 */
	public String getSolicitudesExcelBandejaEOCTP(BandejaSolicitudes bandejaSolicitudes, CensoMonitor censoMonitor,
			Date trFechaDesde, Date trFechaHasta, String excluirAcuses);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en ooee
	 * 
	 * @param filterOoee
	 *            Ooee
	 * @return String
	 */
	public String getOoeeExcel(Ooee filterOoee);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en aacc
	 * 
	 * @param filterAacc
	 *            Aacc
	 * @return String
	 */
	public String getAaccExcel(Aacc filterAacc);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en aacc
	 * 
	 * @param filterAaccEuskadi
	 *            AaccEuskadi
	 * @return String
	 */
	public String getAaccEuskadiExcel(AaccEuskadi filterAaccEuskadi);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en arbitro
	 * 
	 * @param filterArbitro
	 *            Arbitro
	 * @return String
	 */
	public String getArbitroExcel(Arbitro filterArbitro);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en perito
	 * 
	 * @param filterEmpper
	 *            Empper
	 * @return String
	 */
	public String getPeritoExcel(Empper filterEmpper);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en perito
	 * 
	 * @param filterJjaa
	 *            Jjaa
	 * @return String
	 */
	public String getJjaaExcel(Jjaa filterJjaa);

	/**
	 * @param filterAdhbandeja
	 *            Arbadhsol
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return String
	 */
	String getAdhbandejaExcel(Arbadhsol filterAdhbandeja, CensoMonitor censoMonitor);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en Tclugaud
	 * 
	 * @param filterTclugaud
	 *            Tclugaud
	 * @return String
	 */
	String getTclugaudExcel(Tclugaud filterTclugaud);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en aacc
	 * 
	 * @param filtroSecretar
	 *            Secretar
	 * @return String
	 */
	String getSecretarExcel(Secretar filtroSecretar);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en aacc
	 * 
	 * @param filtroAacc
	 *            Aacc
	 * @return String
	 */
	public String getEmpresasAdheridasExcel(Integer tipoFiltro, Integer numAdhDesde, Integer numAdhHasta,
			List<String> listaCIF);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en solicitudes
	 * 
	 * @param filterRemesa
	 *            RemesaBusqueda
	 * @param censoMonitor
	 *            CensoMonitor
	 * 
	 * @return String
	 */
	public String getRemesasExcel(RemesaBusqueda filterRemesa, CensoMonitor censoMonitor);

	/**
	 * Genera un tabla html para devolver como excel los elementos seleccionados
	 * en carga de trabajo
	 * 
	 * @param cargaTrabajo
	 *            CargaTrabajo
	 * @return String
	 */
	public String getCargaTrabajoExcel(CargaTrabajo cargaTrabajo);
}
