package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.UnidadesDir3Dao;
import com.ejie.y41b.model.UnidadesDir3;

/**
 * UnidadesDir3ServiceImpl  
 * 
 *  
 */

@Service(value = "unidadesDir3Service")
public class UnidadesDir3ServiceImpl implements UnidadesDir3Service {

	@Autowired
	private UnidadesDir3Dao unidadesDir3Dao;

	/**
	 * Inserts a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public UnidadesDir3 add(UnidadesDir3 unidadesDir3) {
		return this.unidadesDir3Dao.add(unidadesDir3);
	}

	/**
	 * Updates a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public UnidadesDir3 update(UnidadesDir3 unidadesDir3) {
		return this.unidadesDir3Dao.update(unidadesDir3);
	}

	/**
	 * Finds a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	public UnidadesDir3 find(UnidadesDir3 unidadesDir3) {
		return (UnidadesDir3) this.unidadesDir3Dao.find(unidadesDir3);
	}

	/**
	 * Deletes a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(UnidadesDir3 unidadesDir3) {
		this.unidadesDir3Dao.remove(unidadesDir3);
	}

	/**
	 * Finds a list of rows in the UnidadesDir3 table.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @return List<UnidadesDir3>
	 */
	public List<UnidadesDir3> findAll(UnidadesDir3 unidadesDir3, Pagination pagination) {
		return (List<UnidadesDir3>) this.unidadesDir3Dao.findAll(unidadesDir3, pagination);
	}

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<UnidadesDir3>
	 */
	public List<UnidadesDir3> findAllLike(UnidadesDir3 unidadesDir3, Pagination pagination, Boolean startsWith) {
		return (List<UnidadesDir3>) this.unidadesDir3Dao.findAllLike(unidadesDir3, pagination, startsWith);
	}

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<UnidadesDir3>
	 */
	public List<UnidadesDir3> findAllLikeOficinas(UnidadesDir3 unidadesDir3, Pagination pagination,
			Boolean startsWith) {
		return (List<UnidadesDir3>) this.unidadesDir3Dao.findAllLikeOficinas(unidadesDir3, pagination, startsWith);
	}

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 * 
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(UnidadesDir3 unidadesDir3, Boolean startsWith) {
		return this.unidadesDir3Dao.findAllLikeCount(unidadesDir3, startsWith);
	}

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 * 
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCountOficinas(UnidadesDir3 unidadesDir3, Boolean startsWith) {
		return this.unidadesDir3Dao.findAllLikeCountOficinas(unidadesDir3, startsWith);
	}

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<UnidadesDir3>
	 */
	public List<UnidadesDir3> findAllLikeDir3(UnidadesDir3 unidadesDir3, Pagination pagination, Boolean startsWith) {
		return (List<UnidadesDir3>) this.unidadesDir3Dao.findAllLikeDir3(unidadesDir3, pagination, startsWith);
	}

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 * 
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeDir3Count(UnidadesDir3 unidadesDir3, Boolean startsWith) {
		return this.unidadesDir3Dao.findAllLikeDir3Count(unidadesDir3, startsWith);
	}

}
