package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.UnidadesDir3;

/**
 * UnidadesDir3Service  
 * 
 *  
 */

public interface UnidadesDir3Service {

	/**
	 * Inserts a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	UnidadesDir3 add(UnidadesDir3 unidadesDir3);

	/**
	 * Updates a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	UnidadesDir3 update(UnidadesDir3 unidadesDir3);

	/**
	 * Finds a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @return UnidadesDir3
	 */
	UnidadesDir3 find(UnidadesDir3 unidadesDir3);

	/**
	 * Deletes a single row in the UnidadesDir3 table.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 */
	void remove(UnidadesDir3 unidadesDir3);

	/**
	 * Finds a list of rows in the UnidadesDir3 table.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @return List<UnidadesDir3>
	 */
	List<UnidadesDir3> findAll(UnidadesDir3 unidadesDir3, Pagination pagination);

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param tableRequestDto
	 *            TableRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<UnidadesDir3>
	 */
	List<UnidadesDir3> findAllLike(UnidadesDir3 unidadesDir3, Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<UnidadesDir3>
	 */
	public List<UnidadesDir3> findAllLikeOficinas(UnidadesDir3 unidadesDir3, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 * 
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(UnidadesDir3 unidadesDir3, Boolean startsWith);

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 * 
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCountOficinas(UnidadesDir3 unidadesDir3, Boolean startsWith);

	/**
	 * Finds rows in the UnidadesDir3 table using like.
	 *
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List<UnidadesDir3>
	 */
	public List<UnidadesDir3> findAllLikeDir3(UnidadesDir3 unidadesDir3, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the UnidadesDir3 table using like.
	 * 
	 * @param unidadesDir3
	 *            UnidadesDir3
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeDir3Count(UnidadesDir3 unidadesDir3, Boolean startsWith);
}
