package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TribunalDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tribunal;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * TribunalServiceImpl  
 * 
 *  
 */

@Service(value = "tribunalService")
public class TribunalServiceImpl implements TribunalService {

	@Autowired
	private TribunalDao tribunalDao;

	/**
	 * Inserts a single row in the Tribunal table.
	 * 
	 * @param tribunal
	 *            Tribunal
	 * @return Tribunal
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tribunal add(Tribunal tribunal) {
		try {
			return this.tribunalDao.add(tribunal);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException("error.tribunal.DuplicateKeyException",
					true, e);
		}
	}

	/**
	 * Updates a single row in the Tribunal table.
	 * 
	 * @param tribunal
	 *            Tribunal
	 * @return Tribunal
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tribunal update(Tribunal tribunal) {
		return this.tribunalDao.update(tribunal);
	}

	/**
	 * Finds a single row in the Tribunal table.
	 * 
	 * @param tribunal
	 *            Tribunal
	 * @return Tribunal
	 */
	public Tribunal find(Tribunal tribunal) {
		return (Tribunal) this.tribunalDao.find(tribunal);
	}

	/**
	 * Finds a List of rows in the Tribunal table.
	 * 
	 * @param tribunal
	 *            Tribunal
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tribunal> findAll(Tribunal tribunal, Pagination pagination) {
		return (List<Tribunal>) this.tribunalDao.findAll(tribunal, pagination);
	}

	/**
	 * Counts rows in the Tribunal table.
	 * 
	 * @param tribunal
	 *            Tribunal
	 * @return Long
	 */
	public Long findAllCount(Tribunal tribunal) {
		return this.tribunalDao.findAllCount(tribunal);
	}

	/**
	 * Finds rows in the Tribunal table using like.
	 * 
	 * @param tribunal
	 *            Tribunal
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Tribunal> findAllLike(Tribunal tribunal, Pagination pagination,
			Boolean startsWith) {
		return (List<Tribunal>) this.tribunalDao.findAllLike(tribunal,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Tribunal table using like.
	 * 
	 * @param tribunal
	 *            Tribunal
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tribunal tribunal, Boolean startsWith) {
		return this.tribunalDao.findAllLikeCount(tribunal, startsWith);
	}

	/**
	 * Deletes a single row in the Tribunal table.
	 * 
	 * @param tribunal
	 *            Tribunal
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tribunal tribunal) {
		try {
			this.tribunalDao.remove(tribunal);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.tribunal.DataIntegrityViolationException", true, e);
		}
	}

	/**
	 * Deletes multiple rows in the Tribunal table.
	 * 
	 * @param tribunalList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tribunal> tribunalList) {
		for (Tribunal tribunalAux : tribunalList) {
			this.tribunalDao.remove(tribunalAux);
		}
	}

}
