package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TramiteDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tramite;

/**
 * TramiteServiceImpl  
 * 
 *  
 */

@Service(value = "tramiteService")
public class TramiteServiceImpl implements TramiteService {

	@Autowired
	private TramiteDao tramiteDao;

	/**
	 * Inserts a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tramite add(Tramite tramite) {
		return this.tramiteDao.add(tramite);
	}

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tramite update(Tramite tramite) {
		return this.tramiteDao.update(tramite);
	}

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	public Tramite find(Tramite tramite) {
		return (Tramite) this.tramiteDao.find(tramite);
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAll(Tramite tramite, Pagination pagination) {

		return (List<Tramite>) this.tramiteDao.findAll(tramite, pagination);
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllSin(Tramite tramite, Pagination pagination) {

		return (List<Tramite>) this.tramiteDao.findAllSin(tramite, pagination);
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllKontsumonet(Tramite tramite,
			Pagination pagination) {
		List<Tramite> listTramite = (List<Tramite>) this.tramiteDao.findAll(
				tramite, pagination);
		List<Tramite> listTramiteAux = this.tramiteDao
				.findAllTramiteKontsumoGest(tramite, pagination);
		for (Tramite tramiteAux : listTramiteAux) {
			listTramite.add(tramiteAux);
		}

		return listTramite;
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllActivos(Tramite tramite, Pagination pagination) {
		return (List<Tramite>) this.tramiteDao.findAllActivos(tramite,
				pagination);
	}

	/**
	 * Counts rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Long
	 */
	public Long findAllCount(Tramite tramite) {
		return this.tramiteDao.findAllCount(tramite);
	}

	/**
	 * Finds rows in the Tramite table using like.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Tramite> findAllLike(Tramite tramite, Pagination pagination,
			Boolean startsWith) {
		return (List<Tramite>) this.tramiteDao.findAllLike(tramite, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Tramite table using like.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tramite tramite, Boolean startsWith) {
		return this.tramiteDao.findAllLikeCount(tramite, startsWith);
	}

	/**
	 * Deletes a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tramite tramite) {
		this.tramiteDao.remove(tramite);
	}

	/**
	 * Deletes multiple rows in the Tramite table.
	 * 
	 * @param tramiteList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tramite> tramiteList) {
		for (Tramite tramiteAux : tramiteList) {
			this.tramiteDao.remove(tramiteAux);
		}
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findTramitesFase(Tramite tramite, Pagination pagination) {
		return (List<Tramite>) this.tramiteDao.findAllTramitesFase(tramite,
				pagination);
	}

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @param excodigo
	 *            the excodigo
	 * @return List
	 */
	public List<Tramite> findTramitesFaseGenerables(Tramite tramite,
			Pagination pagination, String excodigo) {
		return this.tramiteDao.findAllTramitesFaseGenerables(tramite,
				pagination, excodigo);

	}

}
