package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Tramite;

/**
 * TramiteService  
 * 
 *  
 */

public interface TramiteService {

	/**
	 * Inserts a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 * @throws Exception
	 *             excepcion
	 */
	Tramite add(Tramite tramite) throws Exception;

	/**
	 * Updates a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 * @throws Exception
	 *             excepcion
	 */
	Tramite update(Tramite tramite) throws Exception;

	/**
	 * Finds a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Tramite
	 */
	Tramite find(Tramite tramite);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tramite> findAll(Tramite tramite, Pagination pagination);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tramite> findAllSin(Tramite tramite, Pagination pagination);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tramite> findAllKontsumonet(Tramite tramite,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tramite> findAllActivos(Tramite tramite, Pagination pagination);

	/**
	 * Counts rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return Long
	 */
	Long findAllCount(Tramite tramite);

	/**
	 * Finds rows in the Tramite table using like.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Tramite> findAllLike(Tramite tramite, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Tramite table using like.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Tramite tramite, Boolean startsWith);

	/**
	 * Deletes a single row in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @return
	 */
	void remove(Tramite tramite);

	/**
	 * Deletes multiple rows in the Tramite table.
	 * 
	 * @param tramiteList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Tramite> tramiteList);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tramite> findTramitesFase(Tramite tramite, Pagination pagination);

	/**
	 * Finds a List of rows in the Tramite table.
	 * 
	 * @param tramite
	 *            Tramite
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tramite> findTramitesFaseGenerables(Tramite tramite,
			Pagination pagination, String excodigo);

}
