package com.ejie.y41b.service;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActaNuevaDao;
import com.ejie.y41b.dao.ActuacionDao;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.TramiteDao;
import com.ejie.y41b.dao.TramiteInspeccionDao;
import com.ejie.y41b.model.ActaNueva;
import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.BandejaInspecciones;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteInspeccionDetalle;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * TramiteInspeccionServiceImpl  
 * 
 *  
 */

@Service(value = "tramiteInspeccionService")
public class TramiteInspeccionServiceImpl implements TramiteInspeccionService {

	@Autowired()
	private TramiteInspeccionDao tramiteInspeccionDao;

	@Autowired()
	private TramiteDao tramiteDao;

	@Autowired()
	private ParametrosDao parametrosDao;

	@Autowired()
	private AdjuntardocsDao adjuntardocsDao;

	@Autowired()
	private ActuacionDao actuacionDao;

	@Autowired()
	private BandejaInspeccionesService bandejaInspeccionesService;

	@Autowired()
	private ActaNuevaDao actaNuevaDao;

	/**
	 * Inserts a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion add(TramiteInspeccion tramiteInspeccion) throws Exception {
		return this.tramiteInspeccionDao.add(tramiteInspeccion);
	}

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion update(TramiteInspeccion tramiteInspeccion) throws Exception {
		return this.tramiteInspeccionDao.update(tramiteInspeccion);
	}

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion find(TramiteInspeccion tramiteInspeccion) {
		return (TramiteInspeccion) this.tramiteInspeccionDao.find(tramiteInspeccion);
	}

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteInspeccion> findAll(TramiteInspeccion tramiteInspeccion, Pagination pagination) {
		return (List<TramiteInspeccion>) this.tramiteInspeccionDao.findAll(tramiteInspeccion, pagination);
	}

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return Long
	 */
	public Long findAllCount(TramiteInspeccion tramiteInspeccion) {
		return this.tramiteInspeccionDao.findAllCount(tramiteInspeccion);
	}

	/**
	 * Finds rows in the TramiteInspeccion table using like.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TramiteInspeccion> findAllLike(TramiteInspeccion tramiteInspeccion, Pagination pagination,
			Boolean startsWith) {
		return (List<TramiteInspeccion>) this.tramiteInspeccionDao.findAllLike(tramiteInspeccion, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the TramiteInspeccion table using like.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TramiteInspeccion tramiteInspeccion, Boolean startsWith) {
		return this.tramiteInspeccionDao.findAllLikeCount(tramiteInspeccion, startsWith);
	}

	/**
	 * Deletes a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TramiteInspeccion tramiteInspeccion) {
		this.tramiteInspeccionDao.remove(tramiteInspeccion);
	}

	/**
	 * Deletes multiple rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<TramiteInspeccion> tramiteInspeccionList) {
		for (TramiteInspeccion tramiteInspeccionAux : tramiteInspeccionList) {
			this.tramiteInspeccionDao.remove(tramiteInspeccionAux);
		}
	}

	/**
	 * Busca en el expediente si existe un tipo de tramite o no
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTipoTramite
	 *            String
	 * @return true si existe / false si no existe
	 */
	public boolean existeTramite(String idExpediente, String idTipoTramite) {
		TramiteInspeccion tramiteinspeccionAux = new TramiteInspeccion();
		tramiteinspeccionAux.setTiatcodigo(idExpediente);
		tramiteinspeccionAux.setTicotee(idTipoTramite);
		if (this.tramiteInspeccionDao.findAllCount(tramiteinspeccionAux) > 0) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Busca en el expediente si existe para un tipo de tramite, algun tramite
	 * que no sea el tramite recibido por parametro
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoTramite
	 *            String
	 * @return true si existe / false si no existe
	 */
	public boolean existenMasTramites(String idExpediente, String idTramite, String idTipoTramite) {
		TramiteInspeccionDetalle tramiteinspeccionAux = new TramiteInspeccionDetalle();
		tramiteinspeccionAux.setAtcodigo(idExpediente);
		tramiteinspeccionAux.setTicotee(idTipoTramite);
		List<TramiteInspeccionDetalle> listaTramitesCierre = this.tramiteInspeccionDao
				.findAllTramiteInspeccion(tramiteinspeccionAux, null);
		if (listaTramitesCierre != null && listaTramitesCierre.size() > 0) {
			for (TramiteInspeccionDetalle tramitehechoCierre : listaTramitesCierre) {
				if (!idTramite.equals(tramitehechoCierre.getTicodigo())) {
					// En caso de que haya algun tramite que sea de cierre en el
					// expediente y no sea el recibido por parametro
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * Modifica las fechas de los tramites de cierre del expediente. En concreto
	 * las fechas de inicio de la fecha limite. Usado en tramites de Decision,
	 * Orden Consejero...
	 * 
	 * @param idExpediente
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateFechasTramiteCierre(String idExpediente) {
		TramiteInspeccion tramiteinspeccionAux = new TramiteInspeccion();
		tramiteinspeccionAux.setTiatcodigo(idExpediente);
		tramiteinspeccionAux.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);
		List<TramiteInspeccion> listaTramitesCierre = this.tramiteInspeccionDao.findAll(tramiteinspeccionAux, null);
		if (listaTramitesCierre != null && listaTramitesCierre.size() > 0) {
			// 1. Se calculan fecha inicio y fecha limite
			Tramite tramiteAux = new Tramite();
			tramiteAux.setTrcodigo(Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);
			tramiteAux = this.tramiteDao.find(tramiteAux);
			Date fechaInicio = new Date();
			Date fechaLimite = null;
			if (tramiteAux.getPlazo() != null && tramiteAux.getPlazo() > 0) {
				fechaLimite = Y41bUtils.addDays(fechaInicio, tramiteAux.getPlazo());
			}
			// 2. Se actualizan fecha inicio y fecha limite en tramites cierre
			// Deberia haber solo 1 tramite de cierre por expediente
			for (TramiteInspeccion tramiteInspeccionCierre : listaTramitesCierre) {
				tramiteInspeccionCierre.setTifechainicio(fechaInicio);
				tramiteInspeccionCierre.setTifechalimite(fechaLimite);
				this.tramiteInspeccionDao.updateFechaInicio(tramiteInspeccionCierre);
				this.tramiteInspeccionDao.updateFechaLimite(tramiteInspeccionCierre);
			}
		}
	}

	/**
	 * Actualizamos la fecha limite del tramite de cierre a null
	 * 
	 * @param idExpediente
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateFechaLimiteTramiteCierre(String idExpediente) {
		TramiteInspeccion tramiteinspeccionAux = new TramiteInspeccion();
		tramiteinspeccionAux.setTiatcodigo(idExpediente);
		tramiteinspeccionAux.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);
		List<TramiteInspeccion> listaTramitesCierre = this.tramiteInspeccionDao.findAll(tramiteinspeccionAux, null);
		if (listaTramitesCierre != null && listaTramitesCierre.size() > 0) {
			// Se actualiza la fecha limite a null
			for (TramiteInspeccion tramiteInspeccionCierre : listaTramitesCierre) {
				tramiteInspeccionCierre.setTifechalimite(null);
				this.tramiteInspeccionDao.updateFechaLimite(tramiteInspeccionCierre);
			}
		}
	}

	/**
	 * Inserts a single row in the TramiteInspeccion table. Se incorpora
	 * funcionalidad de fecha limite
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteInspeccion(TramiteInspeccion tramiteInspeccion) throws Exception {

		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteInspeccion.getTiestadotramite())) {
			// 1. Se calcula el plazo del tramite
			Parametros parametros = this.getParametros(tramiteInspeccion);

			if ((tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO)
					|| tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_DESINMOVILIZACION))
					&& Y41bUtils.isFilled(tramiteInspeccion.getTiaccodigo())) {
				// 2. Se anyade en caso de que tenga valor, sino se mete null
				if (parametros != null && parametros.getValor() != null && !parametros.getValor().equals("")) {
					// Buscar el acta
					ActaNueva actanueva = new ActaNueva();
					actanueva.setAncodigo(tramiteInspeccion.getTiaccodigo());
					actanueva = this.actaNuevaDao.find(actanueva);

					// calcular la fecha limite
					Long plazo = new Long(parametros.getValor());
					Date fechaLimite = Y41bUtils.addDays(actanueva.getAnfecha(), plazo);
					tramiteInspeccion.setTifechalimite(fechaLimite);
				} else {
					tramiteInspeccion.setTifechalimite(null);
				}
			} else {
				// 2. Se anyade en caso de que tenga valor, sino se mete null
				if (parametros != null && parametros.getValor() != null && !parametros.getValor().equals("")) {

					Long plazo = new Long(parametros.getValor());
					Date fechaLimite = Y41bUtils.addDays(tramiteInspeccion.getTifechainicio(), plazo);
					tramiteInspeccion.setTifechalimite(fechaLimite);
				} else {
					tramiteInspeccion.setTifechalimite(null);
				}
			}
		}

		// obtener la fase del tramite
		Tramite tramite = new Tramite();
		tramite.setTrcodigo(tramiteInspeccion.getTicotee());
		tramite = this.tramiteDao.find(tramite);

		if (tramite != null && tramite.getFase() != null && tramite.getFase().getFcodigo() != null
				&& !tramite.getFase().getFcodigo().equals("")) {
			// Tramite con fase
			tramiteInspeccion.setTifcodigo(tramite.getFase().getFcodigo());
		} else {
			if (tramiteInspeccion != null && tramiteInspeccion.getTramiteInspeccion() != null
					&& tramiteInspeccion.getTramiteInspeccion().getTicodigo() != null
					&& !tramiteInspeccion.getTramiteInspeccion().equals("")) {
				// buscar el tramite
				TramiteInspeccion tramiteInspeccionRelacionado = this.tramiteInspeccionDao
						.find(tramiteInspeccion.getTramiteInspeccion());
				// coger la fase
				tramiteInspeccion.setTifcodigo(tramiteInspeccionRelacionado.getTifcodigo());
			} else {
				// Tramite generico
				// si no viene, se obtiene el ultimo tramite, y se coge la fase
				// consultar el ultimo tramite realizado
				TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
				tramiteInspeccionDetalle.setAtcodigo(tramiteInspeccion.getTiatcodigo());

				TramiteInspeccionDetalle tramiteInspeccionDetalleAux = null;

				tramiteInspeccionDetalleAux = this.tramiteInspeccionDao
						.findUltimoTramiteInspeccionYFase(tramiteInspeccionDetalle);

				// si es tramite generico consultar el ultimo tramite no
				// generico
				if (tramiteInspeccionDetalleAux.getFcodigo() == null
						|| tramiteInspeccionDetalleAux.getFcodigo().equals("")) {
					TramiteInspeccionDetalle tramiteInspeccionDetalleAux2 = null;
					tramiteInspeccionDetalleAux2 = this.tramiteInspeccionDao
							.findUltimoTramiteInspeccionYFaseNoGenerico(tramiteInspeccionDetalle);

					if (tramiteInspeccionDetalleAux2 != null && tramiteInspeccionDetalleAux2.getTrcodigo() != null
							&& !tramiteInspeccionDetalleAux2.getTrcodigo()
									.equals(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE)) {
						tramiteInspeccion.setTifcodigo(tramiteInspeccionDetalleAux2.getFcodigo());
					} else {
						// buscar tramite no generico que no sea cierre
						TramiteInspeccionDetalle tramiteInspeccionDetalleAux3 = this.tramiteInspeccionDao
								.findUltimoTramiteInspeccionYFaseNoGenericoNoCierre(tramiteInspeccionDetalle);
						tramiteInspeccion.setTifcodigo(tramiteInspeccionDetalleAux3.getFcodigo());
					}
				} else {
					if (tramiteInspeccionDetalleAux != null && tramiteInspeccionDetalleAux.getTrcodigo() != null
							&& !tramiteInspeccionDetalleAux.getTrcodigo()
									.equals(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE)) {
						tramiteInspeccion.setTifcodigo(tramiteInspeccionDetalleAux.getFcodigo());
					} else {
						// buscar tramite no generico que no sea cierre
						TramiteInspeccionDetalle tramiteInspeccionDetalleAux3 = this.tramiteInspeccionDao
								.findUltimoTramiteInspeccionYFaseNoGenericoNoCierre(tramiteInspeccionDetalle);
						tramiteInspeccion.setTifcodigo(tramiteInspeccionDetalleAux3.getFcodigo());
					}

				}
			}
		}

		tramiteInspeccion.setTifechainicio(new Date());
		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteInspeccion.getTiestadotramite())) {
			tramiteInspeccion.setTifechafin(new Date());
		}

		this.tramiteInspeccionDao.add(tramiteInspeccion);

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Inserts a single row in the TramiteInspeccion table. Se incorpora
	 * funcionalidad de fecha limite
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteInspeccionMasiva(TramiteInspeccion tramiteInspeccion) throws Exception {

		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteInspeccion.getTiestadotramite())) {
			// 1. Se calcula el plazo del tramite
			Parametros parametros = this.getParametros(tramiteInspeccion);

			// 2. Se anyade en caso de que tenga valor, sino se mete null
			if (parametros != null && parametros.getValor() != null && !parametros.getValor().equals("")) {

				Long plazo = new Long(parametros.getValor());
				Date fechaLimite = Y41bUtils.addDays(tramiteInspeccion.getTifechainicio(), plazo);
				tramiteInspeccion.setTifechalimite(fechaLimite);
			} else {
				tramiteInspeccion.setTifechalimite(null);
			}
		}

		// obtener la fase del tramite
		tramiteInspeccion.setTifcodigo(Y41bConstantes.FASE_INSPECCIONES);

		tramiteInspeccion.setTifechainicio(new Date());

		this.tramiteInspeccionDao.addMasiva(tramiteInspeccion);

		Actuacion actuacionAux = new Actuacion();
		actuacionAux.setAtcodigo(tramiteInspeccion.getTiatcodigo());
		actuacionAux.setFcodigoactual(Y41bConstantes.FASE_INSPECCIONES);
		actuacionAux.setTrcodigoactual(Y41bConstantes.TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE);
		actuacionAux.setTrposiblecodigo(Y41bConstantes.TRAMITE_INSPECCIONES_ASIGNACION_RESPONSABLE_EXPEDIENTE);
		this.actuacionDao.updateUltimoTramiteConFase(actuacionAux);

		return tramiteInspeccion;
	}

	/**
	 * Updates a single row in the TramiteInspeccion table. Se incorpora
	 * funcionalidad de fecha limite
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion updateTramiteInspeccion(TramiteInspeccion tramiteInspeccion) throws Exception {
		if (Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION.equals(tramiteInspeccion.getTiestadotramite())
				|| Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA.equals(tramiteInspeccion.getTiestadotramite())) {
			// 1. Se calcula el plazo del tramite
			Parametros parametros = this.getParametros(tramiteInspeccion);

			if ((tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_ACUERDO_INICIO_PROCEDIMIENTO)
					|| tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_DESINMOVILIZACION))
					&& Y41bUtils.isFilled(tramiteInspeccion.getTiaccodigo())) {
				// 2. Se anyade en caso de que tenga valor, sino se mete null
				if (parametros != null && parametros.getValor() != null && !parametros.getValor().equals("")) {
					// Buscar el acta
					ActaNueva actanueva = new ActaNueva();
					actanueva.setAncodigo(tramiteInspeccion.getTiaccodigo());
					actanueva = this.actaNuevaDao.find(actanueva);

					// calcular la fecha limite
					Long plazo = new Long(parametros.getValor());
					Date fechaLimite = Y41bUtils.addDays(actanueva.getAnfecha(), plazo);
					tramiteInspeccion.setTifechalimite(fechaLimite);
				} else {
					tramiteInspeccion.setTifechalimite(null);
				}
			} else {
				// 2. Se anyade en caso de que tenga valor, sino se mete null
				if (parametros != null && parametros.getValor() != null && !parametros.getValor().equals("")) {

					Long plazo = new Long(parametros.getValor());
					Date fechaLimite = Y41bUtils.addDays(tramiteInspeccion.getTifechainicio(), plazo);
					tramiteInspeccion.setTifechalimite(fechaLimite);
				} else {
					tramiteInspeccion.setTifechalimite(null);
				}
			}
		}

		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteInspeccion.getTiestadotramite())) {

			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteInspeccion.getTicodigo());

			List<Adjuntardocs> listAdjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

			boolean denegado = false;

			if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
				for (int i = 0; i < listAdjuntardocs.size(); i++) {
					if (listAdjuntardocs.get(i).getThestadodocumento() != null && listAdjuntardocs.get(i)
							.getThestadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA)) {
						denegado = true;
						break;
					}
				}
			}

			if (denegado) {
				tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
			} else {
				boolean todosFirmados = true;
				if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
					for (int i = 0; i < listAdjuntardocs.size(); i++) {
						if (listAdjuntardocs.get(i).getThestadodocumento() != null && !listAdjuntardocs.get(i)
								.getThestadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO)) {
							todosFirmados = false;
							break;
						}
					}
				}
				if (todosFirmados) {
					boolean firmado = false;
					if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
						for (int i = 0; i < listAdjuntardocs.size(); i++) {
							if (listAdjuntardocs.get(i).getThestadodocumento() != null) {
								firmado = true;
								break;
							}
						}
					}

					if (firmado) {
						tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
					} else {
						tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					}

				} else {
					boolean pendienteFirma = false;
					if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
						for (int i = 0; i < listAdjuntardocs.size(); i++) {
							if (listAdjuntardocs.get(i).getThestadodocumento() != null) {
								pendienteFirma = true;
								break;
							}
						}
					}

					if (pendienteFirma) {
						tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
					} else {
						tramiteInspeccion.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					}
				}
			}
		}

		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteInspeccion.getTiestadotramite())) {
			tramiteInspeccion.setTifechafin(new Date());
		}

		this.tramiteInspeccionDao.update(tramiteInspeccion);

		// Actualizar ultimo tramite
		this.actualizarUltimoTramite(tramiteInspeccion);

		return tramiteInspeccion;
	}

	/**
	 * Obtiene el parametro de configuracion para obtener el plazo de dias
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return Parametros
	 */
	private Parametros getParametros(TramiteInspeccion tramiteInspeccion) {
		Parametros parametros = new Parametros();
		if (tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_ACUSE_DE_RECIBO)) {
			parametros.setParametro(Y41bConstantes.TIPO_AVISO_INSPECCIONES_NOTIFICACION_SIN_ACUSE);
			parametros = this.parametrosDao.find(parametros);
		} else if (tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_ALEGACIONES)) {
			parametros.setParametro(Y41bConstantes.TIPO_AVISO_INSPECCIONES_RECEPCION_ALEGACIONES);
			parametros = this.parametrosDao.find(parametros);
		} else if (tramiteInspeccion.getTicotee().equals(Y41bConstantes.TRAMITE_INSPECCIONES_RECEPCION_REQUERIMIENTO)) {
			parametros.setParametro(Y41bConstantes.TIPO_AVISO_INSPECCIONES_RECEPCION_REQUERIMIENTO);
			parametros = this.parametrosDao.find(parametros);
			// } else if (tramiteInspeccion.getTicotee().equals(
			// Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE)) {
			// parametros
			// .setParametro(Y41bConstantes.TIPO_AVISO_INSPECCIONES_CIERRE_EXPEDIENTE);
			// parametros = this.parametrosDao.find(parametros);
		} else {
			Tramite tramite = new Tramite();
			tramite.setTrcodigo(tramiteInspeccion.getTicotee());

			tramite = this.tramiteDao.find(tramite);
			if (tramite.getPlazo() != null) {
				parametros.setValor(tramite.getPlazo().toString());
			}
		}

		return parametros;
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion updateRegistroSalidaPlatea(TramiteInspeccion tramiteInspeccion) {
		return this.tramiteInspeccionDao.updateRegistroSalidaPlatea(tramiteInspeccion);
	}

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	public Long getNewEsperaPK() {
		return this.tramiteInspeccionDao.getNewEsperaPK();
	}

	/**
	 * Metodo que actualiza el ultimo tramite
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 */
	public void actualizarUltimoTramite(TramiteInspeccion tramiteInspeccion) {
		// consultar el ultimo tramite realizado
		TramiteInspeccionDetalle tramiteInspeccionDetalle = new TramiteInspeccionDetalle();
		tramiteInspeccionDetalle.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		TramiteInspeccionDetalle tramiteInspeccionDetalleAux = null;
		tramiteInspeccionDetalleAux = this.tramiteInspeccionDao
				.findUltimoTramiteInspeccionYFase(tramiteInspeccionDetalle);

		// si es tramite generico consultar el ultimo tramite no generico
		if (tramiteInspeccionDetalleAux.getFcodigo() == null || tramiteInspeccionDetalleAux.getFcodigo().equals("")) {
			TramiteInspeccionDetalle tramiteInspeccionDetalleAux2 = null;
			tramiteInspeccionDetalleAux2 = this.tramiteInspeccionDao
					.findUltimoTramiteInspeccionYFaseNoGenerico(tramiteInspeccionDetalle);

			Actuacion actuacionAux = new Actuacion();
			actuacionAux.setAtcodigo(tramiteInspeccion.getTiatcodigo());
			actuacionAux.setFcodigoactual(tramiteInspeccionDetalleAux2.getFcodigo());
			actuacionAux.setTrcodigoactual(tramiteInspeccionDetalleAux.getTrcodigo());

			if (!Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE
					.equals(tramiteInspeccionDetalleAux2.getTrcodigo())) {
				actuacionAux.setTrposiblecodigo(tramiteInspeccionDetalleAux2.getTrcodigo());
			} else {
				// buscar tramite no generico que no sea cierre
				TramiteInspeccionDetalle tramiteInspeccionDetalleAux3 = this.tramiteInspeccionDao
						.findUltimoTramiteInspeccionYFaseNoGenericoNoCierre(tramiteInspeccionDetalle);
				actuacionAux.setTrposiblecodigo(tramiteInspeccionDetalleAux3.getTrcodigo());
			}

			this.actuacionDao.updateUltimoTramiteConFase(actuacionAux);

		} else {
			// si no es tramite generico actualizar
			// updateUltimoTramiteConFase
			Actuacion actuacionAux = new Actuacion();
			actuacionAux.setAtcodigo(tramiteInspeccion.getTiatcodigo());
			actuacionAux.setFcodigoactual(tramiteInspeccionDetalleAux.getFcodigo());
			actuacionAux.setTrcodigoactual(tramiteInspeccionDetalleAux.getTrcodigo());

			if (!tramiteInspeccionDetalleAux.getTrcodigo()
					.equals(Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE)) {
				actuacionAux.setTrposiblecodigo(tramiteInspeccionDetalleAux.getTrcodigo());

				// if (tramiteInspeccion.getTiestadotramite() != null &&
				// tramiteInspeccion.getTiestadotramite()
				// .equalsIgnoreCase(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO)) {
				// //
				// actuacionAux.setTrcodigoactual(tramiteInspeccion.getTicotee());
				// actuacionAux.setTrposiblecodigo(tramiteInspeccion.getTicotee());
				// } else {
				// actuacionAux.setTrposiblecodigo(tramiteInspeccionDetalleAux.getTrcodigo());
				// }

			} else {
				// buscar tramite no generico que no sea cierre
				TramiteInspeccionDetalle tramiteInspeccionDetalleAux3 = this.tramiteInspeccionDao
						.findUltimoTramiteInspeccionPorTipoTramite(tramiteInspeccionDetalle);
				actuacionAux.setTrposiblecodigo(tramiteInspeccionDetalleAux3.getTrcodigo());
			}

			this.actuacionDao.updateUltimoTramiteConFase(actuacionAux);
		}

		BandejaInspecciones bandejaInspecciones = new BandejaInspecciones();
		bandejaInspecciones.setAtcodigo(tramiteInspeccion.getTiatcodigo());

		// Comprobamos si el expediente esta cerrado y actualizamos la bandeja
		// de Inspecciones en consecuencia.
		TramiteInspeccion tramiteInspeccionAux = new TramiteInspeccion();
		tramiteInspeccionAux.setTiatcodigo(tramiteInspeccion.getTiatcodigo());
		tramiteInspeccionAux.setTicotee(Y41bConstantes.TRAMITE_INSPECCIONES_CIERRE_EXPEDIENTE);
		tramiteInspeccionAux.setTiestadotramite(Y41bConstantes.ESTADO_TRAMITE_TRAMITADO);
		Long total = this.tramiteInspeccionDao.findAllCount(tramiteInspeccionAux);

		if (total > 0) {
			this.bandejaInspeccionesService.remove(bandejaInspecciones);
		} else {
			this.bandejaInspeccionesService.updateUltimoTramite(bandejaInspecciones);
		}
	}

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	public Long findAllTramiteRegistroInspeccionTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		return this.tramiteInspeccionDao.findAllTramiteRegistroInspeccionTramitadoCount(tramiteInspeccionDetalle);
	}

	/**
	 * Finds a single row in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	public TramiteInspeccionDetalle findUltimoTramiteHechoPorTipoTramite(
			TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		return this.tramiteInspeccionDao.findUltimoTramiteHechoPorTipoTramite(tramiteInspeccionDetalle);

	}

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	public Long findAllTramiteEmisionInformeProtocoloTramitadoCount(TramiteInspeccionDetalle tramiteInspeccionDetalle) {
		return this.tramiteInspeccionDao.findAllTramiteEmisionInformeProtocoloTramitadoCount(tramiteInspeccionDetalle);
	}
}
