package com.ejie.y41b.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.TramiteInspeccion;
import com.ejie.y41b.model.TramiteInspeccionDetalle;

/**
 * TramiteInspeccionService  
 * 
 *  
 */

public interface TramiteInspeccionService {

	/**
	 * Busca en el expediente si existe para un tipo de tramite, algun tramite
	 * que no sea el tramite recibido por parametro
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoTramite
	 *            String
	 * @return true si existe / false si no existe
	 */
	boolean existenMasTramites(String idExpediente, String idTramite,
			String idTipoTramite);

	/**
	 * Inserts a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	TramiteInspeccion add(TramiteInspeccion tramiteInspeccion) throws Exception;

	/**
	 * Inserts a single row in the TramiteInspeccion table. Se incorpora
	 * funcionalidad de fecha limite
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	public TramiteInspeccion addTramiteInspeccionMasiva(
			TramiteInspeccion tramiteInspeccion) throws Exception;

	/**
	 * Updates a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	TramiteInspeccion update(TramiteInspeccion tramiteInspeccion)
			throws Exception;

	/**
	 * Modifica las fechas de los tramites de cierre del expediente. En concreto
	 * las fechas de inicio de la fecha limite. Usado en tramites de Decision,
	 * Orden Consejero...
	 * 
	 * @param idExpediente
	 *            String
	 */
	public void updateFechasTramiteCierre(String idExpediente);

	/**
	 * Finds a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	TramiteInspeccion find(TramiteInspeccion tramiteInspeccion);

	/**
	 * Finds a List of rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TramiteInspeccion> findAll(TramiteInspeccion tramiteInspeccion,
			Pagination pagination);

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return Long
	 */
	Long findAllCount(TramiteInspeccion tramiteInspeccion);

	/**
	 * Finds rows in the TramiteInspeccion table using like.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TramiteInspeccion> findAllLike(TramiteInspeccion tramiteInspeccion,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TramiteInspeccion table using like.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TramiteInspeccion tramiteInspeccion,
			Boolean startsWith);

	/**
	 * Deletes a single row in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return
	 */
	void remove(TramiteInspeccion tramiteInspeccion);

	/**
	 * Deletes multiple rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionList
	 *            List
	 * @return
	 */
	void removeMultiple(List<TramiteInspeccion> tramiteInspeccionList);

	/**
	 * Inserts a single row in the TramiteInspeccion table. Se incorpora
	 * funcionalidad de fecha limite
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion addTramiteInspeccion(
			TramiteInspeccion tramiteInspeccion) throws Exception;

	/**
	 * Updates a single row in the TramiteInspeccion table. Se incorpora
	 * funcionalidad de fecha limite
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 * @throws Exception
	 *             excepcion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteInspeccion updateTramiteInspeccion(
			TramiteInspeccion tramiteInspeccion) throws Exception;

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 * @return TramiteInspeccion
	 */
	public TramiteInspeccion updateRegistroSalidaPlatea(
			TramiteInspeccion tramiteInspeccion);

	/**
	 * Actualizamos la fecha limite del tramite de cierre a null
	 * 
	 * @param idExpediente
	 *            String
	 */
	public void updateFechaLimiteTramiteCierre(String idExpediente);

	/**
	 * Busca en el expediente si existe un tipo de tramite o no
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTipoTramite
	 *            String
	 * @return true si existe / false si no existe
	 */
	public boolean existeTramite(String idExpediente, String idTipoTramite);

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	public Long getNewEsperaPK();

	/**
	 * Metodo que actualiza el ultimo tramite
	 * 
	 * @param tramiteInspeccion
	 *            TramiteInspeccion
	 */
	public void actualizarUltimoTramite(TramiteInspeccion tramiteInspeccion);

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	public Long findAllTramiteRegistroInspeccionTramitadoCount(
			TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Finds a single row in the tramiteinspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return TramiteInspeccionDetalle
	 */
	public TramiteInspeccionDetalle findUltimoTramiteHechoPorTipoTramite(
			TramiteInspeccionDetalle tramiteInspeccionDetalle);

	/**
	 * Counts rows in the TramiteInspeccion table.
	 * 
	 * @param tramiteInspeccionDetalle
	 *            TramiteInspeccionDetalle
	 * @return Long
	 */
	public Long findAllTramiteEmisionInformeProtocoloTramitadoCount(
			TramiteInspeccionDetalle tramiteInspeccionDetalle);
}
