package com.ejie.y41b.service;

import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjuntardocsDao;
import com.ejie.y41b.dao.HechoDenunciadoDao;
import com.ejie.y41b.dao.ParametrosDao;
import com.ejie.y41b.dao.TramiteDao;
import com.ejie.y41b.dao.TramiteHechoDao;
import com.ejie.y41b.model.Adjuntardocs;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.SolicitudDetalle;
import com.ejie.y41b.model.Tramite;
import com.ejie.y41b.model.TramiteHecho;
import com.ejie.y41b.model.TramiteHechoDetalle;
import com.ejie.y41b.utils.Y41bUtils;

/**
 * TramiteHechoServiceImpl  
 * 
 *  
 */

@Service(value = "tramiteHechoService")
public class TramiteHechoServiceImpl implements TramiteHechoService {

	private static final Logger logger = LoggerFactory.getLogger(TramiteHechoServiceImpl.class);

	@Autowired
	private TramiteHechoDao tramiteHechoDao;

	@Autowired
	private AdjuntardocsDao adjuntardocsDao;

	@Autowired
	private TramiteDao tramiteDao;

	@Autowired
	private ParametrosDao parametrosDao;

	@Autowired
	private HechoDenunciadoDao hechoDenunciadoDao;

	/**
	 * Inserts a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho add(TramiteHecho tramiteHecho) {
		return this.tramiteHechoDao.add(tramiteHecho);
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho update(TramiteHecho tramiteHecho) {
		return this.tramiteHechoDao.update(tramiteHecho);
	}

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho updateRegistroSalidaPlatea(TramiteHecho tramiteHecho) {
		return this.tramiteHechoDao.updateRegistroSalidaPlatea(tramiteHecho);
	}

	/**
	 * Inserts a single row in the TramiteHecho table. Se incorpora
	 * funcionalidad de fecha limite
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho addTramiteHecho(TramiteHecho tramiteHecho) {
		logger.debug("###################INICIO ADD TRAMITE HECHO");

		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteHecho.getEhestadotramite())) {
			// 1. Se calcula el plazo del tramite
			Parametros parametros = getParametros(tramiteHecho);

			// 2. Se anyade en caso de que tenga valor, sino se mete null
			if (parametros != null && parametros.getValor() != null && !parametros.getValor().equals("")) {

				Long plazo = new Long(parametros.getValor());
				Date fechaLimite = Y41bUtils.addDays(tramiteHecho.getEhfechainicio(), plazo);
				tramiteHecho.setEhfechalimite(fechaLimite);
			} else {
				tramiteHecho.setEhfechalimite(null);
			}
		}

		// obtener la fase del tramite
		Tramite tramite = new Tramite();
		tramite.setTrcodigo(tramiteHecho.getEhcotee());
		tramite = this.tramiteDao.find(tramite);

		if (tramite != null && tramite.getFase() != null && tramite.getFase().getFcodigo() != null
				&& !tramite.getFase().getFcodigo().equals("")) {
			logger.debug("###################TRAMITE CON FASE");
			// Tramite con fase
			tramiteHecho.setEhfcodigo(tramite.getFase().getFcodigo());
		} else {
			logger.debug("###################TRAMITE GENERICO");
			if (tramiteHecho != null && tramiteHecho.getTramiteHecho() != null
					&& tramiteHecho.getTramiteHecho().getEhcodigo() != null
					&& !tramiteHecho.getTramiteHecho().equals("")) {
				logger.debug("###################INICIO BUSCAR TRAMITE RELACIONADO");
				logger.debug("###################EHCODIGO TRAMITE RELACIONADO["
						+ tramiteHecho.getTramiteHecho().getEhcodigo() + "]");
				// buscar el tramite
				TramiteHecho tramitehechoRelacionado = this.tramiteHechoDao.find(tramiteHecho.getTramiteHecho());
				logger.debug("###################TRAMITE RELACIONADO[" + tramitehechoRelacionado + "]");
				// coger la fase
				tramiteHecho.setEhfcodigo(tramitehechoRelacionado.getEhfcodigo());
				logger.debug("###################FIN BUSCAR TRAMITE RELACIONADO");
			} else {
				// Tramite generico
				// si no viene, se obtiene el ultimo tramite, y se coge la fase
				// consultar el ultimo tramite realizado
				TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
				tramiteHechoDetalle.setHdcodigo(tramiteHecho.getEhcohd());

				TramiteHechoDetalle tramiteHechoDetalleAux = null;

				tramiteHechoDetalleAux = this.tramiteHechoDao.findUltimoTramiteHechoYFase(tramiteHechoDetalle);

				// si es tramite generico consultar el ultimo tramite no
				// generico
				if (tramiteHechoDetalleAux.getFcodigo() == null || tramiteHechoDetalleAux.getFcodigo().equals("")) {
					TramiteHechoDetalle tramiteHechoDetalleAux2 = null;
					tramiteHechoDetalleAux2 = this.tramiteHechoDao
							.findUltimoTramiteHechoYFaseNoGenerico(tramiteHechoDetalle);

					if (tramiteHechoDetalleAux2 != null && tramiteHechoDetalleAux2.getTrcodigo() != null
							&& !tramiteHechoDetalleAux2.getTrcodigo()
									.equals(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE)) {
						tramiteHecho.setEhfcodigo(tramiteHechoDetalleAux2.getFcodigo());
					} else {
						// buscar tramite no generico que no sea cierre
						TramiteHechoDetalle tramiteHechoDetalleAux3 = this.tramiteHechoDao
								.findUltimoTramiteHechoYFaseNoGenericoNoCierre(tramiteHechoDetalle);
						tramiteHecho.setEhfcodigo(tramiteHechoDetalleAux3.getFcodigo());
					}
				} else {
					if (tramiteHechoDetalleAux != null && tramiteHechoDetalleAux.getTrcodigo() != null
							&& !tramiteHechoDetalleAux.getTrcodigo().equals(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE)) {
						tramiteHecho.setEhfcodigo(tramiteHechoDetalleAux.getFcodigo());
					} else {
						// buscar tramite no generico que no sea cierre
						TramiteHechoDetalle tramiteHechoDetalleAux3 = this.tramiteHechoDao
								.findUltimoTramiteHechoYFaseNoGenericoNoCierre(tramiteHechoDetalle);
						tramiteHecho.setEhfcodigo(tramiteHechoDetalleAux3.getFcodigo());
					}

				}
			}
		}

		tramiteHecho.setEhfechainicio(new Date());
		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteHecho.getEhestadotramite())) {
			tramiteHecho.setEhfechafin(new Date());
		}

		SolicitudDetalle solDetalle = null;
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteHecho.getEhcohd());

		solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		if (solDetalle.getHddenunciaaaccempresas() != null
				&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
			if (Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION.equals(tramiteHecho.getEhcotee())
					|| Y41bConstantes.TRAMITE_ALEGACION.equals(tramiteHecho.getEhcotee())) {
				tramiteHecho.setEhfcodigo(Y41bConstantes.FASE_ALEGACIONES);
			}
		}

		logger.debug("###################FIN ADD TRAMITE HECHO");

		return this.tramiteHechoDao.add(tramiteHecho);
	}

	/**
	 * Obtiene el parametro de configuracion para obtener el plazo de días
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return Parametros
	 */
	public Parametros getParametros(TramiteHecho tramiteHecho) {
		Parametros parametros = new Parametros();

		if (tramiteHecho.getEhcotee().equals(Y41bConstantes.TRAMITE_ACUSE_RECIBO)) {
			parametros.setParametro(Y41bConstantes.TIPO_AVISO_SOLICITUDES_NOTIFICACION_SIN_ACUSE);
			parametros = this.parametrosDao.find(parametros);
		} else if (tramiteHecho.getEhcotee().equals(Y41bConstantes.TRAMITE_ALEGACION)) {
			parametros.setParametro(Y41bConstantes.TIPO_AVISO_SOLICITUDES_REGISTRO_ALEGACION);
			parametros = this.parametrosDao.find(parametros);
		} else if (tramiteHecho.getEhcotee().equals(Y41bConstantes.TRAMITE_RECEPCION_REQUERIMIENTO_INFORMACION)) {
			parametros.setParametro(Y41bConstantes.TIPO_AVISO_SOLICITUDES_REQUERIMIENTO_INFORMACION);
			parametros = this.parametrosDao.find(parametros);
		} else if (tramiteHecho.getEhcotee().equals(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE)) {
			parametros.setParametro(Y41bConstantes.TIPO_AVISO_SOLICITUDES_CIERRE_EXPEDIENTE);
			parametros = this.parametrosDao.find(parametros);
		} else {
			Tramite tramite = new Tramite();
			tramite.setTrcodigo(tramiteHecho.getEhcotee());

			tramite = this.tramiteDao.find(tramite);
			if (tramite.getPlazo() != null) {
				parametros.setValor(tramite.getPlazo().toString());
			}
		}

		return parametros;
	}

	/**
	 * Updates a single row in the TramiteHecho table. Se incorpora
	 * funcionalidad de fecha limite
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TramiteHecho updateTramiteHecho(TramiteHecho tramiteHecho) {
		if (Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION.equals(tramiteHecho.getEhestadotramite())
				|| Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA.equals(tramiteHecho.getEhestadotramite())) {
			// 1. Se calcula el plazo del tramite
			Parametros parametros = getParametros(tramiteHecho);

			// 2. Se anyade en caso de que tenga valor, sino se mete null
			if (parametros != null && parametros.getValor() != null && !parametros.getValor().equals("")) {

				Long plazo = new Long(parametros.getValor());
				Date fechaLimite = Y41bUtils.addDays(tramiteHecho.getEhfechainicio(), plazo);
				tramiteHecho.setEhfechalimite(fechaLimite);
			} else {
				tramiteHecho.setEhfechalimite(null);
			}
		}

		if (!Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteHecho.getEhestadotramite())) {

			Adjuntardocs adjuntardocs = new Adjuntardocs();
			adjuntardocs.setThidTramite(tramiteHecho.getEhcodigo());

			List<Adjuntardocs> listAdjuntardocs = this.adjuntardocsDao.findAll(adjuntardocs, null);

			boolean denegado = false;

			if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
				for (int i = 0; i < listAdjuntardocs.size(); i++) {
					if (listAdjuntardocs.get(i).getThestadodocumento() != null && listAdjuntardocs.get(i)
							.getThestadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADENEGADA)) {
						denegado = true;
						break;
					}
				}
			}

			if (denegado) {
				tramiteHecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADENEGADA);
			} else {
				boolean todosFirmados = true;
				if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
					for (int i = 0; i < listAdjuntardocs.size(); i++) {
						if (listAdjuntardocs.get(i).getThestadodocumento() != null && !listAdjuntardocs.get(i)
								.getThestadodocumento().equals(Y41bConstantes.ESTADO_DOCUMENTO_FIRMADO)) {
							todosFirmados = false;
							break;
						}
					}
				}
				if (todosFirmados) {
					boolean firmado = false;
					if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
						for (int i = 0; i < listAdjuntardocs.size(); i++) {
							if (listAdjuntardocs.get(i).getThestadodocumento() != null) {
								firmado = true;
								break;
							}
						}
					}

					if (firmado) {
						tramiteHecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_FIRMADO);
					} else {
						tramiteHecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					}

				} else {
					boolean pendienteFirma = false;
					if (listAdjuntardocs != null && listAdjuntardocs.size() > 0) {
						for (int i = 0; i < listAdjuntardocs.size(); i++) {
							if (listAdjuntardocs.get(i).getThestadodocumento() != null) {
								pendienteFirma = true;
								break;
							}
						}
					}

					if (pendienteFirma) {
						tramiteHecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_PENDIENTEFIRMA);
					} else {
						tramiteHecho.setEhestadotramite(Y41bConstantes.ESTADO_TRAMITE_ENTRAMITACION);
					}
				}
			}
		}

		if (Y41bConstantes.ESTADO_TRAMITE_TRAMITADO.equals(tramiteHecho.getEhestadotramite())) {
			tramiteHecho.setEhfechafin(new Date());
		}

		SolicitudDetalle solDetalle = null;
		SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
		solicitudDetalle.setHdcodigo(tramiteHecho.getEhcohd());

		solDetalle = this.hechoDenunciadoDao.findSolicitud(solicitudDetalle);

		if (solDetalle.getHddenunciaaaccempresas() != null
				&& solDetalle.getHddenunciaaaccempresas().equals(Y41bConstantes.VALOR_SI)) {
			if (Y41bConstantes.TRAMITE_REQUERIMIENTO_ALEGACION.equals(tramiteHecho.getEhcotee())
					|| Y41bConstantes.TRAMITE_ALEGACION.equals(tramiteHecho.getEhcotee())) {
				tramiteHecho.setEhfcodigo(Y41bConstantes.FASE_ALEGACIONES);
			}
		}

		return this.tramiteHechoDao.update(tramiteHecho);
	}

	/**
	 * Busca en el expediente si existe un tipo de tramite o no
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTipoTramite
	 *            String
	 * @return true si existe / false si no existe
	 */
	public boolean existeTramite(String idExpediente, String idTipoTramite) {
		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcohd(idExpediente);
		tramitehechoAux.setEhcotee(idTipoTramite);
		if (this.tramiteHechoDao.findAllCount(tramitehechoAux) > 0) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Busca en el expediente si existe para un tipo de tramite, algun tramite
	 * que no sea el tramite recibido por parametro
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoTramite
	 *            String
	 * @return true si existe / false si no existe
	 */
	public boolean existenMasTramites(String idExpediente, String idTramite, String idTipoTramite) {
		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcohd(idExpediente);
		tramitehechoAux.setEhcotee(idTipoTramite);
		List<TramiteHecho> listaTramitesCierre = this.tramiteHechoDao.findAll(tramitehechoAux, null);
		if (listaTramitesCierre != null && listaTramitesCierre.size() > 0) {
			for (TramiteHecho tramitehechoCierre : listaTramitesCierre) {
				if (!idTramite.equals(tramitehechoCierre.getEhcodigo())) {
					// En caso de que haya algun tramite que sea de cierre en el
					// expediente y no sea el recibido por parametro
					return true;
				}
			}
		}
		return false;
	}

	/**
	 * Modifica las fechas de los tramites de cierre del expediente. En concreto
	 * las fechas de inicio de la fecha limite. Usado en tramites de Decision,
	 * Orden Consejero...
	 * 
	 * @param idExpediente
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateFechasTramiteCierre(String idExpediente) {
		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcohd(idExpediente);
		tramitehechoAux.setEhcotee(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);
		List<TramiteHecho> listaTramitesCierre = this.tramiteHechoDao.findAll(tramitehechoAux, null);
		if (listaTramitesCierre != null && listaTramitesCierre.size() > 0) {
			// 1. Se calculan fecha inicio y fecha limite
			Tramite tramiteAux = new Tramite();
			tramiteAux.setTrcodigo(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);
			tramiteAux = this.tramiteDao.find(tramiteAux);
			Date fechaInicio = new Date();
			Date fechaLimite = null;
			if (tramiteAux.getPlazo() != null && tramiteAux.getPlazo() > 0) {
				fechaLimite = Y41bUtils.addDays(fechaInicio, tramiteAux.getPlazo());
			}
			// 2. Se actualizan fecha inicio y fecha limite en tramites cierre
			// Deberia haber solo 1 tramite de cierre por expediente
			for (TramiteHecho tramitehechoCierre : listaTramitesCierre) {
				tramitehechoCierre.setEhfechainicio(fechaInicio);
				tramitehechoCierre.setEhfechalimite(fechaLimite);
				this.tramiteHechoDao.updateFechaInicio(tramitehechoCierre);
				this.tramiteHechoDao.updateFechaLimite(tramitehechoCierre);
			}
		}
	}

	/**
	 * Actualizamos la fecha limite del tramite de cierre a null
	 * 
	 * @param idExpediente
	 *            String
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void updateFechaLimiteTramiteCierre(String idExpediente) {
		TramiteHecho tramitehechoAux = new TramiteHecho();
		tramitehechoAux.setEhcohd(idExpediente);
		tramitehechoAux.setEhcotee(Y41bConstantes.TRAMITE_CIERRE_EXPEDIENTE);
		List<TramiteHecho> listaTramitesCierre = this.tramiteHechoDao.findAll(tramitehechoAux, null);
		if (listaTramitesCierre != null && listaTramitesCierre.size() > 0) {
			// Se actualiza la fecha limite a null
			for (TramiteHecho tramitehechoCierre : listaTramitesCierre) {
				tramitehechoCierre.setEhfechalimite(null);
				this.tramiteHechoDao.updateFechaLimite(tramitehechoCierre);
			}
		}
	}

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	public TramiteHecho find(TramiteHecho tramiteHecho) {
		return (TramiteHecho) this.tramiteHechoDao.find(tramiteHecho);
	}

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TramiteHecho> findAll(TramiteHecho tramiteHecho, Pagination pagination) {
		return (List<TramiteHecho>) this.tramiteHechoDao.findAll(tramiteHecho, pagination);
	}

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return Long
	 */
	public Long findAllCount(TramiteHecho tramiteHecho) {
		return this.tramiteHechoDao.findAllCount(tramiteHecho);
	}

	/**
	 * Finds rows in the TramiteHecho table using like.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TramiteHecho> findAllLike(TramiteHecho tramiteHecho, Pagination pagination, Boolean startsWith) {
		return (List<TramiteHecho>) this.tramiteHechoDao.findAllLike(tramiteHecho, pagination, startsWith);
	}

	/**
	 * Counts rows in the TramiteHecho table using like.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TramiteHecho tramiteHecho, Boolean startsWith) {
		return this.tramiteHechoDao.findAllLikeCount(tramiteHecho, startsWith);
	}

	/**
	 * Deletes a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TramiteHecho tramiteHecho) {
		this.tramiteHechoDao.remove(tramiteHecho);
	}

	/**
	 * Deletes multiple rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<TramiteHecho> tramiteHechoList) {
		for (TramiteHecho tramiteHechoAux : tramiteHechoList) {
			this.tramiteHechoDao.remove(tramiteHechoAux);
		}
	}

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	public Long getNewEsperaPK() {
		return this.tramiteHechoDao.getNewEsperaPK();
	}

	/**
	 * Finds row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	public TramiteHecho findTramiteRegistroSolicitud(TramiteHecho tramiteHecho) {
		return (TramiteHecho) this.tramiteHechoDao.findTramiteRegistroSolicitud(tramiteHecho);
	}

}
