package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Parametros;
import com.ejie.y41b.model.TramiteHecho;

/**
 * TramiteHechoService  
 * 
 *  
 */

public interface TramiteHechoService {

	/**
	 * Inserts a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho add(TramiteHecho tramiteHecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho update(TramiteHecho tramiteHecho);

	/**
	 * Updates a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	public TramiteHecho updateRegistroSalidaPlatea(TramiteHecho tramiteHecho);

	/**
	 * Inserts a single row in the TramiteHecho table. Se incorpora
	 * funcionalidad de fecha limite
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho addTramiteHecho(TramiteHecho tramiteHecho);

	/**
	 * Updates a single row in the TramiteHecho table. Se incorpora
	 * funcionalidad de fecha limite
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho updateTramiteHecho(TramiteHecho tramiteHecho);

	/**
	 * Busca en el expediente si existe un tipo de tramite o no
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTipoTramite
	 *            String
	 * @return true si existe / false si no existe
	 */
	boolean existeTramite(String idExpediente, String idTipoTramite);

	/**
	 * Busca en el expediente si existe para un tipo de tramite, algun tramite
	 * que no sea el tramite recibido por parametro
	 * 
	 * @param idExpediente
	 *            String
	 * @param idTramite
	 *            String
	 * @param idTipoTramite
	 *            String
	 * @return true si existe / false si no existe
	 */
	boolean existenMasTramites(String idExpediente, String idTramite, String idTipoTramite);

	/**
	 * Modifica las fechas de los tramites de cierre del expediente. En concreto
	 * las fechas de inicio de la fecha limite.
	 * 
	 * @param idExpediente
	 *            String
	 */
	void updateFechasTramiteCierre(String idExpediente);

	/**
	 * Actualizamos la fecha limite del tramite de cierre a null
	 * 
	 * @param idExpediente
	 *            String
	 */
	void updateFechaLimiteTramiteCierre(String idExpediente);

	/**
	 * Finds a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho find(TramiteHecho tramiteHecho);

	/**
	 * Finds a List of rows in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TramiteHecho> findAll(TramiteHecho tramiteHecho, Pagination pagination);

	/**
	 * Counts rows in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return Long
	 */
	Long findAllCount(TramiteHecho tramiteHecho);

	/**
	 * Finds rows in the TramiteHecho table using like.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TramiteHecho> findAllLike(TramiteHecho tramiteHecho, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TramiteHecho table using like.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TramiteHecho tramiteHecho, Boolean startsWith);

	/**
	 * Deletes a single row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return
	 */
	void remove(TramiteHecho tramiteHecho);

	/**
	 * Deletes multiple rows in the TramiteHecho table.
	 * 
	 * @param tramiteHechoList
	 *            List
	 * @return
	 */
	void removeMultiple(List<TramiteHecho> tramiteHechoList);

	/**
	 * Obtiene el parametro de configuracion para obtener el plazo de días
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return Parametros
	 */
	Parametros getParametros(TramiteHecho tramiteHecho);

	/**
	 * Get a New PK (Esperas).
	 * 
	 * @return Long
	 */
	public Long getNewEsperaPK();

	/**
	 * Finds row in the TramiteHecho table.
	 * 
	 * @param tramiteHecho
	 *            TramiteHecho
	 * @return TramiteHecho
	 */
	TramiteHecho findTramiteRegistroSolicitud(TramiteHecho tramiteHecho);

}
