package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TipsubsanaDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tipsubsana;

/**
 * TipsubsanaServiceImpl  
 * 
 *  
 */

@Service(value = "tipsubsanaService")
public class TipsubsanaServiceImpl implements TipsubsanaService {

	@Autowired
	private TipsubsanaDao tipsubsanaDao;

	/**
	 * Inserts a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Tipsubsana
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipsubsana add(Tipsubsana tipsubsana) {
		return this.tipsubsanaDao.add(tipsubsana);
	}

	/**
	 * Updates a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Tipsubsana
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipsubsana update(Tipsubsana tipsubsana) {
		return this.tipsubsanaDao.update(tipsubsana);
	}

	/**
	 * Finds a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Tipsubsana
	 */
	public Tipsubsana find(Tipsubsana tipsubsana) {
		return (Tipsubsana) this.tipsubsanaDao.find(tipsubsana);
	}

	/**
	 * Finds a List of rows in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tipsubsana> findAll(Tipsubsana tipsubsana, Pagination pagination) {
		return (List<Tipsubsana>) this.tipsubsanaDao.findAll(tipsubsana,
				pagination);
	}

	/**
	 * Counts rows in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Long
	 */
	public Long findAllCount(Tipsubsana tipsubsana) {
		return this.tipsubsanaDao.findAllCount(tipsubsana);
	}

	/**
	 * Finds rows in the Tipsubsana table using like.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Tipsubsana> findAllLike(Tipsubsana tipsubsana,
			Pagination pagination, Boolean startsWith) {
		return (List<Tipsubsana>) this.tipsubsanaDao.findAllLike(tipsubsana,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Tipsubsana table using like.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tipsubsana tipsubsana, Boolean startsWith) {
		return this.tipsubsanaDao.findAllLikeCount(tipsubsana, startsWith);
	}

	/**
	 * Deletes a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tipsubsana tipsubsana) {
		this.tipsubsanaDao.remove(tipsubsana);
	}

	/**
	 * Deletes multiple rows in the Tipsubsana table.
	 * 
	 * @param tipsubsanaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tipsubsana> tipsubsanaList) {
		for (Tipsubsana tipsubsanaAux : tipsubsanaList) {
			this.tipsubsanaDao.remove(tipsubsanaAux);
		}
	}

	/**
	 * Finds a List of rows in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tipsubsana> findAllPorTramite(Tipsubsana tipsubsana,
			Pagination pagination) {
		return (List<Tipsubsana>) this.tipsubsanaDao.findAllPorTramite(
				tipsubsana, pagination);
	}
}
