package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.Tipsubsana;

/**
 * TipsubsanaService  
 * 
 *  
 */

public interface TipsubsanaService {

	/**
	 * Inserts a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Tipsubsana
	 */
	Tipsubsana add(Tipsubsana tipsubsana);

	/**
	 * Updates a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Tipsubsana
	 */
	Tipsubsana update(Tipsubsana tipsubsana);

	/**
	 * Finds a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Tipsubsana
	 */
	Tipsubsana find(Tipsubsana tipsubsana);

	/**
	 * Finds a List of rows in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tipsubsana> findAll(Tipsubsana tipsubsana, Pagination pagination);

	/**
	 * Counts rows in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return Long
	 */
	Long findAllCount(Tipsubsana tipsubsana);

	/**
	 * Finds rows in the Tipsubsana table using like.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Tipsubsana> findAllLike(Tipsubsana tipsubsana, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Tipsubsana table using like.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Tipsubsana tipsubsana, Boolean startsWith);

	/**
	 * Deletes a single row in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @return
	 */
	void remove(Tipsubsana tipsubsana);

	/**
	 * Deletes multiple rows in the Tipsubsana table.
	 * 
	 * @param tipsubsanaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Tipsubsana> tipsubsanaList);

	/**
	 * Finds a List of rows in the Tipsubsana table.
	 * 
	 * @param tipsubsana
	 *            Tipsubsana
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Tipsubsana> findAllPorTramite(Tipsubsana tipsubsana,
			Pagination pagination);
}
