package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TiposerroresDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tiposerrores;

/**
 * TiposerroresServiceImpl  
 *  
 */

@Service(value = "tiposerroresService")
public class TiposerroresServiceImpl implements TiposerroresService {

	@Autowired
	private TiposerroresDao tiposerroresDao;

	/**
	 * Inserts a single row in the Tiposerrores table.
	 *
	 * @param tiposerrores Tiposerrores
	 * @return Tiposerrores
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tiposerrores add(Tiposerrores tiposerrores) {
		return this.tiposerroresDao.add(tiposerrores);
	}

	/**
	 * Updates a single row in the Tiposerrores table.
	 *
	 * @param tiposerrores Tiposerrores
	 * @return Tiposerrores
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tiposerrores update(Tiposerrores tiposerrores) {
		return this.tiposerroresDao.update(tiposerrores);
	 }

	/**
	 * Finds a single row in the Tiposerrores table.
	 *
	 * @param tiposerrores Tiposerrores
	 * @return Tiposerrores
	 */
	public Tiposerrores find(Tiposerrores tiposerrores) {
		return (Tiposerrores) this.tiposerroresDao.find(tiposerrores);
	}

	/**
	 * Finds a List of rows in the Tiposerrores table.
	 *
	 * @param tiposerrores Tiposerrores
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Tiposerrores> findAll(Tiposerrores tiposerrores, Pagination pagination) {
		return (List<Tiposerrores>) this.tiposerroresDao.findAll(tiposerrores, pagination);
	}
    
	/**
	 * Counts rows in the Tiposerrores table.
	 *
	 * @param tiposerrores Tiposerrores
	 * @return Long
	 */
	public Long findAllCount(Tiposerrores tiposerrores) {        
		return  this.tiposerroresDao.findAllCount(tiposerrores);
	}

	/**
	 * Finds rows in the Tiposerrores table using like.
	 *
	 * @param tiposerrores Tiposerrores
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Tiposerrores> findAllLike(Tiposerrores tiposerrores, Pagination pagination, Boolean startsWith) {
		return (List<Tiposerrores>) this.tiposerroresDao.findAllLike(tiposerrores, pagination, startsWith);
	}

	/**
	 * Counts rows in the Tiposerrores table using like.
	 *
	 * @param tiposerrores Tiposerrores
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tiposerrores tiposerrores, Boolean startsWith) {
		return this.tiposerroresDao.findAllLikeCount(tiposerrores, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Tiposerrores table.
	 *
	 * @param tiposerrores Tiposerrores
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tiposerrores tiposerrores) {
		this.tiposerroresDao.remove(tiposerrores);
	}
	
	/**
	 * Deletes multiple rows in the Tiposerrores table.
	 *
	 * @param tiposerroresList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tiposerrores> tiposerroresList) {
		for (Tiposerrores  tiposerroresAux:tiposerroresList) {
			this.tiposerroresDao.remove(tiposerroresAux);
		}
	}
	
}

