package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TipopronunciamentoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tipopronunciamento;

/**
 * TipopronunciamentoServiceImpl  
 *  
 */

@Service(value = "tipopronunciamentoService")
public class TipopronunciamentoServiceImpl implements TipopronunciamentoService {

	@Autowired
	private TipopronunciamentoDao tipopronunciamentoDao;

	/**
	 * Inserts a single row in the Tipopronunciamento table.
	 *
	 * @param tipopronunciamento Tipopronunciamento
	 * @return Tipopronunciamento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipopronunciamento add(Tipopronunciamento tipopronunciamento) {
		return this.tipopronunciamentoDao.add(tipopronunciamento);
	}

	/**
	 * Updates a single row in the Tipopronunciamento table.
	 *
	 * @param tipopronunciamento Tipopronunciamento
	 * @return Tipopronunciamento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipopronunciamento update(Tipopronunciamento tipopronunciamento) {
		return this.tipopronunciamentoDao.update(tipopronunciamento);
	 }

	/**
	 * Finds a single row in the Tipopronunciamento table.
	 *
	 * @param tipopronunciamento Tipopronunciamento
	 * @return Tipopronunciamento
	 */
	public Tipopronunciamento find(Tipopronunciamento tipopronunciamento) {
		return (Tipopronunciamento) this.tipopronunciamentoDao.find(tipopronunciamento);
	}

	/**
	 * Finds a List of rows in the Tipopronunciamento table.
	 *
	 * @param tipopronunciamento Tipopronunciamento
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Tipopronunciamento> findAll(Tipopronunciamento tipopronunciamento, Pagination pagination) {
		return (List<Tipopronunciamento>) this.tipopronunciamentoDao.findAll(tipopronunciamento, pagination);
	}
    
	/**
	 * Counts rows in the Tipopronunciamento table.
	 *
	 * @param tipopronunciamento Tipopronunciamento
	 * @return Long
	 */
	public Long findAllCount(Tipopronunciamento tipopronunciamento) {        
		return  this.tipopronunciamentoDao.findAllCount(tipopronunciamento);
	}

	/**
	 * Finds rows in the Tipopronunciamento table using like.
	 *
	 * @param tipopronunciamento Tipopronunciamento
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Tipopronunciamento> findAllLike(Tipopronunciamento tipopronunciamento, Pagination pagination, Boolean startsWith) {
		return (List<Tipopronunciamento>) this.tipopronunciamentoDao.findAllLike(tipopronunciamento, pagination, startsWith);
	}

	/**
	 * Counts rows in the Tipopronunciamento table using like.
	 *
	 * @param tipopronunciamento Tipopronunciamento
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tipopronunciamento tipopronunciamento, Boolean startsWith) {
		return this.tipopronunciamentoDao.findAllLikeCount(tipopronunciamento, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Tipopronunciamento table.
	 *
	 * @param tipopronunciamento Tipopronunciamento
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tipopronunciamento tipopronunciamento) {
		this.tipopronunciamentoDao.remove(tipopronunciamento);
	}
	
	/**
	 * Deletes multiple rows in the Tipopronunciamento table.
	 *
	 * @param tipopronunciamentoList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tipopronunciamento> tipopronunciamentoList) {
		for (Tipopronunciamento  tipopronunciamentoAux:tipopronunciamentoList) {
			this.tipopronunciamentoDao.remove(tipopronunciamentoAux);
		}
	}
	
}

