package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TipomovimientosDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tipomovimientos;

/**
 * TipomovimientosServiceImpl  
 *  
 */

@Service(value = "tipomovimientosService")
public class TipomovimientosServiceImpl implements TipomovimientosService {

	@Autowired
	private TipomovimientosDao tipomovimientosDao;

	/**
	 * Inserts a single row in the Tipomovimientos table.
	 *
	 * @param tipomovimientos Tipomovimientos
	 * @return Tipomovimientos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipomovimientos add(Tipomovimientos tipomovimientos) {
		return this.tipomovimientosDao.add(tipomovimientos);
	}

	/**
	 * Updates a single row in the Tipomovimientos table.
	 *
	 * @param tipomovimientos Tipomovimientos
	 * @return Tipomovimientos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipomovimientos update(Tipomovimientos tipomovimientos) {
		return this.tipomovimientosDao.update(tipomovimientos);
	 }

	/**
	 * Finds a single row in the Tipomovimientos table.
	 *
	 * @param tipomovimientos Tipomovimientos
	 * @return Tipomovimientos
	 */
	public Tipomovimientos find(Tipomovimientos tipomovimientos) {
		return (Tipomovimientos) this.tipomovimientosDao.find(tipomovimientos);
	}

	/**
	 * Finds a List of rows in the Tipomovimientos table.
	 *
	 * @param tipomovimientos Tipomovimientos
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Tipomovimientos> findAll(Tipomovimientos tipomovimientos, Pagination pagination) {
		return (List<Tipomovimientos>) this.tipomovimientosDao.findAll(tipomovimientos, pagination);
	}
    
	/**
	 * Counts rows in the Tipomovimientos table.
	 *
	 * @param tipomovimientos Tipomovimientos
	 * @return Long
	 */
	public Long findAllCount(Tipomovimientos tipomovimientos) {        
		return  this.tipomovimientosDao.findAllCount(tipomovimientos);
	}

	/**
	 * Finds rows in the Tipomovimientos table using like.
	 *
	 * @param tipomovimientos Tipomovimientos
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Tipomovimientos> findAllLike(Tipomovimientos tipomovimientos, Pagination pagination, Boolean startsWith) {
		return (List<Tipomovimientos>) this.tipomovimientosDao.findAllLike(tipomovimientos, pagination, startsWith);
	}

	/**
	 * Counts rows in the Tipomovimientos table using like.
	 *
	 * @param tipomovimientos Tipomovimientos
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tipomovimientos tipomovimientos, Boolean startsWith) {
		return this.tipomovimientosDao.findAllLikeCount(tipomovimientos, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Tipomovimientos table.
	 *
	 * @param tipomovimientos Tipomovimientos
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tipomovimientos tipomovimientos) {
		this.tipomovimientosDao.remove(tipomovimientos);
	}
	
	/**
	 * Deletes multiple rows in the Tipomovimientos table.
	 *
	 * @param tipomovimientosList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tipomovimientos> tipomovimientosList) {
		for (Tipomovimientos  tipomovimientosAux:tipomovimientosList) {
			this.tipomovimientosDao.remove(tipomovimientosAux);
		}
	}
	
}

