package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TipoconceptopagoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tipoconceptopago;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * TipoconceptopagoServiceImpl  
 * 
 *  
 */

@Service(value = "tipoconceptopagoService")
public class TipoconceptopagoServiceImpl implements TipoconceptopagoService {

	@Autowired
	private TipoconceptopagoDao tipoconceptopagoDao;

	/**
	 * Inserts a single row in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @return Tipoconceptopago
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipoconceptopago add(Tipoconceptopago tipoconceptopago) {
		return this.tipoconceptopagoDao.add(tipoconceptopago);
	}

	/**
	 * Updates a single row in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @return Tipoconceptopago
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipoconceptopago update(Tipoconceptopago tipoconceptopago) {
		return this.tipoconceptopagoDao.update(tipoconceptopago);
	}

	/**
	 * Finds a single row in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @return Tipoconceptopago
	 */
	public Tipoconceptopago find(Tipoconceptopago tipoconceptopago) {
		return (Tipoconceptopago) this.tipoconceptopagoDao
				.find(tipoconceptopago);
	}

	/**
	 * Finds a List of rows in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tipoconceptopago> findAll(Tipoconceptopago tipoconceptopago,
			Pagination pagination) {
		if (pagination != null && pagination.getSort() != null
				&& pagination.getSort().equals("claseingreso.sldesces")) {
			pagination.setSort("claseingresosldesces");
		}
		if (pagination != null && pagination.getSort() != null
				&& pagination.getSort().equals("claseingreso.sldesceu")) {
			pagination.setSort("claseingresosldesceu");
		}
		return (List<Tipoconceptopago>) this.tipoconceptopagoDao.findAll(
				tipoconceptopago, pagination);
	}

	/**
	 * Counts rows in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @return Long
	 */
	public Long findAllCount(Tipoconceptopago tipoconceptopago) {
		return this.tipoconceptopagoDao.findAllCount(tipoconceptopago);
	}

	/**
	 * Finds rows in the Tipoconceptopago table using like.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Tipoconceptopago> findAllLike(
			Tipoconceptopago tipoconceptopago, Pagination pagination,
			Boolean startsWith) {
		return (List<Tipoconceptopago>) this.tipoconceptopagoDao.findAllLike(
				tipoconceptopago, pagination, startsWith);
	}

	/**
	 * Counts rows in the Tipoconceptopago table using like.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tipoconceptopago tipoconceptopago,
			Boolean startsWith) {
		return this.tipoconceptopagoDao.findAllLikeCount(tipoconceptopago,
				startsWith);
	}

	/**
	 * Deletes a single row in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopago
	 *            Tipoconceptopago
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tipoconceptopago tipoconceptopago) {
		try {
			this.tipoconceptopagoDao.remove(tipoconceptopago);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.tipoconceptopago.DataIntegrityViolationException",
					true, e);
		}

	}

	/**
	 * Deletes multiple rows in the Tipoconceptopago table.
	 * 
	 * @param tipoconceptopagoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tipoconceptopago> tipoconceptopagoList) {
		for (Tipoconceptopago tipoconceptopagoAux : tipoconceptopagoList) {
			this.tipoconceptopagoDao.remove(tipoconceptopagoAux);
		}
	}

	/**
	 * getNewPK .
	 * 
	 * @return long
	 */
	@Transactional(rollbackFor = Throwable.class)
	public long getNewPK() {
		return this.tipoconceptopagoDao.getNewPK();
	}
}
