package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TipoReclamacionDao;
import com.ejie.y41b.model.TipoReclamacion;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TipoReclamacionServiceImpl  
 * 
 *  
 */

@Service(value = "tipoReclamacionService")
public class TipoReclamacionServiceImpl implements TipoReclamacionService {

	private static final Logger logger = LoggerFactory
			.getLogger(TipoReclamacionServiceImpl.class);
	@Autowired
	private TipoReclamacionDao tipoReclamacionDao;

	/**
	 * Inserts a single row in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoReclamacion add(TipoReclamacion tipoReclamacion) {
		try {
			return this.tipoReclamacionDao.add(tipoReclamacion);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException(
					"error.tiporeclamacion.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoReclamacion update(TipoReclamacion tipoReclamacion) {
		return this.tipoReclamacionDao.update(tipoReclamacion);
	}

	/**
	 * Updates a single row in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoReclamacion updateFechaBaja(TipoReclamacion tipoReclamacion) {
		return this.tipoReclamacionDao.updateFechaBaja(tipoReclamacion);
	}

	/**
	 * Finds a single row in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	public TipoReclamacion find(TipoReclamacion tipoReclamacion) {
		return (TipoReclamacion) this.tipoReclamacionDao.find(tipoReclamacion);
	}

	/**
	 * Finds a List of rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoReclamacion> findAll(TipoReclamacion tipoReclamacion,
			Pagination pagination) {
		return (List<TipoReclamacion>) this.tipoReclamacionDao.findAll(
				tipoReclamacion, pagination);
	}

	/**
	 * Counts rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return Long
	 */
	public Long findAllCount(TipoReclamacion tipoReclamacion) {
		return this.tipoReclamacionDao.findAllCount(tipoReclamacion);
	}

	/**
	 * Finds a List of rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoReclamacion> findAllAlta(TipoReclamacion tipoReclamacion,
			Pagination pagination) {
		return (List<TipoReclamacion>) this.tipoReclamacionDao.findAllAlta(
				tipoReclamacion, pagination);
	}

	/**
	 * Counts rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return Long
	 */
	public Long findAllAltaCount(TipoReclamacion tipoReclamacion) {
		return this.tipoReclamacionDao.findAllAltaCount(tipoReclamacion);
	}

	/**
	 * Finds rows in the TipoReclamacion table using like.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipoReclamacion> findAllLike(TipoReclamacion tipoReclamacion,
			Pagination pagination, Boolean startsWith) {
		return (List<TipoReclamacion>) this.tipoReclamacionDao.findAllLike(
				tipoReclamacion, pagination, startsWith);
	}

	/**
	 * Counts rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TipoReclamacion tipoReclamacion,
			Boolean startsWith) {
		return this.tipoReclamacionDao.findAllLikeCount(tipoReclamacion,
				startsWith);
	}

	/**
	 * Deletes a single row in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoReclamacion tipoReclamacion) {
		try {
			this.tipoReclamacionDao.remove(tipoReclamacion);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.tiporeclamacion.DataIntegrityViolationException",
					true, e);
		}
	}

	/**
	 * Deletes multiple rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacionList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipoReclamacion> tipoReclamacionList) {
		for (TipoReclamacion tipoReclamacionAux : tipoReclamacionList) {
			this.tipoReclamacionDao.remove(tipoReclamacionAux);
		}
	}

	/**
	 * Getter method for TipoReclamacionDao
	 * 
	 * @return TipoReclamacionDao
	 */
	public TipoReclamacionDao getTipoReclamacionDao() {
		return this.tipoReclamacionDao;
	}

	/**
	 * Setter method for TipoReclamacionDao.
	 * 
	 * @param tipoReclamacionDao
	 *            TipoReclamacionDao
	 * @return
	 */
	public void setTipoReclamacionDao(TipoReclamacionDao tipoReclamacionDao) {
		logger.info("Setting Dependency " + tipoReclamacionDao);
		this.tipoReclamacionDao = tipoReclamacionDao;
	}
}
