package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.TipoReclamacion;

/**
 * * TipoReclamacionService  
 * 
 *  
 */

public interface TipoReclamacionService {

	/**
	 * Inserts a single row in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion add(TipoReclamacion tipoReclamacion);

	/**
	 * Updates a single row in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion update(TipoReclamacion tipoReclamacion);

	/**
	 * Updates a single row in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	public TipoReclamacion updateFechaBaja(TipoReclamacion tipoReclamacion);

	/**
	 * Finds a single row in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return TipoReclamacion
	 */
	TipoReclamacion find(TipoReclamacion tipoReclamacion);

	/**
	 * Finds a List of rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipoReclamacion> findAll(TipoReclamacion tipoReclamacion,
			Pagination pagination);

	/**
	 * Counts rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return Long
	 */
	Long findAllCount(TipoReclamacion tipoReclamacion);

	/**
	 * Finds a List of rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoReclamacion> findAllAlta(TipoReclamacion tipoReclamacion,
			Pagination pagination);

	/**
	 * Counts rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return Long
	 */
	public Long findAllAltaCount(TipoReclamacion tipoReclamacion);

	/**
	 * Finds rows in the TipoReclamacion table using like.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipoReclamacion> findAllLike(TipoReclamacion tipoReclamacion,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TipoReclamacion tipoReclamacion,
			Boolean startsWith);

	/**
	 * Deletes a single row in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacion
	 *            TipoReclamacion
	 * @return
	 */
	void remove(TipoReclamacion tipoReclamacion);

	/**
	 * Deletes multiple rows in the TipoReclamacion table.
	 * 
	 * @param tipoReclamacionList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<TipoReclamacion> tipoReclamacionList);

}
