package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TipoProcedimientoDao;
import com.ejie.y41b.model.TipoProcedimiento;

/**
 * TipoProcedimientoServiceImpl  
 * 
 *  
 */

@Service(value = "tipoProcedimientoService")
public class TipoProcedimientoServiceImpl implements TipoProcedimientoService {

	@Autowired
	private TipoProcedimientoDao tipoProcedimientoDao;

	/**
	 * Inserts a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return TipoProcedimiento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoProcedimiento add(TipoProcedimiento tipoProcedimiento) {
		return this.tipoProcedimientoDao.add(tipoProcedimiento);
	}

	/**
	 * Updates a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return TipoProcedimiento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoProcedimiento update(TipoProcedimiento tipoProcedimiento) {
		return this.tipoProcedimientoDao.update(tipoProcedimiento);
	}

	/**
	 * Finds a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return TipoProcedimiento
	 */
	public TipoProcedimiento find(TipoProcedimiento tipoProcedimiento) {
		return (TipoProcedimiento) this.tipoProcedimientoDao.find(tipoProcedimiento);
	}

	/**
	 * Finds a List of rows in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoProcedimiento> findAll(TipoProcedimiento tipoProcedimiento, Pagination pagination) {
		return (List<TipoProcedimiento>) this.tipoProcedimientoDao.findAll(tipoProcedimiento, pagination);
	}

	/**
	 * Finds a List of rows in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoProcedimiento> findAllConRemesa(TipoProcedimiento tipoProcedimiento, Pagination pagination) {
		return (List<TipoProcedimiento>) this.tipoProcedimientoDao.findAllConRemesa(tipoProcedimiento, pagination);
	}

	/**
	 * Counts rows in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return Long
	 */
	public Long findAllCount(TipoProcedimiento tipoProcedimiento) {
		return this.tipoProcedimientoDao.findAllCount(tipoProcedimiento);
	}

	/**
	 * Counts rows in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return Long
	 */
	public Long findAllCountConRemesa(TipoProcedimiento tipoProcedimiento) {
		return this.tipoProcedimientoDao.findAllCountConRemesa(tipoProcedimiento);
	}

	/**
	 * Finds rows in the TipoProcedimiento table using like.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipoProcedimiento> findAllLike(TipoProcedimiento tipoProcedimiento, Pagination pagination,
			Boolean startsWith) {
		return (List<TipoProcedimiento>) this.tipoProcedimientoDao.findAllLike(tipoProcedimiento, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the TipoProcedimiento table using like.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TipoProcedimiento tipoProcedimiento, Boolean startsWith) {
		return this.tipoProcedimientoDao.findAllLikeCount(tipoProcedimiento, startsWith);
	}

	/**
	 * Deletes a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoProcedimiento tipoProcedimiento) {
		this.tipoProcedimientoDao.remove(tipoProcedimiento);
	}

	/**
	 * Deletes multiple rows in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimientoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<TipoProcedimiento> tipoProcedimientoList) {
		for (TipoProcedimiento tipoProcedimientoAux : tipoProcedimientoList) {
			this.tipoProcedimientoDao.remove(tipoProcedimientoAux);
		}
	}

	// EVOLUTIVO 0150942
	@Override
	public List<TipoProcedimiento> findAllCombo(TipoProcedimiento filterTipoProcedimiento, Pagination pagination) {
		return (List<TipoProcedimiento>) this.tipoProcedimientoDao.findAllCombo(filterTipoProcedimiento, pagination);
	}
	// EVOLUTIVO 0150942

	/**
	 * Finds a List of rows in the TipoProcedimiento table. Para el combo de
	 * avisos multiple en establecimiento
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	@Transactional(rollbackFor = Throwable.class)
	public List<TipoProcedimiento> findAllProcAvisos() {
		return (List<TipoProcedimiento>) this.tipoProcedimientoDao.findAllProcAvisos();
	}
}
