package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.TipoProcedimiento;

/**
 * TipoProcedimientoService  
 * 
 *  
 */

public interface TipoProcedimientoService {

	/**
	 * Inserts a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return TipoProcedimiento
	 */
	TipoProcedimiento add(TipoProcedimiento tipoProcedimiento);

	/**
	 * Updates a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return TipoProcedimiento
	 */
	TipoProcedimiento update(TipoProcedimiento tipoProcedimiento);

	/**
	 * Finds a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return TipoProcedimiento
	 */
	TipoProcedimiento find(TipoProcedimiento tipoProcedimiento);

	/**
	 * Finds a List of rows in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipoProcedimiento> findAll(TipoProcedimiento tipoProcedimiento, Pagination pagination);

	/**
	 * Finds a List of rows in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipoProcedimiento> findAllConRemesa(TipoProcedimiento tipoProcedimiento, Pagination pagination);

	/**
	 * Counts rows in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return Long
	 */
	Long findAllCount(TipoProcedimiento tipoProcedimiento);

	/**
	 * Counts rows in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return Long
	 */
	Long findAllCountConRemesa(TipoProcedimiento tipoProcedimiento);

	/**
	 * Finds rows in the TipoProcedimiento table using like.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipoProcedimiento> findAllLike(TipoProcedimiento tipoProcedimiento, Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TipoProcedimiento table using like.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TipoProcedimiento tipoProcedimiento, Boolean startsWith);

	/**
	 * Deletes a single row in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimiento
	 *            TipoProcedimiento
	 * @return
	 */
	void remove(TipoProcedimiento tipoProcedimiento);

	/**
	 * Deletes multiple rows in the TipoProcedimiento table.
	 * 
	 * @param tipoProcedimientoList
	 *            List
	 * @return
	 */
	void removeMultiple(List<TipoProcedimiento> tipoProcedimientoList);

	// EVOLUTIVO 0150942
	List<TipoProcedimiento> findAllCombo(TipoProcedimiento filterTipoProcedimiento, Pagination pagination);
	// EVOLUTIVO 0150942

	/**
	 * Finds a List of rows in the TipoProcedimiento table. Para el combo de
	 * avisos multiple en establecimiento
	 * 
	 * @param tipoprocedimiento
	 *            TipoProcedimiento
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipoProcedimiento> findAllProcAvisos();

}
