package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TipoInfraccionAgrupadoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.TipoInfraccionAgrupado;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * TipoInfraccionAgrupadoServiceImpl  
 * 
 *  
 */

@Service(value = "tipoInfraccionAgrupadoService")
public class TipoInfraccionAgrupadoServiceImpl implements
		TipoInfraccionAgrupadoService {

	@Autowired
	private TipoInfraccionAgrupadoDao tipoInfraccionAgrupadoDao;

	/**
	 * Inserts a single row in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @return TipoInfraccionAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoInfraccionAgrupado add(
			TipoInfraccionAgrupado tipoInfraccionAgrupado) {
		try {
			return this.tipoInfraccionAgrupadoDao.add(tipoInfraccionAgrupado);
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException(
					"error.tipoinfraccionagrupado.DuplicateKeyException", true,
					e);
		}
	}

	/**
	 * Updates a single row in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @return TipoInfraccionAgrupado
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoInfraccionAgrupado update(
			TipoInfraccionAgrupado tipoInfraccionAgrupado) {
		return this.tipoInfraccionAgrupadoDao.update(tipoInfraccionAgrupado);
	}

	/**
	 * Finds a single row in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @return TipoInfraccionAgrupado
	 */
	public TipoInfraccionAgrupado find(
			TipoInfraccionAgrupado tipoInfraccionAgrupado) {
		return (TipoInfraccionAgrupado) this.tipoInfraccionAgrupadoDao
				.find(tipoInfraccionAgrupado);
	}

	/**
	 * Finds a List of rows in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipoInfraccionAgrupado> findAll(
			TipoInfraccionAgrupado tipoInfraccionAgrupado, Pagination pagination) {
		return (List<TipoInfraccionAgrupado>) this.tipoInfraccionAgrupadoDao
				.findAll(tipoInfraccionAgrupado, pagination);
	}

	/**
	 * Counts rows in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @return Long
	 */
	public Long findAllCount(TipoInfraccionAgrupado tipoInfraccionAgrupado) {
		return this.tipoInfraccionAgrupadoDao
				.findAllCount(tipoInfraccionAgrupado);
	}

	/**
	 * Finds rows in the TipoInfraccionAgrupado table using like.
	 * 
	 * @param tipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipoInfraccionAgrupado> findAllLike(
			TipoInfraccionAgrupado tipoInfraccionAgrupado,
			Pagination pagination, Boolean startsWith) {

		// Control para poder ordenar correctamente el campo código alfanumérico
		if (pagination != null) {
			if (pagination.getSort() != null
					&& pagination.getSort().equals("l4codigo")) {

				if (pagination.getAscDsc().equals("asc")) {
					pagination
							.setSort("regexp_substr(l4codigo, '^\\D*') , to_number(regexp_substr(l4codigo, '\\d+')) ");

				} else if (pagination.getAscDsc().equals("desc")) {
					pagination
							.setSort("regexp_substr(l4codigo, '^\\D*') DESC, to_number(regexp_substr(l4codigo, '\\d+')) ");

				}
			}
		}

		return (List<TipoInfraccionAgrupado>) this.tipoInfraccionAgrupadoDao
				.findAllLike(tipoInfraccionAgrupado, pagination, startsWith);
	}

	/**
	 * Counts rows in the TipoInfraccionAgrupado table using like.
	 * 
	 * @param tipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TipoInfraccionAgrupado tipoInfraccionAgrupado,
			Boolean startsWith) {
		return this.tipoInfraccionAgrupadoDao.findAllLikeCount(
				tipoInfraccionAgrupado, startsWith);
	}

	/**
	 * Deletes a single row in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoInfraccionAgrupado
	 *            TipoInfraccionAgrupado
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoInfraccionAgrupado tipoInfraccionAgrupado) {
		try {
			this.tipoInfraccionAgrupadoDao.remove(tipoInfraccionAgrupado);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.tipoinfraccionagrupado.DataIntegrityViolationException",
					true, e);
		}
	}

	/**
	 * Deletes multiple rows in the TipoInfraccionAgrupado table.
	 * 
	 * @param tipoInfraccionAgrupadoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(
			List<TipoInfraccionAgrupado> tipoInfraccionAgrupadoList) {
		for (TipoInfraccionAgrupado tipoInfraccionAgrupadoAux : tipoInfraccionAgrupadoList) {
			this.tipoInfraccionAgrupadoDao.remove(tipoInfraccionAgrupadoAux);
		}
	}

}
