package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TipoDocumentoDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.TipoDocumento;

/**
 * TipoDocumentoServiceImpl  
 *  
 */

@Service(value = "tipoDocumentoService")
public class TipoDocumentoServiceImpl implements TipoDocumentoService {

	@Autowired
	private TipoDocumentoDao tipoDocumentoDao;

	/**
	 * Inserts a single row in the TipoDocumento table.
	 *
	 * @param tipoDocumento TipoDocumento
	 * @return TipoDocumento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoDocumento add(TipoDocumento tipoDocumento) {
		return this.tipoDocumentoDao.add(tipoDocumento);
	}

	/**
	 * Updates a single row in the TipoDocumento table.
	 *
	 * @param tipoDocumento TipoDocumento
	 * @return TipoDocumento
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoDocumento update(TipoDocumento tipoDocumento) {
		return this.tipoDocumentoDao.update(tipoDocumento);
	 }

	/**
	 * Finds a single row in the TipoDocumento table.
	 *
	 * @param tipoDocumento TipoDocumento
	 * @return TipoDocumento
	 */
	public TipoDocumento find(TipoDocumento tipoDocumento) {
		return (TipoDocumento) this.tipoDocumentoDao.find(tipoDocumento);
	}

	/**
	 * Finds a List of rows in the TipoDocumento table.
	 *
	 * @param tipoDocumento TipoDocumento
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipoDocumento> findAll(TipoDocumento tipoDocumento, Pagination pagination) {
		return (List<TipoDocumento>) this.tipoDocumentoDao.findAll(tipoDocumento, pagination);
	}
    
	/**
	 * Counts rows in the TipoDocumento table.
	 *
	 * @param tipoDocumento TipoDocumento
	 * @return Long
	 */
	public Long findAllCount(TipoDocumento tipoDocumento) {        
		return  this.tipoDocumentoDao.findAllCount(tipoDocumento);
	}

	/**
	 * Finds rows in the TipoDocumento table using like.
	 *
	 * @param tipoDocumento TipoDocumento
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipoDocumento> findAllLike(TipoDocumento tipoDocumento, Pagination pagination, Boolean startsWith) {
		return (List<TipoDocumento>) this.tipoDocumentoDao.findAllLike(tipoDocumento, pagination, startsWith);
	}

	/**
	 * Counts rows in the TipoDocumento table using like.
	 *
	 * @param tipoDocumento TipoDocumento
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TipoDocumento tipoDocumento, Boolean startsWith) {
		return this.tipoDocumentoDao.findAllLikeCount(tipoDocumento, startsWith);
	}
	    
	/**
	 * Deletes a single row in the TipoDocumento table.
	 *
	 * @param tipoDocumento TipoDocumento
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoDocumento tipoDocumento) {
		this.tipoDocumentoDao.remove(tipoDocumento);
	}
	
	/**
	 * Deletes multiple rows in the TipoDocumento table.
	 *
	 * @param tipoDocumentoList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<TipoDocumento> tipoDocumentoList) {
		for (TipoDocumento  tipoDocumentoAux:tipoDocumentoList) {
			this.tipoDocumentoDao.remove(tipoDocumentoAux);
		}
	}
	
}

