package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TipoCaracterAlertaDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.TipoCaracterAlerta;

/**
 * TipoCaracterAlertaServiceImpl  
 *  
 */

@Service(value = "tipoCaracterAlertaService")
public class TipoCaracterAlertaServiceImpl implements TipoCaracterAlertaService {

	@Autowired
	private TipoCaracterAlertaDao tipoCaracterAlertaDao;

	/**
	 * Inserts a single row in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @return TipoCaracterAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoCaracterAlerta add(TipoCaracterAlerta tipoCaracterAlerta) {
		return this.tipoCaracterAlertaDao.add(tipoCaracterAlerta);
	}

	/**
	 * Updates a single row in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @return TipoCaracterAlerta
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipoCaracterAlerta update(TipoCaracterAlerta tipoCaracterAlerta) {
		return this.tipoCaracterAlertaDao.update(tipoCaracterAlerta);
	 }

	/**
	 * Finds a single row in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @return TipoCaracterAlerta
	 */
	public TipoCaracterAlerta find(TipoCaracterAlerta tipoCaracterAlerta) {
		return (TipoCaracterAlerta) this.tipoCaracterAlertaDao.find(tipoCaracterAlerta);
	}

	/**
	 * Finds a List of rows in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @param pagination Pagination
	 * @return List
	 */
	public List<TipoCaracterAlerta> findAll(TipoCaracterAlerta tipoCaracterAlerta, Pagination pagination) {
		return (List<TipoCaracterAlerta>) this.tipoCaracterAlertaDao.findAll(tipoCaracterAlerta, pagination);
	}
    
	/**
	 * Counts rows in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @return Long
	 */
	public Long findAllCount(TipoCaracterAlerta tipoCaracterAlerta) {        
		return  this.tipoCaracterAlertaDao.findAllCount(tipoCaracterAlerta);
	}

	/**
	 * Finds rows in the TipoCaracterAlerta table using like.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<TipoCaracterAlerta> findAllLike(TipoCaracterAlerta tipoCaracterAlerta, Pagination pagination, Boolean startsWith) {
		return (List<TipoCaracterAlerta>) this.tipoCaracterAlertaDao.findAllLike(tipoCaracterAlerta, pagination, startsWith);
	}

	/**
	 * Counts rows in the TipoCaracterAlerta table using like.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TipoCaracterAlerta tipoCaracterAlerta, Boolean startsWith) {
		return this.tipoCaracterAlertaDao.findAllLikeCount(tipoCaracterAlerta, startsWith);
	}
	    
	/**
	 * Deletes a single row in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipoCaracterAlerta tipoCaracterAlerta) {
		this.tipoCaracterAlertaDao.remove(tipoCaracterAlerta);
	}
	
	/**
	 * Deletes multiple rows in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlertaList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<TipoCaracterAlerta> tipoCaracterAlertaList) {
		for (TipoCaracterAlerta  tipoCaracterAlertaAux:tipoCaracterAlertaList) {
			this.tipoCaracterAlertaDao.remove(tipoCaracterAlertaAux);
		}
	}
	
}

