package com.ejie.y41b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.y41b.model.TipoCaracterAlerta;

/**
 * TipoCaracterAlertaService  
 *  
 */

public interface TipoCaracterAlertaService {

	/**
	 * Inserts a single row in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @return TipoCaracterAlerta
	 */
    TipoCaracterAlerta add(TipoCaracterAlerta tipoCaracterAlerta);

	/**
	 * Updates a single row in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @return TipoCaracterAlerta
	 */
	TipoCaracterAlerta update(TipoCaracterAlerta tipoCaracterAlerta);

	/**
	 * Finds a single row in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @return TipoCaracterAlerta
	 */
	TipoCaracterAlerta find(TipoCaracterAlerta tipoCaracterAlerta);

	/**
	 * Finds a List of rows in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @param pagination Pagination
	 * @return List
	 */
	List<TipoCaracterAlerta> findAll(TipoCaracterAlerta tipoCaracterAlerta, Pagination pagination);

	/**
	 * Counts rows in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @return Long
	 */
	Long findAllCount(TipoCaracterAlerta tipoCaracterAlerta);
	
	/**
	 * Finds rows in the TipoCaracterAlerta table using like.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<TipoCaracterAlerta> findAllLike(TipoCaracterAlerta tipoCaracterAlerta, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the TipoCaracterAlerta table using like.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(TipoCaracterAlerta tipoCaracterAlerta, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlerta TipoCaracterAlerta
	 * @return 
	 */
	void remove(TipoCaracterAlerta tipoCaracterAlerta);
	
	/**
	 * Deletes multiple rows in the TipoCaracterAlerta table.
	 *
	 * @param tipoCaracterAlertaList List
	 * @return 
	 */	
	void removeMultiple(List<TipoCaracterAlerta> tipoCaracterAlertaList);
    
}


