package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TipReqNormativoDao;
import com.ejie.y41b.model.TipReqNormativo;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * * TipReqNormativoServiceImpl  
 * 
 *  
 */

@Service(value = "tipReqNormativoService")
public class TipReqNormativoServiceImpl implements TipReqNormativoService {

	private static final Logger logger = LoggerFactory
			.getLogger(TipReqNormativoServiceImpl.class);
	@Autowired
	private TipReqNormativoDao tipReqNormativoDao;

	/**
	 * Inserts a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipReqNormativo add(TipReqNormativo tipReqNormativo) {
		try {
			tipReqNormativo.setTticodigo(tipReqNormativo.getTticodigo()
					.toUpperCase());
			tipReqNormativo = this.tipReqNormativoDao.add(tipReqNormativo);

			if (tipReqNormativo.getTticodigo().length() > 1) {

				String tticodigoPadre = tipReqNormativo.getTticodigo()
						.substring(0,
								tipReqNormativo.getTticodigo().length() - 1);

				TipReqNormativo tipReqNormativoAux = new TipReqNormativo();
				tipReqNormativoAux.setTticodigo(tticodigoPadre);

				Long numTipReqNormativo1 = this.tipReqNormativoDao
						.findAllCount(tipReqNormativoAux);

				tticodigoPadre = tipReqNormativo.getTticodigo().substring(0,
						tipReqNormativo.getTticodigo().length() - 2);

				tipReqNormativoAux = new TipReqNormativo();
				tipReqNormativoAux.setTticodigo(tticodigoPadre);

				Long numTipReqNormativo2 = this.tipReqNormativoDao
						.findAllCount(tipReqNormativoAux);

				if (numTipReqNormativo1 == 0 && numTipReqNormativo2 == 0) {
					throw new Y41bUDAException(
							"error.tipoinfraccion.NoPadreException", true,
							new Exception());
				}
			}

			return tipReqNormativo;
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException(
					"error.tipoinfraccion.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipReqNormativo update(TipReqNormativo tipReqNormativo) {
		return this.tipReqNormativoDao.update(tipReqNormativo);
	}

	/**
	 * Finds a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	public TipReqNormativo find(TipReqNormativo tipReqNormativo) {
		return (TipReqNormativo) this.tipReqNormativoDao.find(tipReqNormativo);
	}

	/**
	 * Finds a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	public TipReqNormativo findTipReqNormativoSeleccionable(
			TipReqNormativo tipReqNormativo) {
		return (TipReqNormativo) this.tipReqNormativoDao
				.findTipReqNormativoSeleccionable(tipReqNormativo);
	}

	/**
	 * Finds a List of rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipReqNormativo> findAll(TipReqNormativo tipReqNormativo,
			Pagination pagination) {
		return (List<TipReqNormativo>) this.tipReqNormativoDao.findAll(
				tipReqNormativo, pagination);
	}

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return Long
	 */
	public Long findAllCount(TipReqNormativo tipReqNormativo) {
		return this.tipReqNormativoDao.findAllCount(tipReqNormativo);
	}

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipReqNormativo> findAllLike(TipReqNormativo tipReqNormativo,
			Pagination pagination, Boolean startsWith) {
		return (List<TipReqNormativo>) this.tipReqNormativoDao.findAllLike(
				tipReqNormativo, pagination, startsWith);
	}

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipReqNormativo> findAllLikeReqNormativo(
			TipReqNormativo tipReqNormativo, Pagination pagination,
			Boolean startsWith) {
		return (List<TipReqNormativo>) this.tipReqNormativoDao
				.findAllLikeReqNormativo(tipReqNormativo, pagination,
						startsWith);
	}

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipReqNormativo> findAllArticulos(
			TipReqNormativo tipReqNormativo, Pagination pagination,
			List<String> articulosAniadidos) {
		return (List<TipReqNormativo>) this.tipReqNormativoDao
				.findAllArticulos(tipReqNormativo, pagination,
						articulosAniadidos);
	}

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipReqNormativo> findAllMaterias(
			TipReqNormativo tipReqNormativo, Pagination pagination,
			List<String> materiasAniadidas) {
		return (List<TipReqNormativo>) this.tipReqNormativoDao.findAllMaterias(
				tipReqNormativo, pagination, materiasAniadidas);
	}

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeReqNormativoCount(TipReqNormativo tipReqNormativo,
			Boolean startsWith) {
		return this.tipReqNormativoDao.findAllLikeReqNormativoCount(
				tipReqNormativo, startsWith);
	}

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllArticulosCount(TipReqNormativo tipReqNormativo,
			List<String> articulosAniadidos) {
		return this.tipReqNormativoDao.findAllArticulosCount(tipReqNormativo,
				articulosAniadidos);
	}

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllMateriasCount(TipReqNormativo tipReqNormativo,
			List<String> materiasAniadidas) {
		return this.tipReqNormativoDao.findAllMateriasCount(tipReqNormativo,
				materiasAniadidas);
	}

	/**
	 * Deletes a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipReqNormativo tipReqNormativo) {
		try {
			this.tipReqNormativoDao.remove(tipReqNormativo);

			TipReqNormativo tipReqNormativoAux = new TipReqNormativo();
			tipReqNormativoAux.setTticodigo(tipReqNormativo.getTticodigo());

			Long numTipReqNormativo = this.tipReqNormativoDao
					.findAllLikeReqNormativoCount(tipReqNormativoAux, true);

			if (numTipReqNormativo > 0) {
				throw new Y41bUDAException(
						"error.tipoinfraccion.TieneHijosException", true,
						new Exception());
			}
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.tipoinfraccion.DataIntegrityViolationException",
					true, e);
		}
	}

	/**
	 * Deletes multiple rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativoList
	 *            ArrayList
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(ArrayList<TipReqNormativo> tipReqNormativoList) {
		for (TipReqNormativo tipReqNormativoAux : tipReqNormativoList) {
			this.tipReqNormativoDao.remove(tipReqNormativoAux);
		}
	}

	/**
	 * Getter method for TipReqNormativoDao
	 * 
	 * @return TipReqNormativoDao
	 */
	public TipReqNormativoDao getTipReqNormativoDao() {
		return this.tipReqNormativoDao;
	}

	/**
	 * Setter method for TipReqNormativoDao.
	 * 
	 * @param tipReqNormativoDao
	 *            TipReqNormativoDao
	 * @return
	 */
	public void setTipReqNormativoDao(TipReqNormativoDao tipReqNormativoDao) {
		logger.info("Setting Dependency " + tipReqNormativoDao);
		this.tipReqNormativoDao = tipReqNormativoDao;
	}
}
