package com.ejie.y41b.service;

import java.util.ArrayList;
import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.TipReqNormativo;

/**
 * * TipReqNormativoService  
 * 
 *  
 */

public interface TipReqNormativoService {

	/**
	 * Inserts a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	TipReqNormativo add(TipReqNormativo tipReqNormativo);

	/**
	 * Updates a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	TipReqNormativo update(TipReqNormativo tipReqNormativo);

	/**
	 * Finds a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	TipReqNormativo find(TipReqNormativo tipReqNormativo);

	/**
	 * Finds a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return TipReqNormativo
	 */
	public TipReqNormativo findTipReqNormativoSeleccionable(
			TipReqNormativo tipReqNormativo);

	/**
	 * Finds a List of rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipReqNormativo> findAll(TipReqNormativo tipReqNormativo,
			Pagination pagination);

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return Long
	 */
	Long findAllCount(TipReqNormativo tipReqNormativo);

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipReqNormativo> findAllLike(TipReqNormativo tipReqNormativo,
			Pagination pagination, Boolean startsWith);

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipReqNormativo> findAllLikeReqNormativo(
			TipReqNormativo tipReqNormativo, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipReqNormativo> findAllArticulos(TipReqNormativo tipReqNormativo,
			Pagination pagination, List<String> articulosAniadidos);

	/**
	 * Finds rows in the TipReqNormativo table using like.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipReqNormativo> findAllMaterias(TipReqNormativo tipReqNormativo,
			Pagination pagination, List<String> materiasAniadidas);

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeReqNormativoCount(TipReqNormativo tipReqNormativo,
			Boolean startsWith);

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllArticulosCount(TipReqNormativo tipReqNormativo,
			List<String> articulosAniadidos);

	/**
	 * Counts rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllMateriasCount(TipReqNormativo tipReqNormativo,
			List<String> materiasAniadidas);

	/**
	 * Deletes a single row in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativo
	 *            TipReqNormativo
	 * @return
	 */
	void remove(TipReqNormativo tipReqNormativo);

	/**
	 * Deletes multiple rows in the TipReqNormativo table.
	 * 
	 * @param tipReqNormativoList
	 *            ArrayList
	 * @return
	 */
	void removeMultiple(ArrayList<TipReqNormativo> tipReqNormativoList);

}
