package com.ejie.y41b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.AdjuntartipPregProtocDao;
import com.ejie.y41b.dao.ProtocolDao;
import com.ejie.y41b.dao.TipPregProtocDao;
import com.ejie.y41b.dao.TipProtocoloDao;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CopiaTipoProtocolo;
import com.ejie.y41b.model.Protocol;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;
import com.ejie.y41b.utils.Y41bUIDGenerator;
import com.ejie.y41b.utils.exception.Y41bUDAException;

/**
 * TipProtocoloServiceImpl  
 * 
 *  
 */

@Service(value = "tipProtocoloService")
public class TipProtocoloServiceImpl implements TipProtocoloService {

	@Autowired
	private TipProtocoloDao tipProtocoloDao;
	@Autowired
	private TipPregProtocDao tipPregProtocDao;
	@Autowired
	private AdjuntartipPregProtocDao adjuntartipPregProtocDao;
	@Autowired
	private ProtocolDao protocolDao;

	/**
	 * Inserts a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipProtocolo add(TipProtocolo tipProtocolo) {
		return this.tipProtocoloDao.add(tipProtocolo);
	}

	/**
	 * Inserts a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param codTipoProtocoloAlta
	 *            String
	 * @return TipProtocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipProtocolo addTipProtocolo(TipProtocolo tipProtocolo,
			String codTipoProtocoloAlta) {
		try {
			this.tipProtocoloDao.add(tipProtocolo);

			this.tipPregProtocDao.addAllTipPregProtoc(tipProtocolo,
					codTipoProtocoloAlta);

			TipProtocolo tipProtocoloAux = new TipProtocolo();
			tipProtocoloAux.setTpcodigo(codTipoProtocoloAlta);
			this.adjuntartipPregProtocDao
					.removeAllTipPregProtoc(tipProtocoloAux);

			return tipProtocolo;
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException(
					"error.tipProtocolo.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Inserts a single row in the TipProtocolo table.
	 * 
	 * @param copiaTipoProtocolo
	 *            CopiaTipoProtocolo
	 * @return CopiaTipoProtocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public CopiaTipoProtocolo copiarTipoProtocolo(
			CopiaTipoProtocolo copiaTipoProtocolo) {
		try {
			this.tipProtocoloDao.add(copiaTipoProtocolo
					.getTipoProtocoloDestino());

			TipPregProtoc tippregprotoc = new TipPregProtoc();
			TipProtocolo tipProtocolo = new TipProtocolo();
			tipProtocolo.setTpcodigo(copiaTipoProtocolo
					.getTipoProtocoloOrigen().getTpcodigo());
			if (copiaTipoProtocolo.getTipoProtocoloOrigen().getTpestandar() != null
					&& !copiaTipoProtocolo.getTipoProtocoloOrigen()
							.getTpestandar().equals("")) {
				tipProtocolo.setTpestandar(copiaTipoProtocolo
						.getTipoProtocoloOrigen().getTpestandar());
			}
			tippregprotoc.setTipProtocolo(tipProtocolo);

			List<TipPregProtoc> listTipPregProtoc = this.tipPregProtocDao
					.findAll(tippregprotoc, null);

			for (TipPregProtoc tipPregProtocAux : listTipPregProtoc) {
				tipPregProtocAux.setTrcodigo(Y41bUIDGenerator.getInstance()
						.generateId(Y41bConstantes.PK_SIZE));
				tipPregProtocAux.setTipProtocolo(copiaTipoProtocolo
						.getTipoProtocoloDestino());
				this.tipPregProtocDao.add(tipPregProtocAux);
			}

			return copiaTipoProtocolo;
		} catch (DuplicateKeyException e) {
			throw new Y41bUDAException(
					"error.tipProtocolo.DuplicateKeyException", true, e);
		}
	}

	/**
	 * Updates a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipProtocolo update(TipProtocolo tipProtocolo) {
		return this.tipProtocoloDao.update(tipProtocolo);
	}

	/**
	 * Updates a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipProtocolo updateTipProtocolo(TipProtocolo tipProtocolo) {
		try {
			this.tipProtocoloDao.update(tipProtocolo);

			this.tipPregProtocDao.removeAllTipPregProtoc(tipProtocolo);

			this.tipPregProtocDao.addAllTipPregProtoc(tipProtocolo,
					tipProtocolo.getTpcodigo());

			this.adjuntartipPregProtocDao.removeAllTipPregProtoc(tipProtocolo);

			return tipProtocolo;
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.tipProtocolo.DataIntegrityViolationExceptionMod",
					true, e);
		}
	}

	/**
	 * Finds a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	public TipProtocolo find(TipProtocolo tipProtocolo) {
		return (TipProtocolo) this.tipProtocoloDao.find(tipProtocolo);
	}

	/**
	 * Finds a List of rows in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipProtocolo> findAll(TipProtocolo tipProtocolo,
			Pagination pagination) {
		return (List<TipProtocolo>) this.tipProtocoloDao.findAll(tipProtocolo,
				pagination);
	}

	/**
	 * Counts rows in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return Long
	 */
	public Long findAllCount(TipProtocolo tipProtocolo) {
		return this.tipProtocoloDao.findAllCount(tipProtocolo);
	}

	/**
	 * Finds rows in the TipProtocolo table using like.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipProtocolo> findAllLike(TipProtocolo tipProtocolo,
			Pagination pagination, Boolean startsWith) {

		List<TipProtocolo> listTipProtocolo = this.tipProtocoloDao.findAllLike(
				tipProtocolo, pagination, startsWith);

		Protocol protocol = null;
		StringBuffer preguntascontestadas = null;
		for (TipProtocolo tipProtocoloAux : listTipProtocolo) {

			protocol = new Protocol();
			protocol.setPtcoat(tipProtocolo.getAtcodigo());
			protocol.setPtcodigo(tipProtocoloAux.getTpcodigo());
			Long preguntas = this.tipPregProtocDao
					.preguntasProtocoloCount(protocol);

			Long respuestas = this.protocolDao
					.findAllPreguntasContestadasCount(protocol);
			preguntascontestadas = new StringBuffer();
			preguntascontestadas.append(respuestas).append("/")
					.append(preguntas);

			tipProtocoloAux.setPreguntascontestadas(preguntascontestadas
					.toString());
		}

		return listTipProtocolo;
	}

	/**
	 * Counts rows in the TipProtocolo table using like.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TipProtocolo tipProtocolo, Boolean startsWith) {
		return this.tipProtocoloDao.findAllLikeCount(tipProtocolo, startsWith);
	}

	/**
	 * Deletes a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipProtocolo tipProtocolo) {
		this.tipProtocoloDao.remove(tipProtocolo);
	}

	/**
	 * Deletes a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeTipProtocolo(TipProtocolo tipProtocolo) {
		try {
			this.tipPregProtocDao.removeAllTipPregProtoc(tipProtocolo);

			this.tipProtocoloDao.remove(tipProtocolo);
		} catch (DataIntegrityViolationException e) {
			throw new Y41bUDAException(
					"error.tipProtocolo.DataIntegrityViolationException", true,
					e);
		}
	}

	/**
	 * Deletes multiple rows in the TipProtocolo table.
	 * 
	 * @param tipProtocoloList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<TipProtocolo> tipProtocoloList) {
		for (TipProtocolo tipProtocoloAux : tipProtocoloList) {
			this.tipProtocoloDao.remove(tipProtocoloAux);
		}
	}

	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipProtocolo addCampanhaTipoprotocolo(TipProtocolo tipProtocolo) {
		return this.tipProtocoloDao.addCampanhaTipoprotocolo(tipProtocolo);
	}

	/**
	 * Deletes a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeCampanhaTipoprotocolo(TipProtocolo tipProtocolo) {
		this.tipProtocoloDao.removeCampanhaTipoprotocolo(tipProtocolo);
	}

	/**
	 * Find a single row in the findCampanhaTipoprotocolo Many To Many
	 * relationship.
	 * 
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @return TipProtocolo
	 */
	public TipProtocolo findCampanhaTipoprotocolo(TipProtocolo tipProtocolo,
			Campanha campanha, Pagination pagination) {
		return this.tipProtocoloDao.findCampanhaTipoprotocolo(tipProtocolo,
				campanha, pagination);
	}

	/**
	 * Counts rows in the CampanhaTipoprotocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param campanha
	 *            Campanha
	 * @return List
	 */
	public Long findCampanhaTipoprotocoloCount(TipProtocolo tipProtocolo,
			Campanha campanha) {
		return this.tipProtocoloDao.findCampanhaTipoprotocoloCount(
				tipProtocolo, campanha);
	}

}
