package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.CopiaTipoProtocolo;
import com.ejie.y41b.model.TipProtocolo;

/**
 * TipProtocoloService  
 * 
 *  
 */

public interface TipProtocoloService {

	/**
	 * Inserts a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	TipProtocolo add(TipProtocolo tipProtocolo);

	/**
	 * Inserts a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param codTipoProtocoloAlta
	 *            String
	 * @return TipProtocolo
	 */
	public TipProtocolo addTipProtocolo(TipProtocolo tipProtocolo,
			String codTipoProtocoloAlta);

	/**
	 * Inserts a single row in the TipProtocolo table.
	 * 
	 * @param copiaTipoProtocolo
	 *            CopiaTipoProtocolo
	 * @return CopiaTipoProtocolo
	 */
	public CopiaTipoProtocolo copiarTipoProtocolo(
			CopiaTipoProtocolo copiaTipoProtocolo);

	/**
	 * Updates a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	TipProtocolo update(TipProtocolo tipProtocolo);

	/**
	 * Updates a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	public TipProtocolo updateTipProtocolo(TipProtocolo tipProtocolo);

	/**
	 * Finds a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	TipProtocolo find(TipProtocolo tipProtocolo);

	/**
	 * Finds a List of rows in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipProtocolo> findAll(TipProtocolo tipProtocolo, Pagination pagination);

	/**
	 * Counts rows in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return Long
	 */
	Long findAllCount(TipProtocolo tipProtocolo);

	/**
	 * Finds rows in the TipProtocolo table using like.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipProtocolo> findAllLike(TipProtocolo tipProtocolo,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TipProtocolo table using like.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TipProtocolo tipProtocolo, Boolean startsWith);

	/**
	 * Deletes a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return
	 */
	void remove(TipProtocolo tipProtocolo);

	/**
	 * Deletes a single row in the TipProtocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 */
	public void removeTipProtocolo(TipProtocolo tipProtocolo);

	/**
	 * Deletes multiple rows in the TipProtocolo table.
	 * 
	 * @param tipProtocoloList
	 *            List
	 * @return
	 */
	void removeMultiple(List<TipProtocolo> tipProtocoloList);

	/**
	 * Inserts a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @return TipProtocolo
	 */
	TipProtocolo addCampanhaTipoprotocolo(TipProtocolo tipProtocolo);

	/**
	 * Deletes a single row in the CampanhaTipoprotocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 */
	void removeCampanhaTipoprotocolo(TipProtocolo tipProtocolo);

	/**
	 * Find a single row in the findCampanhaTipoprotocolo Many To Many
	 * relationship.
	 * 
	 * @param tipprotocolo
	 *            TipProtocolo
	 * @param campanha
	 *            Campanha
	 * @param pagination
	 *            Pagination
	 * @return TipProtocolo
	 */
	TipProtocolo findCampanhaTipoprotocolo(TipProtocolo tipprotocolo,
			Campanha campanha, Pagination pagination);

	/**
	 * Counts rows in the CampanhaTipoprotocolo table.
	 * 
	 * @param tipProtocolo
	 *            TipProtocolo
	 * @param campanha
	 *            Campanha
	 * @return List
	 */
	Long findCampanhaTipoprotocoloCount(TipProtocolo tipprotocolo,
			Campanha campanha);
}
