package com.ejie.y41b.service;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.constantes.Y41bConstantes;
import com.ejie.y41b.dao.ActaDao;
import com.ejie.y41b.dao.ProtocolDao;
import com.ejie.y41b.dao.TipPregProtocDao;
import com.ejie.y41b.dao.TipProtocoloDao;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Actuacion;
import com.ejie.y41b.model.Campanha;
import com.ejie.y41b.model.InspeccionDetalle;
import com.ejie.y41b.model.Protocol;
import com.ejie.y41b.model.TipPregProtoc;
import com.ejie.y41b.model.TipProtocolo;

/**
 * TipPregProtocServiceImpl  
 * 
 *  
 */

@Service(value = "tipPregProtocService")
public class TipPregProtocServiceImpl implements TipPregProtocService {

	@Autowired
	private TipPregProtocDao tipPregProtocDao;

	@Autowired
	private ProtocolDao protocolDao;

	@Autowired()
	private ActaDao actaDao;

	@Autowired
	private TipProtocoloDao tipProtocoloDao;

	/**
	 * Inserts a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipPregProtoc add(TipPregProtoc tipPregProtoc) {
		return this.tipPregProtocDao.add(tipPregProtoc);
	}

	/**
	 * Updates a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TipPregProtoc update(TipPregProtoc tipPregProtoc) {
		return this.tipPregProtocDao.update(tipPregProtoc);
	}

	/**
	 * Finds a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	public TipPregProtoc find(TipPregProtoc tipPregProtoc) {
		return (TipPregProtoc) this.tipPregProtocDao.find(tipPregProtoc);
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TipPregProtoc> findAll(TipPregProtoc tipPregProtoc,
			Pagination pagination) {
		return (List<TipPregProtoc>) this.tipPregProtocDao.findAll(
				tipPregProtoc, pagination);
	}

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return Long
	 */
	public Long findAllCount(TipPregProtoc tipPregProtoc) {
		return this.tipPregProtocDao.findAllCount(tipPregProtoc);
	}

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return List
	 */
	public List<TipPregProtoc> findAllProtocoloOrdenado(
			TipPregProtoc tipPregProtoc) {
		return (List<TipPregProtoc>) this.tipPregProtocDao
				.findAllProtocoloOrdenado(tipPregProtoc);
	}

	/**
	 * Finds rows in the TipPregProtoc table using like.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TipPregProtoc> findAllLike(TipPregProtoc tipPregProtoc,
			Pagination pagination, Boolean startsWith) {
		return (List<TipPregProtoc>) this.tipPregProtocDao.findAllLike(
				tipPregProtoc, pagination, startsWith);
	}

	/**
	 * Counts rows in the TipPregProtoc table using like.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TipPregProtoc tipPregProtoc, Boolean startsWith) {
		return this.tipPregProtocDao
				.findAllLikeCount(tipPregProtoc, startsWith);
	}

	/**
	 * Deletes a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TipPregProtoc tipPregProtoc) {
		this.tipPregProtocDao.remove(tipPregProtoc);
	}

	/**
	 * Deletes multiple rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtocList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<TipPregProtoc> tipPregProtocList) {
		for (TipPregProtoc tipPregProtocAux : tipPregProtocList) {
			this.tipPregProtocDao.remove(tipPregProtocAux);
		}
	}

	/**
	 * Comprueba si todas las preguntas estn respondidas.
	 * 
	 * @param idExpediente
	 *            String
	 * @return boolean
	 */
	public boolean checkAnswersFilled(String idExpediente) {

		Actuacion actuacion = new Actuacion();
		actuacion.setAtcodigo(idExpediente);

		InspeccionDetalle inspeccionDetalle = this.actaDao
				.findInspeccion(actuacion);

		// Buscar los protocolos
		TipProtocolo filterTipProtocolo = new TipProtocolo();
		Campanha campanha = new Campanha();
		campanha.setCmcodigo(inspeccionDetalle.getAtcocm());
		filterTipProtocolo.setCampanha(campanha);

		if (inspeccionDetalle != null
				&& inspeccionDetalle.getAttipo() != null
				&& inspeccionDetalle.getAttipo().equals(
						Y41bConstantes.TIPO_INSPECCION_CONTROL_ESTANDAR)) {
			filterTipProtocolo.setTpestandar(Y41bConstantes.VALOR_SI);
		} else if (inspeccionDetalle != null
				&& inspeccionDetalle.getAttipo() != null
				&& inspeccionDetalle.getAttipo().equals(
						Y41bConstantes.TIPO_INSPECCION_CONTROL_OTROS)) {
			filterTipProtocolo.setTpestandar(Y41bConstantes.VALOR_NO);
		}

		List<TipProtocolo> listTipProtocolo = this.tipProtocoloDao.findAllLike(
				filterTipProtocolo, null, false);

		if (listTipProtocolo != null && listTipProtocolo.size() > 0) {
			Protocol protocol = new Protocol();
			protocol.setPtcoat(idExpediente);
			protocol.setPtcodigo(listTipProtocolo.get(0).getTpcodigo());
			Long preguntas = this.tipPregProtocDao
					.preguntasProtocoloCount(protocol);

			Long respuestas = this.protocolDao
					.findAllPreguntasContestadasCount(protocol);

			return respuestas.equals(preguntas);
		} else {
			return true;
		}
	}

	/**
	 * Comprueba si todas las preguntas estn respondidas en el protocolo.
	 * 
	 * @param idExpediente
	 *            String
	 * @param tipProtocolo
	 *            String
	 * @return boolean
	 */
	public boolean checkAnswersFilledProtocolo(String idExpediente,
			String tipProtocolo) {

		Protocol protocol = new Protocol();
		protocol.setPtcoat(idExpediente);
		protocol.setPtcodigo(tipProtocolo);
		Long preguntas = this.tipPregProtocDao
				.preguntasProtocoloCount(protocol);

		Long respuestas = this.protocolDao
				.findAllPreguntasContestadasCount(protocol);

		return respuestas.equals(preguntas);
	}
}
