package com.ejie.y41b.service;

import java.util.List;

import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.model.TipPregProtoc;

/**
 * TipPregProtocService  
 * 
 *  
 */

public interface TipPregProtocService {

	/**
	 * Inserts a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	TipPregProtoc add(TipPregProtoc tipPregProtoc);

	/**
	 * Updates a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	TipPregProtoc update(TipPregProtoc tipPregProtoc);

	/**
	 * Finds a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return TipPregProtoc
	 */
	TipPregProtoc find(TipPregProtoc tipPregProtoc);

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TipPregProtoc> findAll(TipPregProtoc tipPregProtoc,
			Pagination pagination);

	/**
	 * Counts rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return Long
	 */
	Long findAllCount(TipPregProtoc tipPregProtoc);

	/**
	 * Finds a List of rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return List
	 */
	public List<TipPregProtoc> findAllProtocoloOrdenado(
			TipPregProtoc tipPregProtoc);

	/**
	 * Finds rows in the TipPregProtoc table using like.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TipPregProtoc> findAllLike(TipPregProtoc tipPregProtoc,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TipPregProtoc table using like.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TipPregProtoc tipPregProtoc, Boolean startsWith);

	/**
	 * Deletes a single row in the TipPregProtoc table.
	 * 
	 * @param tipPregProtoc
	 *            TipPregProtoc
	 * @return
	 */
	void remove(TipPregProtoc tipPregProtoc);

	/**
	 * Deletes multiple rows in the TipPregProtoc table.
	 * 
	 * @param tipPregProtocList
	 *            List
	 * @return
	 */
	void removeMultiple(List<TipPregProtoc> tipPregProtocList);

	/**
	 * Comprueba si todas las preguntas estn respondidas.
	 * 
	 * @param idExpediente
	 *            String
	 * @return boolean
	 */
	boolean checkAnswersFilled(String idExpediente);

	/**
	 * Comprueba si todas las preguntas estn respondidas en el protocolo.
	 * 
	 * @param idExpediente
	 *            String
	 * @param tipProtocolo
	 *            String
	 * @return boolean
	 */
	public boolean checkAnswersFilledProtocolo(String idExpediente,
			String tipProtocolo);

}
