package com.ejie.y41b.service;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41b.dao.TctipresDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.y41b.model.Tctipres;

/**
 * TctipresServiceImpl  
 *  
 */

@Service(value = "tctipresService")
public class TctipresServiceImpl implements TctipresService {

	@Autowired
	private TctipresDao tctipresDao;

	/**
	 * Inserts a single row in the Tctipres table.
	 *
	 * @param tctipres Tctipres
	 * @return Tctipres
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tctipres add(Tctipres tctipres) {
		return this.tctipresDao.add(tctipres);
	}

	/**
	 * Updates a single row in the Tctipres table.
	 *
	 * @param tctipres Tctipres
	 * @return Tctipres
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tctipres update(Tctipres tctipres) {
		return this.tctipresDao.update(tctipres);
	 }

	/**
	 * Finds a single row in the Tctipres table.
	 *
	 * @param tctipres Tctipres
	 * @return Tctipres
	 */
	public Tctipres find(Tctipres tctipres) {
		return (Tctipres) this.tctipresDao.find(tctipres);
	}

	/**
	 * Finds a List of rows in the Tctipres table.
	 *
	 * @param tctipres Tctipres
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Tctipres> findAll(Tctipres tctipres, Pagination pagination) {
		return (List<Tctipres>) this.tctipresDao.findAll(tctipres, pagination);
	}
    
	/**
	 * Counts rows in the Tctipres table.
	 *
	 * @param tctipres Tctipres
	 * @return Long
	 */
	public Long findAllCount(Tctipres tctipres) {        
		return  this.tctipresDao.findAllCount(tctipres);
	}

	/**
	 * Finds rows in the Tctipres table using like.
	 *
	 * @param tctipres Tctipres
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Tctipres> findAllLike(Tctipres tctipres, Pagination pagination, Boolean startsWith) {
		return (List<Tctipres>) this.tctipresDao.findAllLike(tctipres, pagination, startsWith);
	}

	/**
	 * Counts rows in the Tctipres table using like.
	 *
	 * @param tctipres Tctipres
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tctipres tctipres, Boolean startsWith) {
		return this.tctipresDao.findAllLikeCount(tctipres, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Tctipres table.
	 *
	 * @param tctipres Tctipres
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tctipres tctipres) {
		this.tctipresDao.remove(tctipres);
	}
	
	/**
	 * Deletes multiple rows in the Tctipres table.
	 *
	 * @param tctipresList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tctipres> tctipresList) {
		for (Tctipres  tctipresAux:tctipresList) {
			this.tctipresDao.remove(tctipresAux);
		}
	}
	
}

